# This file was auto-generated by Fern from our API Definition.
import typing
import warnings

import httpx
from .agents.client import AgentsClient, AsyncAgentsClient
from .contacts.client import AsyncContactsClient, ContactsClient
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .customers.client import AsyncCustomersClient, CustomersClient
from .environment import PaidEnvironment
from .orders.client import AsyncOrdersClient, OrdersClient
from .tracing.distributed_tracing import (
    generate_tracing_token,
    set_tracing_token,
    unset_tracing_token,
)
from .tracing.signal import signal
from .tracing.tracing import (
    DEFAULT_COLLECTOR_ENDPOINT,
    initialize_tracing,
    trace_async_,
    trace_sync_,
)
from .usage.client import AsyncUsageClient, UsageClient

T = typing.TypeVar("T")


class Paid:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PaidEnvironment
        The environment to use for requests from the client. from .environment import PaidEnvironment
        Defaults to PaidEnvironment.PRODUCTION
    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.
    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.
    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from paid import Paid

    client = Paid(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PaidEnvironment = PaidEnvironment.PRODUCTION,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.customers = CustomersClient(client_wrapper=self._client_wrapper)
        self.agents = AgentsClient(client_wrapper=self._client_wrapper)
        self.contacts = ContactsClient(client_wrapper=self._client_wrapper)
        self.orders = OrdersClient(client_wrapper=self._client_wrapper)
        self.usage = UsageClient(client_wrapper=self._client_wrapper)

    def initialize_tracing(self, collector_endpoint: str = DEFAULT_COLLECTOR_ENDPOINT) -> None:
        """
        Deprecated: Use the @paid_tracing decorator or context manager instead.

        This method is deprecated and will be removed in a future version.
        The @paid_tracing decorator automatically initializes tracing as needed.

        Instead of:
            client.initialize_tracing()
            client.trace(external_customer_id="...", fn=lambda: ...)

        Use:
            from paid.tracing import paid_tracing

            @paid_tracing(external_customer_id="...", external_agent_id="...")
            def my_function():
                ...

        Or as a context manager:
            with paid_tracing(external_customer_id="..."):
                result = agent_workflow()
        """
        warnings.warn(
            "Paid.initialize_tracing() is deprecated and will be removed in a future version. "
            "Use @paid_tracing decorator/context manager directly, which auto-initializes tracing. "
            "See documentation: https://docs.paid.ai/documentation/getting-started/integrate-signals-and-cost-tracking-to-your-codebase",
            DeprecationWarning,
            stacklevel=2,
        )
        token = self._client_wrapper._get_token()
        initialize_tracing(token, collector_endpoint=collector_endpoint)

    def generate_tracing_token(self) -> int:
        """
        Deprecated: Import and use generate_tracing_token() directly from paid.tracing.

        This method is deprecated and will be removed in a future version.
        Use the standalone function instead.

        Instead of:
            from paid import Paid
            client = Paid(token="...")
            token = client.generate_tracing_token()

        Use:
            from paid.tracing import generate_tracing_token
            token = generate_tracing_token()
        """
        warnings.warn(
            "Paid.generate_tracing_token() is deprecated and will be removed in a future version. "
            "Import and use generate_tracing_token() directly from paid.tracing instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        return generate_tracing_token()

    def set_tracing_token(self, token: int):
        """
        Deprecated: Pass tracing_token directly to @paid_tracing() decorator instead.

        This method is deprecated and will be removed in a future version.
        Use the tracing_token parameter in @paid_tracing() to link traces across processes.

        Instead of:
            from paid import Paid
            client = Paid(token="...")
            token = load_from_storage("workflow_123")
            client.set_tracing_token(token)
            @paid_tracing(external_customer_id="cust_123", external_agent_id="agent_456")
            def process_workflow():
                ...
            client.unset_tracing_token()

        Use:
            from paid.tracing import paid_tracing
            token = load_from_storage("workflow_123")

            @paid_tracing(
                external_customer_id="cust_123",
                external_agent_id="agent_456",
                tracing_token=token
            )
            def process_workflow():
                ...

        Parameters
        ----------
        token : int
            A tracing token to use for the next traces.
        """
        warnings.warn(
            "Paid.set_tracing_token() is deprecated and will be removed in a future version. "
            "Pass tracing_token directly to @paid_tracing(tracing_token=...) decorator instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        set_tracing_token(token)

    def unset_tracing_token(self):
        """
        Deprecated: No longer needed. Use tracing_token parameter in @paid_tracing() instead.

        This method is deprecated and will be removed in a future version.
        Since tracing_token is now passed directly to @paid_tracing(), there's no need
        to manually set/unset tokens in the context.

        Old pattern (no longer recommended):
            from paid import Paid
            client = Paid(token="...")
            client.set_tracing_token(token)
            @paid_tracing(external_customer_id="cust_123", external_agent_id="agent_456")
            def my_function():
                ...
            client.unset_tracing_token()

        New pattern (recommended):
            from paid.tracing import paid_tracing
            @paid_tracing(
                external_customer_id="cust_123",
                external_agent_id="agent_456",
                tracing_token=token
            )
            def my_function():
                ...
        """
        warnings.warn(
            "Paid.unset_tracing_token() is deprecated and will be removed in a future version. "
            "Use tracing_token parameter in @paid_tracing(tracing_token=...) decorator instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        unset_tracing_token()

    def trace(
        self,
        external_customer_id: str,
        fn: typing.Callable[[], T],
        external_agent_id: typing.Optional[str] = None,
        tracing_token: typing.Optional[int] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = None,
        args: typing.Optional[typing.Tuple] = None,
        kwargs: typing.Optional[typing.Dict] = None,
    ) -> T:
        """
        Deprecated: Use the @paid_tracing decorator or context manager instead.

        This method is deprecated and will be removed in a future version.
        The callback-based tracing via Paid.trace() is being replaced with the more
        Pythonic @paid_tracing decorator and context manager.

        Instead of:
            result = client.trace(
                external_customer_id="cust_123",
                fn=lambda: agent_workflow(),
                external_agent_id="agent_456"
            )

        Use the decorator:
            from paid.tracing import paid_tracing

            @paid_tracing(external_customer_id="cust_123", external_agent_id="agent_456")
            def agent_workflow():
                ...

            result = agent_workflow()

        Or use the context manager:
            with paid_tracing(external_customer_id="cust_123", external_agent_id="agent_456"):
                result = agent_workflow()
        """
        warnings.warn(
            "Paid.trace() is deprecated and will be removed in a future version. "
            "Use the @paid_tracing decorator or context manager instead. "
            "See documentation: https://docs.paid.ai/documentation/getting-started/integrate-signals-and-cost-tracking-to-your-codebase",
            DeprecationWarning,
            stacklevel=2,
        )
        return trace_sync_(
            external_customer_id=external_customer_id,
            fn=fn,
            external_agent_id=external_agent_id,
            tracing_token=tracing_token,
            metadata=metadata,
            args=args,
            kwargs=kwargs,
        )

    def signal(
        self,
        event_name: str,
        *,
        data: typing.Optional[typing.Dict[str, typing.Any]] = None,
        enable_cost_tracing: bool = False,
    ) -> None:
        """
        Deprecated: Import and use signal() directly from paid.tracing.

        This method is deprecated and will be removed in a future version.
        Use the standalone function instead.

        Instead of:
            from paid import Paid
            client = Paid(token="...")
            client.signal("event_name", data={...})

        Use:
            from paid.tracing import signal
            signal("event_name", data={...})
        """
        warnings.warn(
            "Paid.signal() is deprecated and will be removed in a future version. "
            "Import and use signal() directly from paid.tracing instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        signal(event_name=event_name, enable_cost_tracing=enable_cost_tracing, data=data)


class AsyncPaid:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PaidEnvironment
        The environment to use for requests from the client. from .environment import PaidEnvironment
        Defaults to PaidEnvironment.PRODUCTION
    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from paid import AsyncPaid

    client = AsyncPaid(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PaidEnvironment = PaidEnvironment.PRODUCTION,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.customers = AsyncCustomersClient(client_wrapper=self._client_wrapper)
        self.agents = AsyncAgentsClient(client_wrapper=self._client_wrapper)
        self.contacts = AsyncContactsClient(client_wrapper=self._client_wrapper)
        self.orders = AsyncOrdersClient(client_wrapper=self._client_wrapper)
        self.usage = AsyncUsageClient(client_wrapper=self._client_wrapper)

    def initialize_tracing(self, collector_endpoint: str = DEFAULT_COLLECTOR_ENDPOINT) -> None:
        """
        Deprecated: Use the @paid_tracing decorator or context manager instead.

        This method is deprecated and will be removed in a future version.
        The @paid_tracing decorator automatically initializes tracing as needed.

        Instead of:
            client.initialize_tracing()
            await client.trace(external_customer_id="...", fn=async_func)

        Use:
            from paid.tracing import paid_tracing

            @paid_tracing(external_customer_id="...", external_agent_id="...")
            async def my_async_function():
                ...

            await my_async_function()

        Or as an async context manager:
            async with paid_tracing(external_customer_id="..."):
                result = await async_operation()
        """
        warnings.warn(
            "AsyncPaid.initialize_tracing() is deprecated and will be removed in a future version. "
            "Use @paid_tracing decorator/context manager directly, which auto-initializes tracing. "
            "See documentation: https://docs.paid.ai/documentation/getting-started/integrate-signals-and-cost-tracking-to-your-codebase",
            DeprecationWarning,
            stacklevel=2,
        )
        token = self._client_wrapper._get_token()
        initialize_tracing(token, collector_endpoint=collector_endpoint)

    def generate_tracing_token(self) -> int:
        """
        Deprecated: Import and use generate_tracing_token() directly from paid.tracing.

        This method is deprecated and will be removed in a future version.
        Use the standalone function instead.

        Instead of:
            from paid import AsyncPaid
            client = AsyncPaid(token="...")
            token = client.generate_tracing_token()

        Use:
            from paid.tracing import generate_tracing_token
            token = generate_tracing_token()
        """
        warnings.warn(
            "AsyncPaid.generate_tracing_token() is deprecated and will be removed in a future version. "
            "Import and use generate_tracing_token() directly from paid.tracing instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        return generate_tracing_token()

    def set_tracing_token(self, token: int):
        """
        Deprecated: Pass tracing_token directly to @paid_tracing() decorator instead.

        This method is deprecated and will be removed in a future version.
        Use the tracing_token parameter in @paid_tracing() to link traces across processes.

        Instead of:
            from paid import AsyncPaid
            client = AsyncPaid(token="...")
            token = load_from_storage("workflow_123")
            client.set_tracing_token(token)
            @paid_tracing(external_customer_id="cust_123", external_agent_id="agent_456")
            async def process_workflow():
                ...
            client.unset_tracing_token()

        Use:
            from paid.tracing import paid_tracing
            token = load_from_storage("workflow_123")

            @paid_tracing(
                external_customer_id="cust_123",
                external_agent_id="agent_456",
                tracing_token=token
            )
            async def process_workflow():
                ...

        Parameters
        ----------
        token : int
            A tracing token to use for the next traces.
        """
        warnings.warn(
            "AsyncPaid.set_tracing_token() is deprecated and will be removed in a future version. "
            "Pass tracing_token directly to @paid_tracing(tracing_token=...) decorator instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        set_tracing_token(token)

    def unset_tracing_token(self):
        """
        Deprecated: No longer needed. Use tracing_token parameter in @paid_tracing() instead.

        This method is deprecated and will be removed in a future version.
        Since tracing_token is now passed directly to @paid_tracing(), there's no need
        to manually set/unset tokens in the context.

        Old pattern (no longer recommended):
            from paid import AsyncPaid
            client = AsyncPaid(token="...")
            client.set_tracing_token(token)
            @paid_tracing(external_customer_id="cust_123", external_agent_id="agent_456")
            async def my_function():
                ...
            client.unset_tracing_token()

        New pattern (recommended):
            from paid.tracing import paid_tracing
            @paid_tracing(
                external_customer_id="cust_123",
                external_agent_id="agent_456",
                tracing_token=token
            )
            async def my_function():
                ...
        """
        warnings.warn(
            "AsyncPaid.unset_tracing_token() is deprecated and will be removed in a future version. "
            "Use tracing_token parameter in @paid_tracing(tracing_token=...) decorator instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        unset_tracing_token()

    async def trace(
        self,
        external_customer_id: str,
        fn: typing.Callable[[], typing.Awaitable[T]],
        external_agent_id: typing.Optional[str] = None,
        tracing_token: typing.Optional[int] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Any]] = None,
        args: typing.Optional[typing.Tuple] = None,
        kwargs: typing.Optional[typing.Dict] = None,
    ) -> typing.Union[T, typing.Awaitable[T]]:
        """
        Deprecated: Use the @paid_tracing decorator or context manager instead.

        This method is deprecated and will be removed in a future version.
        The callback-based tracing via AsyncPaid.trace() is being replaced with the more
        Pythonic @paid_tracing decorator and context manager.

        Instead of:
            result = await client.trace(
                external_customer_id="cust_123",
                fn=agent_workflow,
                external_agent_id="agent_456"
            )

        Use the decorator:
            from paid.tracing import paid_tracing

            @paid_tracing(external_customer_id="cust_123", external_agent_id="agent_456")
            async def agent_workflow():
                ...

            result = await agent_workflow()

        Or use the async context manager:
            async with paid_tracing(external_customer_id="cust_123", external_agent_id="agent_456"):
                result = await agent_workflow()
        """
        warnings.warn(
            "AsyncPaid.trace() is deprecated and will be removed in a future version. "
            "Use the @paid_tracing decorator or context manager instead. "
            "See documentation: https://docs.paid.ai/documentation/getting-started/integrate-signals-and-cost-tracking-to-your-codebase",
            DeprecationWarning,
            stacklevel=2,
        )
        return await trace_async_(
            external_customer_id=external_customer_id,
            fn=fn,
            external_agent_id=external_agent_id,
            tracing_token=tracing_token,
            metadata=metadata,
            args=args,
            kwargs=kwargs,
        )

    def signal(
        self,
        event_name: str,
        *,
        data: typing.Optional[typing.Dict[str, typing.Any]] = None,
        enable_cost_tracing: bool = False,
    ) -> None:
        """
        Deprecated: Import and use signal() directly from paid.tracing.

        This method is deprecated and will be removed in a future version.
        Use the standalone function instead.

        Instead of:
            from paid import AsyncPaid
            client = AsyncPaid(token="...")
            client.signal("event_name", data={...})

        Use:
            from paid.tracing import signal
            signal("event_name", data={...})
        """
        warnings.warn(
            "AsyncPaid.signal() is deprecated and will be removed in a future version. "
            "Import and use signal() directly from paid.tracing instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        signal(event_name=event_name, enable_cost_tracing=enable_cost_tracing, data=data)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: PaidEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
