# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.signal import Signal
from .raw_client import AsyncRawUsageClient, RawUsageClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsageClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsageClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUsageClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsageClient
        """
        return self._raw_client

    def record_bulk(
        self,
        *,
        signals: typing.Optional[typing.Sequence[Signal]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        signals : typing.Optional[typing.Sequence[Signal]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from paid import Paid, Signal

        client = Paid(
            token="YOUR_TOKEN",
        )
        client.usage.record_bulk(
            signals=[Signal(), Signal(), Signal()],
        )
        """
        _response = self._raw_client.record_bulk(signals=signals, request_options=request_options)
        return _response.data


class AsyncUsageClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsageClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUsageClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsageClient
        """
        return self._raw_client

    async def record_bulk(
        self,
        *,
        signals: typing.Optional[typing.Sequence[Signal]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        signals : typing.Optional[typing.Sequence[Signal]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from paid import AsyncPaid, Signal

        client = AsyncPaid(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.usage.record_bulk(
                signals=[Signal(), Signal(), Signal()],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.record_bulk(signals=signals, request_options=request_options)
        return _response.data
