# Copyright 2023 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1alpha1LocalModelCacheSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'model_size': 'ResourceQuantity',
        'node_groups': 'list[str]',
        'source_model_uri': 'str'
    }

    attribute_map = {
        'model_size': 'modelSize',
        'node_groups': 'nodeGroups',
        'source_model_uri': 'sourceModelUri'
    }

    def __init__(self, model_size=None, node_groups=None, source_model_uri='', local_vars_configuration=None):  # noqa: E501
        """V1alpha1LocalModelCacheSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._model_size = None
        self._node_groups = None
        self._source_model_uri = None
        self.discriminator = None

        self.model_size = model_size
        self.node_groups = node_groups
        self.source_model_uri = source_model_uri

    @property
    def model_size(self):
        """Gets the model_size of this V1alpha1LocalModelCacheSpec.  # noqa: E501


        :return: The model_size of this V1alpha1LocalModelCacheSpec.  # noqa: E501
        :rtype: ResourceQuantity
        """
        return self._model_size

    @model_size.setter
    def model_size(self, model_size):
        """Sets the model_size of this V1alpha1LocalModelCacheSpec.


        :param model_size: The model_size of this V1alpha1LocalModelCacheSpec.  # noqa: E501
        :type: ResourceQuantity
        """
        if self.local_vars_configuration.client_side_validation and model_size is None:  # noqa: E501
            raise ValueError("Invalid value for `model_size`, must not be `None`")  # noqa: E501

        self._model_size = model_size

    @property
    def node_groups(self):
        """Gets the node_groups of this V1alpha1LocalModelCacheSpec.  # noqa: E501

        group of nodes to cache the model on. Todo: support more than 1 node groups  # noqa: E501

        :return: The node_groups of this V1alpha1LocalModelCacheSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._node_groups

    @node_groups.setter
    def node_groups(self, node_groups):
        """Sets the node_groups of this V1alpha1LocalModelCacheSpec.

        group of nodes to cache the model on. Todo: support more than 1 node groups  # noqa: E501

        :param node_groups: The node_groups of this V1alpha1LocalModelCacheSpec.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and node_groups is None:  # noqa: E501
            raise ValueError("Invalid value for `node_groups`, must not be `None`")  # noqa: E501

        self._node_groups = node_groups

    @property
    def source_model_uri(self):
        """Gets the source_model_uri of this V1alpha1LocalModelCacheSpec.  # noqa: E501

        Original StorageUri  # noqa: E501

        :return: The source_model_uri of this V1alpha1LocalModelCacheSpec.  # noqa: E501
        :rtype: str
        """
        return self._source_model_uri

    @source_model_uri.setter
    def source_model_uri(self, source_model_uri):
        """Sets the source_model_uri of this V1alpha1LocalModelCacheSpec.

        Original StorageUri  # noqa: E501

        :param source_model_uri: The source_model_uri of this V1alpha1LocalModelCacheSpec.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_model_uri is None:  # noqa: E501
            raise ValueError("Invalid value for `source_model_uri`, must not be `None`")  # noqa: E501

        self._source_model_uri = source_model_uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1LocalModelCacheSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1LocalModelCacheSpec):
            return True

        return self.to_dict() != other.to_dict()
