# Copyright 2023 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1alpha1LocalModelNodeGroupSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'persistent_volume_claim_spec': 'V1PersistentVolumeClaimSpec',
        'persistent_volume_spec': 'V1PersistentVolumeSpec',
        'storage_limit': 'ResourceQuantity'
    }

    attribute_map = {
        'persistent_volume_claim_spec': 'persistentVolumeClaimSpec',
        'persistent_volume_spec': 'persistentVolumeSpec',
        'storage_limit': 'storageLimit'
    }

    def __init__(self, persistent_volume_claim_spec=None, persistent_volume_spec=None, storage_limit=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1LocalModelNodeGroupSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._persistent_volume_claim_spec = None
        self._persistent_volume_spec = None
        self._storage_limit = None
        self.discriminator = None

        self.persistent_volume_claim_spec = persistent_volume_claim_spec
        self.persistent_volume_spec = persistent_volume_spec
        self.storage_limit = storage_limit

    @property
    def persistent_volume_claim_spec(self):
        """Gets the persistent_volume_claim_spec of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501


        :return: The persistent_volume_claim_spec of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501
        :rtype: V1PersistentVolumeClaimSpec
        """
        return self._persistent_volume_claim_spec

    @persistent_volume_claim_spec.setter
    def persistent_volume_claim_spec(self, persistent_volume_claim_spec):
        """Sets the persistent_volume_claim_spec of this V1alpha1LocalModelNodeGroupSpec.


        :param persistent_volume_claim_spec: The persistent_volume_claim_spec of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501
        :type: V1PersistentVolumeClaimSpec
        """
        if self.local_vars_configuration.client_side_validation and persistent_volume_claim_spec is None:  # noqa: E501
            raise ValueError("Invalid value for `persistent_volume_claim_spec`, must not be `None`")  # noqa: E501

        self._persistent_volume_claim_spec = persistent_volume_claim_spec

    @property
    def persistent_volume_spec(self):
        """Gets the persistent_volume_spec of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501


        :return: The persistent_volume_spec of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501
        :rtype: V1PersistentVolumeSpec
        """
        return self._persistent_volume_spec

    @persistent_volume_spec.setter
    def persistent_volume_spec(self, persistent_volume_spec):
        """Sets the persistent_volume_spec of this V1alpha1LocalModelNodeGroupSpec.


        :param persistent_volume_spec: The persistent_volume_spec of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501
        :type: V1PersistentVolumeSpec
        """
        if self.local_vars_configuration.client_side_validation and persistent_volume_spec is None:  # noqa: E501
            raise ValueError("Invalid value for `persistent_volume_spec`, must not be `None`")  # noqa: E501

        self._persistent_volume_spec = persistent_volume_spec

    @property
    def storage_limit(self):
        """Gets the storage_limit of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501


        :return: The storage_limit of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501
        :rtype: ResourceQuantity
        """
        return self._storage_limit

    @storage_limit.setter
    def storage_limit(self, storage_limit):
        """Sets the storage_limit of this V1alpha1LocalModelNodeGroupSpec.


        :param storage_limit: The storage_limit of this V1alpha1LocalModelNodeGroupSpec.  # noqa: E501
        :type: ResourceQuantity
        """
        if self.local_vars_configuration.client_side_validation and storage_limit is None:  # noqa: E501
            raise ValueError("Invalid value for `storage_limit`, must not be `None`")  # noqa: E501

        self._storage_limit = storage_limit

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1LocalModelNodeGroupSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1LocalModelNodeGroupSpec):
            return True

        return self.to_dict() != other.to_dict()
