# Copyright 2023 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1beta1InferenceServicesConfig(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'explainers': 'V1beta1ExplainersConfig',
        'resource': 'V1beta1ResourceConfig',
        'service_annotation_disallowed_list': 'list[str]',
        'service_label_disallowed_list': 'list[str]'
    }

    attribute_map = {
        'explainers': 'explainers',
        'resource': 'resource',
        'service_annotation_disallowed_list': 'serviceAnnotationDisallowedList',
        'service_label_disallowed_list': 'serviceLabelDisallowedList'
    }

    def __init__(self, explainers=None, resource=None, service_annotation_disallowed_list=None, service_label_disallowed_list=None, local_vars_configuration=None):  # noqa: E501
        """V1beta1InferenceServicesConfig - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._explainers = None
        self._resource = None
        self._service_annotation_disallowed_list = None
        self._service_label_disallowed_list = None
        self.discriminator = None

        self.explainers = explainers
        if resource is not None:
            self.resource = resource
        if service_annotation_disallowed_list is not None:
            self.service_annotation_disallowed_list = service_annotation_disallowed_list
        if service_label_disallowed_list is not None:
            self.service_label_disallowed_list = service_label_disallowed_list

    @property
    def explainers(self):
        """Gets the explainers of this V1beta1InferenceServicesConfig.  # noqa: E501


        :return: The explainers of this V1beta1InferenceServicesConfig.  # noqa: E501
        :rtype: V1beta1ExplainersConfig
        """
        return self._explainers

    @explainers.setter
    def explainers(self, explainers):
        """Sets the explainers of this V1beta1InferenceServicesConfig.


        :param explainers: The explainers of this V1beta1InferenceServicesConfig.  # noqa: E501
        :type: V1beta1ExplainersConfig
        """
        if self.local_vars_configuration.client_side_validation and explainers is None:  # noqa: E501
            raise ValueError("Invalid value for `explainers`, must not be `None`")  # noqa: E501

        self._explainers = explainers

    @property
    def resource(self):
        """Gets the resource of this V1beta1InferenceServicesConfig.  # noqa: E501


        :return: The resource of this V1beta1InferenceServicesConfig.  # noqa: E501
        :rtype: V1beta1ResourceConfig
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this V1beta1InferenceServicesConfig.


        :param resource: The resource of this V1beta1InferenceServicesConfig.  # noqa: E501
        :type: V1beta1ResourceConfig
        """

        self._resource = resource

    @property
    def service_annotation_disallowed_list(self):
        """Gets the service_annotation_disallowed_list of this V1beta1InferenceServicesConfig.  # noqa: E501

        ServiceAnnotationDisallowedList is a list of annotations that are not allowed to be propagated to Knative revisions  # noqa: E501

        :return: The service_annotation_disallowed_list of this V1beta1InferenceServicesConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._service_annotation_disallowed_list

    @service_annotation_disallowed_list.setter
    def service_annotation_disallowed_list(self, service_annotation_disallowed_list):
        """Sets the service_annotation_disallowed_list of this V1beta1InferenceServicesConfig.

        ServiceAnnotationDisallowedList is a list of annotations that are not allowed to be propagated to Knative revisions  # noqa: E501

        :param service_annotation_disallowed_list: The service_annotation_disallowed_list of this V1beta1InferenceServicesConfig.  # noqa: E501
        :type: list[str]
        """

        self._service_annotation_disallowed_list = service_annotation_disallowed_list

    @property
    def service_label_disallowed_list(self):
        """Gets the service_label_disallowed_list of this V1beta1InferenceServicesConfig.  # noqa: E501

        ServiceLabelDisallowedList is a list of labels that are not allowed to be propagated to Knative revisions  # noqa: E501

        :return: The service_label_disallowed_list of this V1beta1InferenceServicesConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._service_label_disallowed_list

    @service_label_disallowed_list.setter
    def service_label_disallowed_list(self, service_label_disallowed_list):
        """Sets the service_label_disallowed_list of this V1beta1InferenceServicesConfig.

        ServiceLabelDisallowedList is a list of labels that are not allowed to be propagated to Knative revisions  # noqa: E501

        :param service_label_disallowed_list: The service_label_disallowed_list of this V1beta1InferenceServicesConfig.  # noqa: E501
        :type: list[str]
        """

        self._service_label_disallowed_list = service_label_disallowed_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1beta1InferenceServicesConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1beta1InferenceServicesConfig):
            return True

        return self.to_dict() != other.to_dict()
