# Copyright 2023 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1alpha1StorageContainerSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'container': 'V1Container',
        'supported_uri_formats': 'list[V1alpha1SupportedUriFormat]',
        'workload_type': 'str'
    }

    attribute_map = {
        'container': 'container',
        'supported_uri_formats': 'supportedUriFormats',
        'workload_type': 'workloadType'
    }

    def __init__(self, container=None, supported_uri_formats=None, workload_type=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1StorageContainerSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._container = None
        self._supported_uri_formats = None
        self._workload_type = None
        self.discriminator = None

        self.container = container
        self.supported_uri_formats = supported_uri_formats
        if workload_type is not None:
            self.workload_type = workload_type

    @property
    def container(self):
        """Gets the container of this V1alpha1StorageContainerSpec.  # noqa: E501


        :return: The container of this V1alpha1StorageContainerSpec.  # noqa: E501
        :rtype: V1Container
        """
        return self._container

    @container.setter
    def container(self, container):
        """Sets the container of this V1alpha1StorageContainerSpec.


        :param container: The container of this V1alpha1StorageContainerSpec.  # noqa: E501
        :type: V1Container
        """
        if self.local_vars_configuration.client_side_validation and container is None:  # noqa: E501
            raise ValueError("Invalid value for `container`, must not be `None`")  # noqa: E501

        self._container = container

    @property
    def supported_uri_formats(self):
        """Gets the supported_uri_formats of this V1alpha1StorageContainerSpec.  # noqa: E501

        List of URI formats that this container supports  # noqa: E501

        :return: The supported_uri_formats of this V1alpha1StorageContainerSpec.  # noqa: E501
        :rtype: list[V1alpha1SupportedUriFormat]
        """
        return self._supported_uri_formats

    @supported_uri_formats.setter
    def supported_uri_formats(self, supported_uri_formats):
        """Sets the supported_uri_formats of this V1alpha1StorageContainerSpec.

        List of URI formats that this container supports  # noqa: E501

        :param supported_uri_formats: The supported_uri_formats of this V1alpha1StorageContainerSpec.  # noqa: E501
        :type: list[V1alpha1SupportedUriFormat]
        """
        if self.local_vars_configuration.client_side_validation and supported_uri_formats is None:  # noqa: E501
            raise ValueError("Invalid value for `supported_uri_formats`, must not be `None`")  # noqa: E501

        self._supported_uri_formats = supported_uri_formats

    @property
    def workload_type(self):
        """Gets the workload_type of this V1alpha1StorageContainerSpec.  # noqa: E501


        :return: The workload_type of this V1alpha1StorageContainerSpec.  # noqa: E501
        :rtype: str
        """
        return self._workload_type

    @workload_type.setter
    def workload_type(self, workload_type):
        """Sets the workload_type of this V1alpha1StorageContainerSpec.


        :param workload_type: The workload_type of this V1alpha1StorageContainerSpec.  # noqa: E501
        :type: str
        """

        self._workload_type = workload_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1StorageContainerSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1StorageContainerSpec):
            return True

        return self.to_dict() != other.to_dict()
