# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OnPremiseVantagePointWorkerArgs', 'OnPremiseVantagePointWorker']

@pulumi.input_type
class OnPremiseVantagePointWorkerArgs:
    def __init__(__self__, *,
                 apm_domain_id: pulumi.Input[str],
                 on_premise_vantage_point_id: pulumi.Input[str],
                 resource_principal_token_public_key: pulumi.Input[str],
                 version: pulumi.Input[str],
                 configuration_details: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 worker_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OnPremiseVantagePointWorker resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[str] on_premise_vantage_point_id: The OCID of the On-premise vantage point.
        :param pulumi.Input[str] resource_principal_token_public_key: public key for resource Principal Token based validation to be used in further calls.
        :param pulumi.Input[str] version: Image version of the On-premise VP worker.
        :param pulumi.Input[str] configuration_details: (Updatable) Configuration details of the On-premise VP worker.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] name: Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input[int] priority: (Updatable) Priority of the On-premise VP worker to schedule monitors.
        :param pulumi.Input[str] status: (Updatable) Enables or disables the On-premise VP worker.
        :param pulumi.Input[str] worker_type: Type of the On-premise VP worker.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        pulumi.set(__self__, "on_premise_vantage_point_id", on_premise_vantage_point_id)
        pulumi.set(__self__, "resource_principal_token_public_key", resource_principal_token_public_key)
        pulumi.set(__self__, "version", version)
        if configuration_details is not None:
            pulumi.set(__self__, "configuration_details", configuration_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if worker_type is not None:
            pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="onPremiseVantagePointId")
    def on_premise_vantage_point_id(self) -> pulumi.Input[str]:
        """
        The OCID of the On-premise vantage point.
        """
        return pulumi.get(self, "on_premise_vantage_point_id")

    @on_premise_vantage_point_id.setter
    def on_premise_vantage_point_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "on_premise_vantage_point_id", value)

    @property
    @pulumi.getter(name="resourcePrincipalTokenPublicKey")
    def resource_principal_token_public_key(self) -> pulumi.Input[str]:
        """
        public key for resource Principal Token based validation to be used in further calls.
        """
        return pulumi.get(self, "resource_principal_token_public_key")

    @resource_principal_token_public_key.setter
    def resource_principal_token_public_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_principal_token_public_key", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Image version of the On-premise VP worker.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Configuration details of the On-premise VP worker.
        """
        return pulumi.get(self, "configuration_details")

    @configuration_details.setter
    def configuration_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Priority of the On-premise VP worker to schedule monitors.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Enables or disables the On-premise VP worker.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the On-premise VP worker.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "worker_type")

    @worker_type.setter
    def worker_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_type", value)


@pulumi.input_type
class _OnPremiseVantagePointWorkerState:
    def __init__(__self__, *,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 configuration_details: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 geo_info: Optional[pulumi.Input[str]] = None,
                 identity_infos: Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerIdentityInfoArgs']]]] = None,
                 monitor_lists: Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerMonitorListArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_premise_vantage_point_id: Optional[pulumi.Input[str]] = None,
                 opvp_id: Optional[pulumi.Input[str]] = None,
                 opvp_name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 resource_principal_token_public_key: Optional[pulumi.Input[str]] = None,
                 runtime_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_sync_up: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 version_details: Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerVersionDetailArgs']]]] = None,
                 worker_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OnPremiseVantagePointWorker resources.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[str] configuration_details: (Updatable) Configuration details of the On-premise VP worker.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Unique name that can be edited. The name should not contain any confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] geo_info: Geographical information of the On-premise VP worker.
        :param pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerIdentityInfoArgs']]] identity_infos: Domain details of the On-premise VP worker.
        :param pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerMonitorListArgs']]] monitor_lists: Monitors list assigned to the On-premise VP worker.
        :param pulumi.Input[str] name: Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input[str] on_premise_vantage_point_id: The OCID of the On-premise vantage point.
        :param pulumi.Input[str] opvp_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the On-premise vantage point.
        :param pulumi.Input[str] opvp_name: On-premise vantage point name.
        :param pulumi.Input[int] priority: (Updatable) Priority of the On-premise VP worker to schedule monitors.
        :param pulumi.Input[str] resource_principal_token_public_key: public key for resource Principal Token based validation to be used in further calls.
        :param pulumi.Input[str] runtime_id: The runtime assigned id of the On-premise VP worker.
        :param pulumi.Input[str] status: (Updatable) Enables or disables the On-premise VP worker.
        :param pulumi.Input[str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_last_sync_up: The time the resource was last synced, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param pulumi.Input[str] version: Image version of the On-premise VP worker.
        :param pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerVersionDetailArgs']]] version_details: Image version details of the On-premise VP worker.
        :param pulumi.Input[str] worker_type: Type of the On-premise VP worker.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if apm_domain_id is not None:
            pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if configuration_details is not None:
            pulumi.set(__self__, "configuration_details", configuration_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if geo_info is not None:
            pulumi.set(__self__, "geo_info", geo_info)
        if identity_infos is not None:
            pulumi.set(__self__, "identity_infos", identity_infos)
        if monitor_lists is not None:
            pulumi.set(__self__, "monitor_lists", monitor_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_premise_vantage_point_id is not None:
            pulumi.set(__self__, "on_premise_vantage_point_id", on_premise_vantage_point_id)
        if opvp_id is not None:
            pulumi.set(__self__, "opvp_id", opvp_id)
        if opvp_name is not None:
            pulumi.set(__self__, "opvp_name", opvp_name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if resource_principal_token_public_key is not None:
            pulumi.set(__self__, "resource_principal_token_public_key", resource_principal_token_public_key)
        if runtime_id is not None:
            pulumi.set(__self__, "runtime_id", runtime_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_sync_up is not None:
            pulumi.set(__self__, "time_last_sync_up", time_last_sync_up)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_details is not None:
            pulumi.set(__self__, "version_details", version_details)
        if worker_type is not None:
            pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Configuration details of the On-premise VP worker.
        """
        return pulumi.get(self, "configuration_details")

    @configuration_details.setter
    def configuration_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="geoInfo")
    def geo_info(self) -> Optional[pulumi.Input[str]]:
        """
        Geographical information of the On-premise VP worker.
        """
        return pulumi.get(self, "geo_info")

    @geo_info.setter
    def geo_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geo_info", value)

    @property
    @pulumi.getter(name="identityInfos")
    def identity_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerIdentityInfoArgs']]]]:
        """
        Domain details of the On-premise VP worker.
        """
        return pulumi.get(self, "identity_infos")

    @identity_infos.setter
    def identity_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerIdentityInfoArgs']]]]):
        pulumi.set(self, "identity_infos", value)

    @property
    @pulumi.getter(name="monitorLists")
    def monitor_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerMonitorListArgs']]]]:
        """
        Monitors list assigned to the On-premise VP worker.
        """
        return pulumi.get(self, "monitor_lists")

    @monitor_lists.setter
    def monitor_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerMonitorListArgs']]]]):
        pulumi.set(self, "monitor_lists", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onPremiseVantagePointId")
    def on_premise_vantage_point_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the On-premise vantage point.
        """
        return pulumi.get(self, "on_premise_vantage_point_id")

    @on_premise_vantage_point_id.setter
    def on_premise_vantage_point_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_premise_vantage_point_id", value)

    @property
    @pulumi.getter(name="opvpId")
    def opvp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the On-premise vantage point.
        """
        return pulumi.get(self, "opvp_id")

    @opvp_id.setter
    def opvp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opvp_id", value)

    @property
    @pulumi.getter(name="opvpName")
    def opvp_name(self) -> Optional[pulumi.Input[str]]:
        """
        On-premise vantage point name.
        """
        return pulumi.get(self, "opvp_name")

    @opvp_name.setter
    def opvp_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opvp_name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Priority of the On-premise VP worker to schedule monitors.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="resourcePrincipalTokenPublicKey")
    def resource_principal_token_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        public key for resource Principal Token based validation to be used in further calls.
        """
        return pulumi.get(self, "resource_principal_token_public_key")

    @resource_principal_token_public_key.setter
    def resource_principal_token_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_principal_token_public_key", value)

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime assigned id of the On-premise VP worker.
        """
        return pulumi.get(self, "runtime_id")

    @runtime_id.setter
    def runtime_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Enables or disables the On-premise VP worker.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastSyncUp")
    def time_last_sync_up(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was last synced, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_last_sync_up")

    @time_last_sync_up.setter
    def time_last_sync_up(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_sync_up", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Image version of the On-premise VP worker.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="versionDetails")
    def version_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerVersionDetailArgs']]]]:
        """
        Image version details of the On-premise VP worker.
        """
        return pulumi.get(self, "version_details")

    @version_details.setter
    def version_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnPremiseVantagePointWorkerVersionDetailArgs']]]]):
        pulumi.set(self, "version_details", value)

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the On-premise VP worker.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "worker_type")

    @worker_type.setter
    def worker_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_type", value)


class OnPremiseVantagePointWorker(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 configuration_details: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_premise_vantage_point_id: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 resource_principal_token_public_key: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 worker_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the On Premise Vantage Point Worker resource in Oracle Cloud Infrastructure Apm Synthetics service.

        Registers a new worker.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_on_premise_vantage_point_worker = oci.apm_synthetics.OnPremiseVantagePointWorker("testOnPremiseVantagePointWorker",
            apm_domain_id=oci_apm_apm_domain["test_apm_domain"]["id"],
            on_premise_vantage_point_id=oci_apm_synthetics_on_premise_vantage_point["test_on_premise_vantage_point"]["id"],
            resource_principal_token_public_key=var["on_premise_vantage_point_worker_resource_principal_token_public_key"],
            version=var["on_premise_vantage_point_worker_version"],
            configuration_details=var["on_premise_vantage_point_worker_configuration_details"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            priority=var["on_premise_vantage_point_worker_priority"],
            status=var["on_premise_vantage_point_worker_status"],
            worker_type=var["on_premise_vantage_point_worker_worker_type"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        OnPremiseVantagePointWorkers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmSynthetics/onPremiseVantagePointWorker:OnPremiseVantagePointWorker test_on_premise_vantage_point_worker "onPremiseVantagePoints/{onPremiseVantagePointId}/workers/{workerId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[str] configuration_details: (Updatable) Configuration details of the On-premise VP worker.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] name: Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input[str] on_premise_vantage_point_id: The OCID of the On-premise vantage point.
        :param pulumi.Input[int] priority: (Updatable) Priority of the On-premise VP worker to schedule monitors.
        :param pulumi.Input[str] resource_principal_token_public_key: public key for resource Principal Token based validation to be used in further calls.
        :param pulumi.Input[str] status: (Updatable) Enables or disables the On-premise VP worker.
        :param pulumi.Input[str] version: Image version of the On-premise VP worker.
        :param pulumi.Input[str] worker_type: Type of the On-premise VP worker.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OnPremiseVantagePointWorkerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the On Premise Vantage Point Worker resource in Oracle Cloud Infrastructure Apm Synthetics service.

        Registers a new worker.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_on_premise_vantage_point_worker = oci.apm_synthetics.OnPremiseVantagePointWorker("testOnPremiseVantagePointWorker",
            apm_domain_id=oci_apm_apm_domain["test_apm_domain"]["id"],
            on_premise_vantage_point_id=oci_apm_synthetics_on_premise_vantage_point["test_on_premise_vantage_point"]["id"],
            resource_principal_token_public_key=var["on_premise_vantage_point_worker_resource_principal_token_public_key"],
            version=var["on_premise_vantage_point_worker_version"],
            configuration_details=var["on_premise_vantage_point_worker_configuration_details"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            priority=var["on_premise_vantage_point_worker_priority"],
            status=var["on_premise_vantage_point_worker_status"],
            worker_type=var["on_premise_vantage_point_worker_worker_type"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        OnPremiseVantagePointWorkers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmSynthetics/onPremiseVantagePointWorker:OnPremiseVantagePointWorker test_on_premise_vantage_point_worker "onPremiseVantagePoints/{onPremiseVantagePointId}/workers/{workerId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param OnPremiseVantagePointWorkerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OnPremiseVantagePointWorkerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 configuration_details: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_premise_vantage_point_id: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 resource_principal_token_public_key: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 worker_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OnPremiseVantagePointWorkerArgs.__new__(OnPremiseVantagePointWorkerArgs)

            if apm_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'apm_domain_id'")
            __props__.__dict__["apm_domain_id"] = apm_domain_id
            __props__.__dict__["configuration_details"] = configuration_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            if on_premise_vantage_point_id is None and not opts.urn:
                raise TypeError("Missing required property 'on_premise_vantage_point_id'")
            __props__.__dict__["on_premise_vantage_point_id"] = on_premise_vantage_point_id
            __props__.__dict__["priority"] = priority
            if resource_principal_token_public_key is None and not opts.urn:
                raise TypeError("Missing required property 'resource_principal_token_public_key'")
            __props__.__dict__["resource_principal_token_public_key"] = resource_principal_token_public_key
            __props__.__dict__["status"] = status
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["worker_type"] = worker_type
            __props__.__dict__["display_name"] = None
            __props__.__dict__["geo_info"] = None
            __props__.__dict__["identity_infos"] = None
            __props__.__dict__["monitor_lists"] = None
            __props__.__dict__["opvp_id"] = None
            __props__.__dict__["opvp_name"] = None
            __props__.__dict__["runtime_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_sync_up"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version_details"] = None
        super(OnPremiseVantagePointWorker, __self__).__init__(
            'oci:ApmSynthetics/onPremiseVantagePointWorker:OnPremiseVantagePointWorker',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apm_domain_id: Optional[pulumi.Input[str]] = None,
            configuration_details: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            geo_info: Optional[pulumi.Input[str]] = None,
            identity_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OnPremiseVantagePointWorkerIdentityInfoArgs']]]]] = None,
            monitor_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OnPremiseVantagePointWorkerMonitorListArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            on_premise_vantage_point_id: Optional[pulumi.Input[str]] = None,
            opvp_id: Optional[pulumi.Input[str]] = None,
            opvp_name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            resource_principal_token_public_key: Optional[pulumi.Input[str]] = None,
            runtime_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_sync_up: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            version_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OnPremiseVantagePointWorkerVersionDetailArgs']]]]] = None,
            worker_type: Optional[pulumi.Input[str]] = None) -> 'OnPremiseVantagePointWorker':
        """
        Get an existing OnPremiseVantagePointWorker resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[str] configuration_details: (Updatable) Configuration details of the On-premise VP worker.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Unique name that can be edited. The name should not contain any confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] geo_info: Geographical information of the On-premise VP worker.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OnPremiseVantagePointWorkerIdentityInfoArgs']]]] identity_infos: Domain details of the On-premise VP worker.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OnPremiseVantagePointWorkerMonitorListArgs']]]] monitor_lists: Monitors list assigned to the On-premise VP worker.
        :param pulumi.Input[str] name: Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input[str] on_premise_vantage_point_id: The OCID of the On-premise vantage point.
        :param pulumi.Input[str] opvp_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the On-premise vantage point.
        :param pulumi.Input[str] opvp_name: On-premise vantage point name.
        :param pulumi.Input[int] priority: (Updatable) Priority of the On-premise VP worker to schedule monitors.
        :param pulumi.Input[str] resource_principal_token_public_key: public key for resource Principal Token based validation to be used in further calls.
        :param pulumi.Input[str] runtime_id: The runtime assigned id of the On-premise VP worker.
        :param pulumi.Input[str] status: (Updatable) Enables or disables the On-premise VP worker.
        :param pulumi.Input[str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_last_sync_up: The time the resource was last synced, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param pulumi.Input[str] version: Image version of the On-premise VP worker.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OnPremiseVantagePointWorkerVersionDetailArgs']]]] version_details: Image version details of the On-premise VP worker.
        :param pulumi.Input[str] worker_type: Type of the On-premise VP worker.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OnPremiseVantagePointWorkerState.__new__(_OnPremiseVantagePointWorkerState)

        __props__.__dict__["apm_domain_id"] = apm_domain_id
        __props__.__dict__["configuration_details"] = configuration_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["geo_info"] = geo_info
        __props__.__dict__["identity_infos"] = identity_infos
        __props__.__dict__["monitor_lists"] = monitor_lists
        __props__.__dict__["name"] = name
        __props__.__dict__["on_premise_vantage_point_id"] = on_premise_vantage_point_id
        __props__.__dict__["opvp_id"] = opvp_id
        __props__.__dict__["opvp_name"] = opvp_name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["resource_principal_token_public_key"] = resource_principal_token_public_key
        __props__.__dict__["runtime_id"] = runtime_id
        __props__.__dict__["status"] = status
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_sync_up"] = time_last_sync_up
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        __props__.__dict__["version_details"] = version_details
        __props__.__dict__["worker_type"] = worker_type
        return OnPremiseVantagePointWorker(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> pulumi.Output[str]:
        """
        (Updatable) Configuration details of the On-premise VP worker.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="geoInfo")
    def geo_info(self) -> pulumi.Output[str]:
        """
        Geographical information of the On-premise VP worker.
        """
        return pulumi.get(self, "geo_info")

    @property
    @pulumi.getter(name="identityInfos")
    def identity_infos(self) -> pulumi.Output[Sequence['outputs.OnPremiseVantagePointWorkerIdentityInfo']]:
        """
        Domain details of the On-premise VP worker.
        """
        return pulumi.get(self, "identity_infos")

    @property
    @pulumi.getter(name="monitorLists")
    def monitor_lists(self) -> pulumi.Output[Sequence['outputs.OnPremiseVantagePointWorkerMonitorList']]:
        """
        Monitors list assigned to the On-premise VP worker.
        """
        return pulumi.get(self, "monitor_lists")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onPremiseVantagePointId")
    def on_premise_vantage_point_id(self) -> pulumi.Output[str]:
        """
        The OCID of the On-premise vantage point.
        """
        return pulumi.get(self, "on_premise_vantage_point_id")

    @property
    @pulumi.getter(name="opvpId")
    def opvp_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the On-premise vantage point.
        """
        return pulumi.get(self, "opvp_id")

    @property
    @pulumi.getter(name="opvpName")
    def opvp_name(self) -> pulumi.Output[str]:
        """
        On-premise vantage point name.
        """
        return pulumi.get(self, "opvp_name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        (Updatable) Priority of the On-premise VP worker to schedule monitors.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="resourcePrincipalTokenPublicKey")
    def resource_principal_token_public_key(self) -> pulumi.Output[str]:
        """
        public key for resource Principal Token based validation to be used in further calls.
        """
        return pulumi.get(self, "resource_principal_token_public_key")

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> pulumi.Output[str]:
        """
        The runtime assigned id of the On-premise VP worker.
        """
        return pulumi.get(self, "runtime_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) Enables or disables the On-premise VP worker.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastSyncUp")
    def time_last_sync_up(self) -> pulumi.Output[str]:
        """
        The time the resource was last synced, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_last_sync_up")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Image version of the On-premise VP worker.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionDetails")
    def version_details(self) -> pulumi.Output[Sequence['outputs.OnPremiseVantagePointWorkerVersionDetail']]:
        """
        Image version details of the On-premise VP worker.
        """
        return pulumi.get(self, "version_details")

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> pulumi.Output[str]:
        """
        Type of the On-premise VP worker.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "worker_type")

