# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 kubernetes_version: pulumi.Input[str],
                 vcn_id: pulumi.Input[str],
                 cluster_pod_network_options: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterPodNetworkOptionArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 endpoint_config: Optional[pulumi.Input['ClusterEndpointConfigArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_policy_config: Optional[pulumi.Input['ClusterImagePolicyConfigArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['ClusterOptionsArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which to create the cluster.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install into the cluster masters.
        :param pulumi.Input[str] vcn_id: The OCID of the virtual cloud network (VCN) in which to create the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterPodNetworkOptionArgs']]] cluster_pod_network_options: Available CNIs and network options for existing and new node pools of the cluster
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input['ClusterEndpointConfigArgs'] endpoint_config: The network configuration for access to the Cluster control plane.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['ClusterImagePolicyConfigArgs'] image_policy_config: (Updatable) The image verification policy for signature validation. Once a policy is created and enabled with one or more kms keys, the policy will ensure all images deployed has been signed with the key(s) attached to the policy.
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        :param pulumi.Input[str] name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input['ClusterOptionsArgs'] options: (Updatable) Optional attributes for the cluster.
        :param pulumi.Input[str] type: (Updatable) Type of cluster
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        pulumi.set(__self__, "vcn_id", vcn_id)
        if cluster_pod_network_options is not None:
            pulumi.set(__self__, "cluster_pod_network_options", cluster_pod_network_options)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_policy_config is not None:
            pulumi.set(__self__, "image_policy_config", image_policy_config)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment in which to create the cluster.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Input[str]:
        """
        (Updatable) The version of Kubernetes to install into the cluster masters.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[str]:
        """
        The OCID of the virtual cloud network (VCN) in which to create the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcn_id", value)

    @property
    @pulumi.getter(name="clusterPodNetworkOptions")
    def cluster_pod_network_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterPodNetworkOptionArgs']]]]:
        """
        Available CNIs and network options for existing and new node pools of the cluster
        """
        return pulumi.get(self, "cluster_pod_network_options")

    @cluster_pod_network_options.setter
    def cluster_pod_network_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterPodNetworkOptionArgs']]]]):
        pulumi.set(self, "cluster_pod_network_options", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input['ClusterEndpointConfigArgs']]:
        """
        The network configuration for access to the Cluster control plane.
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input['ClusterEndpointConfigArgs']]):
        pulumi.set(self, "endpoint_config", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imagePolicyConfig")
    def image_policy_config(self) -> Optional[pulumi.Input['ClusterImagePolicyConfigArgs']]:
        """
        (Updatable) The image verification policy for signature validation. Once a policy is created and enabled with one or more kms keys, the policy will ensure all images deployed has been signed with the key(s) attached to the policy.
        """
        return pulumi.get(self, "image_policy_config")

    @image_policy_config.setter
    def image_policy_config(self, value: Optional[pulumi.Input['ClusterImagePolicyConfigArgs']]):
        pulumi.set(self, "image_policy_config", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['ClusterOptionsArgs']]:
        """
        (Updatable) Optional attributes for the cluster.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['ClusterOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of cluster
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 available_kubernetes_upgrades: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cluster_pod_network_options: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterPodNetworkOptionArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 endpoint_config: Optional[pulumi.Input['ClusterEndpointConfigArgs']] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_policy_config: Optional[pulumi.Input['ClusterImagePolicyConfigArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['ClusterOptionsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_kubernetes_upgrades: Available Kubernetes versions to which the clusters masters may be upgraded.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterPodNetworkOptionArgs']]] cluster_pod_network_options: Available CNIs and network options for existing and new node pools of the cluster
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which to create the cluster.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input['ClusterEndpointConfigArgs'] endpoint_config: The network configuration for access to the Cluster control plane.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]] endpoints: Endpoints served up by the cluster masters.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['ClusterImagePolicyConfigArgs'] image_policy_config: (Updatable) The image verification policy for signature validation. Once a policy is created and enabled with one or more kms keys, the policy will ensure all images deployed has been signed with the key(s) attached to the policy.
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install into the cluster masters.
        :param pulumi.Input[str] lifecycle_details: Details about the state of the cluster masters.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMetadataArgs']]] metadatas: Metadata about the cluster.
        :param pulumi.Input[str] name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input['ClusterOptionsArgs'] options: (Updatable) Optional attributes for the cluster.
        :param pulumi.Input[str] state: The state of the cluster masters.
        :param pulumi.Input[str] type: (Updatable) Type of cluster
        :param pulumi.Input[str] vcn_id: The OCID of the virtual cloud network (VCN) in which to create the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if available_kubernetes_upgrades is not None:
            pulumi.set(__self__, "available_kubernetes_upgrades", available_kubernetes_upgrades)
        if cluster_pod_network_options is not None:
            pulumi.set(__self__, "cluster_pod_network_options", cluster_pod_network_options)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image_policy_config is not None:
            pulumi.set(__self__, "image_policy_config", image_policy_config)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="availableKubernetesUpgrades")
    def available_kubernetes_upgrades(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Available Kubernetes versions to which the clusters masters may be upgraded.
        """
        return pulumi.get(self, "available_kubernetes_upgrades")

    @available_kubernetes_upgrades.setter
    def available_kubernetes_upgrades(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_kubernetes_upgrades", value)

    @property
    @pulumi.getter(name="clusterPodNetworkOptions")
    def cluster_pod_network_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterPodNetworkOptionArgs']]]]:
        """
        Available CNIs and network options for existing and new node pools of the cluster
        """
        return pulumi.get(self, "cluster_pod_network_options")

    @cluster_pod_network_options.setter
    def cluster_pod_network_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterPodNetworkOptionArgs']]]]):
        pulumi.set(self, "cluster_pod_network_options", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment in which to create the cluster.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input['ClusterEndpointConfigArgs']]:
        """
        The network configuration for access to the Cluster control plane.
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input['ClusterEndpointConfigArgs']]):
        pulumi.set(self, "endpoint_config", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]]:
        """
        Endpoints served up by the cluster masters.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="imagePolicyConfig")
    def image_policy_config(self) -> Optional[pulumi.Input['ClusterImagePolicyConfigArgs']]:
        """
        (Updatable) The image verification policy for signature validation. Once a policy is created and enabled with one or more kms keys, the policy will ensure all images deployed has been signed with the key(s) attached to the policy.
        """
        return pulumi.get(self, "image_policy_config")

    @image_policy_config.setter
    def image_policy_config(self, value: Optional[pulumi.Input['ClusterImagePolicyConfigArgs']]):
        pulumi.set(self, "image_policy_config", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of Kubernetes to install into the cluster masters.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the state of the cluster masters.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMetadataArgs']]]]:
        """
        Metadata about the cluster.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['ClusterOptionsArgs']]:
        """
        (Updatable) Optional attributes for the cluster.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['ClusterOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the cluster masters.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of cluster
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the virtual cloud network (VCN) in which to create the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_id", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_pod_network_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterClusterPodNetworkOptionArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 endpoint_config: Optional[pulumi.Input[pulumi.InputType['ClusterEndpointConfigArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_policy_config: Optional[pulumi.Input[pulumi.InputType['ClusterImagePolicyConfigArgs']]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['ClusterOptionsArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Cluster resource in Oracle Cloud Infrastructure Container Engine service.

        Create a new cluster.

        ## Import

        Clusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ContainerEngine/cluster:Cluster test_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterClusterPodNetworkOptionArgs']]]] cluster_pod_network_options: Available CNIs and network options for existing and new node pools of the cluster
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which to create the cluster.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[pulumi.InputType['ClusterEndpointConfigArgs']] endpoint_config: The network configuration for access to the Cluster control plane.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[pulumi.InputType['ClusterImagePolicyConfigArgs']] image_policy_config: (Updatable) The image verification policy for signature validation. Once a policy is created and enabled with one or more kms keys, the policy will ensure all images deployed has been signed with the key(s) attached to the policy.
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install into the cluster masters.
        :param pulumi.Input[str] name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[pulumi.InputType['ClusterOptionsArgs']] options: (Updatable) Optional attributes for the cluster.
        :param pulumi.Input[str] type: (Updatable) Type of cluster
        :param pulumi.Input[str] vcn_id: The OCID of the virtual cloud network (VCN) in which to create the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cluster resource in Oracle Cloud Infrastructure Container Engine service.

        Create a new cluster.

        ## Import

        Clusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ContainerEngine/cluster:Cluster test_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_pod_network_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterClusterPodNetworkOptionArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 endpoint_config: Optional[pulumi.Input[pulumi.InputType['ClusterEndpointConfigArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image_policy_config: Optional[pulumi.Input[pulumi.InputType['ClusterImagePolicyConfigArgs']]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['ClusterOptionsArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["cluster_pod_network_options"] = cluster_pod_network_options
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["endpoint_config"] = endpoint_config
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["image_policy_config"] = image_policy_config
            __props__.__dict__["kms_key_id"] = kms_key_id
            if kubernetes_version is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_version'")
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["type"] = type
            if vcn_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_id'")
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["available_kubernetes_upgrades"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["state"] = None
        super(Cluster, __self__).__init__(
            'oci:ContainerEngine/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_kubernetes_upgrades: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cluster_pod_network_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterClusterPodNetworkOptionArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            endpoint_config: Optional[pulumi.Input[pulumi.InputType['ClusterEndpointConfigArgs']]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterEndpointArgs']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            image_policy_config: Optional[pulumi.Input[pulumi.InputType['ClusterImagePolicyConfigArgs']]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            kubernetes_version: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterMetadataArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[pulumi.InputType['ClusterOptionsArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vcn_id: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_kubernetes_upgrades: Available Kubernetes versions to which the clusters masters may be upgraded.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterClusterPodNetworkOptionArgs']]]] cluster_pod_network_options: Available CNIs and network options for existing and new node pools of the cluster
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which to create the cluster.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[pulumi.InputType['ClusterEndpointConfigArgs']] endpoint_config: The network configuration for access to the Cluster control plane.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterEndpointArgs']]]] endpoints: Endpoints served up by the cluster masters.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[pulumi.InputType['ClusterImagePolicyConfigArgs']] image_policy_config: (Updatable) The image verification policy for signature validation. Once a policy is created and enabled with one or more kms keys, the policy will ensure all images deployed has been signed with the key(s) attached to the policy.
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install into the cluster masters.
        :param pulumi.Input[str] lifecycle_details: Details about the state of the cluster masters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterMetadataArgs']]]] metadatas: Metadata about the cluster.
        :param pulumi.Input[str] name: (Updatable) The name of the cluster. Avoid entering confidential information.
        :param pulumi.Input[pulumi.InputType['ClusterOptionsArgs']] options: (Updatable) Optional attributes for the cluster.
        :param pulumi.Input[str] state: The state of the cluster masters.
        :param pulumi.Input[str] type: (Updatable) Type of cluster
        :param pulumi.Input[str] vcn_id: The OCID of the virtual cloud network (VCN) in which to create the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["available_kubernetes_upgrades"] = available_kubernetes_upgrades
        __props__.__dict__["cluster_pod_network_options"] = cluster_pod_network_options
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["endpoint_config"] = endpoint_config
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image_policy_config"] = image_policy_config
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["vcn_id"] = vcn_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availableKubernetesUpgrades")
    def available_kubernetes_upgrades(self) -> pulumi.Output[Sequence[str]]:
        """
        Available Kubernetes versions to which the clusters masters may be upgraded.
        """
        return pulumi.get(self, "available_kubernetes_upgrades")

    @property
    @pulumi.getter(name="clusterPodNetworkOptions")
    def cluster_pod_network_options(self) -> pulumi.Output[Sequence['outputs.ClusterClusterPodNetworkOption']]:
        """
        Available CNIs and network options for existing and new node pools of the cluster
        """
        return pulumi.get(self, "cluster_pod_network_options")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment in which to create the cluster.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> pulumi.Output[Optional['outputs.ClusterEndpointConfig']]:
        """
        The network configuration for access to the Cluster control plane.
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterEndpoint']]:
        """
        Endpoints served up by the cluster masters.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="imagePolicyConfig")
    def image_policy_config(self) -> pulumi.Output['outputs.ClusterImagePolicyConfig']:
        """
        (Updatable) The image verification policy for signature validation. Once a policy is created and enabled with one or more kms keys, the policy will ensure all images deployed has been signed with the key(s) attached to the policy.
        """
        return pulumi.get(self, "image_policy_config")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The version of Kubernetes to install into the cluster masters.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the state of the cluster masters.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.ClusterMetadata']]:
        """
        Metadata about the cluster.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.ClusterOptions']:
        """
        (Updatable) Optional attributes for the cluster.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the cluster masters.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        (Updatable) Type of cluster
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[str]:
        """
        The OCID of the virtual cloud network (VCN) in which to create the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

