# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthenticationPolicyArgs', 'AuthenticationPolicy']

@pulumi.input_type
class AuthenticationPolicyArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 network_policy: Optional[pulumi.Input['AuthenticationPolicyNetworkPolicyArgs']] = None,
                 password_policy: Optional[pulumi.Input['AuthenticationPolicyPasswordPolicyArgs']] = None):
        """
        The set of arguments for constructing a AuthenticationPolicy resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input['AuthenticationPolicyNetworkPolicyArgs'] network_policy: (Updatable) Network policy, Consists of a list of Network Source ids.
        :param pulumi.Input['AuthenticationPolicyPasswordPolicyArgs'] password_policy: (Updatable) Password policy, currently set for the given compartment.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyNetworkPolicyArgs']]:
        """
        (Updatable) Network policy, Consists of a list of Network Source ids.
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyNetworkPolicyArgs']]):
        pulumi.set(self, "network_policy", value)

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyPasswordPolicyArgs']]:
        """
        (Updatable) Password policy, currently set for the given compartment.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyPasswordPolicyArgs']]):
        pulumi.set(self, "password_policy", value)


@pulumi.input_type
class _AuthenticationPolicyState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 network_policy: Optional[pulumi.Input['AuthenticationPolicyNetworkPolicyArgs']] = None,
                 password_policy: Optional[pulumi.Input['AuthenticationPolicyPasswordPolicyArgs']] = None):
        """
        Input properties used for looking up and filtering AuthenticationPolicy resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input['AuthenticationPolicyNetworkPolicyArgs'] network_policy: (Updatable) Network policy, Consists of a list of Network Source ids.
        :param pulumi.Input['AuthenticationPolicyPasswordPolicyArgs'] password_policy: (Updatable) Password policy, currently set for the given compartment.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if password_policy is not None:
            pulumi.set(__self__, "password_policy", password_policy)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyNetworkPolicyArgs']]:
        """
        (Updatable) Network policy, Consists of a list of Network Source ids.
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyNetworkPolicyArgs']]):
        pulumi.set(self, "network_policy", value)

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyPasswordPolicyArgs']]:
        """
        (Updatable) Password policy, currently set for the given compartment.
        """
        return pulumi.get(self, "password_policy")

    @password_policy.setter
    def password_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyPasswordPolicyArgs']]):
        pulumi.set(self, "password_policy", value)


class AuthenticationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 network_policy: Optional[pulumi.Input[pulumi.InputType['AuthenticationPolicyNetworkPolicyArgs']]] = None,
                 password_policy: Optional[pulumi.Input[pulumi.InputType['AuthenticationPolicyPasswordPolicyArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Authentication Policy resource in Oracle Cloud Infrastructure Identity service.

        Updates authentication policy for the specified tenancy

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_authentication_policy = oci.identity.AuthenticationPolicy("testAuthenticationPolicy",
            compartment_id=var["tenancy_ocid"],
            network_policy=oci.identity.AuthenticationPolicyNetworkPolicyArgs(
                network_source_ids=var["authentication_policy_network_policy_network_source_ids"],
            ),
            password_policy=oci.identity.AuthenticationPolicyPasswordPolicyArgs(
                is_lowercase_characters_required=var["authentication_policy_password_policy_is_lowercase_characters_required"],
                is_numeric_characters_required=var["authentication_policy_password_policy_is_numeric_characters_required"],
                is_special_characters_required=var["authentication_policy_password_policy_is_special_characters_required"],
                is_uppercase_characters_required=var["authentication_policy_password_policy_is_uppercase_characters_required"],
                is_username_containment_allowed=var["authentication_policy_password_policy_is_username_containment_allowed"],
                minimum_password_length=var["authentication_policy_password_policy_minimum_password_length"],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        AuthenticationPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/authenticationPolicy:AuthenticationPolicy test_authentication_policy "authenticationPolicies/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[pulumi.InputType['AuthenticationPolicyNetworkPolicyArgs']] network_policy: (Updatable) Network policy, Consists of a list of Network Source ids.
        :param pulumi.Input[pulumi.InputType['AuthenticationPolicyPasswordPolicyArgs']] password_policy: (Updatable) Password policy, currently set for the given compartment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Authentication Policy resource in Oracle Cloud Infrastructure Identity service.

        Updates authentication policy for the specified tenancy

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_authentication_policy = oci.identity.AuthenticationPolicy("testAuthenticationPolicy",
            compartment_id=var["tenancy_ocid"],
            network_policy=oci.identity.AuthenticationPolicyNetworkPolicyArgs(
                network_source_ids=var["authentication_policy_network_policy_network_source_ids"],
            ),
            password_policy=oci.identity.AuthenticationPolicyPasswordPolicyArgs(
                is_lowercase_characters_required=var["authentication_policy_password_policy_is_lowercase_characters_required"],
                is_numeric_characters_required=var["authentication_policy_password_policy_is_numeric_characters_required"],
                is_special_characters_required=var["authentication_policy_password_policy_is_special_characters_required"],
                is_uppercase_characters_required=var["authentication_policy_password_policy_is_uppercase_characters_required"],
                is_username_containment_allowed=var["authentication_policy_password_policy_is_username_containment_allowed"],
                minimum_password_length=var["authentication_policy_password_policy_minimum_password_length"],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        AuthenticationPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/authenticationPolicy:AuthenticationPolicy test_authentication_policy "authenticationPolicies/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param AuthenticationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 network_policy: Optional[pulumi.Input[pulumi.InputType['AuthenticationPolicyNetworkPolicyArgs']]] = None,
                 password_policy: Optional[pulumi.Input[pulumi.InputType['AuthenticationPolicyPasswordPolicyArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticationPolicyArgs.__new__(AuthenticationPolicyArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["network_policy"] = network_policy
            __props__.__dict__["password_policy"] = password_policy
        super(AuthenticationPolicy, __self__).__init__(
            'oci:Identity/authenticationPolicy:AuthenticationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            network_policy: Optional[pulumi.Input[pulumi.InputType['AuthenticationPolicyNetworkPolicyArgs']]] = None,
            password_policy: Optional[pulumi.Input[pulumi.InputType['AuthenticationPolicyPasswordPolicyArgs']]] = None) -> 'AuthenticationPolicy':
        """
        Get an existing AuthenticationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[pulumi.InputType['AuthenticationPolicyNetworkPolicyArgs']] network_policy: (Updatable) Network policy, Consists of a list of Network Source ids.
        :param pulumi.Input[pulumi.InputType['AuthenticationPolicyPasswordPolicyArgs']] password_policy: (Updatable) Password policy, currently set for the given compartment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticationPolicyState.__new__(_AuthenticationPolicyState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["network_policy"] = network_policy
        __props__.__dict__["password_policy"] = password_policy
        return AuthenticationPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> pulumi.Output['outputs.AuthenticationPolicyNetworkPolicy']:
        """
        (Updatable) Network policy, Consists of a list of Network Source ids.
        """
        return pulumi.get(self, "network_policy")

    @property
    @pulumi.getter(name="passwordPolicy")
    def password_policy(self) -> pulumi.Output['outputs.AuthenticationPolicyPasswordPolicy']:
        """
        (Updatable) Password policy, currently set for the given compartment.
        """
        return pulumi.get(self, "password_policy")

