# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHostScanRecipesResult',
    'AwaitableGetHostScanRecipesResult',
    'get_host_scan_recipes',
    'get_host_scan_recipes_output',
]

@pulumi.output_type
class GetHostScanRecipesResult:
    """
    A collection of values returned by getHostScanRecipes.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, host_scan_recipe_summary_collections=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if host_scan_recipe_summary_collections and not isinstance(host_scan_recipe_summary_collections, list):
            raise TypeError("Expected argument 'host_scan_recipe_summary_collections' to be a list")
        pulumi.set(__self__, "host_scan_recipe_summary_collections", host_scan_recipe_summary_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment ID of the scan recipe
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Recipe identifier, which can be renamed
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetHostScanRecipesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="hostScanRecipeSummaryCollections")
    def host_scan_recipe_summary_collections(self) -> Sequence['outputs.GetHostScanRecipesHostScanRecipeSummaryCollectionResult']:
        """
        The list of host_scan_recipe_summary_collection.
        """
        return pulumi.get(self, "host_scan_recipe_summary_collections")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")


class AwaitableGetHostScanRecipesResult(GetHostScanRecipesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostScanRecipesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            host_scan_recipe_summary_collections=self.host_scan_recipe_summary_collections,
            id=self.id,
            state=self.state)


def get_host_scan_recipes(compartment_id: Optional[str] = None,
                          display_name: Optional[str] = None,
                          filters: Optional[Sequence[pulumi.InputType['GetHostScanRecipesFilterArgs']]] = None,
                          state: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostScanRecipesResult:
    """
    This data source provides the list of Host Scan Recipes in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a list of HostScanRecipeSummary objects in a compartment. A recipe determines the types of security issues that you want scanned, and how often to scan.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_scan_recipes = oci.VulnerabilityScanning.get_host_scan_recipes(compartment_id=var["compartment_id"],
        display_name=var["host_scan_recipe_display_name"],
        state=var["host_scan_recipe_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:VulnerabilityScanning/getHostScanRecipes:getHostScanRecipes', __args__, opts=opts, typ=GetHostScanRecipesResult).value

    return AwaitableGetHostScanRecipesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        host_scan_recipe_summary_collections=pulumi.get(__ret__, 'host_scan_recipe_summary_collections'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_host_scan_recipes)
def get_host_scan_recipes_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetHostScanRecipesFilterArgs']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHostScanRecipesResult]:
    """
    This data source provides the list of Host Scan Recipes in Oracle Cloud Infrastructure Vulnerability Scanning service.

    Retrieves a list of HostScanRecipeSummary objects in a compartment. A recipe determines the types of security issues that you want scanned, and how often to scan.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_host_scan_recipes = oci.VulnerabilityScanning.get_host_scan_recipes(compartment_id=var["compartment_id"],
        display_name=var["host_scan_recipe_display_name"],
        state=var["host_scan_recipe_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    ...
