# ESP32 固件文件

这个目录包含了ESP32的预编译固件文件，用于自动烧录功能。

## 文件说明

- `firmware.bin` - ESP32 Arduino风格固件的预编译版本
- 支持DHT11温湿度传感器读取
- 支持数字IO控制（LED、继电器等）
- 支持模拟输入读取
- 支持串口命令协议

## 使用场景

1. **Docker环境** - 当用户在Docker容器中使用时，自动从这个目录获取固件
2. **生产环境** - 当没有开发源码时，提供预编译固件进行自动烧录
3. **用户便利** - 用户无需手动编译固件，实现真正的即插即用

## 自动烧录流程

1. ESP32设备管理器检测到设备但没有固件
2. 自动从此目录获取预编译固件
3. 使用esptool烧录固件到ESP32
4. 等待设备重启并验证固件

## 固件信息

- 编译环境: PlatformIO
- 目标芯片: ESP32
- 固件大小: 约1MB
- 支持功能: DHT11、数字IO、模拟输入、串口通信

## 版本

- 固件版本: 1.0.0
- 对应库版本: esp32-arduino-python v2.2.0+
- 支持协议: Arduino风格串口命令协议