from importlib.metadata import PackageNotFoundError, version

try:
    __version__ = version("plotnine")
except PackageNotFoundError:
    # package is not installed
    pass
finally:
    del version
    del PackageNotFoundError

# Imports below are generated with the following command:
#
# python -c "from plotnine._utils.dev import get_plotnine_all; get_plotnine_all()"  # noqa: E501
#
# added to the clipboard. Run it and paste the results. Do not edit by hand.

from .coords import *
from .facets import *
from .geoms import *
from .ggplot import *
from .guides import *
from .labels import *
from .mapping import *
from .positions import *
from .qplot import *
from .scales import *
from .stats import *
from .themes import *
from .themes.elements import *
from .watermark import *

__all__ = (
    # plotnine.coords
    "coord_cartesian",
    "coord_equal",
    "coord_fixed",
    "coord_flip",
    "coord_trans",
    # plotnine.facets
    "as_labeller",
    "facet_grid",
    "facet_null",
    "facet_wrap",
    "label_both",
    "label_context",
    "label_value",
    "labeller",
    # plotnine.geoms
    "annotate",
    "annotation_logticks",
    "annotation_stripes",
    "arrow",
    "geom_abline",
    "geom_area",
    "geom_bar",
    "geom_bin2d",
    "geom_bin_2d",
    "geom_blank",
    "geom_boxplot",
    "geom_col",
    "geom_count",
    "geom_crossbar",
    "geom_density",
    "geom_density_2d",
    "geom_dotplot",
    "geom_errorbar",
    "geom_errorbarh",
    "geom_freqpoly",
    "geom_histogram",
    "geom_hline",
    "geom_jitter",
    "geom_label",
    "geom_line",
    "geom_linerange",
    "geom_map",
    "geom_path",
    "geom_point",
    "geom_pointdensity",
    "geom_pointrange",
    "geom_polygon",
    "geom_qq",
    "geom_qq_line",
    "geom_quantile",
    "geom_raster",
    "geom_rect",
    "geom_ribbon",
    "geom_rug",
    "geom_segment",
    "geom_sina",
    "geom_smooth",
    "geom_spoke",
    "geom_step",
    "geom_text",
    "geom_tile",
    "geom_violin",
    "geom_vline",
    # plotnine.ggplot
    "ggplot",
    "ggsave",
    "save_as_pdf_pages",
    # plotnine.guides
    "guide_colorbar",
    "guide_colourbar",
    "guide_legend",
    "guides",
    # plotnine.labels
    "ggtitle",
    "labs",
    "xlab",
    "ylab",
    # plotnine.mapping
    "aes",
    "after_scale",
    "after_stat",
    "stage",
    # plotnine.positions
    "position_dodge",
    "position_dodge2",
    "position_fill",
    "position_identity",
    "position_jitter",
    "position_jitterdodge",
    "position_nudge",
    "position_stack",
    # plotnine.qplot
    "qplot",
    # plotnine.scales
    "expand_limits",
    "lims",
    "scale_alpha",
    "scale_alpha_continuous",
    "scale_alpha_datetime",
    "scale_alpha_discrete",
    "scale_alpha_identity",
    "scale_alpha_manual",
    "scale_alpha_ordinal",
    "scale_color_brewer",
    "scale_color_cmap",
    "scale_color_cmap_d",
    "scale_color_continuous",
    "scale_color_datetime",
    "scale_color_desaturate",
    "scale_color_discrete",
    "scale_color_distiller",
    "scale_color_gradient",
    "scale_color_gradient2",
    "scale_color_gradientn",
    "scale_color_gray",
    "scale_color_grey",
    "scale_color_hue",
    "scale_color_identity",
    "scale_color_manual",
    "scale_color_ordinal",
    "scale_colour_brewer",
    "scale_colour_cmap",
    "scale_colour_cmap_d",
    "scale_colour_continuous",
    "scale_colour_datetime",
    "scale_colour_desaturate",
    "scale_colour_discrete",
    "scale_colour_distiller",
    "scale_colour_gradient",
    "scale_colour_gradient2",
    "scale_colour_gradientn",
    "scale_colour_gray",
    "scale_colour_grey",
    "scale_colour_hue",
    "scale_colour_identity",
    "scale_colour_manual",
    "scale_colour_ordinal",
    "scale_fill_brewer",
    "scale_fill_cmap",
    "scale_fill_cmap_d",
    "scale_fill_continuous",
    "scale_fill_datetime",
    "scale_fill_desaturate",
    "scale_fill_discrete",
    "scale_fill_distiller",
    "scale_fill_gradient",
    "scale_fill_gradient2",
    "scale_fill_gradientn",
    "scale_fill_gray",
    "scale_fill_grey",
    "scale_fill_hue",
    "scale_fill_identity",
    "scale_fill_manual",
    "scale_fill_ordinal",
    "scale_linetype",
    "scale_linetype_continuous",
    "scale_linetype_discrete",
    "scale_linetype_identity",
    "scale_linetype_manual",
    "scale_shape",
    "scale_shape_continuous",
    "scale_shape_discrete",
    "scale_shape_identity",
    "scale_shape_manual",
    "scale_size",
    "scale_size_area",
    "scale_size_continuous",
    "scale_size_datetime",
    "scale_size_discrete",
    "scale_size_identity",
    "scale_size_manual",
    "scale_size_ordinal",
    "scale_size_radius",
    "scale_stroke",
    "scale_stroke_continuous",
    "scale_stroke_discrete",
    "scale_x_continuous",
    "scale_x_date",
    "scale_x_datetime",
    "scale_x_discrete",
    "scale_x_log10",
    "scale_x_reverse",
    "scale_x_sqrt",
    "scale_x_symlog",
    "scale_x_timedelta",
    "scale_y_continuous",
    "scale_y_date",
    "scale_y_datetime",
    "scale_y_discrete",
    "scale_y_log10",
    "scale_y_reverse",
    "scale_y_sqrt",
    "scale_y_symlog",
    "scale_y_timedelta",
    "xlim",
    "ylim",
    # plotnine.stats
    "stat_bin",
    "stat_bin2d",
    "stat_bin_2d",
    "stat_bindot",
    "stat_boxplot",
    "stat_count",
    "stat_density",
    "stat_density_2d",
    "stat_ecdf",
    "stat_ellipse",
    "stat_function",
    "stat_hull",
    "stat_identity",
    "stat_pointdensity",
    "stat_qq",
    "stat_qq_line",
    "stat_quantile",
    "stat_sina",
    "stat_smooth",
    "stat_sum",
    "stat_summary",
    "stat_summary_bin",
    "stat_unique",
    "stat_ydensity",
    # plotnine.themes
    "theme",
    "theme_538",
    "theme_bw",
    "theme_classic",
    "theme_dark",
    "theme_get",
    "theme_gray",
    "theme_grey",
    "theme_light",
    "theme_linedraw",
    "theme_matplotlib",
    "theme_minimal",
    "theme_seaborn",
    "theme_set",
    "theme_tufte",
    "theme_update",
    "theme_void",
    "theme_xkcd",
    # plotnine.themes.elements
    "element_blank",
    "element_line",
    "element_rect",
    "element_text",
    # plotnine.watermark
    "watermark",
)
