# -*- coding: utf-8 -*-
# =-
# Copyright Solocal Group (2015)
#
# eureka@solocal.com
#
# This software is a computer program whose purpose is to provide a full
# featured participative innovation solution within your organization.
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability.
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and,  more generally, to use and operate it in the
# same conditions as regards security.
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
# =-

import peak.rules

from eureka.infrastructure.security import Rules
from .comp import User, ProfileBox  # @UnusedImport - used by peak.rules
from .editor import ProfileEditor  # @UnusedImport - used by peak.rules
from .pager import UserPager  # @UnusedImport - used by peak.rules


@peak.rules.when(Rules.has_permission, "perm == 'view_unpublished_ideas' and (isinstance(subject, User) or isinstance(subject, ProfileBox))")
def has_permission_view_unpublished_ideas(self, user, perm, subject):
    if not user:
        return False

    return (subject.uid == user.uid) or user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'view_tracked_ideas' and isinstance(subject, ProfileBox)")
def has_permission_view_tracked_ideas(self, user, perm, subject):
    if not user:
        return False

    return (subject.uid == user.uid) or user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'edit_user' and isinstance(subject, ProfileBox)")
def has_permission_edit_user(self, user, perm, subject):
    if not user:
        return False

    return (subject.uid == user.uid) or user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'edit_fi' and isinstance(subject, ProfileBox)")
def has_permission_edit_fi(self, user, perm, subject):
    if not user:
        return False

    return user.entity.is_facilitator() or user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'edit_avatar' and isinstance(subject, ProfileBox)")
def has_permission_edit_avatar(self, user, perm, subject):
    if not user:
        return False

    return (subject.uid == user.uid) or user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'edit_points' and isinstance(subject, ProfileBox)")
def has_permission_edit_points(self, user, perm, subject):
    if not user:
        return False

    return user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'export_xls' and isinstance(subject, UserPager)")
def has_permission_export_xls(self, user, perm, subject):
    if not user:
        return False

    return user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'view_di_business_area' and (isinstance(subject, ProfileBox) or isinstance(subject, ProfileEditor))")
def has_permission_view_di_business_area(self, user, perm, subject):
    if not user:
        return False

    return (subject.uid == user.uid) or user.entity.is_developer() or user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'view_points_detail' and isinstance(subject, ProfileBox)")
def has_permission_view_points_detail(self, user, perm, subject):
    if not user:
        return False

    return (subject.uid == user.uid) or user.entity.is_dsig()


@peak.rules.when(Rules.has_permission, "perm == 'view_points' and isinstance(subject, ProfileBox)")
def has_permission_view_points_detail(self, user, perm, subject):
    if not user:
        return False

    user = user.entity
    return (subject.uid == user.uid) or user.is_dsig() or user.is_facilitator()


@peak.rules.when(Rules.has_permission, "perm == 'show_fi_basket' and isinstance(subject, User)")
def has_permission_show_fi_basket(self, user, perm, subject):
    if not user:
        return False

    user = user.entity
    return user.is_facilitator()


@peak.rules.when(Rules.has_permission, "perm == 'show_di_basket' and isinstance(subject, User)")
def has_permission_show_di_basket(self, user, perm, subject):
    if not user:
        return False

    user = user.entity
    return user.is_developer()


@peak.rules.when(Rules.has_permission, "perm == 'show_dsig_basket' and isinstance(subject, User)")
def has_permission_show_dsig_basket(self, user, perm, subject):
    if not user:
        return False

    user = user.entity
    return user.is_dsig()
