import { IResource, Resource } from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
import { IPolicyStore } from './policy-store';
export interface IPolicyTemplate extends IResource {
    /**
     * The ID of the policy template.
     *
     * @attribute
     */
    readonly policyTemplateId: string;
}
export interface PolicyTemplateProps {
    /**
     * Specifies the content that you want to use for the new policy template, written in the Cedar policy language.
     *
     * @default - The statement to attach to the new or updated policy template.
     */
    readonly statement: string;
    /**
     * The description to attach to the new or updated policy template.
     *
     * @default - No description.
     */
    readonly description?: string;
    /**
     * The policy store that contains the template.
     *
     * @default - The policy store to attach the new or updated policy template.
     */
    readonly policyStore: IPolicyStore;
}
export interface ITemplateFromFileProps {
    /**
     * The path to the file to be read which contains a single cedar statement representing a policy template
     */
    readonly path: string;
    /**
     * The policy store that the policy template will be created under.
     */
    readonly policyStore: IPolicyStore;
    /**
     * The description of the plicy template
     */
    readonly description?: string;
}
export interface PolicyTemplateAttributes {
    /**
     * The id of the Amazon Verified Permissions PolicyTemplate.
     */
    readonly policyTemplateId: string;
}
declare abstract class PolicyTemplateBase extends Resource implements IPolicyTemplate {
    abstract readonly policyTemplateId: string;
}
export declare class PolicyTemplate extends PolicyTemplateBase {
    /**
     * Create a PolicyTemplate construct that represents an external policy template via policy template id.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param policyTemplateId The PolicyTemplate's id.
     */
    static fromPolicyTemplateId(scope: Construct, id: string, policyTemplateId: string): IPolicyTemplate;
    /**
     * Creates a PolicyTemplate construct that represents an external Policy Template.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `PolicyTemplateAttributes` object.
     */
    static fromPolicyTemplateAttributes(scope: Construct, id: string, attrs: PolicyTemplateAttributes): IPolicyTemplate;
    static fromFile(scope: Construct, id: string, props: ITemplateFromFileProps): PolicyTemplate;
    private readonly policyTemplate;
    /**
     * The ID of the policy template.
     *
     * @attribute
     */
    readonly policyTemplateId: string;
    /**
     * The statement of the policy template.
     */
    readonly statement: string;
    /**
     * Description of the policy template.
     */
    readonly description?: string;
    /**
     * The Policy store that contains the template.
     */
    readonly policyStore: IPolicyStore;
    constructor(scope: Construct, id: string, props: PolicyTemplateProps);
}
export {};
