import random

import mock
import pytest

from swimlane.core.client import SwimlaneAuth, Swimlane
from swimlane.core.resources.app import App
from swimlane.core.resources.record import Record
from swimlane.core.resources.usergroup import User, Group
from swimlane.core.resources.report import Report

@pytest.fixture
def mock_swimlane():
    """Return a mock Swimlane client"""
    with mock.patch('swimlane.core.client.requests.Session', mock.MagicMock()):
        with mock.patch.object(SwimlaneAuth, 'authenticate', return_value=(None, {})):
            swimlane = Swimlane('http://host', 'admin', 'password', verify_server_version=False)
            swimlane._Swimlane__settings = {
                'apiVersion': '3.0+5.0.0+123456'
            }
            swimlane._session.auth.user = mock_user(swimlane)

    return swimlane


@pytest.fixture
def mock_app(mock_swimlane):
    return App(mock_swimlane, {
        '$type': 'Core.Models.Application.Application, Core',
        'acronym': 'RA',
        'createWorkspace': False,
        'createdByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                          'id': '58de1d1c07637a0264c0ca6a',
                          'name': 'admin'},
        'createdDate': '2017-04-05T09:39:16.304Z',
        'description': 'Records created via RSA ESA alerts',
        'disabled': False,
        'fields': [{'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'arnd6',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Action',
                    'key': 'action-key',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {u'supportsMultipleOutputMappings': True, u'name': u'Numeric List', u'itemStep': 0,
                    u'$type': u'Core.Models.Fields.List.ListField, Core', u'required': False, u'inputType': u'numeric',
                    u'readOnly': False, u'fieldType': u'list', u'key': u'numeric-list', u'id': u'azvbz'},
                   {u'supportsMultipleOutputMappings': True, u'name': u'Numeric List Range Limit', u'itemStep': 0,
                    u'minItems': 1, u'$type': u'Core.Models.Fields.List.ListField, Core', u'required': False,
                    u'id': u'adxvq',
                    u'key': u'numeric-list-range-limit', u'readOnly': False, u'itemMin': 5.0, u'fieldType': u'list',
                    u'maxItems': 3, u'itemMax': 10.0, u'inputType': u'numeric'},
                   {u'supportsMultipleOutputMappings': True, u'name': u'Text List', u'itemStep': 0,
                    u'$type': u'Core.Models.Fields.List.ListField, Core', u'required': False, u'inputType': u'text',
                    u'readOnly': False, u'itemLengthType': u'none', u'fieldType': u'list', u'key': u'text-list',
                    u'id': u'ajvrh'}, {u'supportsMultipleOutputMappings': True, u'key': u'text-list-char-limit',
                                       u'name': u'Text List Char Limit', u'itemMinLength': 3, u'itemStep': 0,
                                       u'minItems': 1,
                                       u'$type': u'Core.Models.Fields.List.ListField, Core', u'required': False,
                                       u'id': u'aiprb', u'itemMaxLength': 5, u'readOnly': False,
                                       u'itemLengthType': u'characters', u'fieldType': u'list', u'maxItems': 3,
                                       u'inputType': u'text'},
                   {u'supportsMultipleOutputMappings': True, u'key': u'text-list-word-limit',
                    u'name': u'Text List Word Limit', u'itemMinLength': 2, u'itemStep': 0, u'minItems': 1,
                    u'$type': u'Core.Models.Fields.List.ListField, Core', u'required': False, u'id': u'aeo2v',
                    u'itemMaxLength': 3, u'readOnly': False, u'itemLengthType': u'words', u'fieldType': u'list',
                    u'maxItems': 3, u'inputType': u'text'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a1r3v',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Activity',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'aazhn',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Actors',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.CommentsField, Core',
                    'fieldType': 'comments',
                    'helpTextType': 'none',
                    'id': 'agbsz',
                    'name': 'Additional Crowdstrike Comments'},
                   {'$type': 'Core.Models.Fields.Reference.ReferenceField, Core',
                    'canAdd': True,
                    'columns': ['5938252e8895010e08b70ef4'],
                    'controlType': 'select',
                    'createLink': False,
                    'fieldType': 'reference',
                    'helpTextType': 'none',
                    'id': 'akotp',
                    'name': 'Reference (Select Single)',
                    'selectionType': 'single',
                    'targetId': '58e4bb4407637a0e4c4f9873'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a0g40',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Alert Name',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.UserGroupField, Core',
                    'controlType': 'select',
                    'defaults': [],
                    'fieldType': 'userGroup',
                    'helpTextType': 'none',
                    'id': 'a44wz',
                    'inputType': 'userGroup',
                    'name': 'Assigned SOC Group',
                    'selectable': [],
                    'selectionType': 'single',
                    'showAllGroups': False,
                    'showAllUsers': True},
                   {'$type': 'Core.Models.Fields.AttachmentField, Core',
                    'fieldType': 'attachment',
                    'helpTextType': 'none',
                    'id': 'aasqt',
                    'maxSize': 100000,
                    'name': 'Attachments summary'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'aio1w',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Client',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.AttachmentField, Core',
                    'fieldType': 'attachment',
                    'helpTextType': 'none',
                    'id': 'apwi0',
                    'maxSize': 100000,
                    'name': 'CSV Feed File'},
                   {'$type': 'Core.Models.Fields.UserGroupField, Core',
                    'controlType': 'select',
                    'defaults': [],
                    'fieldType': 'userGroup',
                    'helpTextType': 'none',
                    'id': 'manuallyAddedFieldDef',
                    'inputType': 'userGroup',
                    'members': [{'$type': 'Core.Models.Fields.UserGroup.UserGroupValues, Core',
                                 'id': 'aN99r5xmQ__wW',
                                 'itemType': 'group',
                                 'name': 'Everyone',
                                 'selectionType': 'groups'}],
                    'name': 'User/Groups (Multi Restricted)',
                    'selectionType': 'multi',
                    'showAllGroups': False,
                    'showAllUsers': False},
                   {'$type': 'Core.Models.Fields.Date.DateField, Core',
                    'calculatedDiff': False,
                    'defaultValueType': 'none',
                    'fieldType': 'date',
                    'helpTextType': 'none',
                    'id': 'a7bgv',
                    'inputType': 'date',
                    'name': 'Date Field'},
                   {'$type': 'Core.Models.Fields.Date.DateField, Core',
                    'calculatedDiff': False,
                    'defaultValueType': 'current',
                    'fieldType': 'date',
                    'helpTextType': 'none',
                    'id': 'a2pva',
                    'inputType': 'date',
                    'name': 'Datetime (Read-only)',
                    'readOnly': True},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a429d',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Detection Method',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'aokp5',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Device Class',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a4l9p',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Device ID',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'apf9i',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Device IP',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'arok4',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Device Type',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ampg8',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Domain Types',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'acqdq',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'ESA Time',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a18qr',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Event Category',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'formula': 'CONCATENATE("ip.src=",[apf9i], " || ip.dst=", [apf9i])',
                    'helpTextType': 'none',
                    'id': 'aw9gd',
                    'inputType': 'multiline',
                    'lengthType': 'none',
                    'name': 'Example Query',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.History.HistoryField, Core',
                    'fieldType': 'history',
                    'helpTextType': 'none',
                    'id': 'a29ot',
                    'name': 'History'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'af967',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'ID',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'anet4',
                    'inputType': 'multiline',
                    'lengthType': 'none',
                    'name': 'Identified IPs',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.Date.DateField, Core',
                    'calculatedDiff': False,
                    'defaultValueType': 'none',
                    'fieldType': 'date',
                    'helpTextType': 'none',
                    'id': 'a365t',
                    'inputType': 'dateTime',
                    'name': 'Incident Closed'},
                   {'$type': 'Core.Models.Fields.Date.DateField, Core',
                    'calculatedDiff': False,
                    'defaultValueType': 'none',
                    'fieldType': 'date',
                    'helpTextType': 'none',
                    'id': 'aiir8',
                    'inputType': 'firstCreated',
                    'name': 'Incident Created'},
                   {'$type': 'Core.Models.Fields.UserGroupField, Core',
                    'controlType': 'select',
                    'defaults': [],
                    'fieldType': 'userGroup',
                    'helpTextType': 'none',
                    'id': 'afff3',
                    'inputType': 'createdBy',
                    'name': 'Incident Created By',
                    'selectable': [],
                    'selectionType': 'single',
                    'showAllGroups': False,
                    'showAllUsers': True},
                   {'$type': 'Core.Models.Fields.Date.DateField, Core',
                    'calculatedDiff': False,
                    'defaultValueType': 'none',
                    'fieldType': 'date',
                    'helpTextType': 'none',
                    'id': 'akxvh',
                    'inputType': 'timespan',
                    'name': 'Incident Duration'},
                   {'$type': 'Core.Models.Fields.Date.DateField, Core',
                    'calculatedDiff': False,
                    'defaultValueType': 'none',
                    'fieldType': 'date',
                    'helpTextType': 'none',
                    'id': 'ac1oa',
                    'inputType': 'dateTime',
                    'name': 'Incident Occured'},
                   {'$type': 'Core.Models.Fields.UserGroupField, Core',
                    'controlType': 'select',
                    'defaults': [],
                    'fieldType': 'userGroup',
                    'helpTextType': 'none',
                    'id': 'azygs',
                    'inputType': 'userGroup',
                    'name': 'Incident Owner',
                    'selectable': [],
                    'selectionType': 'single',
                    'showAllGroups': False,
                    'showAllUsers': True},
                   {'$type': 'Core.Models.Fields.ValuesListField, Core',
                    'controlType': 'select',
                    'fieldType': 'valuesList',
                    'helpTextType': 'none',
                    'id': 'a5v09',
                    'name': 'Incident Type',
                    'selectionType': 'single',
                    'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58e7bafd83f418637cf91c3e',
                                'name': 'ESA Alert',
                                'selected': False}]},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ayqk6',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Indicator',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'alnet',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Indicator Type',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.CommentsField, Core',
                    'fieldType': 'comments',
                    'helpTextType': 'none',
                    'id': 'a3uau',
                    'name': 'Investigation Summary'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ara4m',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'IP Address Types',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a5g30',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Kill Chains',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'afrn3',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Labels',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.UserGroupField, Core',
                    'controlType': 'select',
                    'defaults': [],
                    'fieldType': 'userGroup',
                    'helpTextType': 'none',
                    'id': 'a11mn',
                    'inputType': 'userGroup',
                    'name': 'Last Updated By',
                    'selectable': [],
                    'selectionType': 'single',
                    'showAllGroups': False,
                    'showAllUsers': True},
                   {'$type': 'Core.Models.Fields.AttachmentField, Core',
                    'fieldType': 'attachment',
                    'helpTextType': 'none',
                    'id': 'agoat',
                    'maxSize': 100000,
                    'name': 'Log Attachment'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'acl9o',
                    'inputType': 'multiline',
                    'lengthType': 'none',
                    'name': 'Log Messages',
                    'readOnly': True,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ah7js',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Malicious Confidence',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'amuav',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Malware Families',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a7gm5',
                    'inputType': 'multiline',
                    'lengthType': 'none',
                    'name': 'Message',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a6if8',
                    'inputType': 'rich',
                    'lengthType': 'none',
                    'name': 'Meta Json',
                    'readOnly': True,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'aag0z',
                    'inputType': 'rich',
                    'lengthType': 'none',
                    'name': 'Meta Summary',
                    'readOnly': True,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.NumericField, Core',
                    'fieldType': 'numeric',
                    'format': 'none',
                    'helpTextType': 'none',
                    'id': 'aqkg3',
                    'name': 'Numeric',
                    'step': 1.0},
                   {'$type': 'Core.Models.Fields.NumericField, Core',
                    'fieldType': 'numeric',
                    'format': 'none',
                    'helpTextType': 'none',
                    'id': 'ap6up',
                    'max': 10.0,
                    'min': 0.0,
                    'name': 'Numeric (Range)',
                    'step': 1.0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a8vjm',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Outcome',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.AttachmentField, Core',
                    'fieldType': 'attachment',
                    'helpTextType': 'none',
                    'id': 'aep2e',
                    'maxSize': 100000,
                    'name': 'PCAP Attachment'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'axoxa',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'PCAP Base64',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'abcez',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'pcap json',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ahchn',
                    'inputType': 'rich',
                    'lengthType': 'none',
                    'name': 'PCAP Summary',
                    'readOnly': True,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ao0wj',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Query',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.Reference.ReferenceField, Core',
                    'canAdd': True,
                    'columns': ['58e2414007637a1330b75b8d'],
                    'controlType': 'grid',
                    'createLink': False,
                    'fieldType': 'reference',
                    'helpTextType': 'none',
                    'id': 'a3w8f',
                    'name': 'Reference',
                    'selectionType': 'multi',
                    'targetId': '58e2414007637a1330b75b8b'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'au7ic',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Relations',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.CommentsField, Core',
                    'fieldType': 'comments',
                    'helpTextType': 'none',
                    'id': 'a1x9p',
                    'name': 'Remediation Recommendations Comments'},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a3uyp',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Reports',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'axk12',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Repots',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a5yg3',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'RID',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a0y5t',
                    'inputType': 'rich',
                    'lengthType': 'none',
                    'name': 'Search Results',
                    'readOnly': True,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a0mb9',
                    'inputType': 'rich',
                    'lengthType': 'none',
                    'name': 'Search Results - JSON',
                    'readOnly': True,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a3rvw',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Session ID',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a990o',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Severity',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.ValuesListField, Core',
                    'controlType': 'select',
                    'fieldType': 'valuesList',
                    'helpTextType': 'none',
                    'id': 'aasnf',
                    'name': 'Severity/Priority',
                    'selectionType': 'single',
                    'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58e7bb0cc5ca3bbb38570f91',
                                'name': 'Low',
                                'selected': False},
                               {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58e7bb10716b6972b5b9c6d2',
                                'name': 'Medium',
                                'selected': False},
                               {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58e7bb144121bd73d8f53845',
                                'name': 'High',
                                'selected': False},
                               {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58e7bb178cbcab18489ce658',
                                'name': 'Critical',
                                'selected': False}]},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'axdvr',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Size',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a04rv',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Source',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ahziu',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Source Host',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'afbbv',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Source IP',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.ValuesListField, Core',
                    'controlType': 'select',
                    'fieldType': 'valuesList',
                    'helpTextType': 'none',
                    'id': 'a0k7v',
                    'name': 'Status',
                    'selectionType': 'single',
                    'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58e7bae8c61082e377cc4d82',
                                'name': 'Open',
                                'selected': False},
                               {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58e7baed6ddbd9ac229a4011',
                                'name': 'False Positive',
                                'selected': False},
                               {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58e7baeef665f482160bb317',
                                'name': 'Closed',
                                'selected': False}]},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a7ira',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Subject',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a9aon',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TC - Description',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'azfys',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TC - ID',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a2gor',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TC - Name',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ahep6',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TC - Security Label',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'aabxm',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TC - Type',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a1k2a',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TC - Url',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'amjd0',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TcpIPUtils - DNS',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'a2ybt',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TcpIPUtils - Geo Country Name',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'aqc6k',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'TcpIPUtils - Whois',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'awmtq',
                    'inputType': 'text',
                    'lengthType': 'none',
                    'name': 'Theme',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.Date.DateField, Core',
                    'calculatedDiff': False,
                    'defaultValueType': 'none',
                    'fieldType': 'date',
                    'helpTextType': 'none',
                    'id': 'ao64i',
                    'inputType': 'time',
                    'name': 'Time Field'},
                   {'$type': 'Core.Models.Fields.TrackingField, Core',
                    'fieldType': 'tracking',
                    'id': '58e4bb4407637a0e4c4f9875',
                    'name': 'Tracking Id',
                    'prefix': 'RA-',
                    'readOnly': True},
                   {'$type': 'Core.Models.Fields.TextField, Core',
                    'fieldType': 'text',
                    'helpTextType': 'none',
                    'id': 'ahdtf',
                    'inputType': 'multiline',
                    'lengthType': 'none',
                    'name': 'VT IP Results',
                    'readOnly': False,
                    'required': False,
                    'visualize': False,
                    'visualizeMode': 0},
                   {'$type': 'Core.Models.Fields.UserGroupField, Core',
                    'controlType': 'select',
                    'defaults': [],
                    'fieldType': 'userGroup',
                    'groups': [],
                    'helpTextType': 'none',
                    'id': 'agn03',
                    'inputType': 'userGroup',
                    'name': 'User/Groups',
                    'selectable': [],
                    'selectionType': 'multi',
                    'showAllGroups': True,
                    'showAllUsers': True,
                    'users': []},
                   {'$type': 'Core.Models.Fields.ValuesListField, Core',
                    'controlType': 'select',
                    'fieldType': 'valuesList',
                    'helpTextType': 'none',
                    'id': 'arlrt',
                    'name': 'Values List',
                    'selectionType': 'multi',
                    'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58fae4c59173122945a7cff6',
                                'name': 'Option 1',
                                'selected': False},
                               {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58fae4eafef0eead26dee65c',
                                'name': 'Option 2',
                                'selected': False},
                               {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
                                'id': '58fae4ef3ac1a9d413245023',
                                'name': 'Option 3',
                                'selected': False}]}],
        'id': '58e4bb4407637a0e4c4f9873',
        'layout': [{'$type': 'Core.Models.Layouts.SectionLayout, Core',
                    'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 1,
                                  'fieldId': 'a0k7v',
                                  'helpTextType': 'none',
                                  'id': '58e576042ead7c0aa9beb3c1',
                                  'layoutType': 'field',
                                  'parentId': '58e575f3a619896009918afd',
                                  'row': 1,
                                  'sizex': 2.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 3,
                                  'fieldId': 'a5v09',
                                  'helpTextType': 'none',
                                  'id': '58e576286f53898db5c0ee30',
                                  'layoutType': 'field',
                                  'parentId': '58e575f3a619896009918afd',
                                  'row': 1,
                                  'sizex': 2.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 1,
                                  'fieldId': 'aasnf',
                                  'helpTextType': 'none',
                                  'id': '58e5763e660c4183b2a04678',
                                  'layoutType': 'field',
                                  'parentId': '58e575f3a619896009918afd',
                                  'row': 2,
                                  'sizex': 2.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 3,
                                  'fieldId': 'a429d',
                                  'helpTextType': 'none',
                                  'id': '58e57657b3beaaaee997dc45',
                                  'layoutType': 'field',
                                  'parentId': '58e575f3a619896009918afd',
                                  'row': 2,
                                  'sizex': 2.0,
                                  'sizey': 0.0}],
                    'col': 1,
                    'collapsed': False,
                    'helpTextType': 'none',
                    'id': '58e575f3a619896009918afd',
                    'layoutType': 'section',
                    'name': 'Incident Details',
                    'row': 1,
                    'sizex': 2.0,
                    'sizey': 0.0},
                   {'$type': 'Core.Models.Layouts.SectionLayout, Core',
                    'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 1,
                                  'fieldId': 'ac1oa',
                                  'helpTextType': 'none',
                                  'id': '58e576e17dc8585a2ea6c87a',
                                  'layoutType': 'field',
                                  'parentId': '58e576807161d1e5309ffbf2',
                                  'row': 1,
                                  'sizex': 2.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 3,
                                  'fieldId': 'aiir8',
                                  'helpTextType': 'none',
                                  'id': '58e57692ebc37b11a7d3a579',
                                  'layoutType': 'field',
                                  'parentId': '58e576807161d1e5309ffbf2',
                                  'row': 1,
                                  'sizex': 2.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 1,
                                  'fieldId': 'a365t',
                                  'helpTextType': 'none',
                                  'id': '58e576b08acfaeb7bd6e8ecd',
                                  'layoutType': 'field',
                                  'parentId': '58e576807161d1e5309ffbf2',
                                  'row': 2,
                                  'sizex': 2.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 3,
                                  'fieldId': 'akxvh',
                                  'helpTextType': 'none',
                                  'id': '58fa711bce7fc3d4c52a0183',
                                  'layoutType': 'field',
                                  'parentId': '58e576807161d1e5309ffbf2',
                                  'row': 2,
                                  'sizex': 2.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 1,
                                  'fieldId': 'ao64i',
                                  'helpTextType': 'none',
                                  'id': '58fa72c691c1864edf0b7998',
                                  'layoutType': 'field',
                                  'parentId': '58e576807161d1e5309ffbf2',
                                  'row': 3,
                                  'sizex': 2.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                  'col': 3,
                                  'fieldId': 'a7bgv',
                                  'helpTextType': 'none',
                                  'id': '58fa779a0513aa012f8a5b7c',
                                  'layoutType': 'field',
                                  'parentId': '58e576807161d1e5309ffbf2',
                                  'row': 3,
                                  'sizex': 2.0,
                                  'sizey': 0.0}],
                    'col': 3,
                    'collapsed': False,
                    'helpTextType': 'none',
                    'id': '58e576807161d1e5309ffbf2',
                    'layoutType': 'section',
                    'name': 'Timeline',
                    'row': 1,
                    'sizex': 2.0,
                    'sizey': 0.0},
                   {'$type': 'Core.Models.Layouts.SectionLayout, Core',
                    'children': [{'$type': 'Core.Models.Layouts.SectionLayout, Core',
                                  'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'azygs',
                                                'helpTextType': 'none',
                                                'id': '58e577210648491194760583',
                                                'layoutType': 'field',
                                                'parentId': '58e57707db982c6dba8a941c',
                                                'row': 1,
                                                'sizex': 1.0,
                                                'sizey': 0.0},
                                               {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'a44wz',
                                                'helpTextType': 'none',
                                                'id': '58e5772ce05d49f71932a2c4',
                                                'layoutType': 'field',
                                                'parentId': '58e57707db982c6dba8a941c',
                                                'row': 2,
                                                'sizex': 1.0,
                                                'sizey': 0.0},
                                               {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'afff3',
                                                'helpTextType': 'none',
                                                'id': '58e577382a6f244831f6f786',
                                                'layoutType': 'field',
                                                'parentId': '58e57707db982c6dba8a941c',
                                                'row': 3,
                                                'sizex': 1.0,
                                                'sizey': 0.0},
                                               {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'a11mn',
                                                'helpTextType': 'none',
                                                'id': '58e5774976ddd32269f9b09d',
                                                'layoutType': 'field',
                                                'parentId': '58e57707db982c6dba8a941c',
                                                'row': 4,
                                                'sizex': 1.0,
                                                'sizey': 0.0}],
                                  'col': 1,
                                  'collapsed': False,
                                  'helpTextType': 'none',
                                  'id': '58e57707db982c6dba8a941c',
                                  'layoutType': 'section',
                                  'name': 'Personnel',
                                  'parentId': '58e576fb81fa41ca085fe0ad',
                                  'row': 1,
                                  'sizex': 4.0,
                                  'sizey': 0.0},
                                 {'$type': 'Core.Models.Layouts.TabLayout, Core',
                                  'col': 2,
                                  'id': '58e577565b16d85c5653195e',
                                  'layoutType': 'tab',
                                  'parentId': '58e576fb81fa41ca085fe0ad',
                                  'row': 1,
                                  'sizex': 1.5,
                                  'sizey': 0.0,
                                  'tabs': [{'$type': 'Core.Models.Layouts.Tabs, Core',
                                            'active': False,
                                            'children': [{
                                                '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'a3uau',
                                                'helpTextType': 'none',
                                                'id': '58e5779bdfbff605fcf254b0',
                                                'layoutType': 'field',
                                                'parentId': '58e577565b16d85c5653195e',
                                                'row': 1,
                                                'sizex': 1.0,
                                                'sizey': 0.0}],
                                            'id': '58e5775cbb0968b7d0f7081e',
                                            'name': 'Summary'},
                                           {'$type': 'Core.Models.Layouts.Tabs, Core',
                                            'active': False,
                                            'children': [{
                                                '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'a1x9p',
                                                'helpTextType': 'none',
                                                'id': '58e577a8c4a8104078bb75b2',
                                                'layoutType': 'field',
                                                'parentId': '58e577565b16d85c5653195e',
                                                'row': 1,
                                                'sizex': 1.0,
                                                'sizey': 0.0}],
                                            'id': '58e57761ab16c6952915747d',
                                            'name': 'Remediation Recommendations'},
                                           {'$type': 'Core.Models.Layouts.Tabs, Core',
                                            'active': False,
                                            'children': [{
                                                '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'aasqt',
                                                'helpTextType': 'none',
                                                'id': '58e577b7e7fcd0ccca7f5fc4',
                                                'layoutType': 'field',
                                                'parentId': '58e577565b16d85c5653195e',
                                                'row': 1,
                                                'sizex': 1.0,
                                                'sizey': 0.0}],
                                            'id': '58e5778800daf3435d693cf3',
                                            'name': 'Attachments'},
                                           {'$type': 'Core.Models.Layouts.Tabs, Core',
                                            'active': False,
                                            'children': [{
                                                '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                'col': 1,
                                                'helpTextType': 0,
                                                'id': '58e577d398d564015f69adc6',
                                                'layoutType': 'integration',
                                                'name': 'Notify Slack Channel',
                                                'parentId': '58e577565b16d85c5653195e',
                                                'row': 1,
                                                'sizex': 4.0,
                                                'sizey': 0.0}],
                                            'id': '58e5778ed3fd2290057f4153',
                                            'name': 'Notify'},
                                           {'$type': 'Core.Models.Layouts.Tabs, Core',
                                            'active': False,
                                            'children': [{
                                                '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'a29ot',
                                                'helpTextType': 'none',
                                                'id': '58f7deaae0cd13e87d755a34',
                                                'layoutType': 'field',
                                                'parentId': '58e577565b16d85c5653195e',
                                                'row': 1,
                                                'sizex': 1.0,
                                                'sizey': 0.0}],
                                            'id': '58f7de9e01155618aab3e7f2',
                                            'name': 'History'},
                                           {'$type': 'Core.Models.Layouts.Tabs, Core',
                                            'active': False,
                                            'children': [{
                                                '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                'col': 1,
                                                'fieldId': 'a3w8f',
                                                'helpTextType': 'none',
                                                'id': '58f7dec679b76135800281a9',
                                                'layoutType': 'field',
                                                'parentId': '58e577565b16d85c5653195e',
                                                'row': 1,
                                                'sizex': 1.0,
                                                'sizey': 0.0},
                                                {
                                                    '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                    'col': 1,
                                                    'fieldId': 'aqkg3',
                                                    'helpTextType': 'none',
                                                    'id': '58f7e02f4e6b5ae5dca52bf1',
                                                    'layoutType': 'field',
                                                    'parentId': '58e577565b16d85c5653195e',
                                                    'row': 2,
                                                    'sizex': 2.0,
                                                    'sizey': 0.0},
                                                {
                                                    '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                    'col': 3,
                                                    'fieldId': 'agn03',
                                                    'helpTextType': 'none',
                                                    'id': '58fae48d9331da717c1665f3',
                                                    'layoutType': 'field',
                                                    'parentId': '58e577565b16d85c5653195e',
                                                    'row': 2,
                                                    'sizex': 2.0,
                                                    'sizey': 0.0},
                                                {
                                                    '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                    'col': 1,
                                                    'fieldId': 'arlrt',
                                                    'helpTextType': 'none',
                                                    'id': '58fae4ae9c4a932ffb11e39c',
                                                    'layoutType': 'field',
                                                    'parentId': '58e577565b16d85c5653195e',
                                                    'row': 3,
                                                    'sizex': 2.0,
                                                    'sizey': 0.0}],
                                            'id': '58f7debef92bd8579a092744',
                                            'name': 'Reference'}]}],
                    'col': 1,
                    'collapsed': False,
                    'helpTextType': 'none',
                    'id': '58e576fb81fa41ca085fe0ad',
                    'layoutType': 'section',
                    'name': 'Notes',
                    'row': 2,
                    'sizex': 1.0,
                    'sizey': 0.0},
                   {'$type': 'Core.Models.Layouts.TabLayout, Core',
                    'col': 1,
                    'id': '58e516a0027f9d87af37d50d',
                    'layoutType': 'tab',
                    'row': 3,
                    'sizex': 1.0,
                    'sizey': 0.0,
                    'tabs': [{'$type': 'Core.Models.Layouts.Tabs, Core',
                              'active': False,
                              'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'a0g40',
                                            'helpTextType': 'none',
                                            'id': '58e5182f06f158b93689829f',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 1,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 2,
                                            'fieldId': 'a7gm5',
                                            'helpTextType': 'none',
                                            'id': '58e53d92dd4d4f145a55ab83',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 1,
                                            'sizex': 1.5,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'a18qr',
                                            'helpTextType': 'none',
                                            'id': '58e516e2b08a593ffff40837',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 2,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 2,
                                            'fieldId': 'apf9i',
                                            'helpTextType': 'none',
                                            'id': '58e517fcf280f5f0eb3bfc96',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 2,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 4,
                                            'fieldId': 'a3rvw',
                                            'helpTextType': 'none',
                                            'id': '58e516eb9726b02644b947d6',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 2,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 7,
                                            'fieldId': 'af967',
                                            'helpTextType': 'none',
                                            'id': '58e5179887b147024c122fc7',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 2,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'a4l9p',
                                            'helpTextType': 'none',
                                            'id': '58e518311ead588fbb52dade',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 3,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 2,
                                            'fieldId': 'a5yg3',
                                            'helpTextType': 'none',
                                            'id': '58e516e99a79ae41f65474ca',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 3,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 4,
                                            'fieldId': 'afbbv',
                                            'helpTextType': 'none',
                                            'id': '58e516e41e5d42c7990fbd00',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 3,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 7,
                                            'fieldId': 'ahziu',
                                            'helpTextType': 'none',
                                            'id': '58e516ec53b678d82b53c731',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 3,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'acqdq',
                                            'helpTextType': 'none',
                                            'id': '58e517d63337f10314607169',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 4,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 2,
                                            'fieldId': 'a990o',
                                            'helpTextType': 'none',
                                            'id': '58e517d1cf1dfa439b2f24c6',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 4,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 4,
                                            'fieldId': 'arok4',
                                            'helpTextType': 'none',
                                            'id': '58e516ed0f752f94f738f188',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 4,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 7,
                                            'fieldId': 'a1r3v',
                                            'helpTextType': 'none',
                                            'id': '58e516dffb019d3eae066c0b',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 4,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'awmtq',
                                            'helpTextType': 'none',
                                            'id': '58e517f99e1bc251d8d171d8',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 5,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 2,
                                            'fieldId': 'arnd6',
                                            'helpTextType': 'none',
                                            'id': '58e516ee748dee33ea535ade',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 5,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 4,
                                            'fieldId': 'a8vjm',
                                            'helpTextType': 'none',
                                            'id': '58e5182cc5fb058d44fcf14a',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 5,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 7,
                                            'fieldId': 'aokp5',
                                            'helpTextType': 'none',
                                            'id': '58e518155e483fd06bb0e2dd',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 5,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'a04rv',
                                            'helpTextType': 'none',
                                            'id': '58e516e8ff326d1a17d455b2',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 6,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 2,
                                            'fieldId': 'aio1w',
                                            'helpTextType': 'none',
                                            'id': '58e51797c6e0eacedb65ad51',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 6,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 4,
                                            'fieldId': 'a7ira',
                                            'helpTextType': 'none',
                                            'id': '58e517d379c561fd17950e62',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 6,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 7,
                                            'fieldId': 'axdvr',
                                            'helpTextType': 'none',
                                            'id': '58e51813866053500c89f9c8',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 6,
                                            'sizex': 4.0,
                                            'sizey': 0.0}],
                              'id': '58e516a2b3915579de915997',
                              'name': 'ESA Alert'},
                             {'$type': 'Core.Models.Layouts.Tabs, Core',
                              'active': False,
                              'children': [{'$type': 'Core.Models.Layouts.TabLayout, Core',
                                            'col': 1,
                                            'id': '58e5592fdaaa1f2f22579210',
                                            'layoutType': 'tab',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 1,
                                            'sizex': 1.0,
                                            'sizey': 0.0,
                                            'tabs': [{'$type': 'Core.Models.Layouts.Tabs, Core',
                                                      'active': False,
                                                      'children': [{
                                                          '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                          'col': 1,
                                                          'helpTextType': 0,
                                                          'id': '58e6c768b699dd6ae345a4a2',
                                                          'layoutType': 'integration',
                                                          'name': 'Pull PCAPs',
                                                          'parentId': '58e5592fdaaa1f2f22579210',
                                                          'row': 1,
                                                          'sizex': 4.0,
                                                          'sizey': 0.0,
                                                          'taskId': '58e6b96207637a13e4bb8c6d'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                              'col': 2,
                                                              'helpTextType': 0,
                                                              'id': '58ebb693040226823c80d019',
                                                              'layoutType': 'integration',
                                                              'name': 'Analyze PCAP',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 1,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0,
                                                              'taskId': '58e6c20807637a13e4bc1caa'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                              'col': 4,
                                                              'helpTextType': 0,
                                                              'id': '58e7edf5545d3c5ea10e4b20',
                                                              'layoutType': 'integration',
                                                              'name': 'PCAP Summary',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 1,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0,
                                                              'taskId': '58e5076807637a0e4c507c16'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.HtmlObjectLayout, Core',
                                                              'col': 7,
                                                              'html': '',
                                                              'id': '58e6c775979dd9f722ba2b40',
                                                              'layoutType': 'htmlObject',
                                                              'name': 'HtmlObject',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 1,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'aep2e',
                                                              'helpTextType': 'none',
                                                              'id': '58e5577a064adeefbc06ad5c',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 2,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 3,
                                                              'fieldId': 'axoxa',
                                                              'helpTextType': 'none',
                                                              'id': '58e5582d212759a31fb01e50',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 2,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'abcez',
                                                              'helpTextType': 'none',
                                                              'id': '58e56e60ef3b0b3219d47a5a',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 3,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'ahchn',
                                                              'helpTextType': 'none',
                                                              'id': '58e5597e8e9c42bf006eb3e1',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 4,
                                                              'sizex': 1.0,
                                                              'sizey': 0.0}],
                                                      'id': '58e55931d847d54fb601db1c',
                                                      'name': 'PCAPs'},
                                                     {'$type': 'Core.Models.Layouts.Tabs, Core',
                                                      'active': False,
                                                      'children': [{
                                                          '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                          'col': 1,
                                                          'helpTextType': 0,
                                                          'id': '58e6c792110623b1966e5299',
                                                          'layoutType': 'integration',
                                                          'name': 'Pull Logs',
                                                          'parentId': '58e5592fdaaa1f2f22579210',
                                                          'row': 1,
                                                          'sizex': 4.0,
                                                          'sizey': 0.0,
                                                          'taskId': '58e6b99c07637a13e4bb8e4e'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.HtmlObjectLayout, Core',
                                                              'col': 2,
                                                              'html': '',
                                                              'id': '58e6c790f7e7dc8ef5bdfd4b',
                                                              'layoutType': 'htmlObject',
                                                              'name': 'HtmlObject',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 1,
                                                              'sizex': 1.5,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'agoat',
                                                              'helpTextType': 'none',
                                                              'id': '58e5577b586cb162bae3701e',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 2,
                                                              'sizex': 1.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'acl9o',
                                                              'helpTextType': 'none',
                                                              'id': '58e56d64dcddb58c23e8166a',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 3,
                                                              'sizex': 1.0,
                                                              'sizey': 0.0}],
                                                      'id': '58e55939283456d0098a7e60',
                                                      'name': 'Logs'},
                                                     {'$type': 'Core.Models.Layouts.Tabs, Core',
                                                      'active': False,
                                                      'children': [{
                                                          '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                          'col': 1,
                                                          'helpTextType': 0,
                                                          'id': '58e6c7a098134cd1b1778251',
                                                          'layoutType': 'integration',
                                                          'name': 'Pull Meta',
                                                          'parentId': '58e5592fdaaa1f2f22579210',
                                                          'row': 1,
                                                          'sizex': 4.0,
                                                          'sizey': 0.0,
                                                          'taskId': '58e6be4007637a13e4bbec5c'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.HtmlObjectLayout, Core',
                                                              'col': 2,
                                                              'html': '',
                                                              'id': '58e6c79eacea60220cfded2f',
                                                              'layoutType': 'htmlObject',
                                                              'name': 'HtmlObject',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 1,
                                                              'sizex': 1.5,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'a6if8',
                                                              'helpTextType': 'none',
                                                              'id': '58e569f43b441255bfe04b50',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 2,
                                                              'sizex': 1.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'aag0z',
                                                              'helpTextType': 'none',
                                                              'id': '58e6bf570fa1c02d7986b3fc',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 3,
                                                              'sizex': 1.0,
                                                              'sizey': 0.0}],
                                                      'id': '58e5593cc9e82d969b879747',
                                                      'name': 'Meta'},
                                                     {'$type': 'Core.Models.Layouts.Tabs, Core',
                                                      'active': False,
                                                      'children': [{
                                                          '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                          'col': 1,
                                                          'helpTextType': 0,
                                                          'id': '58e6c7b15d34a5a6b95c161f',
                                                          'layoutType': 'integration',
                                                          'name': 'Pull IPs',
                                                          'parentId': '58e5592fdaaa1f2f22579210',
                                                          'row': 1,
                                                          'sizex': 4.0,
                                                          'sizey': 0.0,
                                                          'taskId': '58e6c24107637a13e4bc1e0e'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.HtmlObjectLayout, Core',
                                                              'col': 2,
                                                              'html': '',
                                                              'id': '58e6c7ade3f2c392427db6d0',
                                                              'layoutType': 'htmlObject',
                                                              'name': 'HtmlObject',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 1,
                                                              'sizex': 1.5,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'anet4',
                                                              'helpTextType': 'none',
                                                              'id': '58e55eebed9a867cc28161a7',
                                                              'layoutType': 'field',
                                                              'parentId': '58e5592fdaaa1f2f22579210',
                                                              'row': 2,
                                                              'sizex': 1.0,
                                                              'sizey': 0.0}],
                                                      'id': '58e55eceaa20cbe1d92f4841',
                                                      'name': 'Identified IPs'}]}],
                              'id': '58e516a23368c037ea8b1517',
                              'name': 'Automated Analysis'},
                             {'$type': 'Core.Models.Layouts.Tabs, Core',
                              'active': False,
                              'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'aw9gd',
                                            'helpTextType': 'none',
                                            'id': '58e5563c78176456718aa7e0',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 1,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 2,
                                            'fieldId': 'ao0wj',
                                            'helpTextType': 'none',
                                            'id': '58eb9df2ffd05a002568dfc2',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 1,
                                            'sizex': 4.0,
                                            'sizey': 0.0},
                                           {
                                               '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                               'col': 4,
                                               'helpTextType': 0,
                                               'id': '58e6c7e3db92fe84aa10c81a',
                                               'layoutType': 'integration',
                                               'name': 'Advanced Query',
                                               'parentId': '58e516a0027f9d87af37d50d',
                                               'row': 1,
                                               'sizex': 2.0,
                                               'sizey': 0.0,
                                               'taskId': '58eb9e4907637a02d4a105cf'},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'a0mb9',
                                            'helpTextType': 'none',
                                            'id': '58e55f034efd0c4866b8b1bf',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 2,
                                            'sizex': 1.0,
                                            'sizey': 0.0},
                                           {'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'a0y5t',
                                            'helpTextType': 'none',
                                            'id': '58eba1b29833abb017d62000',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 3,
                                            'sizex': 1.0,
                                            'sizey': 0.0}],
                              'id': '58e516a3c536f80d98f00844',
                              'name': 'Advanced Search Investigation'},
                             {'$type': 'Core.Models.Layouts.Tabs, Core',
                              'active': False,
                              'children': [{'$type': 'Core.Models.Layouts.TabLayout, Core',
                                            'col': 1,
                                            'id': '58e57813520eece1186aedd7',
                                            'layoutType': 'tab',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 1,
                                            'sizex': 1.0,
                                            'sizey': 0.0,
                                            'tabs': [{'$type': 'Core.Models.Layouts.Tabs, Core',
                                                      'active': False,
                                                      'children': [{
                                                          '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                          'col': 1,
                                                          'helpTextType': 0,
                                                          'id': '58e57b1b0bb43aab4c101b10',
                                                          'layoutType': 'integration',
                                                          'name': 'VirusTotal IP Search',
                                                          'parentId': '58e57813520eece1186aedd7',
                                                          'row': 1,
                                                          'sizex': 4.0,
                                                          'sizey': 0.0,
                                                          'taskId': '58e66f8107637a10c803f444'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 2,
                                                              'fieldId': 'ahdtf',
                                                              'helpTextType': 'none',
                                                              'id': '58e57b1ef538892763646da9',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 1,
                                                              'sizex': 1.5,
                                                              'sizey': 0.0}],
                                                      'id': '58e5781657c0524e7800d098',
                                                      'name': 'Virustotal'},
                                                     {'$type': 'Core.Models.Layouts.Tabs, Core',
                                                      'active': False,
                                                      'children': [{
                                                          '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                          'col': 1,
                                                          'helpTextType': 0,
                                                          'id': '58e579494f5c29b874667d32',
                                                          'layoutType': 'integration',
                                                          'name': 'TCPUtils IP',
                                                          'parentId': '58e57813520eece1186aedd7',
                                                          'row': 1,
                                                          'sizex': 4.0,
                                                          'sizey': 0.0,
                                                          'taskId': '58e6787e07637a10c8040ab3'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.HtmlObjectLayout, Core',
                                                              'col': 2,
                                                              'html': '',
                                                              'id': '58e5794f86ea9f1a52d52ac8',
                                                              'layoutType': 'htmlObject',
                                                              'name': 'HtmlObject',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 1,
                                                              'sizex': 1.5,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'aqc6k',
                                                              'helpTextType': 'none',
                                                              'id': '58e578bd14f28fa204e24455',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 2,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 3,
                                                              'fieldId': 'a2ybt',
                                                              'helpTextType': 'none',
                                                              'id': '58e578c75b8d16ceb46e68ed',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 2,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'amjd0',
                                                              'helpTextType': 'none',
                                                              'id': '58e578dfeffe7800417b00d5',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 3,
                                                              'sizex': 1.0,
                                                              'sizey': 0.0}],
                                                      'id': '58e57816a96cf486cf08a26f',
                                                      'name': 'TcpIPUtils'},
                                                     {'$type': 'Core.Models.Layouts.Tabs, Core',
                                                      'active': False,
                                                      'children': [{
                                                          '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                          'col': 1,
                                                          'helpTextType': 0,
                                                          'id': '58e5793b5de81b8ae2f66926',
                                                          'layoutType': 'integration',
                                                          'name': 'Threat Connect',
                                                          'parentId': '58e57813520eece1186aedd7',
                                                          'row': 1,
                                                          'sizex': 4.0,
                                                          'sizey': 0.0,
                                                          'taskId': '58e6783007637a10c80409ad'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.HtmlObjectLayout, Core',
                                                              'col': 2,
                                                              'html': '',
                                                              'id': '58e5794148be5e8649b077a3',
                                                              'layoutType': 'htmlObject',
                                                              'name': 'HtmlObject',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 1,
                                                              'sizex': 1.5,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'a9aon',
                                                              'helpTextType': 'none',
                                                              'id': '58e57902830eacb5faab45c3',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 2,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 3,
                                                              'fieldId': 'azfys',
                                                              'helpTextType': 'none',
                                                              'id': '58e578f6340433a4afd7e121',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 2,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'a2gor',
                                                              'helpTextType': 'none',
                                                              'id': '58e578f83cde52824a820ec8',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 3,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 3,
                                                              'fieldId': 'ahep6',
                                                              'helpTextType': 'none',
                                                              'id': '58e578fa931192bed2f914ec',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 3,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'aabxm',
                                                              'helpTextType': 'none',
                                                              'id': '58e578fdb1c763e934242626',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 4,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 3,
                                                              'fieldId': 'a1k2a',
                                                              'helpTextType': 'none',
                                                              'id': '58e578ff824f83f9e04600c7',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 4,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0}],
                                                      'id': '58e5781709651abda0f1196d',
                                                      'name': 'ThreatConnect'},
                                                     {'$type': 'Core.Models.Layouts.Tabs, Core',
                                                      'active': False,
                                                      'children': [{
                                                          '$type': 'Core.Models.Layouts.IntegrationLayout, Core',
                                                          'col': 1,
                                                          'helpTextType': 0,
                                                          'id': '58e5796364d8a0c726e76481',
                                                          'layoutType': 'integration',
                                                          'name': 'IP Search in CrowdStrike',
                                                          'parentId': '58e57813520eece1186aedd7',
                                                          'row': 1,
                                                          'sizex': 2.0,
                                                          'sizey': 0.0,
                                                          'taskId': '58e677b007637a10c80408b8'},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 3,
                                                              'fieldId': 'alnet',
                                                              'helpTextType': 'none',
                                                              'id': '58e5797739b1dff445127095',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 1,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 6,
                                                              'fieldId': 'ayqk6',
                                                              'helpTextType': 'none',
                                                              'id': '58e5796d1670bae9939d886a',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 1,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'a3uyp',
                                                              'helpTextType': 'none',
                                                              'id': '58e57995e14257724e9f5a9c',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 2,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 2,
                                                              'fieldId': 'ah7js',
                                                              'helpTextType': 'none',
                                                              'id': '58e57983a394c5a71dca6297',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 2,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 4,
                                                              'fieldId': 'aazhn',
                                                              'helpTextType': 'none',
                                                              'id': '58e579a0a16d33439df5e923',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 2,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 7,
                                                              'fieldId': 'axk12',
                                                              'helpTextType': 'none',
                                                              'id': '58e5798c21cdac73b20eefb4',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 2,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'amuav',
                                                              'helpTextType': 'none',
                                                              'id': '58e579b15bb8f22d359a5e4e',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 3,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 2,
                                                              'fieldId': 'a5g30',
                                                              'helpTextType': 'none',
                                                              'id': '58e579b91792f6154c8a7be9',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 3,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 4,
                                                              'fieldId': 'ampg8',
                                                              'helpTextType': 'none',
                                                              'id': '58e579c581aac30ad9708118',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 3,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 7,
                                                              'fieldId': 'ara4m',
                                                              'helpTextType': 'none',
                                                              'id': '58e579cf5b480fef7eb82857',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 3,
                                                              'sizex': 4.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'afrn3',
                                                              'helpTextType': 'none',
                                                              'id': '58e579e5b31775c44cbd563c',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 4,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 3,
                                                              'fieldId': 'au7ic',
                                                              'helpTextType': 'none',
                                                              'id': '58e579dcfbb6bab0ef5a6ccc',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 4,
                                                              'sizex': 2.0,
                                                              'sizey': 0.0},
                                                          {
                                                              '$type': 'Core.Models.Layouts.FieldLayout, Core',
                                                              'col': 1,
                                                              'fieldId': 'agbsz',
                                                              'helpTextType': 'none',
                                                              'id': '58e57ab61aea0612e21ca87d',
                                                              'layoutType': 'field',
                                                              'parentId': '58e57813520eece1186aedd7',
                                                              'row': 5,
                                                              'sizex': 1.0,
                                                              'sizey': 0.0}],
                                                      'id': '58e578791dd03ae430a96254',
                                                      'name': 'CrowdStrike'}]}],
                              'id': '58e577fcf96a526b4d8b147d',
                              'name': 'External Research'},
                             {'$type': 'Core.Models.Layouts.Tabs, Core',
                              'active': False,
                              'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
                                            'col': 1,
                                            'fieldId': 'apwi0',
                                            'helpTextType': 'none',
                                            'id': '58e57cf3d898111c710db9eb',
                                            'layoutType': 'field',
                                            'parentId': '58e516a0027f9d87af37d50d',
                                            'row': 1,
                                            'sizex': 2.0,
                                            'sizey': 0.0}],
                              'id': '58e57ce79d105c20bf12cdfd',
                              'name': 'Feed Upload'}]}],
        'maxTrackingId': 30.0,
        'modifiedByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                           'id': '58de1d1c07637a0264c0ca6a',
                           'name': 'admin'},
        'modifiedDate': '2017-04-21T23:07:22.667Z',
        'name': 'RSA Alerts',
        'permissions': {'$type': 'Core.Models.Security.PermissionMatrix, Core'},
        'timeTrackingEnabled': False,
        'trackingFieldId': '58e4bb4407637a0e4c4f9875',
        'workspaces': ['58e4bb4407637a0e4c4f9888']})


@pytest.fixture
def mock_record(mock_app):
    return Record(mock_app, {
        '$type': 'Core.Models.Record.Record, Core',
        'actionsExecuted': {
            '$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Object, mscorlib]], mscorlib'},
        'allowed': [],
        'applicationId': '58e4bb4407637a0e4c4f9873',
        'applicationRevision': 0.0,
        'comments': {
            '$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Collections.Generic.List`1[[Core.Models.Record.Comments, Core]], mscorlib]], mscorlib',
            'a3uau': [{'$type': 'Core.Models.Record.Comments, Core',
                       'createdByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                                         'id': '58de1d1c07637a0264c0ca6a',
                                         'name': 'admin'},
                       'createdDate': '2017-04-19T18:40:25.529Z',
                       'message': 'Example comment'}]},
        'createdDate': '0001-01-01T00:00:00',
        'disabled': False,
        'id': '58ebb22807637a02d4a14bd6',
        'isNew': False,
        'linkedData': {
            '$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Object, mscorlib]], mscorlib'},
        'modifiedDate': '0001-01-01T00:00:00',
        'referencedByIds': [],
        'referencedRecordIds': [],
        'sessionTimeSpent': 0,
        'timeTrackingEnabled': True,
        'totalTimeSpent': 0,
        'trackingId': 7.0,
        'values': {
            '$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Object, mscorlib]], mscorlib',
            '58e4bb4407637a0e4c4f9875': 'RA-7',
            'a04rv': '10.0.1.184:56005:3172',
            'a0g40': 'Alert Action',
            'a0k7v': {'$type': 'Core.Models.Record.ValueSelection, Core',
                      'id': '58e7bae8c61082e377cc4d82',
                      'value': 'Open'},
            'a11mn': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                      'id': '58de1d1c07637a0264c0ca6a',
                      'name': 'admin'},
            'a18qr': 'User.Activity.Failed Logins',
            'a1k2a': 'https://app.threatconnect.com/auth/threat/threat.xhtml?threat=2058283',
            'a1r3v': 'Logon',
            'a2gor': 'Transparent Tribe',
            'a2ybt': 'Germany',
            'a365t': '2017-04-05T13:00:00',
            'a3rvw': '3172',
            'a3w8f': ['58e24e8607637a0b488849c0',
                      '58e24e8607637a0b488849ca',
                      '58e24dc507637a0b48884950'],
            'a44wz': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                      'id': '58de1d1c07637a0264c0ca71',
                      'name': 'Everyone'},
            'a4l9p': 'logdec1',
            'a5g30': 'C2',
            'a5v09': {'$type': 'Core.Models.Record.ValueSelection, Core',
                      'id': '58e7bafd83f418637cf91c3e',
                      'value': 'ESA Alert'},
            'a5yg3': '3172',
            'a6if8': '[{"lifetime": "60", "rid": "4531291", "payload": "7808", "size": "11956", "service": "0", "eth.src": "00:0C:29:5B:98:5E", "feed.name": "Swimlane_Feed", "medium": "1", "ip.dst": "178.238.235.143", "org.dst": "Contabo GmbH", "sessionid": "4534669", "latdec.dst": "51.2993", "eth.type": "2048", "ip.src": "10.0.1.183", "domain.dst": "contabo.host", "eth.dst": "00:50:56:A7:4D:79", "did": "packdec1", "longdec.dst": "9.491", "packets": "122", "streams": "2", "country.dst": "Germany", "time": 1491593904, "ip.proto": "1"}]',
            'a7bgv': '2017-04-21T00:00:00Z',
            'a7gm5': '<14>Apr  5 23:42:54 localhost CEF:0|RSA|Security Analytics ESA|10.4|Module_58e40ea9e4b070dfd2a59ad5_Alert|Alert Action|7|rt=2017-04-05T23:42Z id=890eb2b1-2d90-46a5-b1ed-6e58b408ed83 source=10.0.1.184:56005:3172  action=authentication failure;; client=sshd;; device_class=Unix;; device_ip=10.0.1.178;; device_type=crossbeamc;; did=logdec1;; ec_activity=Logon;; ec_outcome=Failure;; ec_subject=User;; ec_theme=Authentication;; esa_time=1491435774280;; event_cat_name=User.Activity.Failed Logins;; event_source_id=10.0.1.184:56005:3172;; header_id=0006;; host_src=178.238.235.143;; level=4;; medium=32;; msg_id=000103;; rid=3172;; sessionid=3172;; size=175;; time=1491435771;; user_dst=user;; username=0;;\x00',
            'a7ira': 'User',
            'a8vjm': 'Failure',
            'a990o': '7',
            'aabxm': 'Threat',
            'aag0z': '<table class="table table-bordered table-hover"><tr><th>lifetime</th><th>rid</th><th>payload</th><th>size</th><th>service</th><th>eth.src</th><th>country.dst</th><th>medium</th><th>ip.dst</th><th>org.dst</th><th>sessionid</th><th>latdec.dst</th><th>eth.type</th><th>ip.src</th><th>domain.dst</th><th>eth.dst</th><th>did</th><th>longdec.dst</th><th>packets</th><th>streams</th><th>feed.name</th><th>time</th><th>ip.proto</th></tr><tr><td>60</td><td>4531291</td><td>7808</td><td>11956</td><td>0</td><td>00:0C:29:5B:98:5E</td><td>Germany</td><td>1</td><td>178.238.235.143</td><td>Contabo GmbH</td><td>4534669</td><td>51.2993</td><td>2048</td><td>10.0.1.183</td><td>contabo.host</td><td>00:50:56:A7:4D:79</td><td>packdec1</td><td>9.491</td><td>122</td><td>2</td><td>Swimlane_Feed</td><td>1491593904</td><td>1</td></tr></table>',
            'aasnf': {'$type': 'Core.Models.Record.ValueSelection, Core',
                      'id': '58e7bb144121bd73d8f53845',
                      'value': 'High'},
            'aazhn': 'MYTHICLEOPARD',
            'ac1oa': '2017-04-02T23:42:00',
            'acl9o': 'Mar 29 08:59:50 splunk lxcfs[940]:   4: fd:   9: net_cls,net_prio\nMar 29 08:59:50 splunk kernel: [    0.000000] Hypervisor detected: VMware\nMar 29 08:59:50 splunk kernel: [    0.000000] NODE_DATA(0) allocated [mem 0x13fff8000-0x13fffcfff]\nMar 29 08:59:50 splunk kernel: [    0.000000] RCU: Adjusting geometry for rcu_fanout_leaf=64, nr_cpu_ids=4\nMar 29 08:59:50 splunk kernel: [    0.000000] console [tty0] enabled\nMar 29 08:59:50 splunk kernel: [    0.187011] PM: Registering ACPI NVS region [mem 0xbfeff000-0xbfefffff] (4096 bytes)\nMar 29 08:59:50 splunk kernel: [    0.289673] pci 0000:00:15.4: [15ad:07a0] type 01 class 0x060400\nMar 29 08:59:50 splunk kernel: [    0.306003] pci 0000:00:18.5: System wakeup disabled by ACPI\nMar 29 08:59:50 splunk kernel: [    0.317367] pci 0000:00:15.4: PCI bridge to [bus 07]\nMar 29 08:59:50 splunk kernel: [    0.324226] pci 0000:00:18.3: PCI bridge to [bus 1e]\nMar 29 08:59:50 splunk kernel: [    0.374053] pci 0000:00:17.6: bridge window [io  0x1000-0x0fff] to [bus 19] add_size 1000\nMar 29 08:59:50 splunk kernel: [    0.376241] pci 0000:00:17.5: BAR 13: failed to assign [io  size 0x1000]\nMar 29 08:59:50 splunk kernel: [    0.381821] pci 0000:00:15.3: PCI bridge to [bus 06]\nMar 29 08:59:50 splunk kernel: [    0.389813] pci 0000:00:18.2: PCI bridge to [bus 1d]\nMar 29 08:59:50 splunk kernel: [    0.391570] pci_bus 0000:13: resource 2 [mem 0xeb800000-0xeb8fffff 64bit pref]\nMar 29 08:59:50 splunk kernel: [    0.788759] pcie_pme 0000:00:15.0:pcie01: service driver pcie_pme loaded\nMar 29 08:59:50 splunk kernel: [    0.796112] pciehp 0000:00:15.6:pcie04: service driver pciehp loaded\nMar 29 08:59:50 splunk kernel: [    0.852911] ehci-pci: EHCI PCI platform driver\nMar 29 08:59:50 splunk kernel: [    2.111909] AVX version of gcm_enc/dec engaged.\nMar 29 08:59:50 splunk kernel: [    4.099053] md: raid4 personality registered for level 4\nMar 29 08:59:50 splunk irqbalance[1106]:    ...done.\nMar 29 11:12:59 splunk sshd[3125]: fatal: Unable to negotiate with 10.0.1.10 port 55450: no matching key exchange method found. Their offer: diffie-hellman-group1-sha1 [preauth]\nMar 29 19:56:21 splunk sshd[9399]: fatal: Unable to negotiate with 10.0.1.10 port 50808: no matching key exchange method found. Their offer: diffie-hellman-group1-sha1 [preauth]\nMar 30 05:17:01 splunk CRON[16176]: pam_unix(cron:session): session opened for user root by (uid=0)\nMar 30 13:16:22 splunk systemd[1]: apt-daily.timer: Adding 1h 12min 7.795190s random time.\nMar 30 18:22:08 splunk sshd[26877]: fatal: Unable to negotiate with 10.0.1.10 port 47092: no matching key exchange method found. Their offer: diffie-hellman-group1-sha1 [preauth]\nMar 31 03:17:01 splunk CRON[1496]: pam_unix(cron:session): session closed for user root\nMar 31 11:17:01 splunk CRON[7743]: pam_unix(cron:session): session closed for user root\nMar 31 19:36:54 splunk systemd[1]: apt-daily.timer: Adding 3h 28min 17.687266s random time.\nMar 31 20:17:01 splunk CRON[14688]: (root) CMD (   cd / && run-parts --report /etc/cron.hourly)\nApr  1 05:43:20 splunk systemd[1]: snapd.refresh.timer: Adding 3h 41min 31.130550s random time.\nApr  1 13:17:01 splunk CRON[27787]: pam_unix(cron:session): session opened for user root by (uid=0)\nApr  1 23:08:55 splunk sshd[2991]: fatal: Unable to negotiate with 10.0.1.10 port 45758: no matching key exchange method found. Their offer: diffie-hellman-group1-sha1 [preauth]\nApr  2 06:47:01 splunk CRON[9119]: pam_unix(cron:session): session opened for user root by (uid=0)\nApr  2 06:47:03 splunk CRON[9119]: pam_unix(cron:session): session closed for user root\nApr  2 15:26:13 splunk sshd[15787]: fatal: Unable to negotiate with 10.0.1.10 port 51872: no matching key exchange method found. Their offer: diffie-hellman-group1-sha1 [preauth]\nApr  3 00:17:01 splunk CRON[22704]: pam_unix(cron:session): session opened for user root by (uid=0)\nApr  3 08:58:35 splunk sshd[29536]: fatal: Unable to negotiate with 10.0.1.10 port 44038: no matching key exchange method found. Their offer: diffie-hellman-group1-sha1 [preauth]\nApr  3 18:17:01 splunk CRON[4260]: pam_unix(cron:session): session closed for user root\nApr  4 10:17:01 splunk CRON[15857]: pam_unix(cron:session): session opened for user root by (uid=0)\nApr  4 15:01:51 splunk sshd[19167]: pam_unix(sshd:auth): check pass; user unknown\nApr  4 15:12:20 splunk sshd[19342]: Failed password for invalid user admin from 10.0.3.200 port 61969 ssh2\nApr  4 15:23:20 splunk sshd[19546]: PAM 1 more authentication failure; logname= uid=0 euid=0 tty=ssh ruser= rhost=10.0.3.200\nApr  4 15:45:18 splunk sshd[19814]: pam_unix(sshd:auth): check pass; user unknown\nApr  4 16:08:34 splunk sshd[20033]: Invalid user admin from 10.0.3.200\nApr  4 22:17:01 splunk CRON[24590]: pam_unix(cron:session): session opened for user root by (uid=0)\nApr  5 11:17:01 splunk CRON[1667]: pam_unix(cron:session): session opened for user root by (uid=0)\nApr  5 11:17:01 splunk CRON[1667]: pam_unix(cron:session): session closed for user root\nApr  5 13:21:41 splunk sshd[3382]: message repeated 2 times: [ Failed password for user from 10.0.3.200 port 61496 ssh2]\nApr  5 13:35:07 splunk systemd-logind[996]: New session 202 of user user.\nApr  5 17:16:14 splunk systemd[1]: snapd.refresh.timer: Adding 3h 48min 41.276237s random time.\nApr  6 09:17:01 splunk CRON[18136]: pam_unix(cron:session): session closed for user root\nApr  6 09:17:10 splunk systemd[1]: Started Cleanup of Temporary Directories.\nApr  7 00:17:01 splunk CRON[29019]: pam_unix(cron:session): session closed for user root\nApr  7 11:17:01 splunk CRON[4922]: (root) CMD (   cd / && run-parts --report /etc/cron.hourly)\nApr  7 16:45:09 splunk sshd[9179]: Connection closed by 10.0.1.10 port 44167 [preauth]\nApr  7 22:40:33 splunk sshd[13666]: fatal: Unable to negotiate with 10.0.1.10 port 60949: no matching host key type found. Their offer: ecdsa-sha2-nistp521 [preauth]\nApr  7 23:17:01 splunk CRON[14063]: (root) CMD (   cd / && run-parts --report /etc/cron.hourly)\nApr  8 05:42:16 splunk sshd[19026]: Did not receive identification string from 10.0.1.10\nApr  8 10:48:13 splunk systemd[1]: snapd.refresh.timer: Adding 4h 27min 21.903828s random time.\nApr  8 17:17:01 splunk CRON[27791]: pam_unix(cron:session): session closed for user root\nApr  8 23:32:33 splunk sshd[32530]: Connection closed by 10.0.1.10 port 48600 [preauth]\nApr  8 23:32:33 splunk sshd[32533]: fatal: Unable to negotiate with 10.0.1.10 port 48615: no matching host key type found. Their offer: ecdsa-sha2-nistp384 [preauth]\nApr  9 05:25:42 splunk sshd[4731]: fatal: Unable to negotiate with 10.0.1.10 port 46071: no matching host key type found. Their offer: ecdsa-sha2-nistp384 [preauth]\nApr  9 11:22:54 splunk sshd[9292]: Protocol major versions differ for 10.0.1.10: SSH-2.0-OpenSSH_7.2p2 Ubuntu-4ubuntu2.1 vs. SSH-1.5-Nmap-SSH1-Hostkey\nApr  9 17:18:35 splunk sshd[13798]: Protocol major versions differ for 10.0.1.10: SSH-2.0-OpenSSH_7.2p2 Ubuntu-4ubuntu2.1 vs. SSH-1.5-NmapNSE_1.0\nApr  9 23:17:01 splunk CRON[18223]: pam_unix(cron:session): session closed for user root\nApr 10 02:17:01 splunk CRON[20422]: pam_unix(cron:session): session closed for user root\nApr 10 04:17:01 splunk CRON[22016]: pam_unix(cron:session): session closed for user root\nApr 10 06:32:03 splunk sshd[23779]: fatal: Unable to negotiate with 10.0.1.10 port 51063: no matching host key type found. Their offer: ecdsa-sha2-nistp521 [preauth]\nApr 10 09:18:01 splunk systemd[1]: Starting Cleanup of Temporary Directories...\nApr 10 09:18:01 splunk systemd[1]: Started Cleanup of Temporary Directories.\n',
            'acqdq': '1491435774280',
            'aep2e': [{'$type': 'Core.Models.Record.Attachment, Core',
                       'fileId': '58ebb22907637a0b488b7b17',
                       'filename': '5f09afe50064b2bd718e77818b565df1.pcap',
                       'uploadDate': '2017-04-10T16:26:17.017Z'}],
            'af967': '890eb2b1-2d90-46a5-b1ed-6e58b408ed83',
            'afbbv': '',
            'afff3': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                      'id': '58de1d1c07637a0264c0ca6a',
                      'name': 'admin'},
            'afrn3': 'ThreatType/Targeted, KillChain/C2, MaliciousConfidence/High, Actor/MYTHICLEOPARD',
            'agn03': [{'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                       'id': '58de1d1c07637a0264c0ca6a',
                       'name': 'admin'},
                      {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                       'id': '58ebc11107637a02d4a23f14',
                       'name': 'wade wilson'}],
            'agoat': [{'$type': 'Core.Models.Record.Attachment, Core',
                       'fileId': '58ebb22a07637a0b488b7db3',
                       'filename': '362a36190a149866cf0f54e0fd119338.log',
                       'uploadDate': '2017-04-10T16:26:18.548Z'}],
            'ah7js': 'high',
            'ahdtf': 'http://mail.vdjunky.org/, http://www.vdjunky.org/, http://vdjunky.org/, http://178.238.235.143:9001/, http://178.238.235.143/, http://m1343.contabo.host/',
            'ahep6': 'TLP RED',
            'ahziu': '178.238.235.143',
            'aiir8': '2017-04-10T16:26:16.389',
            'aio1w': 'sshd',
            'akxvh': 177360000,
            'alnet': 'ip_address',
            'amjd0': 'ns1.contabo.net,ns2.contabo.net',
            'anet4': '10.0.1.183, 178.238.235.143',
            'ao64i': '2017-04-21T21:00:10.942',
            'aokp5': 'Unix',
            'apf9i': '10.0.1.178',
            'aqc6k': 'Contabo GmbH',
            'aqkg3': 1,
            'arlrt': [{'$type': 'Core.Models.Record.ValueSelection, Core',
                       'id': '58fae4eafef0eead26dee65c',
                       'value': 'Option 2'},
                      {'$type': 'Core.Models.Record.ValueSelection, Core',
                       'id': '58fae4c59173122945a7cff6',
                       'value': 'Option 1'}],
            'arnd6': 'authentication failure',
            'arok4': 'crossbeamc',
            'au7ic': 'vdjunky.org, a6f8b4b528d67fe5b985ad0a394e46f5c116bb80b7cb8ca9a094d92f4dc614c1, 9b98abb9a9fa714e05d43b08b76c0afa, 85429d5f2745d813e53b28d3d953d1cd, 3e91836b89b6d6249741dc8ee0d2895a, tcp.vdjunky.org, 8253dd13c126c44483bcbde23e61d53d',
            'aw9gd': 'ip.src=10.0.1.178 || ip.dst=10.0.1.178',
            'awmtq': 'Authentication',
            'axdvr': '175',
            'ayqk6': '178.238.235.143',
            'azfys': 2058283,
            'azygs': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                      'id': '58de1d1c07637a0264c0ca71',
                      'name': 'Everyone'}},
        'visualizations': {
            '$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Collections.Generic.List`1[[Core.Models.Record.VisualizationData, Core]], mscorlib]], mscorlib'}})


@pytest.fixture
def mock_user(mock_swimlane):
    return User(mock_swimlane, {
        '$type': 'Core.Models.Identity.ApplicationUser, Core',
        'active': False,
        'createdByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core'},
        'createdDate': '2017-03-31T09:10:52.717Z',
        'disabled': False,
        'displayName': 'admin',
        'groups': [],
        'id': '58de1d1c07637a0264c0ca6a',
        'isAdmin': True,
        'isMe': False,
        'lastLogin': '2017-04-27T15:45:43.066Z',
        'lastPasswordChangedDate': '2017-03-31T09:10:52.536Z',
        'modifiedByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core'},
        'modifiedDate': '2017-03-31T09:10:52.76Z',
        'name': 'admin',
        'passwordComplexityScore': 3,
        'passwordHash': 'AQAAAAEAACcQAAAAEESp9LR0jN3qPF2fw5qWdyceYxbeBbawMW5AFt31dA5n3xX16MFJWsU/j82heenFww==',
        'passwordResetRequired': False,
        'roles': [],
        'userName': 'admin'})


@pytest.fixture
def mock_group(mock_swimlane):
    return Group(mock_swimlane, {
        '$type': 'Core.Models.Groups.Group, Core',
        'createdByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core'},
        'createdDate': '2017-03-31T09:10:52.786Z',
        'description': 'Each user is automatically added as a member of this group',
        'disabled': False,
        'groups': [],
        'id': '58de1d1c07637a0264c0ca71',
        'modifiedByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core'},
        'modifiedDate': '2017-03-31T09:10:52.808Z',
        'name': 'Everyone',
        'roles': [],
        'users': [{'$type': 'Core.Models.Base.Entity, Core',
                   'disabled': False,
                   'id': '58de1d1c07637a0264c0ca6a',
                   'name': 'admin'},
                  {'$type': 'Core.Models.Base.Entity, Core',
                   'disabled': False,
                   'id': '58ebc08807637a02d4a23cb8',
                   'name': 'clark.kent'},
                  {'$type': 'Core.Models.Base.Entity, Core',
                   'disabled': False,
                   'id': '58ebc0d507637a02d4a23e42',
                   'name': 'bruce.wayne'},
                  {'$type': 'Core.Models.Base.Entity, Core',
                   'disabled': False,
                   'id': '58ebc0f307637a02d4a23eb7',
                   'name': 'tony.stark'},
                  {'$type': 'Core.Models.Base.Entity, Core',
                   'disabled': False,
                   'id': '58ebc11107637a02d4a23f14',
                   'name': 'wade.wilson'},
                  {'$type': 'Core.Models.Base.Entity, Core',
                   'disabled': False,
                   'id': '58ebc12907637a02d4a23f7d',
                   'name': 'jon.snow'},
                  {'$type': 'Core.Models.Base.Entity, Core',
                   'disabled': False,
                   'id': '58ebc14807637a02d4a23fde',
                   'name': 'fred.rogers'}]}
                 )


@pytest.fixture
def mock_report(mock_app):
    return Report(mock_app, {
        '$type': 'Core.Models.Search.Report, Core',
        'aggregates': [],
        'allowed': [],
        'applicationIds': ['58e4bb4407637a0e4c4f9873'],
        'columns': ['arnd6',
                    'a1r3v',
                    'aazhn',
                    'agbsz',
                    'a0g40',
                    'a44wz',
                    'aasqt',
                    'aio1w',
                    'apwi0',
                    'a7bgv',
                    'a429d',
                    'aokp5',
                    'a4l9p',
                    'apf9i',
                    'arok4',
                    'ampg8',
                    'acqdq',
                    'a18qr',
                    'aw9gd',
                    'a29ot',
                    'af967',
                    'anet4',
                    'a365t',
                    'aiir8',
                    'afff3',
                    'akxvh',
                    'ac1oa',
                    'azygs',
                    'a5v09',
                    'ayqk6',
                    'alnet',
                    'a3uau',
                    'ara4m',
                    'a5g30',
                    'afrn3',
                    'a11mn',
                    'agoat',
                    'acl9o',
                    'ah7js',
                    'amuav',
                    'a7gm5',
                    'a6if8',
                    'aag0z',
                    'aqkg3',
                    'a8vjm',
                    'aep2e',
                    'axoxa',
                    'abcez',
                    'ahchn',
                    'ao0wj',
                    'a3w8f',
                    'au7ic',
                    'a1x9p',
                    'a3uyp',
                    'axk12',
                    'a5yg3',
                    'a0y5t',
                    'a0mb9',
                    'a3rvw',
                    'a990o',
                    'aasnf',
                    'axdvr',
                    'a04rv',
                    'ahziu',
                    'afbbv',
                    'a0k7v',
                    'a7ira',
                    'a9aon',
                    'azfys',
                    'a2gor',
                    'ahep6',
                    'aabxm',
                    'a1k2a',
                    'amjd0',
                    'a2ybt',
                    'aqc6k',
                    'awmtq',
                    'ao64i',
                    '58e4bb4407637a0e4c4f9875',
                    'ahdtf',
                    'agn03',
                    'arlrt'],
        'createdByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                          'id': '58de1d1c07637a0264c0ca6a',
                          'name': 'admin'},
        'createdDate': '2017-04-27T17:13:36-06:00',
        'defaultSearchReport': False,
        'disabled': False,
        'filters': [],
        'groupBys': [],
        'id': None,
        'keywords': '',
        'modifiedByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
                           'id': '58de1d1c07637a0264c0ca6a',
                           'name': 'admin'},
        'modifiedDate': '2017-04-27T17:13:36-06:00',
        'name': 'search-12345678',
        'offset': 0,
        'pageSize': 50,
        'permissions': {'$type': 'Core.Models.Security.PermissionMatrix, Core'},
        'sorts': {
            '$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[Core.Models.Search.SortTypes, Core]], mscorlib'}})

@pytest.fixture
def mock_app_all_fields(mock_swimlane):
    return App(mock_swimlane, {
          '$type': 'Core.Models.Application.Application, Core',
          'acronym': 'AFC',
          'createWorkspace': False,
          'createdByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
           'id': 'a53r5Mitu5NnbuzdH',
           'name': 'admin'},
          'createdDate': '2017-11-22T17:29:50.017Z',
          'description': 'An application of all field types.',
          'disabled': False,
          'fields': [{'$type': 'Core.Models.Fields.AttachmentField, Core',
            'fieldType': 'attachment',
            'helpTextType': 'none',
            'id': 'a7W4o9aUbztV0W3kj',
            'key': 'attachment',
            'layoutId': 'a7q1Rm4GIqg_iKEIz',
            'maxSize': 100000,
            'name': 'Attachment'},
           {'$type': 'Core.Models.Fields.ValuesListField, Core',
            'controlType': 'checkbox',
            'fieldType': 'valuesList',
            'helpTextType': 'none',
            'id': 'aDD7P9NP8MJYX84pI',
            'key': 'checkbox-multi-select-values-',
            'layoutId': 'aDX42lsAqD73DxFNY',
            'name': 'Checkbox Multi-select Values List',
            'selectionType': 'multi',
            'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02d124233491ba2afff63',
              'name': 'a',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02d1ea3005d2b6bce02ed',
              'name': 'b',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02d21148c5105475ec998',
              'name': 'c',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02d247a52c19845976992',
              'name': 'd',
              'selected': False}]},
           {'$type': 'Core.Models.Fields.CommentsField, Core',
            'fieldType': 'comments',
            'helpTextType': 'none',
            'id': 'a3OmQDERYtSxyxtTQ',
            'key': 'comments',
            'layoutId': 'a3ij3pjDFkGSfm31g',
            'name': 'Comments'},
           {'$type': 'Core.Models.Fields.UserGroupField, Core',
            'controlType': 'select',
            'defaults': [],
            'fieldType': 'userGroup',
            'helpTextType': 'none',
            'id': 'a9PlfpW7n6hWBO46F',
            'inputType': 'createdBy',
            'key': 'created-by',
            'layoutId': 'a9jiJQ_uTyV0tCEfV',
            'members': [],
            'name': 'Created By',
            'selectionType': 'single',
            'showAllGroups': False,
            'showAllUsers': True},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aJY3IN8s3RLcRNR0N',
            'inputType': 'dateTime',
            'key': 'date--time',
            'layoutId': 'aJr_wzddlI978BbZd',
            'name': 'Date & Time'},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aHeNQiDDtJXbGVQer',
            'inputType': 'date',
            'key': 'date-min-day',
            'layoutId': 'aHyK4Jh_aAL5yJbD6',
            'minMode': 'day',
            'name': 'Date Min Day'},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aH0U8UEgUbwast5XL',
            'inputType': 'date',
            'key': 'date-min-month',
            'layoutId': 'aHKQn5jSBSk5ZhG5b',
            'minMode': 'month',
            'name': 'Date Min Month'},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aGNarGG85uKaUFlPq',
            'inputType': 'date',
            'key': 'date-min-year',
            'layoutId': 'aGhXUskunl85B3vz5',
            'minMode': 'year',
            'name': 'Date Min Year'},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aM4dSG32dGld_smUP',
            'inputType': 'date',
            'key': 'default-date',
            'layoutId': 'aMOa5sXpK7Z8hgx2f',
            'name': 'Default Date'},
           {'$type': 'Core.Models.Fields.NumericField, Core',
            'fieldType': 'numeric',
            'format': 'none',
            'helpTextType': 'none',
            'id': 'aOcCc8yEC6AfZN6yR',
            'key': 'default-numeric',
            'layoutId': 'aOw9FlR_txzAGBHWh',
            'name': 'Default Numeric',
            'step': 1.0},
           {'$type': 'Core.Models.Fields.Reference.ReferenceField, Core',
            'canAdd': True,
            'columns': ['aVtzRCC0CkcEZ2yqH'],
            'controlType': 'grid',
            'createLink': False,
            'fieldType': 'reference',
            'helpTextType': 'none',
            'id': 'a6FIDidOpZgUEGOVi',
            'key': 'default-reference',
            'layoutId': 'a6ZEsK7AWQTzw4Z3y',
            'name': 'Default Reference',
            'selectionType': 'multi',
            'targetId': 'aWCw4ogmubPkFs8OX'},
           {'$type': 'Core.Models.Fields.UserGroupField, Core',
            'controlType': 'select',
            'defaults': [],
            'fieldType': 'userGroup',
            'helpTextType': 'none',
            'id': 'aBJRXURlyEVXMG4Sm',
            'inputType': 'userGroup',
            'key': 'default-usergroups',
            'layoutId': 'aBdOB5wXf5J234F11',
            'members': [],
            'name': 'Default User/Groups',
            'selectionType': 'single',
            'showAllGroups': False,
            'showAllUsers': True},
           {'$type': 'Core.Models.Fields.ValuesListField, Core',
            'controlType': 'select',
            'fieldType': 'valuesList',
            'helpTextType': 'none',
            'id': 'aF6oGpJ2JU7Zi05Ap',
            'key': 'default-values-list',
            'layoutId': 'aFQkvQnp0Kw4OpFk4',
            'name': 'Default Values List',
            'selectionType': 'single',
            'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c304c52e4babd91419b',
              'name': 'One',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c381d2c1723a2625759',
              'name': 'Two',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c3d40b89cd9957fd519',
              'name': 'Three',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c422e29e4c21d1a58e4',
              'name': 'Four',
              'selected': False}]},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aRmg3Fqy9eBhWUnYz',
            'inputType': 'email',
            'key': 'email',
            'layoutId': 'aS5chsKjrU_CDIy7E',
            'lengthType': 'none',
            'name': 'Email',
            'readOnly': False,
            'required': False,
            'visualize': False,
            'visualizeMode': 0},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aIvA09AJfjkc2l5ts',
            'inputType': 'firstCreated',
            'key': 'first-created',
            'layoutId': 'aJE6elf5MaY6kZGS7',
            'name': 'First Created'},
           {'$type': 'Core.Models.Fields.Reference.ReferenceField, Core',
            'canAdd': True,
            'columns': ['aVtzRCC0CkcEZ2yqH'],
            'controlType': 'grid',
            'createLink': False,
            'fieldType': 'reference',
            'helpTextType': 'none',
            'id': 'a5cOwUerQs4Tqe3OC',
            'key': 'grid-multi-column-reference',
            'layoutId': 'a5wLa68d7iszXSDxS',
            'name': 'Grid multi-column Reference',
            'selectionType': 'multi',
            'targetId': 'aWCw4ogmubPkFs8OX'},
           {'$type': 'Core.Models.Fields.History.HistoryField, Core',
            'fieldType': 'history',
            'helpTextType': 'none',
            'id': 'a27zqmHLmTFxBiDEP',
            'key': 'history',
            'layoutId': 'a2RwUNm7TK3RtWNnf',
            'name': 'History'},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aPs_BavJzWNgLcnCS',
            'inputType': 'ip',
            'key': 'ip',
            'layoutId': 'aQBwqCP5gNBB2Qxli',
            'lengthType': 'none',
            'name': 'IP',
            'readOnly': False,
            'required': False,
            'visualize': False,
            'visualizeMode': 0},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aIHGiwBmH18bf7lmM',
            'inputType': 'lastUpdated',
            'key': 'last-updated',
            'layoutId': 'aIbDMXgXysx6LwwKc',
            'name': 'Last Updated'},
           {'$type': 'Core.Models.Fields.UserGroupField, Core',
            'controlType': 'select',
            'defaults': [],
            'fieldType': 'userGroup',
            'helpTextType': 'none',
            'id': 'a8msNbXaOP5Vnljzk',
            'inputType': 'lastUpdatedBy',
            'key': 'last-updated-by',
            'layoutId': 'a95p1D1M5Fu0UZuX_',
            'members': [],
            'name': 'Last Updated By',
            'selectionType': 'single',
            'showAllGroups': False,
            'showAllUsers': True},
           {'$type': 'Core.Models.Fields.Reference.ReferenceField, Core',
            'canAdd': True,
            'columns': ['aVtzRCC0CkcEZ2yqH'],
            'controlType': 'select',
            'createLink': False,
            'fieldType': 'reference',
            'helpTextType': 'none',
            'id': 'a4zVeGgJ29TTS0jGh',
            'key': 'multi-select-reference',
            'layoutId': 'a5ISHtA4k0Gz8ptpx',
            'name': 'Multi Select Reference',
            'selectionType': 'multi',
            'targetId': 'aWCw4ogmubPkFs8OX'},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aT2Sdho2x3OiIkSn_',
            'inputType': 'multiline',
            'key': 'multi-line-text',
            'layoutId': 'aTMPHJHpdvCC_YdMF',
            'lengthType': 'none',
            'name': 'Multi-line Text',
            'readOnly': False,
            'required': False,
            'visualize': False,
            'visualizeMode': 0},
           {'$type': 'Core.Models.Fields.UserGroupField, Core',
            'controlType': 'select',
            'defaults': [],
            'fieldType': 'userGroup',
            'helpTextType': 'none',
            'id': 'aA2ey2UgApIWa0PDl',
            'inputType': 'userGroup',
            'key': 'multi-select-usergroups',
            'layoutId': 'aAMbbezRsg61GpZn0',
            'members': [],
            'name': 'Multi-select User/Groups',
            'selectionType': 'multi',
            'showAllGroups': False,
            'showAllUsers': True},
           {'$type': 'Core.Models.Fields.ValuesListField, Core',
            'controlType': 'select',
            'fieldType': 'valuesList',
            'helpTextType': 'none',
            'id': 'aCaE6wOrkeiY8Vkhn',
            'key': 'multi-select-value-list',
            'layoutId': 'aCuAlXtdRVW2qJvG2',
            'name': 'Multi-select Value List',
            'selectionType': 'multi',
            'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c88cb0a82ca7b9d5713',
              'name': 'I',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c8e581fcb224ded6b93',
              'name': 'II',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c92f3fa15ccf87b0f43',
              'name': 'III',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c98dacabe5ce0c0b21c',
              'name': 'IV',
              'selected': False}]},
           {'$type': 'Core.Models.Fields.ValuesListField, Core',
            'controlType': 'radio',
            'fieldType': 'valuesList',
            'helpTextType': 'none',
            'id': 'aDr0hNLxX3vYvlPwo',
            'key': 'radio-button-values-list',
            'layoutId': 'aE9yKzqjDvj3cZaV3',
            'name': 'Radio Button Values List',
            'selectionType': 'single',
            'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02cca95ac38f579631df0',
              'name': '00',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02cd2d3f92e8c591de395',
              'name': '01',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02cd62542d03efcdcf0bd',
              'name': '10',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02cda383fe28ec3fa9f6c',
              'name': '11',
              'selected': False}]},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aLRkA24VEZ9dcFRMu',
            'inputType': 'date',
            'key': 'required-date',
            'layoutId': 'aLlgoeZGwPy8J3bw9',
            'name': 'Required Date',
            'required': True},
           {'$type': 'Core.Models.Fields.NumericField, Core',
            'fieldType': 'numeric',
            'format': 'none',
            'helpTextType': 'none',
            'id': 'aNzJJvzgoOZfAkmqw',
            'key': 'required-numeric',
            'layoutId': 'aOIFyXTSVFN9sYxPB',
            'name': 'Required Numeric',
            'required': True,
            'step': 1.0},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aUJFD8l8jTbj4_820',
            'inputType': 'text',
            'key': 'required-text',
            'layoutId': 'aUdBrlEvQKPDmoIbG',
            'lengthType': 'none',
            'name': 'Required Text',
            'readOnly': False,
            'required': True,
            'visualize': False,
            'visualizeMode': 0},
           {'$type': 'Core.Models.Fields.UserGroupField, Core',
            'controlType': 'select',
            'defaults': [],
            'fieldType': 'userGroup',
            'helpTextType': 'none',
            'id': 'aAgYFGTDZWuWydkLG',
            'inputType': 'userGroup',
            'key': 'required-usergroups',
            'layoutId': 'aA_Utsx_GNi1fRuuW',
            'members': [],
            'name': 'Required User/Groups',
            'required': True,
            'selectionType': 'single',
            'showAllGroups': False,
            'showAllUsers': True},
           {'$type': 'Core.Models.Fields.ValuesListField, Core',
            'controlType': 'select',
            'fieldType': 'valuesList',
            'helpTextType': 'none',
            'id': 'aETuzbKUvmWZJNl3J',
            'key': 'required-values-list',
            'layoutId': 'aEnrdCpGcdK40BvcZ',
            'name': 'Required Values List',
            'required': True,
            'selectionType': 'single',
            'values': [{'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c5d276777a2d3fa1ba9',
              'name': 'A',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c6112c9ab6f14d8b9fc',
              'name': 'B',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c653e798565fcd505a1',
              'name': 'C',
              'selected': False},
             {'$type': 'Core.Models.Fields.ValuesList.ValuesListValues, Core',
              'id': '58c02c68b8c926c616160991',
              'name': 'D',
              'selected': False}]},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aTgLvvmbKl_ihMnvV',
            'inputType': 'rich',
            'key': 'rich-text',
            'layoutId': 'aT_IZXGN1coDOAyTl',
            'lengthType': 'none',
            'name': 'Rich Text',
            'readOnly': False,
            'required': False,
            'unique': False,
            'visualize': False,
            'visualizeMode': 0},
           {'$type': 'Core.Models.Fields.Reference.ReferenceField, Core',
            'canAdd': True,
            'columns': ['aVtzRCC0CkcEZ2yqH'],
            'controlType': 'select',
            'createLink': False,
            'fieldType': 'reference',
            'helpTextType': 'none',
            'id': 'a4LcM2hleRsT3OO9B',
            'key': 'single-select-reference',
            'layoutId': 'a4fY_fBXLIfylCYiR',
            'name': 'Single select Reference',
            'selectionType': 'single',
            'targetId': 'aWCw4ogmubPkFs8OX'},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aUx8VMjh7BCjTcT9W',
            'inputType': 'text',
            'key': 'default-text',
            'layoutId': 'aVG58zDSp20EAQdim',
            'lengthType': 'none',
            'name': 'SOC Team',
            'readOnly': False,
            'required': False,
            'visualize': False,
            'visualizeMode': 0},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aR8mm1sPlwah7sSRT',
            'inputType': 'telephone',
            'key': 'telephone',
            'layoutId': 'aRSjPeMBSnOBpgc_j',
            'lengthType': 'none',
            'name': 'Telephone',
            'readOnly': False,
            'required': False,
            'visualize': False,
            'visualizeMode': 0},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aKoqsp5xqrYdDd6FO',
            'inputType': 'time',
            'key': 'time',
            'layoutId': 'aL7nWQajXiM7vRGoe',
            'name': 'Time'},
           {'$type': 'Core.Models.Fields.Date.DateField, Core',
            'calculatedDiff': False,
            'defaultValueType': 'none',
            'fieldType': 'date',
            'helpTextType': 'none',
            'id': 'aKAxab7PS8xcp_m7t',
            'inputType': 'timespan',
            'key': 'timespan',
            'layoutId': 'aKUuECcB8_l7Wowh8',
            'name': 'Timespan'},
           {'$type': 'Core.Models.Fields.TrackingField, Core',
            'fieldType': 'tracking',
            'id': 'aVtzRCC0CkcEZ2yqH',
            'key': 'tracking-id',
            'name': 'Tracking Id',
            'prefix': 'AFC-',
            'readOnly': True},
           {'$type': 'Core.Models.Fields.NumericField, Core',
            'fieldType': 'numeric',
            'format': 'none',
            'helpTextType': 'none',
            'id': 'aNLQ1i08Pgyen7RjQ',
            'key': 'unique-numeric',
            'layoutId': 'aNfMgJUv6Xm9TwcHg',
            'name': 'Unique Numeric',
            'step': 1.0,
            'unique': True},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aSPZLTpVYLnhv77gU',
            'inputType': 'text',
            'key': 'unique-text',
            'layoutId': 'aSjV_5JHFCbCbwIEk',
            'lengthType': 'none',
            'name': 'Unique Text',
            'readOnly': False,
            'required': False,
            'unique': True,
            'visualize': False,
            'visualizeMode': 0},
           {'$type': 'Core.Models.Fields.TextField, Core',
            'fieldType': 'text',
            'helpTextType': 'none',
            'id': 'aQVtTotsNDzgkF7Jy',
            'inputType': 'url',
            'key': 'url',
            'layoutId': 'aQpq7QNe44nBR3HtD',
            'lengthType': 'none',
            'name': 'URL',
            'readOnly': False,
            'required': False,
            'visualize': False,
            'visualizeMode': 0}],
          'id': 'aWCw4ogmubPkFs8OX',
          'layout': [{'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aUx8VMjh7BCjTcT9W',
              'helpTextType': 'none',
              'id': 'aVG58zDSp20EAQdim',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aUJFD8l8jTbj4_820',
              'helpTextType': 'none',
              'id': 'aUdBrlEvQKPDmoIbG',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aTgLvvmbKl_ihMnvV',
              'helpTextType': 'none',
              'id': 'aT_IZXGN1coDOAyTl',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aT2Sdho2x3OiIkSn_',
              'helpTextType': 'none',
              'id': 'aTMPHJHpdvCC_YdMF',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aSPZLTpVYLnhv77gU',
              'helpTextType': 'none',
              'id': 'aSjV_5JHFCbCbwIEk',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 3,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aRmg3Fqy9eBhWUnYz',
              'helpTextType': 'none',
              'id': 'aS5chsKjrU_CDIy7E',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 3,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aR8mm1sPlwah7sSRT',
              'helpTextType': 'none',
              'id': 'aRSjPeMBSnOBpgc_j',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 4,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aQVtTotsNDzgkF7Jy',
              'helpTextType': 'none',
              'id': 'aQpq7QNe44nBR3HtD',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 4,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aPs_BavJzWNgLcnCS',
              'helpTextType': 'none',
              'id': 'aQBwqCP5gNBB2Qxli',
              'layoutType': 'field',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 5,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.IntegrationLayout, Core',
              'col': 3,
              'helpTextType': 0,
              'id': 'aPZ2XzQYHfaAeoceC',
              'layoutType': 'integration',
              'name': 'Text Integration',
              'parentId': 'aVa1naiEVtojsEoH1',
              'row': 5,
              'sizex': 2.0,
              'sizey': 0.0,
              'taskId': 'aL369K8_X6gz4'}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'aVa1naiEVtojsEoH1',
            'layoutType': 'section',
            'name': 'Text Section',
            'row': 1,
            'sizex': 1.0,
            'sizey': 0.0},
           {'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aOcCc8yEC6AfZN6yR',
              'helpTextType': 'none',
              'id': 'aOw9FlR_txzAGBHWh',
              'layoutType': 'field',
              'parentId': 'aPF5uMwmaomfx_S4x',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aNzJJvzgoOZfAkmqw',
              'helpTextType': 'none',
              'id': 'aOIFyXTSVFN9sYxPB',
              'layoutType': 'field',
              'parentId': 'aPF5uMwmaomfx_S4x',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aNLQ1i08Pgyen7RjQ',
              'helpTextType': 'none',
              'id': 'aNfMgJUv6Xm9TwcHg',
              'layoutType': 'field',
              'parentId': 'aPF5uMwmaomfx_S4x',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.IntegrationLayout, Core',
              'col': 3,
              'helpTextType': 0,
              'id': 'aN1TO5WMiqA95JHAA',
              'layoutType': 'integration',
              'name': 'Numeric Integration',
              'parentId': 'aPF5uMwmaomfx_S4x',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0,
              'taskId': 'aPnbW3YCXFRSq'}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'aPF5uMwmaomfx_S4x',
            'layoutType': 'section',
            'name': 'Numeric Fields',
            'row': 2,
            'sizex': 1.0,
            'sizey': 0.0},
           {'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aM4dSG32dGld_smUP',
              'helpTextType': 'none',
              'id': 'aMOa5sXpK7Z8hgx2f',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aLRkA24VEZ9dcFRMu',
              'helpTextType': 'none',
              'id': 'aLlgoeZGwPy8J3bw9',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aKoqsp5xqrYdDd6FO',
              'helpTextType': 'none',
              'id': 'aL7nWQajXiM7vRGoe',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aKAxab7PS8xcp_m7t',
              'helpTextType': 'none',
              'id': 'aKUuECcB8_l7Wowh8',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aJY3IN8s3RLcRNR0N',
              'helpTextType': 'none',
              'id': 'aJr_wzddlI978BbZd',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 3,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aIvA09AJfjkc2l5ts',
              'helpTextType': 'none',
              'id': 'aJE6elf5MaY6kZGS7',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 3,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aIHGiwBmH18bf7lmM',
              'helpTextType': 'none',
              'id': 'aIbDMXgXysx6LwwKc',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 4,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aHeNQiDDtJXbGVQer',
              'helpTextType': 'none',
              'id': 'aHyK4Jh_aAL5yJbD6',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 4,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aH0U8UEgUbwast5XL',
              'helpTextType': 'none',
              'id': 'aHKQn5jSBSk5ZhG5b',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 5,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aGNarGG85uKaUFlPq',
              'helpTextType': 'none',
              'id': 'aGhXUskunl85B3vz5',
              'layoutType': 'field',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 5,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.IntegrationLayout, Core',
              'col': 1,
              'helpTextType': 0,
              'id': 'aG3eCemMP2X4nRara',
              'layoutType': 'integration',
              'name': 'Date Integration',
              'parentId': 'aMiWkU1b0zMeOV6bv',
              'row': 6,
              'sizex': 2.0,
              'sizey': 0.0,
              'taskId': 'aNRb2OBBgyC4y'}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'aMiWkU1b0zMeOV6bv',
            'layoutType': 'section',
            'name': 'Date/Time Section',
            'row': 3,
            'sizex': 1.0,
            'sizey': 0.0},
           {'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aF6oGpJ2JU7Zi05Ap',
              'helpTextType': 'none',
              'id': 'aFQkvQnp0Kw4OpFk4',
              'layoutType': 'field',
              'parentId': 'aFkhZ2HaiBja5dQIK',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aETuzbKUvmWZJNl3J',
              'helpTextType': 'none',
              'id': 'aEnrdCpGcdK40BvcZ',
              'layoutType': 'field',
              'parentId': 'aFkhZ2HaiBja5dQIK',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aDr0hNLxX3vYvlPwo',
              'helpTextType': 'none',
              'id': 'aE9yKzqjDvj3cZaV3',
              'layoutType': 'field',
              'parentId': 'aFkhZ2HaiBja5dQIK',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aDD7P9NP8MJYX84pI',
              'helpTextType': 'none',
              'id': 'aDX42lsAqD73DxFNY',
              'layoutType': 'field',
              'parentId': 'aFkhZ2HaiBja5dQIK',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aCaE6wOrkeiY8Vkhn',
              'helpTextType': 'none',
              'id': 'aCuAlXtdRVW2qJvG2',
              'layoutType': 'field',
              'parentId': 'aFkhZ2HaiBja5dQIK',
              'row': 3,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.IntegrationLayout, Core',
              'col': 3,
              'helpTextType': 0,
              'id': 'aCGHTJv52nv2Rha8X',
              'layoutType': 'integration',
              'name': 'Values List Integration',
              'parentId': 'aFkhZ2HaiBja5dQIK',
              'row': 3,
              'sizex': 2.0,
              'sizey': 0.0,
              'taskId': 'a3sd718ybVFOZ'}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'aFkhZ2HaiBja5dQIK',
            'layoutType': 'section',
            'name': 'Value List Section',
            'row': 4,
            'sizex': 1.0,
            'sizey': 0.0},
           {'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aBJRXURlyEVXMG4Sm',
              'helpTextType': 'none',
              'id': 'aBdOB5wXf5J234F11',
              'layoutType': 'field',
              'parentId': 'aBxKpiQJLx6XktPaH',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'aAgYFGTDZWuWydkLG',
              'helpTextType': 'none',
              'id': 'aA_Utsx_GNi1fRuuW',
              'layoutType': 'field',
              'parentId': 'aBxKpiQJLx6XktPaH',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'aA2ey2UgApIWa0PDl',
              'helpTextType': 'none',
              'id': 'aAMbbezRsg61GpZn0',
              'layoutType': 'field',
              'parentId': 'aBxKpiQJLx6XktPaH',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'a9PlfpW7n6hWBO46F',
              'helpTextType': 'none',
              'id': 'a9jiJQ_uTyV0tCEfV',
              'layoutType': 'field',
              'parentId': 'aBxKpiQJLx6XktPaH',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'a8msNbXaOP5Vnljzk',
              'helpTextType': 'none',
              'id': 'a95p1D1M5Fu0UZuX_',
              'layoutType': 'field',
              'parentId': 'aBxKpiQJLx6XktPaH',
              'row': 3,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.IntegrationLayout, Core',
              'col': 3,
              'helpTextType': 0,
              'id': 'a8Svj_2ohYI05xZQU',
              'layoutType': 'integration',
              'name': 'Users/Groups Integration',
              'parentId': 'aBxKpiQJLx6XktPaH',
              'row': 3,
              'sizex': 2.0,
              'sizey': 0.0,
              'taskId': 'aDoxnZOQg9vnS'}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'aBxKpiQJLx6XktPaH',
            'layoutType': 'section',
            'name': 'User/Groups Section',
            'row': 5,
            'sizex': 1.0,
            'sizey': 0.0},
           {'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'a7W4o9aUbztV0W3kj',
              'helpTextType': 'none',
              'id': 'a7q1Rm4GIqg_iKEIz',
              'layoutType': 'field',
              'parentId': 'a88z5NZ1_hUVP8OsE',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.IntegrationLayout, Core',
              'col': 3,
              'helpTextType': 0,
              'id': 'a7C89Y5iv84_JhuBT',
              'layoutType': 'integration',
              'name': 'Attachment Integration',
              'parentId': 'a88z5NZ1_hUVP8OsE',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0,
              'taskId': 'a9PSEg1TCZrmr'}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'a88z5NZ1_hUVP8OsE',
            'layoutType': 'section',
            'name': 'Attachment Section',
            'row': 6,
            'sizex': 1.0,
            'sizey': 0.0},
           {'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'a6FIDidOpZgUEGOVi',
              'helpTextType': 'none',
              'id': 'a6ZEsK7AWQTzw4Z3y',
              'layoutType': 'field',
              'parentId': 'a6tBVwbxDHHUctjdD',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'a5cOwUerQs4Tqe3OC',
              'helpTextType': 'none',
              'id': 'a5wLa68d7iszXSDxS',
              'layoutType': 'field',
              'parentId': 'a6tBVwbxDHHUctjdD',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'a4zVeGgJ29TTS0jGh',
              'helpTextType': 'none',
              'id': 'a5ISHtA4k0Gz8ptpx',
              'layoutType': 'field',
              'parentId': 'a6tBVwbxDHHUctjdD',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 3,
              'fieldId': 'a4LcM2hleRsT3OO9B',
              'helpTextType': 'none',
              'id': 'a4fY_fBXLIfylCYiR',
              'layoutType': 'field',
              'parentId': 'a6tBVwbxDHHUctjdD',
              'row': 2,
              'sizex': 2.0,
              'sizey': 0.0}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'a6tBVwbxDHHUctjdD',
            'layoutType': 'section',
            'name': 'Reference Section',
            'row': 7,
            'sizex': 1.0,
            'sizey': 0.0},
           {'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'a3OmQDERYtSxyxtTQ',
              'helpTextType': 'none',
              'id': 'a3ij3pjDFkGSfm31g',
              'layoutType': 'field',
              'parentId': 'a41fiRCzxb3yMaDaw',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0},
             {'$type': 'Core.Models.Layouts.IntegrationLayout, Core',
              'col': 3,
              'helpTextType': 0,
              'id': 'a34pmbkfs1fSH8ivA',
              'layoutType': 'integration',
              'name': 'Comments Integration',
              'parentId': 'a41fiRCzxb3yMaDaw',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0,
              'taskId': 'a4OmK2DJTh2lz'}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'a41fiRCzxb3yMaDaw',
            'layoutType': 'section',
            'name': 'Comments Section',
            'row': 8,
            'sizex': 1.0,
            'sizey': 0.0},
           {'$type': 'Core.Models.Layouts.SectionLayout, Core',
            'children': [{'$type': 'Core.Models.Layouts.FieldLayout, Core',
              'col': 1,
              'fieldId': 'a27zqmHLmTFxBiDEP',
              'helpTextType': 'none',
              'id': 'a2RwUNm7TK3RtWNnf',
              'layoutType': 'field',
              'parentId': 'a2lt7_FuAArxaKYLv',
              'row': 1,
              'sizex': 2.0,
              'sizey': 0.0}],
            'col': 1,
            'collapsed': True,
            'helpTextType': 'none',
            'id': 'a2lt7_FuAArxaKYLv',
            'layoutType': 'section',
            'name': 'History Section',
            'row': 9,
            'sizex': 1.0,
            'sizey': 0.0}],
          'maxTrackingId': 11.0,
          'modifiedByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
           'id': 'a53r5Mitu5NnbuzdH',
           'name': 'admin'},
          'modifiedDate': '2017-12-20T18:58:12.113Z',
          'name': 'All Fields Combo',
          'permissions': {'$type': 'Core.Models.Security.PermissionMatrix, Core'},
          'timeTrackingEnabled': False,
          'trackingFieldId': 'aVtzRCC0CkcEZ2yqH',
          'workspaces': ['a3GC1swWXle3KLc6_']})

@pytest.fixture
def mock_record_all_fields(mock_app_all_fields):
    return Record(mock_app_all_fields, {'$type': 'Core.Models.Record.Record, Core',
         'actionsExecuted': {'$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Object, mscorlib]], mscorlib'},
         'allowed': [],
         'applicationId': 'aWCw4ogmubPkFs8OX',
         'applicationRevision': 4.0,
         'coeditSession': {'$type': 'Core.Models.Record.CoeditRecord, Core',
          'applicationId': 'aWCw4ogmubPkFs8OX',
          'createdDate': '2017-12-21T20:35:53.246Z',
          'disabled': False,
          'editors': [{'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
            'id': 'a53r5Mitu5NnbuzdH',
            'name': 'admin'}],
          'id': 'aBOiyZ1wHJ8rK93MG',
          'modifiedDate': '2017-12-21T20:35:53.246Z',
          'recordId': 'aRJWwDZDFdNspCR0',
          'values': {'$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Object, mscorlib]], mscorlib'}},
         'comments': {'$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Collections.Generic.List`1[[Core.Models.Record.Comments, Core]], mscorlib]], mscorlib'},
         'createdByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
          'id': 'a53r5Mitu5NnbuzdH',
          'name': 'admin'},
         'createdDate': '2017-12-12T17:07:17.878Z',
         'disabled': False,
         'id': 'aRJWwDZDFdNspCR0',
         'infiniteLoopFlag': False,
         'isHangfireCreatedAndUnpersisted': False,
         'isNew': False,
         'linkedData': {'$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Object, mscorlib]], mscorlib',
          'aIHGiwBmH18bf7lmM': {'$type': 'Core.Models.Record.DateTimeParsed, Core',
           'd': 20,
           'dow': 3,
           'h': 18,
           'm': 55,
           'mm': 12,
           'q': 4,
           'w': 51,
           'y': 2017},
          'aIvA09AJfjkc2l5ts': {'$type': 'Core.Models.Record.DateTimeParsed, Core',
           'd': 12,
           'dow': 2,
           'h': 17,
           'm': 7,
           'mm': 12,
           'q': 4,
           'w': 50,
           'y': 2017},
          'aLRkA24VEZ9dcFRMu': {'$type': 'Core.Models.Record.DateTimeParsed, Core',
           'd': 12,
           'dow': 2,
           'h': 0,
           'm': 0,
           'mm': 12,
           'q': 4,
           'w': 50,
           'y': 2017}},
         'locked': False,
         'modifiedByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
          'id': 'a53r5Mitu5NnbuzdH',
          'name': 'admin'},
         'modifiedDate': '2017-12-20T18:55:22.774Z',
         'name': 'AFC-8',
         'sessionTimeSpent': 0,
         'timeTrackingEnabled': True,
         'totalTimeSpent': 0,
         'trackingFull': 'AFC-8',
         'trackingId': 8.0,
         'values': {'$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Object, mscorlib]], mscorlib',
          'a27zqmHLmTFxBiDEP': None,
          'a3OmQDERYtSxyxtTQ': None,
          'a7W4o9aUbztV0W3kj': [],
          'a8msNbXaOP5Vnljzk': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
           'id': 'a53r5Mitu5NnbuzdH',
           'name': 'admin'},
          'a9PlfpW7n6hWBO46F': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
           'id': 'a53r5Mitu5NnbuzdH',
           'name': 'admin'},
          'aA2ey2UgApIWa0PDl': [],
          'aAgYFGTDZWuWydkLG': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core',
           'id': '5a146b8fb6f94719740bb405',
           'name': 'Krista Burton'},
          'aBJRXURlyEVXMG4Sm': None,
          'aCaE6wOrkeiY8Vkhn': [],
          'aDD7P9NP8MJYX84pI': [],
          'aDr0hNLxX3vYvlPwo': None,
          'aETuzbKUvmWZJNl3J': {'$type': 'Core.Models.Record.ValueSelection, Core',
           'id': '58c02c6112c9ab6f14d8b9fc',
           'value': 'B'},
          'aF6oGpJ2JU7Zi05Ap': None,
          'aGNarGG85uKaUFlPq': None,
          'aH0U8UEgUbwast5XL': None,
          'aHeNQiDDtJXbGVQer': None,
          'aIHGiwBmH18bf7lmM': '2017-12-20T18:55:22.657000Z',
          'aIvA09AJfjkc2l5ts': '2017-12-12T17:07:38.167000Z',
          'aJY3IN8s3RLcRNR0N': None,
          'aKAxab7PS8xcp_m7t': None,
          'aKoqsp5xqrYdDd6FO': None,
          'aLRkA24VEZ9dcFRMu': '2017-12-12T00:00:00.000000Z',
          'aM4dSG32dGld_smUP': None,
          'aNLQ1i08Pgyen7RjQ': None,
          'aNzJJvzgoOZfAkmqw': 2,
          'aOcCc8yEC6AfZN6yR': None,
          'aPs_BavJzWNgLcnCS': '',
          'aQVtTotsNDzgkF7Jy': '',
          'aR8mm1sPlwah7sSRT': '',
          'aRmg3Fqy9eBhWUnYz': '',
          'aSPZLTpVYLnhv77gU': '',
          'aT2Sdho2x3OiIkSn_': '',
          'aTgLvvmbKl_ihMnvV': '',
          'aUJFD8l8jTbj4_820': 'two',
          'aUx8VMjh7BCjTcT9W': 'Team A',
          'aVtzRCC0CkcEZ2yqH': 'AFC-8'},
         'visualizations': {'$type': 'System.Collections.Generic.Dictionary`2[[System.String, mscorlib],[System.Collections.Generic.List`1[[Core.Models.Record.VisualizationData, Core]], mscorlib]], mscorlib'}}
         )

@pytest.fixture
def random_mock_user(mock_swimlane):
    idx = random.randint(1, 10000)
    return User(mock_swimlane, {
        '$type': 'Core.Models.Identity.ApplicationUser, Core',
        'active': False,
        'createdByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core'},
        'createdDate': '2017-03-31T09:10:52.717Z',
        'disabled': False,
        'displayName': 'admin',
        'groups': [],
        'id': idx,
        'name': 'admin{}'.format(idx),
        'isAdmin': True,
        'isMe': False,
        'lastLogin': '2017-04-27T15:45:43.066Z',
        'lastPasswordChangedDate': '2017-03-31T09:10:52.536Z',
        'modifiedByUser': {'$type': 'Core.Models.Utilities.UserGroupSelection, Core'},
        'modifiedDate': '2017-03-31T09:10:52.76Z',
        'passwordComplexityScore': 3,
        'passwordHash': 'AQAAAAEAACcQAAAAEESp9LR0jN3qPF2fw5qWdyceYxbeBbawMW5AFt31dA5n3xX16MFJWsU/j82heenFww==',
        'passwordResetRequired': False,
        'roles': [],
        'userName': 'admin'})
