""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.iam.schemas import apis


class IAMClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(IAMClient, self).__init__(config, transport, middleware, logger)

    def create_project(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateProject - 创建项目

        **Request**

        - **ProjectName** (str) - (Required) 项目名称，不得与现有项目重名

        **Response**

        - **ProjectId** (str) - 所创建项目的Id

        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.CreateProjectRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateProject", d, **kwargs)
        return apis.CreateProjectResponseSchema().loads(resp)

    def delete_project(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteProject - 删除项目

        **Request**

        - **ProjectID** (str) - (Required) 项目ID

        **Response**

        - **Message** (str) - 错误消息

        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.DeleteProjectRequestSchema().dumps(d)

        resp = self.invoke("DeleteProject", d, **kwargs)
        return apis.DeleteProjectResponseSchema().loads(resp)
