""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.tidb.schemas import apis


class TiDBClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(TiDBClient, self).__init__(config, transport, middleware, logger)

    def create_ti_db_service(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateTiDBService - 创建TiDB服务

        **Request**

        - **ProjectId** (str) - (Config) 项目 ID
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Name** (str) - (Required) 服务名称， 长度不超过64
        - **Password** (str) - (Required) 服务root账号的密码， 长度不超过32
        - **SubnetId** (str) - (Required) 子网 ID
        - **VPCId** (str) - (Required) VPC ID
        - **DTType** (str) - 容灾类型：10:同可用区，20:跨可用区，默认是同可用区
        - **Ip** (str) - ipv4
        - **Port** (str) - 端口
        - **TikvMemoryHardTh** (str) - 实例类型:   0: 旗舰版，30: 体验版，60: 轻量版

        **Response**

        - **Data** (dict) - 见 **ServiceID** 模型定义
        - **Message** (str) - 返回信息
        - **ServiceId** (str) - 服务ID

        **Response Model**

        **ServiceID**
        - **Id** (str) - 服务ID


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateTiDBServiceRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateTiDBService", d, **kwargs)
        return apis.CreateTiDBServiceResponseSchema().loads(resp)

    def delete_ti_db_service(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteTiDBService - 删除一个服务

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Id** (str) - (Required) 资源ID

        **Response**

        - **Message** (str) - 返回信息
        - **ServiceId** (str) - ServiceId

        """
        # build request
        d = {
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteTiDBServiceRequestSchema().dumps(d)

        resp = self.invoke("DeleteTiDBService", d, **kwargs)
        return apis.DeleteTiDBServiceResponseSchema().loads(resp)

    def set_ti_db_config(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """SetTiDBConfig - 设置TiDB服务实例参数

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Id** (str) - (Required) 资源Id
        - **Configs** (list) - 见 **SetTiDBConfigParamConfigs** 模型定义

        **Response**

        - **ServiceId** (str) - ServiceId

        **Request Model**

        **SetTiDBConfigParamConfigs**
        - **Name** (str) - 修改的参数名: proxysql_mysql-max_connections:类型：string, 描述:  所有用户总共的最大连接数 。proxysql_max_connections:  类型：string, 描述:  每个用户的最大连接数。tidb_gc:  类型：string, 描述:   tikv_gc_life_time。
        - **Value** (str) - 对应修改的参数值: string


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.SetTiDBConfigRequestSchema().dumps(d)

        resp = self.invoke("SetTiDBConfig", d, **kwargs)
        return apis.SetTiDBConfigResponseSchema().loads(resp)
