"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToSagemakerEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
/**
 * @summary The LambdaToSagemakerEndpoint class.
 */
class LambdaToSagemakerEndpoint extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToSagemakerEndpoint class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a scope-unique id.
     * @param {LambdaToSagemakerEndpointProps} props - user provided props for the construct.
     * @since 1.87.1
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        defaults.CheckSagemakerProps(props);
        if (props.deployVpc || props.existingVpc) {
            // create the VPC
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
            // Add S3 VPC Gateway Endpoint, required by SageMaker to access Models artifacts via AWS private network
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.S3);
            // Add SAGEMAKER_RUNTIME VPC Interface Endpoint, required by the lambda function to invoke the SageMaker endpoint
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SAGEMAKER_RUNTIME);
        }
        // Build SageMaker Endpoint (inclduing SageMaker's Endpoint Configuration and Model)
        const buildSagemakerEndpointResponse = defaults.BuildSagemakerEndpoint(this, id, {
            ...props,
            vpc: this.vpc,
        });
        this.sagemakerEndpoint = buildSagemakerEndpointResponse.endpoint;
        this.sagemakerEndpointConfig = buildSagemakerEndpointResponse.endpointConfig;
        this.sagemakerModel = buildSagemakerEndpointResponse.model;
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc,
        });
        // Configure environment variables
        const sagemakerEnvironmentVariableName = props.sagemakerEnvironmentVariableName || 'SAGEMAKER_ENDPOINT_NAME';
        this.lambdaFunction.addEnvironment(sagemakerEnvironmentVariableName, this.sagemakerEndpoint.attrEndpointName);
        // Add permission to invoke the SageMaker endpoint
        this.lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['sagemaker:InvokeEndpoint'],
            resources: [this.sagemakerEndpoint.ref],
        }));
    }
}
exports.LambdaToSagemakerEndpoint = LambdaToSagemakerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
LambdaToSagemakerEndpoint[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-sagemakerendpoint.LambdaToSagemakerEndpoint", version: "2.97.0" };
//# sourceMappingURL=data:application/json;base64,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