#!/bin/python
"""
(c) 2019 Momsen Reincke <mail@momsenreincke.de> and Jakob Kreye <jakob.kreye@charite.de>

This file has been automatically generated using createPrimerDB.py
    
It defines the five dictionaries primer_IGHV, primer_IGHJ, primer_IGLV, primer_IGKV, primer_IGKJ. They contain the primer corresponding to certain IgG genes. 
    
    Example:
    The 5' primer corresponding to IGH1-2*02 can be found in the dictionary primer_IGHV under the key '1-2*02'
    (the primer has the name H5 2/3-1). Analogously, the 3' primer corresponding to IGK1-9*01 can be found 
    in the dictionary primer_IGKJ under the key 1-9*01 (the primer has the name K5 3-2)
"""

primer_IGHV = {
    "N/A": "",
    "1-2*01": "H5 2/3-1",
    "1-2*02": "H5 2/3-1",
    "1-2*03": "H5 2/3-1",
    "1-2*04": "H5 2/3-1",
    "1-2*05": "H5 2/3-1",
    "1-3*01": "H5 2/3-1",
    "1-3*02": "H5 3-7",
    "1-8*01": "H5 2/3-1",
    "1-8*02": "H5 2/3-1",
    "1-12*01": "Pseudogen - kein Primer",
    "1-12*02": "Pseudogen - kein Primer",
    "1-14": "Pseudogen - kein Primer",
    "1-17*01": "Pseudogen - kein Primer",
    "1-17*02": "Pseudogen - kein Primer",
    "1-18*01": "H5 3-7",
    "1-18*02": "H5 3-7",
    "1-18*03": "H5 3-7",
    "1-18*04": "H5 3-7",
    "1-24*01": "H5 3-8",
    "1-38-4*01": "ORF - kein Primer",
    "1-45*01": "H5 3-17",
    "1-45*02": "H5 3-17",
    "1-45*03": "H5 3-17",
    "1-46*01": "H5 2/3-1",
    "1-46*02": "H5 2/3-1",
    "1-46*03": "H5 2/3-1",
    "1-58*01": "H5 3-18",
    "1-58*02": "H5 3-18",
    "1-67*01": "Pseudogen - kein Primer",
    "1-67*02": "Pseudogen - kein Primer",
    "1-68": "Pseudogen - kein Primer",
    "1-69*01": "H5 2/3-1",
    "1-69*02": "H5 2/3-1",
    "1-69*03": "H5 2/3-1",
    "1-69*04": "H5 2/3-1",
    "1-69*05": "H5 2/3-1",
    "1-69*06": "H5 2/3-1",
    "1-69*07": "Anfang deletiert - kein Primer",
    "1-69*08": "H5 2/3-1",
    "1-69*09": "H5 2/3-1",
    "1-69*10": "H5 2/3-1",
    "1-69*11": "H5 2/3-1",
    "1-69*12": "H5 2/3-1",
    "1-69*13": "H5 2/3-1",
    "1-69*14": "H5 2/3-1",
    "1-69D*01": "H5 2/3-1",
    "1-69-2*01": "H5 2/3-1",
    "1-69-2*02": "H5 2/3-1",
    "1-NL1": "Pseudogen - kein Primer",
    "2-5*01": "H5 3-19",
    "2-5*02": "H5 3-19",
    "2-5*03": "H5 3-19",
    "2-5*04": "H5 3-19",
    "2-5*05": "H5 3-19",
    "2-5*06": "H5 3-19",
    "2-5*07": "H5 3-19",
    "2-5*08": "H5 3-20",
    "2-5*09": "H5 3-20",
    "2-10*01": "Pseudogen - kein Primer",
    "2-26*01": "H5 3-20",
    "2-70*01": "H5 3-21",
    "2-70*02": "H5 3-21",
    "2-70*03": "H5 3-20",
    "2-70*04": "H5 3-20",
    "2-70*05": "Anfang deletiert - kein Primer",
    "2-70*06": "H5 3-20",
    "2-70*07": "H5 3-21",
    "2-70*08": "H5 3-21",
    "2-70*09": "ORF - kein Primer",
    "2-70*10": "H5 3-20",
    "2-70*11": "H5 3-22",
    "2-70*12": "H5 3-19",
    "2-70*13": "H5 3-21",
    "2-70D*04": "H5 3-20",
    "2-70D*14": "H5 3-20",
    "3-6*01": "Pseudogen - kein Primer",
    "3-7*01": "H5 2/3-3",
    "3-7*02": "H5 2/3-3",
    "3-7*03": "H5 2/3-3",
    "3-9*01": "H5 3-9",
    "3-9*02": "H5 3-9",
    "3-9*03": "H5 3-9",
    "3-11*01": "H5 3-10",
    "3-11*02": "Pseudogen - kein Primer",
    "3-11*03": "H5 3-23",
    "3-11*04": "H5 3-10",
    "3-11*05": "H5 3-10",
    "3-11*06": "H5 3-10",
    "3-13*01": "H5 2/3-3",
    "3-13*02": "H5 3-24",
    "3-13*03": "H5 2/3-3",
    "3-13*04": "H5 2/3-3",
    "3-13*05": "H5 2/3-3",
    "3-15*01": "H5 2/3-3",
    "3-15*02": "H5 2/3-3",
    "3-15*03": "H5 2/3-3",
    "3-15*04": "H5 2/3-3",
    "3-15*05": "H5 2/3-3",
    "3-15*06": "H5 2/3-3",
    "3-15*07": "H5 2/3-3",
    "3-15*08": "H5 2/3-3",
    "3-16*01": "ORF - kein Primer",
    "3-16*02": "ORF - kein Primer",
    "3-19*01": "Pseudogen - kein Primer",
    "3-20*01": "H5 2/3-3",
    "3-20*02": "ORF - kein Primer",
    "3-21*01": "H5 2/3-3",
    "3-21*02": "H5 2/3-3",
    "3-21*03": "H5 2/3-3",
    "3-21*04": "H5 2/3-3",
    "3-22*01": "Pseudogen - kein Primer",
    "3-22*02": "Pseudogen - kein Primer",
    "3-23*01": "H5 2/3-4",
    "3-23*02": "H5 2/3-4",
    "3-23*03": "H5 2/3-4",
    "3-23*04": "H5 2/3-3",
    "3-23*05": "H5 2/3-4",
    "3-23D*01": "H5 2/3-4",
    "3-25*01": "Pseudogen - kein Primer",
    "3-25*02": "Pseudogen - kein Primer",
    "3-25*03": "Pseudogen - kein Primer",
    "3-25*04": "ORF - kein Primer",
    "3-25*05": "Pseudogen - kein Primer",
    "3-29*01": "Pseudogen - kein Primer",
    "3-30*01": "H5 3-10",
    "3-30*02": "H5 3-10",
    "3-30*03": "H5 3-10",
    "3-30*04": "H5 3-10",
    "3-30*05": "H5 3-10",
    "3-30*06": "H5 3-10",
    "3-30*07": "H5 3-10",
    "3-30*08": "kein Primer",
    "3-30*09": "H5 3-10",
    "3-30*10": "H5 3-10",
    "3-30*11": "H5 3-10",
    "3-30*12": "H5 3-10",
    "3-30*13": "H5 3-10",
    "3-30*14": "H5 3-10",
    "3-30*15": "H5 3-10",
    "3-30*16": "H5 3-10",
    "3-30*17": "H5 3-10",
    "3-30*18": "H5 3-10",
    "3-30*19": "H5 3-10",
    "3-30-2*01": "Pseudogen - kein Primer",
    "3-30-3*01": "H5 3-10",
    "3-30-3*02": "H5 3-10",
    "3-30-3*03": "H5 3-10",
    "3-30-5*01": "keine Sequenz in IMGT - kein Primer",
    "3-30-5*02": "keine Sequenz in IMGT - kein Primer",
    "3-30-22*01": "Pseudogen - kein Primer",
    "3-30-33*01": "Pseudogen - kein Primer",
    "3-30-42*01": "Pseudogen - kein Primer",
    "3-30-52*01": "Pseudogen - kein Primer",
    "3-32*01": "Pseudogen - kein Primer",
    "3-33*01": "H5 3-10",
    "3-33*02": "kein Primer",
    "3-33*03": "H5 3-10",
    "3-33*04": "H5 3-10",
    "3-33*05": "H5 3-10",
    "3-33*06": "H5 3-10",
    "3-33-2*01": "Pseudogen - kein Primer",
    "3-35*01": "ORF - kein Primer",
    "3-36*01": "Pseudogen - kein Primer",
    "3-36*02": "Pseudogen - kein Primer",
    "3-36*03": "Pseudogen - kein Primer",
    "3-37*01": "Pseudogen - kein Primer",
    "3-37*02": "Pseudogen - kein Primer",
    "3-38*01": "ORF - kein Primer",
    "3-38*02": "ORF - kein Primer",
    "3-38*03": "ORF - kein Primer",
    "3-38-3*01": "ORF - kein Primer",
    "3-41*01": "Pseudogen - kein Primer",
    "3-42*01": "Pseudogen - kein Primer",
    "3-42*02": "Pseudogen - kein Primer",
    "3-42*03": "Pseudogen - kein Primer",
    "3-42D*01": "Pseudogen - kein Primer",
    "3-43*01": "H5 3-9",
    "3-43*02": "H5 3-9",
    "3-43D*01": "H5 3-9",
    "3-47*01": "Pseudogen - kein Primer",
    "3-47*02": "Pseudogen - kein Primer",
    "3-47*03": "Pseudogen - kein Primer",
    "3-48*01": "H5 2/3-3",
    "3-48*02": "H5 2/3-3",
    "3-48*03": "H5 2/3-3",
    "3-48*04": "H5 2/3-3",
    "3-49*01": "H5 2/3-3",
    "3-49*02": "H5 2/3-3",
    "3-49*03": "H5 2/3-3",
    "3-49*04": "H5 2/3-3",
    "3-49*05": "H5 2/3-3",
    "3-50*01": "Pseudogen - kein Primer",
    "3-52*01": "Pseudogen - kein Primer",
    "3-52*02": "Pseudogen - kein Primer",
    "3-52*03": "Pseudogen - kein Primer",
    "3-53*01": "H5 2/3-3",
    "3-53*02": "H5 2/3-3",
    "3-53*03": "H5 2/3-3",
    "3-53*04": "H5 2/3-3",
    "3-54*01": "Pseudogen - kein Primer",
    "3-54*02": "Pseudogen - kein Primer",
    "3-54*03": "Pseudogen - kein Primer",
    "3-54*04": "Pseudogen - kein Primer",
    "3-57*01": "Pseudogen - kein Primer",
    "3-57*02": "Pseudogen - kein Primer",
    "3-60*01": "Pseudogen - kein Primer",
    "3-62*01": "Pseudogen - kein Primer",
    "3-62*02": "Pseudogen - kein Primer",
    "3-63*01": "Pseudogen - kein Primer",
    "3-63*02": "Pseudogen - kein Primer",
    "3-64*01": "H5 2/3-3",
    "3-64*02": "H5 2/3-3",
    "3-64*03": "H5 2/3-3",
    "3-64*04": "H5 3-10",
    "3-64*05": "H5 2/3-3",
    "3-64D*06": "H5 2/3-3",
    "3-65*01": "Pseudogen - kein Primer",
    "3-65*02": "Pseudogen - kein Primer",
    "3-65*03": "Pseudogen - kein Primer",
    "3-66*01": "H5 2/3-3",
    "3-66*02": "H5 2/3-3",
    "3-66*03": "H5 2/3-3",
    "3-66*04": "H5 2/3-3",
    "3-69-1*01": "Pseudogen - kein Primer",
    "3-69-1*02": "Pseudogen - kein Primer",
    "3-71*01": "Pseudogen - kein Primer",
    "3-71*02": "Pseudogen - kein Primer",
    "3-71*03": "Pseudogen - kein Primer",
    "3-72*01": "H5 2/3-3",
    "3-72*02": "Anfang deletiert - kein Primer",
    "3-73*01": "H5 2/3-3",
    "3-73*02": "H5 2/3-3",
    "3-74*01": "H5 2/3-3",
    "3-74*02": "H5 2/3-3",
    "3-74*03": "H5 2/3-3",
    "3-75*01": "Pseudogen - kein Primer",
    "3-76*01": "Pseudogen - kein Primer",
    "3-76*02": "Pseudogen - kein Primer",
    "3-79*01": "Pseudogen - kein Primer",
    "3-NL1*01": "H5 3-10",
    "4-4*01": "H5 2/3-5",
    "4-4*02": "H5 2/3-5",
    "4-4*03": "H5 2/3-5",
    "4-4*04": "H5 2/3-5",
    "4-4*05": "H5 2/3-5",
    "4-4*06": "H5 2/3-5",
    "4-4*07": "H5 2/3-5",
    "4-4*08": "H5 2/3-5",
    "4-28*01": "H5 2/3-5",
    "4-28*02": "H5 2/3-5",
    "4-28*03": "H5 2/3-5",
    "4-28*04": "H5 2/3-5",
    "4-28*05": "H5 2/3-5",
    "4-28*06": "kein Primer",
    "4-28*07": "kein Primer",
    "4-30-1*01": "keine Sequenz in IMGT - kein Primer",
    "4-30-2*01": "H5 3-11",
    "4-30-2*02": "H5 3-11",
    "4-30-2*03": "H5 3-11",
    "4-30-2*04": "H5 3-11",
    "4-30-2*05": "H5 3-11",
    "4-30-2*06": "H5 3-11",
    "4-30-4*01": "H5 2/3-5",
    "4-30-4*02": "H5 2/3-5",
    "4-30-4*03": "H5 2/3-5",
    "4-30-4*04": "kein Primer",
    "4-30-4*05": "Anfang deletiert - kein Primer",
    "4-30-4*06": "Anfang deletiert - kein Primer",
    "4-30-4*07": "H5 2/3-5",
    "4-31*01": "H5 2/3-5",
    "4-31*02": "H5 2/3-5",
    "4-31*03": "H5 2/3-5",
    "4-31*04": "kein Primer",
    "4-31*05": "H5 2/3-5",
    "4-31*06": "H5 2/3-5",
    "4-31*07": "H5 2/3-5",
    "4-31*08": "H5 2/3-5",
    "4-31*09": "H5 2/3-5",
    "4-31*10": "H5 2/3-5",
    "4-34*01": "H5 2/3-6",
    "4-34*02": "kein Primer",
    "4-34*03": "H5 2/3-6",
    "4-34*04": "H5 2/3-6",
    "4-34*05": "H5 2/3-6",
    "4-34*06": "H5 2/3-6",
    "4-34*07": "H5 2/3-6",
    "4-34*08": "H5 2/3-6",
    "4-34*09": "H5 2/3-5",
    "4-34*10": "H5 2/3-5",
    "4-34*11": "H5 2/3-6",
    "4-34*12": "H5 2/3-6",
    "4-34*13": "Anfang deletiert - kein Primer",
    "4-38-2*01": "H5 2/3-5",
    "4-38-2*02": "H5 2/3-5",
    "4-39*01": "H5 3-11",
    "4-39*02": "H5 3-11",
    "4-39*03": "H5 3-11",
    "4-39*04": "Anfang deletiert - kein Primer",
    "4-39*05": "H5 3-11",
    "4-39*06": "kein Primer",
    "4-39*07": "H5 3-11",
    "4-55*01": "Pseudogen - kein Primer",
    "4-55*02": "Pseudogen - kein Primer",
    "4-55*03": "Pseudogen - kein Primer",
    "4-55*04": "Pseudogen - kein Primer",
    "4-55*05": "Pseudogen - kein Primer",
    "4-55*06": "Pseudogen - kein Primer",
    "4-55*07": "Pseudogen - kein Primer",
    "4-55*08": "Pseudogen - kein Primer",
    "4-55*09": "Pseudogen - kein Primer",
    "4-59*01": "H5 2/3-5",
    "4-59*02": "H5 2/3-5",
    "4-59*03": "H5 2/3-5",
    "4-59*04": "H5 2/3-5",
    "4-59*05": "H5 2/3-5",
    "4-59*06": "H5 2/3-5",
    "4-59*07": "H5 2/3-5",
    "4-59*08": "H5 2/3-5",
    "4-59*09": "Anfang deletiert - kein Primer",
    "4-59*10": "H5 2/3-6",
    "4-61*01": "H5 2/3-5",
    "4-61*02": "H5 2/3-5",
    "4-61*03": "H5 2/3-5",
    "4-61*04": "H5 2/3-5",
    "4-61*05": "H5 3-11",
    "4-61*06": "ORF - kein Primer",
    "4-61*07": "Anfang deletiert - kein Primer",
    "4-61*08": "H5 2/3-5",
    "4-80*01": "Pseudogen - kein Primer",
    "5-10-1*01": "H5 3-14",
    "5-10-1*02": "H5 3-14",
    "5-10-1*03": "H5 3-14",
    "5-10-1*04": "H5 3-14",
    "5-51*01": "H5 2/3-2",
    "5-51*02": "H5 2/3-2",
    "5-51*03": "H5 2/3-2",
    "5-51*04": "H5 2/3-2",
    "5-51*05": "Anfang deletiert - kein Primer",
    "5-78*01": "Pseudogen - kein Primer",
    "5-78*02": "Pseudogen - kein Primer",
    "6-1*01": "H5 3-12",
    "6-1*02": "H5 3-12",
    "7-4-1*01": "H5 3-13",
    "7-4-1*02": "H5 3-13",
    "7-4-1*03": "H5 3-13",
    "7-4-1*04": "H5 3-13",
    "7-4-1*05": "H5 3-13",
    "7-27*01": "Pseudogen - kein Primer",
    "7-34-1*01": "kein Primer",
    "7-34-1*02": "kein Primer",
    "7-40*01": "keine Sequenz in IMGT - kein Primer",
    "7-40*02": "keine Sequenz in IMGT - kein Primer",
    "7-40*03": "keine Sequenz in IMGT - kein Primer",
    "7-40*04": "keine Sequenz in IMGT - kein Primer",
    "7-40D*01": "Pseudogen - kein Primer",
    "7-56*01": "Pseudogen - kein Primer",
    "7-56*02": "Pseudogen - kein Primer",
    "7-77*01": "unclear Function - kein Primer",
    "7-81*01": "ORF - kein Primer",
    "7-NL1*01": "Pseudogen - kein Primer",
    "7-NL1*02": "Pseudogen - kein Primer",
    "7-NL1*03": "Pseudogen - kein Primer",
    "7-NL1*04": "Pseudogen - kein Primer",
    "7-NL1*05": "Pseudogen - kein Primer",
}
primer_IGHJ = {
    "N/A": "",
    "1*01": "H3 3-1",
    "1P*01": "Pseudogen - kein Primer",
    "1*02": "H3 3-1",
    "2*01": "H3 3-1",
    "2P*01": "Pseudogen - kein Primer",
    "2*02": "H3 3-1",
    "3*01": "H3 3-2",
    "3*02": "H3 3-2",
    "4*01": "H3 3-1",
    "4*02": "H3 3-1",
    "4*03": "H3 3-1",
    "5*01": "H3 3-1",
    "5*02": "H3 3-1",
    "3P*01": "Pseudogen - kein Primer",
    "3P*02": "Pseudogen - kein Primer",
    "6*01": "H3 3-3",
    "6*02": "H3 3-3",
    "6*03": "H3 3-3",
    "6*04": "H3 3-3",
}
primer_IGKV = {
    "N/A": "",
    "1-5*01": "K5 3-1",
    "1-5*02": "K5 3-1",
    "1-5*03": "K5 3-1",
    "1-6*01": "kein Primer",
    "1-6*02": "kein Primer",
    "1-8*01": "K5 3-3",
    "1-9*01": "K5 3-2",
    "1-12*01": "K5 3-1",
    "1-12*02": "K5 3-1",
    "1-13*01": "Pseudogen - kein Primer",
    "1-13*02": "K5 3-12",
    "1-16*01": "K5 3-1",
    "1-16*02": "K5 3-1",
    "1-17*01": "K5 3-1",
    "1-17*02": "K5 3-1",
    "1-17*03": "K5 3-1",
    "1-22*01": "Pseudogen - kein Primer",
    "1-27*01": "K5 3-1",
    "1-32*01": "Pseudogen - kein Primer",
    "1-33*01": "K5 3-1",
    "1-35*01": "Pseudogen - kein Primer",
    "1-35*02": "Pseudogen - kein Primer",
    "1-37*01": "ORF - kein Primer",
    "1-39*01": "K5 3-1",
    "1-39*02": "Pseudogen - kein Primer",
    "1D-8*01": "K5 3-11",
    "1D-8*02": "kein Primer",
    "1D-8*03": "K5 3-11",
    "1D-12*01": "K5 3-1",
    "1D-12*02": "K5 3-1",
    "1D-13*01": "K5 3-12",
    "1D-13*02": "K5 3-12",
    "1D-16*01": "K5 3-1",
    "1D-16*02": "K5 3-1",
    "1D-17*01": "K5 3-1",
    "1D-22*01": "Pseudogen - kein Primer",
    "1D-27*01": "Pseudogen - kein Primer",
    "1D-32*01": "Pseudogen - kein Primer",
    "1D-33*01": "keine Sequenz in IMGT - kein Primer",
    "1D-35*01": "Pseudogen - kein Primer",
    "1D-35*02": "Pseudogen - kein Primer",
    "1D-37*01": "ORF - kein Primer",
    "1D-39*01": "K5 3-1",
    "1-NL1*01": "K5 3-1",
    "1D-42*01": "ORF - kein Primer",
    "1D-42*02": "ORF - kein Primer",
    "1D-43*01": "keine Sequenz in IMGT - kein Primer",
    "2-4*01": "Pseudogen - kein Primer",
    "2-10*01": "Pseudogen - kein Primer",
    "2-14*01": "Pseudogen - kein Primer",
    "2-18*01": "Pseudogen - kein Primer",
    "2-19*01": "Pseudogen - kein Primer",
    "2-23*01": "Pseudogen - kein Primer",
    "2-24*01": "K5 3-4",
    "2-26*01": "Pseudogen - kein Primer",
    "2-28*01": "K5 3-5",
    "2-29*01": "Pseudogen - kein Primer",
    "2-29*02": "K5 3-4",
    "2-29*03": "K5 3-4",
    "2-30*01": "K5 3-6",
    "2-30*02": "K5 3-6",
    "2-36*01": "Pseudogen - kein Primer",
    "2-38*01": "Pseudogen - kein Primer",
    "2-40*01": "K5 3-4",
    "2-40*02": "K5 3-4",
    "2D-10*01": "Pseudogen - kein Primer",
    "2D-14*01": "Pseudogen - kein Primer",
    "2D-18*01": "Pseudogen - kein Primer",
    "2D-19*01": "Pseudogen - kein Primer",
    "2D-23*01": "Pseudogen - kein Primer",
    "2D-24*01": "ORF - kein Primer",
    "2D-26*01": "kein Primer",
    "2D-26*02": "kein Primer",
    "2D-26*03": "kein Primer",
    "2D-28*01": "K5 3-5",
    "2D-29*01": "K5 3-4",
    "2D-29*02": "K5 3-4",
    "2D-30*01": "K5 3-6",
    "2D-36*01": "Pseudogen - kein Primer",
    "2D-38*01": "Pseudogen - kein Primer",
    "2D-40*01": "K5 3-4",
    "3-7*01": "ORF - kein Primer",
    "3-7*02": "ORF - kein Primer",
    "3-7*03": "ORF - kein Primer",
    "3-7*04": "ORF - kein Primer",
    "3-11*01": "K5 3-7",
    "3-11*02": "K5 3-7",
    "3-15*01": "K5 3-8",
    "3-20*01": "K5 3-9",
    "3-20*02": "K5 3-9",
    "3-25*01": "Pseudogen - kein Primer",
    "3-31*01": "Pseudogen - kein Primer",
    "3-34*01": "Pseudogen - kein Primer",
    "3D-7*01": "kein Primer",
    "3D-11*01": "K5 3-7",
    "3D-11*02": "K5 3-7",
    "3D-11*03": "K5 3-7",
    "3D-15*01": "K5 3-8",
    "3D-15*02": "Pseudogen - kein Primer",
    "3D-15*03": "K5 3-8",
    "3D-20*01": "K5 3-9",
    "3D-20*02": "ORF - kein Primer",
    "3D-25*01": "Pseudogen - kein Primer",
    "3D-31*01": "Pseudogen - kein Primer",
    "3D-31*02": "Pseudogen - kein Primer",
    "3D-34*01": "Pseudogen - kein Primer",
    "4-1*01": "K5 3-10",
    "5-2*01": "kein Primer",
    "6-21*01": "kein Primer",
    "6-21*02": "kein Primer",
    "6D-21*01": "kein Primer",
    "6D-21*02": "kein Primer",
    "6D-41*01": "ORF - kein Primer",
    "7-3*01": "Pseudogen - kein Primer",
}
primer_IGKJ = {
    "N/A": "",
    "1*01": "K3 3-1",
    "2*01": "K3 3-2",
    "2*02": "K3 3-2",
    "2*03": "K3 3-2",
    "2*04": "K3 3-2",
    "3*01": "K3 3-3",
    "4*01": "K3 3-1",
    "4*02": "K3 3-1",
    "5*01": "K3 3-4",
}
primer_IGLV = {
    "N/A": "",
    "1-36*01": "L5 2/3-1",
    "1-40*01": "L5 2/3-1",
    "1-40*02": "kein Primer",
    "1-40*03": "kein Primer",
    "1-41*01": "ORF - kein Primer",
    "1-41*02": "Pseudogen - kein Primer",
    "1-44*01": "L5 2/3-1",
    "1-47*01": "L5 2/3-1",
    "1-47*02": "L5 2/3-1",
    "1-50*01": "ORF - kein Primer",
    "1-51*01": "L5 2/3-1",
    "1-51*02": "L5 2/3-1",
    "1-62*01": "Pseudogen - kein Primer",
    "2-5*01": "Pseudogen - kein Primer",
    "2-5*02": "Pseudogen - kein Primer",
    "2-8*01": "L5 2/3-2",
    "2-8*02": "L5 2/3-2",
    "2-8*03": "Anfang deletiert - kein Primer",
    "2-11*01": "L5 2/3-2",
    "2-11*02": "L5 2/3-2",
    "2-11*03": "Anfang deletiert - kein Primer",
    "2-14*01": "L5 2/3-2",
    "2-14*02": "L5 2/3-2",
    "2-14*03": "Anfang deletiert - kein Primer",
    "2-14*04": "Anfang deletiert - kein Primer",
    "2-18*01": "L5 2/3-2",
    "2-18*02": "L5 2/3-2",
    "2-18*03": "L5 2/3-2",
    "2-18*04": "L5 2/3-2",
    "2-23*01": "L5 2/3-2",
    "2-23*02": "L5 2/3-2",
    "2-23*03": "L5 2/3-2",
    "2-28*01": "Pseudogen - kein Primer",
    "2-33*01": "ORF - kein Primer",
    "2-33*02": "ORF - kein Primer",
    "2-33*03": "ORF - kein Primer",
    "2-34*01": "Pseudogen - kein Primer",
    "2-34*02": "Pseudogen - kein Primer",
    "3-1*01": "L5 2/3-3",
    "3-2*01": "Pseudogen - kein Primer",
    "3-2*02": "Pseudogen - kein Primer",
    "3-4*01": "Pseudogen - kein Primer",
    "3-6*01": "Pseudogen - kein Primer",
    "3-6*02": "Pseudogen - kein Primer",
    "3-7*01": "Pseudogen - kein Primer",
    "3-9*01": "L5 2/3-3",
    "3-9*02": "L5 2/3-3",
    "3-9*03": "Pseudogen - kein Primer",
    "3-10*01": "L5 2/3-3",
    "3-10*02": "L5 2/3-3",
    "3-12*01": "L5 2/3-3",
    "3-12*02": "L5 2/3-3",
    "3-13*01": "Pseudogen - kein Primer",
    "3-15*01": "Pseudogen - kein Primer",
    "3-16*01": "L5 2/3-3",
    "3-17*01": "Pseudogen - kein Primer",
    "3-19*01": "kein Primer",
    "3-21*01": "kein Primer",
    "3-21*02": "L5 2/3-3",
    "3-21*03": "kein Primer",
    "3-22*01": "L5 2/3-3",
    "3-22*02": "Pseudogen - kein Primer",
    "3-24*01": "Pseudogen - kein Primer",
    "3-24*02": "Pseudogen - kein Primer",
    "3-25*01": "kein Primer",
    "3-25*02": "L5 2/3-3",
    "3-25*03": "L5 2/3-3",
    "3-26*01": "Pseudogen - kein Primer",
    "3-27*01": "L5 2/3-3",
    "3-29*01": "Pseudogen - kein Primer",
    "3-30*01": "Pseudogen - kein Primer",
    "3-30*02": "Pseudogen - kein Primer",
    "3-31*01": "Pseudogen - kein Primer",
    "3-31*02": "Pseudogen - kein Primer",
    "3-32*01": "ORF - kein Primer",
    "4-3*01": "kein Primer",
    "4-60*01": "L5 2/3-4",
    "4-60*02": "L5 2/3-4",
    "4-60*03": "L5 2/3-4",
    "4-69*01": "L5 2/3-4",
    "4-69*02": "L5 2/3-4",
    "5-37*01": "L5 2/3-4",
    "5-39*01": "L5 2/3-4",
    "5-39*02": "L5 2/3-4",
    "5-45*01": "kein Primer (cag gct gtg ctg act ca)",
    "5-45*02": "kein Primer (cag gct gtg ctg act ca)",
    "5-45*03": "kein Primer (cag gct gtg ctg act ca)",
    "5-45*04": "kein Primer (cag gct gtg ctg act ca)",
    "5-48*01": "ORF - kein Primer",
    "5-48*02": "Pseudogen - kein Primer",
    "5-52*01": "L5 2/3-4",
    "6-57*01": "L5 2/3-5",
    "6-57*02": "L5 2/3-5",
    "7-35*01": "Pseudogen - kein Primer",
    "7-43*01": "L5 2/3-6",
    "7-46*01": "L5 2/3-6",
    "7-46*02": "L5 2/3-6",
    "7-46*03": "Pseudogen - kein Primer",
    "8-61*01": "L5 2/3-6",
    "8-61*02": "L5 2/3-6",
    "8-61*03": "L5 2/3-6",
    "9-49*01": "L5 2/3-4",
    "9-49*02": "L5 2/3-4",
    "9-49*03": "L5 2/3-4",
    "10-54*01": "kein Primer",
    "10-54*02": "kein Primer",
    "10-54*03": "Pseudogen - kein Primer",
    "10-67*01": "Pseudogen - kein Primer",
    "10-67*02": "Pseudogen - kein Primer",
    "11-55*01": "ORF - kein Primer",
    "11-55*02": "ORF - kein Primer",
    "(I)-20*01": "Pseudogen - kein Primer",
    "(I)-38*01": "Pseudogen - kein Primer",
    "(I)-42*01": "Pseudogen - kein Primer",
    "(I)-56*01": "Pseudogen - kein Primer",
    "(I)-63*01": "Pseudogen - kein Primer",
    "(I)-68*01": "Pseudogen - kein Primer",
    "(I)-70*01": "Pseudogen - kein Primer",
    "(IV)-53*01": "Pseudogen - kein Primer",
    "(IV)-59*01": "Pseudogen - kein Primer",
    "(IV)-64*01": "Pseudogen - kein Primer",
    "(IV)-65*01": "Pseudogen - kein Primer",
    "(IV)-66-1*01": "Pseudogen - kein Primer",
    "(V)-58*01": "Pseudogen - kein Primer",
    "(V)-66*01": "Pseudogen - kein Primer",
    "(VI)-22-1*01": "Pseudogen - kein Primer",
    "(VI)-25-1*01": "Pseudogen - kein Primer",
    "(VII)-41-1*01": "Pseudogen - kein Primer",
}
primer_IGLJ = {
    "N/A": "",
    "1*01": "L3 2/3",
    "2*01": "L3 2/3",
    "3*01": "L3 2/3",
    "3*02": "L3 2/3",
    "4*01": "ORF - kein Primer",
    "5*01": "ORF - kein Primer",
    "5*02": "ORF - kein Primer",
    "6*01": "L3 2/3",
    "7*01": "L3 2/3",
    "7*02": "L3 2/3",
}
