"""
pagesizes.py

This module defines a few common page sizes in PIDDLE units (1/72 inch).
"""
from __future__ import annotations
__all__: list[str] = ['A0', 'A1', 'A2', 'A3', 'A4', 'A5', 'A6', 'B0', 'B1', 'B2', 'B3', 'B4', 'B5', 'B6', 'cm', 'elevenSeventeen', 'inch', 'legal', 'letter']
A0: tuple = (2381.102362204724, 3367.55905511811)
A1: tuple = (3367.55905511811, 1190.551181102362)
A2: tuple = (1190.551181102362, 1683.779527559055)
A3: tuple = (1683.779527559055, 595.275590551181)
A4: tuple = (595.275590551181, 841.8897637795275)
A5: tuple = (420.94488188976374, 595.275590551181)
A6: tuple = (297.6377952755905, 420.94488188976374)
B0: tuple = (2834.6456692913384, 4002.5196850393695)
B1: tuple = (4002.5196850393695, 1417.3228346456692)
B2: tuple = (1417.3228346456692, 2001.2598425196848)
B3: tuple = (2001.2598425196848, 708.6614173228346)
B4: tuple = (708.6614173228346, 1000.6299212598424)
B5: tuple = (500.3149606299212, 708.6614173228346)
B6: tuple = (354.3307086614173, 500.3149606299212)
_BH: float = 1000.6299212598424
_BW: float = 708.6614173228346
_H: float = 841.8897637795275
_W: float = 595.275590551181
cm: float = 28.346456692913385
elevenSeventeen: tuple = (792, 1224)
inch: int = 72
legal: tuple = (612.0, 1224)
letter: tuple = (612.0, 792)
