# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVulnerabilityAuditsResult',
    'AwaitableGetVulnerabilityAuditsResult',
    'get_vulnerability_audits',
    'get_vulnerability_audits_output',
]

@pulumi.output_type
class GetVulnerabilityAuditsResult:
    """
    A collection of values returned by getVulnerabilityAudits.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, is_success=None, knowledge_base_id=None, state=None, vulnerability_audit_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_success and not isinstance(is_success, bool):
            raise TypeError("Expected argument 'is_success' to be a bool")
        pulumi.set(__self__, "is_success", is_success)
        if knowledge_base_id and not isinstance(knowledge_base_id, str):
            raise TypeError("Expected argument 'knowledge_base_id' to be a str")
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vulnerability_audit_collections and not isinstance(vulnerability_audit_collections, list):
            raise TypeError("Expected argument 'vulnerability_audit_collections' to be a list")
        pulumi.set(__self__, "vulnerability_audit_collections", vulnerability_audit_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the compartment associated with the Vulnerability Audit.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the Vulnerability Audit.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVulnerabilityAuditsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSuccess")
    def is_success(self) -> Optional[bool]:
        """
        Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.
        """
        return pulumi.get(self, "is_success")

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> Optional[str]:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Knowledge Base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the Vulnerability Audit.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vulnerabilityAuditCollections")
    def vulnerability_audit_collections(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionResult']:
        """
        The list of vulnerability_audit_collection.
        """
        return pulumi.get(self, "vulnerability_audit_collections")


class AwaitableGetVulnerabilityAuditsResult(GetVulnerabilityAuditsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityAuditsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_success=self.is_success,
            knowledge_base_id=self.knowledge_base_id,
            state=self.state,
            vulnerability_audit_collections=self.vulnerability_audit_collections)


def get_vulnerability_audits(compartment_id: Optional[str] = None,
                             display_name: Optional[str] = None,
                             filters: Optional[Sequence[pulumi.InputType['GetVulnerabilityAuditsFilterArgs']]] = None,
                             id: Optional[str] = None,
                             is_success: Optional[bool] = None,
                             knowledge_base_id: Optional[str] = None,
                             state: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityAuditsResult:
    """
    This data source provides the list of Vulnerability Audits in Oracle Cloud Infrastructure ADM service.

    Returns a list of Vulnerability Audits based on the specified query parameters.
    At least one of id, compartmentId or knowledgeBaseId query parameter must be provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_audits = oci.Adm.get_vulnerability_audits(compartment_id=var["compartment_id"],
        display_name=var["vulnerability_audit_display_name"],
        id=var["vulnerability_audit_id"],
        is_success=var["vulnerability_audit_is_success"],
        knowledge_base_id=oci_adm_knowledge_base["test_knowledge_base"]["id"],
        state=var["vulnerability_audit_state"])
    ```


    :param str compartment_id: A filter to return only resources that belong to the specified compartment identifier.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A filter to return only resources that match the specified identifier.
    :param bool is_success: A filter to return only successful or failed Vulnerability Audits.
    :param str knowledge_base_id: A filter to return only Vulnerability Audits that were created against the specified knowledge base.
    :param str state: A filter to return only Vulnerability Audits that match the specified lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['isSuccess'] = is_success
    __args__['knowledgeBaseId'] = knowledge_base_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Adm/getVulnerabilityAudits:getVulnerabilityAudits', __args__, opts=opts, typ=GetVulnerabilityAuditsResult).value

    return AwaitableGetVulnerabilityAuditsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_success=pulumi.get(__ret__, 'is_success'),
        knowledge_base_id=pulumi.get(__ret__, 'knowledge_base_id'),
        state=pulumi.get(__ret__, 'state'),
        vulnerability_audit_collections=pulumi.get(__ret__, 'vulnerability_audit_collections'))


@_utilities.lift_output_func(get_vulnerability_audits)
def get_vulnerability_audits_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVulnerabilityAuditsFilterArgs']]]]] = None,
                                    id: Optional[pulumi.Input[Optional[str]]] = None,
                                    is_success: Optional[pulumi.Input[Optional[bool]]] = None,
                                    knowledge_base_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    state: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVulnerabilityAuditsResult]:
    """
    This data source provides the list of Vulnerability Audits in Oracle Cloud Infrastructure ADM service.

    Returns a list of Vulnerability Audits based on the specified query parameters.
    At least one of id, compartmentId or knowledgeBaseId query parameter must be provided.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_audits = oci.Adm.get_vulnerability_audits(compartment_id=var["compartment_id"],
        display_name=var["vulnerability_audit_display_name"],
        id=var["vulnerability_audit_id"],
        is_success=var["vulnerability_audit_is_success"],
        knowledge_base_id=oci_adm_knowledge_base["test_knowledge_base"]["id"],
        state=var["vulnerability_audit_state"])
    ```


    :param str compartment_id: A filter to return only resources that belong to the specified compartment identifier.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A filter to return only resources that match the specified identifier.
    :param bool is_success: A filter to return only successful or failed Vulnerability Audits.
    :param str knowledge_base_id: A filter to return only Vulnerability Audits that were created against the specified knowledge base.
    :param str state: A filter to return only Vulnerability Audits that match the specified lifecycleState.
    """
    ...
