# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProcessorJobArgs', 'ProcessorJob']

@pulumi.input_type
class ProcessorJobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 input_location: pulumi.Input['ProcessorJobInputLocationArgs'],
                 output_location: pulumi.Input['ProcessorJobOutputLocationArgs'],
                 processor_config: pulumi.Input['ProcessorJobProcessorConfigArgs'],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ProcessorJob resource.
        :param pulumi.Input[str] compartment_id: The compartment identifier.
        :param pulumi.Input['ProcessorJobInputLocationArgs'] input_location: The location of the inputs.
        :param pulumi.Input['ProcessorJobOutputLocationArgs'] output_location: The object storage location where to store analysis results.
        :param pulumi.Input['ProcessorJobProcessorConfigArgs'] processor_config: The configuration of a processor.
        :param pulumi.Input[str] display_name: The display name of the processor job.
        """
        ProcessorJobArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            input_location=input_location,
            output_location=output_location,
            processor_config=processor_config,
            display_name=display_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             input_location: pulumi.Input['ProcessorJobInputLocationArgs'],
             output_location: pulumi.Input['ProcessorJobOutputLocationArgs'],
             processor_config: pulumi.Input['ProcessorJobProcessorConfigArgs'],
             display_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'inputLocation' in kwargs:
            input_location = kwargs['inputLocation']
        if 'outputLocation' in kwargs:
            output_location = kwargs['outputLocation']
        if 'processorConfig' in kwargs:
            processor_config = kwargs['processorConfig']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']

        _setter("compartment_id", compartment_id)
        _setter("input_location", input_location)
        _setter("output_location", output_location)
        _setter("processor_config", processor_config)
        if display_name is not None:
            _setter("display_name", display_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> pulumi.Input['ProcessorJobInputLocationArgs']:
        """
        The location of the inputs.
        """
        return pulumi.get(self, "input_location")

    @input_location.setter
    def input_location(self, value: pulumi.Input['ProcessorJobInputLocationArgs']):
        pulumi.set(self, "input_location", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Input['ProcessorJobOutputLocationArgs']:
        """
        The object storage location where to store analysis results.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: pulumi.Input['ProcessorJobOutputLocationArgs']):
        pulumi.set(self, "output_location", value)

    @property
    @pulumi.getter(name="processorConfig")
    def processor_config(self) -> pulumi.Input['ProcessorJobProcessorConfigArgs']:
        """
        The configuration of a processor.
        """
        return pulumi.get(self, "processor_config")

    @processor_config.setter
    def processor_config(self, value: pulumi.Input['ProcessorJobProcessorConfigArgs']):
        pulumi.set(self, "processor_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the processor job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _ProcessorJobState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 input_location: Optional[pulumi.Input['ProcessorJobInputLocationArgs']] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input['ProcessorJobOutputLocationArgs']] = None,
                 percent_complete: Optional[pulumi.Input[float]] = None,
                 processor_config: Optional[pulumi.Input['ProcessorJobProcessorConfigArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_accepted: Optional[pulumi.Input[str]] = None,
                 time_finished: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ProcessorJob resources.
        :param pulumi.Input[str] compartment_id: The compartment identifier.
        :param pulumi.Input[str] display_name: The display name of the processor job.
        :param pulumi.Input['ProcessorJobInputLocationArgs'] input_location: The location of the inputs.
        :param pulumi.Input[str] lifecycle_details: The detailed status of FAILED state.
        :param pulumi.Input['ProcessorJobOutputLocationArgs'] output_location: The object storage location where to store analysis results.
        :param pulumi.Input[float] percent_complete: How much progress the operation has made, compared to the total amount of work to be performed.
        :param pulumi.Input['ProcessorJobProcessorConfigArgs'] processor_config: The configuration of a processor.
        :param pulumi.Input[str] state: The current state of the processor job.
        :param pulumi.Input[str] time_accepted: The job acceptance time.
        :param pulumi.Input[str] time_finished: The job finish time.
        :param pulumi.Input[str] time_started: The job start time.
        """
        _ProcessorJobState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            display_name=display_name,
            input_location=input_location,
            lifecycle_details=lifecycle_details,
            output_location=output_location,
            percent_complete=percent_complete,
            processor_config=processor_config,
            state=state,
            time_accepted=time_accepted,
            time_finished=time_finished,
            time_started=time_started,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             input_location: Optional[pulumi.Input['ProcessorJobInputLocationArgs']] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             output_location: Optional[pulumi.Input['ProcessorJobOutputLocationArgs']] = None,
             percent_complete: Optional[pulumi.Input[float]] = None,
             processor_config: Optional[pulumi.Input['ProcessorJobProcessorConfigArgs']] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_accepted: Optional[pulumi.Input[str]] = None,
             time_finished: Optional[pulumi.Input[str]] = None,
             time_started: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'inputLocation' in kwargs:
            input_location = kwargs['inputLocation']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'outputLocation' in kwargs:
            output_location = kwargs['outputLocation']
        if 'percentComplete' in kwargs:
            percent_complete = kwargs['percentComplete']
        if 'processorConfig' in kwargs:
            processor_config = kwargs['processorConfig']
        if 'timeAccepted' in kwargs:
            time_accepted = kwargs['timeAccepted']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeStarted' in kwargs:
            time_started = kwargs['timeStarted']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if display_name is not None:
            _setter("display_name", display_name)
        if input_location is not None:
            _setter("input_location", input_location)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if output_location is not None:
            _setter("output_location", output_location)
        if percent_complete is not None:
            _setter("percent_complete", percent_complete)
        if processor_config is not None:
            _setter("processor_config", processor_config)
        if state is not None:
            _setter("state", state)
        if time_accepted is not None:
            _setter("time_accepted", time_accepted)
        if time_finished is not None:
            _setter("time_finished", time_finished)
        if time_started is not None:
            _setter("time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the processor job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> Optional[pulumi.Input['ProcessorJobInputLocationArgs']]:
        """
        The location of the inputs.
        """
        return pulumi.get(self, "input_location")

    @input_location.setter
    def input_location(self, value: Optional[pulumi.Input['ProcessorJobInputLocationArgs']]):
        pulumi.set(self, "input_location", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        The detailed status of FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input['ProcessorJobOutputLocationArgs']]:
        """
        The object storage location where to store analysis results.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input['ProcessorJobOutputLocationArgs']]):
        pulumi.set(self, "output_location", value)

    @property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> Optional[pulumi.Input[float]]:
        """
        How much progress the operation has made, compared to the total amount of work to be performed.
        """
        return pulumi.get(self, "percent_complete")

    @percent_complete.setter
    def percent_complete(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "percent_complete", value)

    @property
    @pulumi.getter(name="processorConfig")
    def processor_config(self) -> Optional[pulumi.Input['ProcessorJobProcessorConfigArgs']]:
        """
        The configuration of a processor.
        """
        return pulumi.get(self, "processor_config")

    @processor_config.setter
    def processor_config(self, value: Optional[pulumi.Input['ProcessorJobProcessorConfigArgs']]):
        pulumi.set(self, "processor_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the processor job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> Optional[pulumi.Input[str]]:
        """
        The job acceptance time.
        """
        return pulumi.get(self, "time_accepted")

    @time_accepted.setter
    def time_accepted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_accepted", value)

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[str]]:
        """
        The job finish time.
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_finished", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        The job start time.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)


class ProcessorJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 input_location: Optional[pulumi.Input[pulumi.InputType['ProcessorJobInputLocationArgs']]] = None,
                 output_location: Optional[pulumi.Input[pulumi.InputType['ProcessorJobOutputLocationArgs']]] = None,
                 processor_config: Optional[pulumi.Input[pulumi.InputType['ProcessorJobProcessorConfigArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Processor Job resource in Oracle Cloud Infrastructure Ai Document service.

        Create a processor job for document analysis.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_processor_job = oci.ai_document.ProcessorJob("testProcessorJob",
            compartment_id=var["compartment_id"],
            input_location=oci.ai_document.ProcessorJobInputLocationArgs(
                source_type=var["processor_job_input_location_source_type"],
                data=var["processor_job_input_location_data"],
                object_locations=[oci.ai_document.ProcessorJobInputLocationObjectLocationArgs(
                    bucket=var["processor_job_input_location_object_locations_bucket"],
                    namespace=var["processor_job_input_location_object_locations_namespace"],
                    object=var["processor_job_input_location_object_locations_object"],
                )],
            ),
            output_location=oci.ai_document.ProcessorJobOutputLocationArgs(
                bucket=var["processor_job_output_location_bucket"],
                namespace=var["processor_job_output_location_namespace"],
                prefix=var["processor_job_output_location_prefix"],
            ),
            processor_config=oci.ai_document.ProcessorJobProcessorConfigArgs(
                features=[oci.ai_document.ProcessorJobProcessorConfigFeatureArgs(
                    feature_type=var["processor_job_processor_config_features_feature_type"],
                    generate_searchable_pdf=var["processor_job_processor_config_features_generate_searchable_pdf"],
                    max_results=var["processor_job_processor_config_features_max_results"],
                    model_id=oci_ai_document_model["test_model"]["id"],
                    tenancy_id=oci_identity_tenancy["test_tenancy"]["id"],
                )],
                processor_type=var["processor_job_processor_config_processor_type"],
                document_type=var["processor_job_processor_config_document_type"],
                is_zip_output_enabled=var["processor_job_processor_config_is_zip_output_enabled"],
                language=var["processor_job_processor_config_language"],
            ),
            display_name=var["processor_job_display_name"])
        ```

        ## Import

        ProcessorJobs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:AiDocument/processorJob:ProcessorJob test_processor_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The compartment identifier.
        :param pulumi.Input[str] display_name: The display name of the processor job.
        :param pulumi.Input[pulumi.InputType['ProcessorJobInputLocationArgs']] input_location: The location of the inputs.
        :param pulumi.Input[pulumi.InputType['ProcessorJobOutputLocationArgs']] output_location: The object storage location where to store analysis results.
        :param pulumi.Input[pulumi.InputType['ProcessorJobProcessorConfigArgs']] processor_config: The configuration of a processor.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProcessorJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Processor Job resource in Oracle Cloud Infrastructure Ai Document service.

        Create a processor job for document analysis.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_processor_job = oci.ai_document.ProcessorJob("testProcessorJob",
            compartment_id=var["compartment_id"],
            input_location=oci.ai_document.ProcessorJobInputLocationArgs(
                source_type=var["processor_job_input_location_source_type"],
                data=var["processor_job_input_location_data"],
                object_locations=[oci.ai_document.ProcessorJobInputLocationObjectLocationArgs(
                    bucket=var["processor_job_input_location_object_locations_bucket"],
                    namespace=var["processor_job_input_location_object_locations_namespace"],
                    object=var["processor_job_input_location_object_locations_object"],
                )],
            ),
            output_location=oci.ai_document.ProcessorJobOutputLocationArgs(
                bucket=var["processor_job_output_location_bucket"],
                namespace=var["processor_job_output_location_namespace"],
                prefix=var["processor_job_output_location_prefix"],
            ),
            processor_config=oci.ai_document.ProcessorJobProcessorConfigArgs(
                features=[oci.ai_document.ProcessorJobProcessorConfigFeatureArgs(
                    feature_type=var["processor_job_processor_config_features_feature_type"],
                    generate_searchable_pdf=var["processor_job_processor_config_features_generate_searchable_pdf"],
                    max_results=var["processor_job_processor_config_features_max_results"],
                    model_id=oci_ai_document_model["test_model"]["id"],
                    tenancy_id=oci_identity_tenancy["test_tenancy"]["id"],
                )],
                processor_type=var["processor_job_processor_config_processor_type"],
                document_type=var["processor_job_processor_config_document_type"],
                is_zip_output_enabled=var["processor_job_processor_config_is_zip_output_enabled"],
                language=var["processor_job_processor_config_language"],
            ),
            display_name=var["processor_job_display_name"])
        ```

        ## Import

        ProcessorJobs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:AiDocument/processorJob:ProcessorJob test_processor_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param ProcessorJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProcessorJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ProcessorJobArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 input_location: Optional[pulumi.Input[pulumi.InputType['ProcessorJobInputLocationArgs']]] = None,
                 output_location: Optional[pulumi.Input[pulumi.InputType['ProcessorJobOutputLocationArgs']]] = None,
                 processor_config: Optional[pulumi.Input[pulumi.InputType['ProcessorJobProcessorConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProcessorJobArgs.__new__(ProcessorJobArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["display_name"] = display_name
            if input_location is not None and not isinstance(input_location, ProcessorJobInputLocationArgs):
                input_location = input_location or {}
                def _setter(key, value):
                    input_location[key] = value
                ProcessorJobInputLocationArgs._configure(_setter, **input_location)
            if input_location is None and not opts.urn:
                raise TypeError("Missing required property 'input_location'")
            __props__.__dict__["input_location"] = input_location
            if output_location is not None and not isinstance(output_location, ProcessorJobOutputLocationArgs):
                output_location = output_location or {}
                def _setter(key, value):
                    output_location[key] = value
                ProcessorJobOutputLocationArgs._configure(_setter, **output_location)
            if output_location is None and not opts.urn:
                raise TypeError("Missing required property 'output_location'")
            __props__.__dict__["output_location"] = output_location
            if processor_config is not None and not isinstance(processor_config, ProcessorJobProcessorConfigArgs):
                processor_config = processor_config or {}
                def _setter(key, value):
                    processor_config[key] = value
                ProcessorJobProcessorConfigArgs._configure(_setter, **processor_config)
            if processor_config is None and not opts.urn:
                raise TypeError("Missing required property 'processor_config'")
            __props__.__dict__["processor_config"] = processor_config
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["percent_complete"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_accepted"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_started"] = None
        super(ProcessorJob, __self__).__init__(
            'oci:AiDocument/processorJob:ProcessorJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            input_location: Optional[pulumi.Input[pulumi.InputType['ProcessorJobInputLocationArgs']]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            output_location: Optional[pulumi.Input[pulumi.InputType['ProcessorJobOutputLocationArgs']]] = None,
            percent_complete: Optional[pulumi.Input[float]] = None,
            processor_config: Optional[pulumi.Input[pulumi.InputType['ProcessorJobProcessorConfigArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_accepted: Optional[pulumi.Input[str]] = None,
            time_finished: Optional[pulumi.Input[str]] = None,
            time_started: Optional[pulumi.Input[str]] = None) -> 'ProcessorJob':
        """
        Get an existing ProcessorJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The compartment identifier.
        :param pulumi.Input[str] display_name: The display name of the processor job.
        :param pulumi.Input[pulumi.InputType['ProcessorJobInputLocationArgs']] input_location: The location of the inputs.
        :param pulumi.Input[str] lifecycle_details: The detailed status of FAILED state.
        :param pulumi.Input[pulumi.InputType['ProcessorJobOutputLocationArgs']] output_location: The object storage location where to store analysis results.
        :param pulumi.Input[float] percent_complete: How much progress the operation has made, compared to the total amount of work to be performed.
        :param pulumi.Input[pulumi.InputType['ProcessorJobProcessorConfigArgs']] processor_config: The configuration of a processor.
        :param pulumi.Input[str] state: The current state of the processor job.
        :param pulumi.Input[str] time_accepted: The job acceptance time.
        :param pulumi.Input[str] time_finished: The job finish time.
        :param pulumi.Input[str] time_started: The job start time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProcessorJobState.__new__(_ProcessorJobState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["input_location"] = input_location
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["output_location"] = output_location
        __props__.__dict__["percent_complete"] = percent_complete
        __props__.__dict__["processor_config"] = processor_config
        __props__.__dict__["state"] = state
        __props__.__dict__["time_accepted"] = time_accepted
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_started"] = time_started
        return ProcessorJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the processor job.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inputLocation")
    def input_location(self) -> pulumi.Output['outputs.ProcessorJobInputLocation']:
        """
        The location of the inputs.
        """
        return pulumi.get(self, "input_location")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        The detailed status of FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Output['outputs.ProcessorJobOutputLocation']:
        """
        The object storage location where to store analysis results.
        """
        return pulumi.get(self, "output_location")

    @property
    @pulumi.getter(name="percentComplete")
    def percent_complete(self) -> pulumi.Output[float]:
        """
        How much progress the operation has made, compared to the total amount of work to be performed.
        """
        return pulumi.get(self, "percent_complete")

    @property
    @pulumi.getter(name="processorConfig")
    def processor_config(self) -> pulumi.Output['outputs.ProcessorJobProcessorConfig']:
        """
        The configuration of a processor.
        """
        return pulumi.get(self, "processor_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the processor job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> pulumi.Output[str]:
        """
        The job acceptance time.
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[str]:
        """
        The job finish time.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[str]:
        """
        The job start time.
        """
        return pulumi.get(self, "time_started")

