# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalyticsInstancePrivateAccessChannelArgs', 'AnalyticsInstancePrivateAccessChannel']

@pulumi.input_type
class AnalyticsInstancePrivateAccessChannelArgs:
    def __init__(__self__, *,
                 analytics_instance_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 private_source_dns_zones: pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]],
                 subnet_id: pulumi.Input[str],
                 vcn_id: pulumi.Input[str],
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_source_scan_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]] = None):
        """
        The set of arguments for constructing a AnalyticsInstancePrivateAccessChannel resource.
        :param pulumi.Input[str] analytics_instance_id: The OCID of the AnalyticsInstance.
        :param pulumi.Input[str] display_name: (Updatable) Display Name of the Private Access Channel.
        :param pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]] private_source_dns_zones: (Updatable) List of Private Source DNS zones registered with Private Access Channel, where datasource hostnames from these dns zones / domains will be resolved in the peered VCN for access from Analytics Instance. Min of 1 is required and Max of 30 Private Source DNS zones can be registered.
        :param pulumi.Input[str] subnet_id: (Updatable) OCID of the customer subnet connected to private access channel.
        :param pulumi.Input[str] vcn_id: (Updatable) OCID of the customer VCN peered with private access channel. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_security_group_ids: (Updatable) Network Security Group OCIDs for an Analytics instance.
        :param pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]] private_source_scan_hosts: (Updatable) List of Private Source DB SCAN hosts registered with Private Access Channel for access from Analytics Instance.
        """
        AnalyticsInstancePrivateAccessChannelArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            analytics_instance_id=analytics_instance_id,
            display_name=display_name,
            private_source_dns_zones=private_source_dns_zones,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
            network_security_group_ids=network_security_group_ids,
            private_source_scan_hosts=private_source_scan_hosts,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             analytics_instance_id: pulumi.Input[str],
             display_name: pulumi.Input[str],
             private_source_dns_zones: pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]],
             subnet_id: pulumi.Input[str],
             vcn_id: pulumi.Input[str],
             network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             private_source_scan_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'analyticsInstanceId' in kwargs:
            analytics_instance_id = kwargs['analyticsInstanceId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'privateSourceDnsZones' in kwargs:
            private_source_dns_zones = kwargs['privateSourceDnsZones']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'vcnId' in kwargs:
            vcn_id = kwargs['vcnId']
        if 'networkSecurityGroupIds' in kwargs:
            network_security_group_ids = kwargs['networkSecurityGroupIds']
        if 'privateSourceScanHosts' in kwargs:
            private_source_scan_hosts = kwargs['privateSourceScanHosts']

        _setter("analytics_instance_id", analytics_instance_id)
        _setter("display_name", display_name)
        _setter("private_source_dns_zones", private_source_dns_zones)
        _setter("subnet_id", subnet_id)
        _setter("vcn_id", vcn_id)
        if network_security_group_ids is not None:
            _setter("network_security_group_ids", network_security_group_ids)
        if private_source_scan_hosts is not None:
            _setter("private_source_scan_hosts", private_source_scan_hosts)

    @property
    @pulumi.getter(name="analyticsInstanceId")
    def analytics_instance_id(self) -> pulumi.Input[str]:
        """
        The OCID of the AnalyticsInstance.
        """
        return pulumi.get(self, "analytics_instance_id")

    @analytics_instance_id.setter
    def analytics_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "analytics_instance_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Display Name of the Private Access Channel.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="privateSourceDnsZones")
    def private_source_dns_zones(self) -> pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]:
        """
        (Updatable) List of Private Source DNS zones registered with Private Access Channel, where datasource hostnames from these dns zones / domains will be resolved in the peered VCN for access from Analytics Instance. Min of 1 is required and Max of 30 Private Source DNS zones can be registered.
        """
        return pulumi.get(self, "private_source_dns_zones")

    @private_source_dns_zones.setter
    def private_source_dns_zones(self, value: pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]):
        pulumi.set(self, "private_source_dns_zones", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the customer subnet connected to private access channel.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the customer VCN peered with private access channel. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcn_id", value)

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @network_security_group_ids.setter
    def network_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_security_group_ids", value)

    @property
    @pulumi.getter(name="privateSourceScanHosts")
    def private_source_scan_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]]:
        """
        (Updatable) List of Private Source DB SCAN hosts registered with Private Access Channel for access from Analytics Instance.
        """
        return pulumi.get(self, "private_source_scan_hosts")

    @private_source_scan_hosts.setter
    def private_source_scan_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]]):
        pulumi.set(self, "private_source_scan_hosts", value)


@pulumi.input_type
class _AnalyticsInstancePrivateAccessChannelState:
    def __init__(__self__, *,
                 analytics_instance_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 egress_source_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_source_dns_zones: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]] = None,
                 private_source_scan_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AnalyticsInstancePrivateAccessChannel resources.
        :param pulumi.Input[str] analytics_instance_id: The OCID of the AnalyticsInstance.
        :param pulumi.Input[str] display_name: (Updatable) Display Name of the Private Access Channel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] egress_source_ip_addresses: The list of IP addresses from the customer subnet connected to private access channel, used as a source Ip by Private Access Channel for network traffic from the AnalyticsInstance to Private Sources.
        :param pulumi.Input[str] ip_address: IP Address of the Private Access channel.
        :param pulumi.Input[str] key: Private Access Channel unique identifier key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_security_group_ids: (Updatable) Network Security Group OCIDs for an Analytics instance.
        :param pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]] private_source_dns_zones: (Updatable) List of Private Source DNS zones registered with Private Access Channel, where datasource hostnames from these dns zones / domains will be resolved in the peered VCN for access from Analytics Instance. Min of 1 is required and Max of 30 Private Source DNS zones can be registered.
        :param pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]] private_source_scan_hosts: (Updatable) List of Private Source DB SCAN hosts registered with Private Access Channel for access from Analytics Instance.
        :param pulumi.Input[str] subnet_id: (Updatable) OCID of the customer subnet connected to private access channel.
        :param pulumi.Input[str] vcn_id: (Updatable) OCID of the customer VCN peered with private access channel. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _AnalyticsInstancePrivateAccessChannelState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            analytics_instance_id=analytics_instance_id,
            display_name=display_name,
            egress_source_ip_addresses=egress_source_ip_addresses,
            ip_address=ip_address,
            key=key,
            network_security_group_ids=network_security_group_ids,
            private_source_dns_zones=private_source_dns_zones,
            private_source_scan_hosts=private_source_scan_hosts,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             analytics_instance_id: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             egress_source_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             ip_address: Optional[pulumi.Input[str]] = None,
             key: Optional[pulumi.Input[str]] = None,
             network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             private_source_dns_zones: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]] = None,
             private_source_scan_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]] = None,
             subnet_id: Optional[pulumi.Input[str]] = None,
             vcn_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'analyticsInstanceId' in kwargs:
            analytics_instance_id = kwargs['analyticsInstanceId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'egressSourceIpAddresses' in kwargs:
            egress_source_ip_addresses = kwargs['egressSourceIpAddresses']
        if 'ipAddress' in kwargs:
            ip_address = kwargs['ipAddress']
        if 'networkSecurityGroupIds' in kwargs:
            network_security_group_ids = kwargs['networkSecurityGroupIds']
        if 'privateSourceDnsZones' in kwargs:
            private_source_dns_zones = kwargs['privateSourceDnsZones']
        if 'privateSourceScanHosts' in kwargs:
            private_source_scan_hosts = kwargs['privateSourceScanHosts']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'vcnId' in kwargs:
            vcn_id = kwargs['vcnId']

        if analytics_instance_id is not None:
            _setter("analytics_instance_id", analytics_instance_id)
        if display_name is not None:
            _setter("display_name", display_name)
        if egress_source_ip_addresses is not None:
            _setter("egress_source_ip_addresses", egress_source_ip_addresses)
        if ip_address is not None:
            _setter("ip_address", ip_address)
        if key is not None:
            _setter("key", key)
        if network_security_group_ids is not None:
            _setter("network_security_group_ids", network_security_group_ids)
        if private_source_dns_zones is not None:
            _setter("private_source_dns_zones", private_source_dns_zones)
        if private_source_scan_hosts is not None:
            _setter("private_source_scan_hosts", private_source_scan_hosts)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)
        if vcn_id is not None:
            _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="analyticsInstanceId")
    def analytics_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the AnalyticsInstance.
        """
        return pulumi.get(self, "analytics_instance_id")

    @analytics_instance_id.setter
    def analytics_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analytics_instance_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Display Name of the Private Access Channel.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="egressSourceIpAddresses")
    def egress_source_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of IP addresses from the customer subnet connected to private access channel, used as a source Ip by Private Access Channel for network traffic from the AnalyticsInstance to Private Sources.
        """
        return pulumi.get(self, "egress_source_ip_addresses")

    @egress_source_ip_addresses.setter
    def egress_source_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "egress_source_ip_addresses", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address of the Private Access channel.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Private Access Channel unique identifier key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @network_security_group_ids.setter
    def network_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_security_group_ids", value)

    @property
    @pulumi.getter(name="privateSourceDnsZones")
    def private_source_dns_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]]:
        """
        (Updatable) List of Private Source DNS zones registered with Private Access Channel, where datasource hostnames from these dns zones / domains will be resolved in the peered VCN for access from Analytics Instance. Min of 1 is required and Max of 30 Private Source DNS zones can be registered.
        """
        return pulumi.get(self, "private_source_dns_zones")

    @private_source_dns_zones.setter
    def private_source_dns_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]]):
        pulumi.set(self, "private_source_dns_zones", value)

    @property
    @pulumi.getter(name="privateSourceScanHosts")
    def private_source_scan_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]]:
        """
        (Updatable) List of Private Source DB SCAN hosts registered with Private Access Channel for access from Analytics Instance.
        """
        return pulumi.get(self, "private_source_scan_hosts")

    @private_source_scan_hosts.setter
    def private_source_scan_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]]):
        pulumi.set(self, "private_source_scan_hosts", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of the customer subnet connected to private access channel.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of the customer VCN peered with private access channel. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_id", value)


class AnalyticsInstancePrivateAccessChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_instance_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_source_dns_zones: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]]] = None,
                 private_source_scan_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Analytics Instance Private Access Channel resource in Oracle Cloud Infrastructure Analytics service.

        Create a Private access Channel for the Analytics instance. The operation is long-running
        and creates a new WorkRequest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analytics_instance_private_access_channel = oci.analytics.AnalyticsInstancePrivateAccessChannel("testAnalyticsInstancePrivateAccessChannel",
            analytics_instance_id=oci_analytics_analytics_instance["test_analytics_instance"]["id"],
            display_name=var["analytics_instance_private_access_channel_display_name"],
            private_source_dns_zones=[oci.analytics.AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs(
                dns_zone=var["analytics_instance_private_access_channel_private_source_dns_zones_dns_zone"],
                description=var["analytics_instance_private_access_channel_private_source_dns_zones_description"],
            )],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            vcn_id=oci_core_vcn["test_vcn"]["id"],
            network_security_group_ids=var["analytics_instance_private_access_channel_network_security_group_ids"],
            private_source_scan_hosts=[oci.analytics.AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs(
                scan_hostname=var["analytics_instance_private_access_channel_private_source_scan_hosts_scan_hostname"],
                scan_port=var["analytics_instance_private_access_channel_private_source_scan_hosts_scan_port"],
                description=var["analytics_instance_private_access_channel_private_source_scan_hosts_description"],
            )])
        ```

        ## Import

        AnalyticsInstancePrivateAccessChannels can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Analytics/analyticsInstancePrivateAccessChannel:AnalyticsInstancePrivateAccessChannel test_analytics_instance_private_access_channel "analyticsInstances/{analyticsInstanceId}/privateAccessChannels/{privateAccessChannelKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analytics_instance_id: The OCID of the AnalyticsInstance.
        :param pulumi.Input[str] display_name: (Updatable) Display Name of the Private Access Channel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_security_group_ids: (Updatable) Network Security Group OCIDs for an Analytics instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]] private_source_dns_zones: (Updatable) List of Private Source DNS zones registered with Private Access Channel, where datasource hostnames from these dns zones / domains will be resolved in the peered VCN for access from Analytics Instance. Min of 1 is required and Max of 30 Private Source DNS zones can be registered.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]] private_source_scan_hosts: (Updatable) List of Private Source DB SCAN hosts registered with Private Access Channel for access from Analytics Instance.
        :param pulumi.Input[str] subnet_id: (Updatable) OCID of the customer subnet connected to private access channel.
        :param pulumi.Input[str] vcn_id: (Updatable) OCID of the customer VCN peered with private access channel. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalyticsInstancePrivateAccessChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Analytics Instance Private Access Channel resource in Oracle Cloud Infrastructure Analytics service.

        Create a Private access Channel for the Analytics instance. The operation is long-running
        and creates a new WorkRequest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analytics_instance_private_access_channel = oci.analytics.AnalyticsInstancePrivateAccessChannel("testAnalyticsInstancePrivateAccessChannel",
            analytics_instance_id=oci_analytics_analytics_instance["test_analytics_instance"]["id"],
            display_name=var["analytics_instance_private_access_channel_display_name"],
            private_source_dns_zones=[oci.analytics.AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs(
                dns_zone=var["analytics_instance_private_access_channel_private_source_dns_zones_dns_zone"],
                description=var["analytics_instance_private_access_channel_private_source_dns_zones_description"],
            )],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            vcn_id=oci_core_vcn["test_vcn"]["id"],
            network_security_group_ids=var["analytics_instance_private_access_channel_network_security_group_ids"],
            private_source_scan_hosts=[oci.analytics.AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs(
                scan_hostname=var["analytics_instance_private_access_channel_private_source_scan_hosts_scan_hostname"],
                scan_port=var["analytics_instance_private_access_channel_private_source_scan_hosts_scan_port"],
                description=var["analytics_instance_private_access_channel_private_source_scan_hosts_description"],
            )])
        ```

        ## Import

        AnalyticsInstancePrivateAccessChannels can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Analytics/analyticsInstancePrivateAccessChannel:AnalyticsInstancePrivateAccessChannel test_analytics_instance_private_access_channel "analyticsInstances/{analyticsInstanceId}/privateAccessChannels/{privateAccessChannelKey}"
        ```

        :param str resource_name: The name of the resource.
        :param AnalyticsInstancePrivateAccessChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyticsInstancePrivateAccessChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            AnalyticsInstancePrivateAccessChannelArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_instance_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_source_dns_zones: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]]] = None,
                 private_source_scan_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyticsInstancePrivateAccessChannelArgs.__new__(AnalyticsInstancePrivateAccessChannelArgs)

            if analytics_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'analytics_instance_id'")
            __props__.__dict__["analytics_instance_id"] = analytics_instance_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["network_security_group_ids"] = network_security_group_ids
            if private_source_dns_zones is None and not opts.urn:
                raise TypeError("Missing required property 'private_source_dns_zones'")
            __props__.__dict__["private_source_dns_zones"] = private_source_dns_zones
            __props__.__dict__["private_source_scan_hosts"] = private_source_scan_hosts
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if vcn_id is None and not opts.urn:
                raise TypeError("Missing required property 'vcn_id'")
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["egress_source_ip_addresses"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["key"] = None
        super(AnalyticsInstancePrivateAccessChannel, __self__).__init__(
            'oci:Analytics/analyticsInstancePrivateAccessChannel:AnalyticsInstancePrivateAccessChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analytics_instance_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            egress_source_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            private_source_dns_zones: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]]] = None,
            private_source_scan_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            vcn_id: Optional[pulumi.Input[str]] = None) -> 'AnalyticsInstancePrivateAccessChannel':
        """
        Get an existing AnalyticsInstancePrivateAccessChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analytics_instance_id: The OCID of the AnalyticsInstance.
        :param pulumi.Input[str] display_name: (Updatable) Display Name of the Private Access Channel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] egress_source_ip_addresses: The list of IP addresses from the customer subnet connected to private access channel, used as a source Ip by Private Access Channel for network traffic from the AnalyticsInstance to Private Sources.
        :param pulumi.Input[str] ip_address: IP Address of the Private Access channel.
        :param pulumi.Input[str] key: Private Access Channel unique identifier key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_security_group_ids: (Updatable) Network Security Group OCIDs for an Analytics instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneArgs']]]] private_source_dns_zones: (Updatable) List of Private Source DNS zones registered with Private Access Channel, where datasource hostnames from these dns zones / domains will be resolved in the peered VCN for access from Analytics Instance. Min of 1 is required and Max of 30 Private Source DNS zones can be registered.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnalyticsInstancePrivateAccessChannelPrivateSourceScanHostArgs']]]] private_source_scan_hosts: (Updatable) List of Private Source DB SCAN hosts registered with Private Access Channel for access from Analytics Instance.
        :param pulumi.Input[str] subnet_id: (Updatable) OCID of the customer subnet connected to private access channel.
        :param pulumi.Input[str] vcn_id: (Updatable) OCID of the customer VCN peered with private access channel. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalyticsInstancePrivateAccessChannelState.__new__(_AnalyticsInstancePrivateAccessChannelState)

        __props__.__dict__["analytics_instance_id"] = analytics_instance_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["egress_source_ip_addresses"] = egress_source_ip_addresses
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["key"] = key
        __props__.__dict__["network_security_group_ids"] = network_security_group_ids
        __props__.__dict__["private_source_dns_zones"] = private_source_dns_zones
        __props__.__dict__["private_source_scan_hosts"] = private_source_scan_hosts
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["vcn_id"] = vcn_id
        return AnalyticsInstancePrivateAccessChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analyticsInstanceId")
    def analytics_instance_id(self) -> pulumi.Output[str]:
        """
        The OCID of the AnalyticsInstance.
        """
        return pulumi.get(self, "analytics_instance_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Display Name of the Private Access Channel.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="egressSourceIpAddresses")
    def egress_source_ip_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of IP addresses from the customer subnet connected to private access channel, used as a source Ip by Private Access Channel for network traffic from the AnalyticsInstance to Private Sources.
        """
        return pulumi.get(self, "egress_source_ip_addresses")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        IP Address of the Private Access channel.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Private Access Channel unique identifier key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter(name="privateSourceDnsZones")
    def private_source_dns_zones(self) -> pulumi.Output[Sequence['outputs.AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone']]:
        """
        (Updatable) List of Private Source DNS zones registered with Private Access Channel, where datasource hostnames from these dns zones / domains will be resolved in the peered VCN for access from Analytics Instance. Min of 1 is required and Max of 30 Private Source DNS zones can be registered.
        """
        return pulumi.get(self, "private_source_dns_zones")

    @property
    @pulumi.getter(name="privateSourceScanHosts")
    def private_source_scan_hosts(self) -> pulumi.Output[Sequence['outputs.AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost']]:
        """
        (Updatable) List of Private Source DB SCAN hosts registered with Private Access Channel for access from Analytics Instance.
        """
        return pulumi.get(self, "private_source_scan_hosts")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        (Updatable) OCID of the customer subnet connected to private access channel.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[str]:
        """
        (Updatable) OCID of the customer VCN peered with private access channel. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vcn_id")

