# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, certificate=None, certificate_id=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, intermediate_certificates=None, lifecycle_details=None, private_key=None, state=None, subject_names=None, time_created=None, time_not_valid_after=None, time_updated=None):
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if intermediate_certificates and not isinstance(intermediate_certificates, str):
            raise TypeError("Expected argument 'intermediate_certificates' to be a str")
        pulumi.set(__self__, "intermediate_certificates", intermediate_certificates)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if private_key and not isinstance(private_key, str):
            raise TypeError("Expected argument 'private_key' to be a str")
        pulumi.set(__self__, "private_key", private_key)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subject_names and not isinstance(subject_names, list):
            raise TypeError("Expected argument 'subject_names' to be a list")
        pulumi.set(__self__, "subject_names", subject_names)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_not_valid_after and not isinstance(time_not_valid_after, str):
            raise TypeError("Expected argument 'time_not_valid_after' to be a str")
        pulumi.set(__self__, "time_not_valid_after", time_not_valid_after)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        The data of the leaf certificate in pem format.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the resource is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intermediateCertificates")
    def intermediate_certificates(self) -> str:
        """
        The intermediate certificate data associated with the certificate in pem format.
        """
        return pulumi.get(self, "intermediate_certificates")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the certificate.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subjectNames")
    def subject_names(self) -> Sequence[str]:
        """
        The entity to be secured by the certificate and additional host names.
        """
        return pulumi.get(self, "subject_names")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeNotValidAfter")
    def time_not_valid_after(self) -> str:
        """
        The date and time the certificate will expire.
        """
        return pulumi.get(self, "time_not_valid_after")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificate=self.certificate,
            certificate_id=self.certificate_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            intermediate_certificates=self.intermediate_certificates,
            lifecycle_details=self.lifecycle_details,
            private_key=self.private_key,
            state=self.state,
            subject_names=self.subject_names,
            time_created=self.time_created,
            time_not_valid_after=self.time_not_valid_after,
            time_updated=self.time_updated)


def get_certificate(certificate_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    This data source provides details about a specific Certificate resource in Oracle Cloud Infrastructure API Gateway service.

    Gets a certificate by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate = oci.ApiGateway.get_certificate(certificate_id=oci_apigateway_certificate["test_certificate"]["id"])
    ```


    :param str certificate_id: The ocid of the certificate.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApiGateway/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        certificate=pulumi.get(__ret__, 'certificate'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        intermediate_certificates=pulumi.get(__ret__, 'intermediate_certificates'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        private_key=pulumi.get(__ret__, 'private_key'),
        state=pulumi.get(__ret__, 'state'),
        subject_names=pulumi.get(__ret__, 'subject_names'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_not_valid_after=pulumi.get(__ret__, 'time_not_valid_after'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_certificate)
def get_certificate_output(certificate_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateResult]:
    """
    This data source provides details about a specific Certificate resource in Oracle Cloud Infrastructure API Gateway service.

    Gets a certificate by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate = oci.ApiGateway.get_certificate(certificate_id=oci_apigateway_certificate["test_certificate"]["id"])
    ```


    :param str certificate_id: The ocid of the certificate.
    """
    ...
