# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DedicatedVantagePointArgs', 'DedicatedVantagePoint']

@pulumi.input_type
class DedicatedVantagePointArgs:
    def __init__(__self__, *,
                 apm_domain_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 dvp_stack_details: pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs'],
                 region: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DedicatedVantagePoint resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[str] display_name: Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs'] dvp_stack_details: (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        :param pulumi.Input[str] region: (Updatable) Name of the region.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] status: (Updatable) Status of the dedicated vantage point.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        DedicatedVantagePointArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            apm_domain_id=apm_domain_id,
            display_name=display_name,
            dvp_stack_details=dvp_stack_details,
            region=region,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             apm_domain_id: pulumi.Input[str],
             display_name: pulumi.Input[str],
             dvp_stack_details: pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs'],
             region: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             status: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'apmDomainId' in kwargs:
            apm_domain_id = kwargs['apmDomainId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'dvpStackDetails' in kwargs:
            dvp_stack_details = kwargs['dvpStackDetails']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("apm_domain_id", apm_domain_id)
        _setter("display_name", display_name)
        _setter("dvp_stack_details", dvp_stack_details)
        _setter("region", region)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if status is not None:
            _setter("status", status)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dvpStackDetails")
    def dvp_stack_details(self) -> pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']:
        """
        (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        """
        return pulumi.get(self, "dvp_stack_details")

    @dvp_stack_details.setter
    def dvp_stack_details(self, value: pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']):
        pulumi.set(self, "dvp_stack_details", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the dedicated vantage point.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _DedicatedVantagePointState:
    def __init__(__self__, *,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dvp_stack_details: Optional[pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 monitor_status_count_maps: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DedicatedVantagePoint resources.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs'] dvp_stack_details: (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]] monitor_status_count_maps: Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        :param pulumi.Input[str] name: Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        :param pulumi.Input[str] region: (Updatable) Name of the region.
        :param pulumi.Input[str] status: (Updatable) Status of the dedicated vantage point.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        _DedicatedVantagePointState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            apm_domain_id=apm_domain_id,
            defined_tags=defined_tags,
            display_name=display_name,
            dvp_stack_details=dvp_stack_details,
            freeform_tags=freeform_tags,
            monitor_status_count_maps=monitor_status_count_maps,
            name=name,
            region=region,
            status=status,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             apm_domain_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             dvp_stack_details: Optional[pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             monitor_status_count_maps: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             region: Optional[pulumi.Input[str]] = None,
             status: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'apmDomainId' in kwargs:
            apm_domain_id = kwargs['apmDomainId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'dvpStackDetails' in kwargs:
            dvp_stack_details = kwargs['dvpStackDetails']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'monitorStatusCountMaps' in kwargs:
            monitor_status_count_maps = kwargs['monitorStatusCountMaps']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if apm_domain_id is not None:
            _setter("apm_domain_id", apm_domain_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if dvp_stack_details is not None:
            _setter("dvp_stack_details", dvp_stack_details)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if monitor_status_count_maps is not None:
            _setter("monitor_status_count_maps", monitor_status_count_maps)
        if name is not None:
            _setter("name", name)
        if region is not None:
            _setter("region", region)
        if status is not None:
            _setter("status", status)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dvpStackDetails")
    def dvp_stack_details(self) -> Optional[pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']]:
        """
        (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        """
        return pulumi.get(self, "dvp_stack_details")

    @dvp_stack_details.setter
    def dvp_stack_details(self, value: Optional[pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']]):
        pulumi.set(self, "dvp_stack_details", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="monitorStatusCountMaps")
    def monitor_status_count_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]]]:
        """
        Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        """
        return pulumi.get(self, "monitor_status_count_maps")

    @monitor_status_count_maps.setter
    def monitor_status_count_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]]]):
        pulumi.set(self, "monitor_status_count_maps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the dedicated vantage point.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class DedicatedVantagePoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dvp_stack_details: Optional[pulumi.Input[pulumi.InputType['DedicatedVantagePointDvpStackDetailsArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Dedicated Vantage Point resource in Oracle Cloud Infrastructure Apm Synthetics service.

        Registers a new dedicated vantage point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dedicated_vantage_point = oci.apm_synthetics.DedicatedVantagePoint("testDedicatedVantagePoint",
            apm_domain_id=oci_apm_apm_domain["test_apm_domain"]["id"],
            display_name=var["dedicated_vantage_point_display_name"],
            dvp_stack_details=oci.apm_synthetics.DedicatedVantagePointDvpStackDetailsArgs(
                dvp_stack_id=oci_resourcemanager_stack["test_stack"]["id"],
                dvp_stack_type=var["dedicated_vantage_point_dvp_stack_details_dvp_stack_type"],
                dvp_stream_id=oci_streaming_stream["test_stream"]["id"],
                dvp_version=var["dedicated_vantage_point_dvp_stack_details_dvp_version"],
            ),
            region=var["dedicated_vantage_point_region"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=var["dedicated_vantage_point_status"])
        ```

        ## Import

        DedicatedVantagePoints can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:ApmSynthetics/dedicatedVantagePoint:DedicatedVantagePoint test_dedicated_vantage_point "dedicatedVantagePoints/{dedicatedVantagePointId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input[pulumi.InputType['DedicatedVantagePointDvpStackDetailsArgs']] dvp_stack_details: (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] region: (Updatable) Name of the region.
        :param pulumi.Input[str] status: (Updatable) Status of the dedicated vantage point.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedVantagePointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Dedicated Vantage Point resource in Oracle Cloud Infrastructure Apm Synthetics service.

        Registers a new dedicated vantage point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dedicated_vantage_point = oci.apm_synthetics.DedicatedVantagePoint("testDedicatedVantagePoint",
            apm_domain_id=oci_apm_apm_domain["test_apm_domain"]["id"],
            display_name=var["dedicated_vantage_point_display_name"],
            dvp_stack_details=oci.apm_synthetics.DedicatedVantagePointDvpStackDetailsArgs(
                dvp_stack_id=oci_resourcemanager_stack["test_stack"]["id"],
                dvp_stack_type=var["dedicated_vantage_point_dvp_stack_details_dvp_stack_type"],
                dvp_stream_id=oci_streaming_stream["test_stream"]["id"],
                dvp_version=var["dedicated_vantage_point_dvp_stack_details_dvp_version"],
            ),
            region=var["dedicated_vantage_point_region"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=var["dedicated_vantage_point_status"])
        ```

        ## Import

        DedicatedVantagePoints can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:ApmSynthetics/dedicatedVantagePoint:DedicatedVantagePoint test_dedicated_vantage_point "dedicatedVantagePoints/{dedicatedVantagePointId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedVantagePointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedVantagePointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DedicatedVantagePointArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dvp_stack_details: Optional[pulumi.Input[pulumi.InputType['DedicatedVantagePointDvpStackDetailsArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedVantagePointArgs.__new__(DedicatedVantagePointArgs)

            if apm_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'apm_domain_id'")
            __props__.__dict__["apm_domain_id"] = apm_domain_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if dvp_stack_details is not None and not isinstance(dvp_stack_details, DedicatedVantagePointDvpStackDetailsArgs):
                dvp_stack_details = dvp_stack_details or {}
                def _setter(key, value):
                    dvp_stack_details[key] = value
                DedicatedVantagePointDvpStackDetailsArgs._configure(_setter, **dvp_stack_details)
            if dvp_stack_details is None and not opts.urn:
                raise TypeError("Missing required property 'dvp_stack_details'")
            __props__.__dict__["dvp_stack_details"] = dvp_stack_details
            __props__.__dict__["freeform_tags"] = freeform_tags
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = status
            __props__.__dict__["monitor_status_count_maps"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DedicatedVantagePoint, __self__).__init__(
            'oci:ApmSynthetics/dedicatedVantagePoint:DedicatedVantagePoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apm_domain_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            dvp_stack_details: Optional[pulumi.Input[pulumi.InputType['DedicatedVantagePointDvpStackDetailsArgs']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            monitor_status_count_maps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedVantagePointMonitorStatusCountMapArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'DedicatedVantagePoint':
        """
        Get an existing DedicatedVantagePoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input[pulumi.InputType['DedicatedVantagePointDvpStackDetailsArgs']] dvp_stack_details: (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedVantagePointMonitorStatusCountMapArgs']]]] monitor_status_count_maps: Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        :param pulumi.Input[str] name: Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        :param pulumi.Input[str] region: (Updatable) Name of the region.
        :param pulumi.Input[str] status: (Updatable) Status of the dedicated vantage point.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedVantagePointState.__new__(_DedicatedVantagePointState)

        __props__.__dict__["apm_domain_id"] = apm_domain_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dvp_stack_details"] = dvp_stack_details
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["monitor_status_count_maps"] = monitor_status_count_maps
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DedicatedVantagePoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dvpStackDetails")
    def dvp_stack_details(self) -> pulumi.Output['outputs.DedicatedVantagePointDvpStackDetails']:
        """
        (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        """
        return pulumi.get(self, "dvp_stack_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="monitorStatusCountMaps")
    def monitor_status_count_maps(self) -> pulumi.Output[Sequence['outputs.DedicatedVantagePointMonitorStatusCountMap']]:
        """
        Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        """
        return pulumi.get(self, "monitor_status_count_maps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) Status of the dedicated vantage point.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

