# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ContainerConfigurationArgs', 'ContainerConfiguration']

@pulumi.input_type
class ContainerConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 is_repository_created_on_first_push: pulumi.Input[bool]):
        """
        The set of arguments for constructing a ContainerConfiguration resource.
        :param pulumi.Input[bool] is_repository_created_on_first_push: Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        ContainerConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            is_repository_created_on_first_push=is_repository_created_on_first_push,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             is_repository_created_on_first_push: pulumi.Input[bool],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'isRepositoryCreatedOnFirstPush' in kwargs:
            is_repository_created_on_first_push = kwargs['isRepositoryCreatedOnFirstPush']

        _setter("compartment_id", compartment_id)
        _setter("is_repository_created_on_first_push", is_repository_created_on_first_push)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isRepositoryCreatedOnFirstPush")
    def is_repository_created_on_first_push(self) -> pulumi.Input[bool]:
        """
        Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        return pulumi.get(self, "is_repository_created_on_first_push")

    @is_repository_created_on_first_push.setter
    def is_repository_created_on_first_push(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_repository_created_on_first_push", value)


@pulumi.input_type
class _ContainerConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_repository_created_on_first_push: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ContainerConfiguration resources.
        :param pulumi.Input[bool] is_repository_created_on_first_push: Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        :param pulumi.Input[str] namespace: The tenancy namespace used in the container repository path.
        """
        _ContainerConfigurationState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            is_repository_created_on_first_push=is_repository_created_on_first_push,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             is_repository_created_on_first_push: Optional[pulumi.Input[bool]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'isRepositoryCreatedOnFirstPush' in kwargs:
            is_repository_created_on_first_push = kwargs['isRepositoryCreatedOnFirstPush']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if is_repository_created_on_first_push is not None:
            _setter("is_repository_created_on_first_push", is_repository_created_on_first_push)
        if namespace is not None:
            _setter("namespace", namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isRepositoryCreatedOnFirstPush")
    def is_repository_created_on_first_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        return pulumi.get(self, "is_repository_created_on_first_push")

    @is_repository_created_on_first_push.setter
    def is_repository_created_on_first_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_repository_created_on_first_push", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The tenancy namespace used in the container repository path.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


class ContainerConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_repository_created_on_first_push: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Container Configuration resource in Oracle Cloud Infrastructure Artifacts service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_container_configuration = oci.artifacts.ContainerConfiguration("testContainerConfiguration")
        ```

        ## Import

        ContainerConfiguration can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Artifacts/containerConfiguration:ContainerConfiguration test_container_configuration "container/configuration/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_repository_created_on_first_push: Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Container Configuration resource in Oracle Cloud Infrastructure Artifacts service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_container_configuration = oci.artifacts.ContainerConfiguration("testContainerConfiguration")
        ```

        ## Import

        ContainerConfiguration can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Artifacts/containerConfiguration:ContainerConfiguration test_container_configuration "container/configuration/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param ContainerConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ContainerConfigurationArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_repository_created_on_first_push: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerConfigurationArgs.__new__(ContainerConfigurationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if is_repository_created_on_first_push is None and not opts.urn:
                raise TypeError("Missing required property 'is_repository_created_on_first_push'")
            __props__.__dict__["is_repository_created_on_first_push"] = is_repository_created_on_first_push
            __props__.__dict__["namespace"] = None
        super(ContainerConfiguration, __self__).__init__(
            'oci:Artifacts/containerConfiguration:ContainerConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            is_repository_created_on_first_push: Optional[pulumi.Input[bool]] = None,
            namespace: Optional[pulumi.Input[str]] = None) -> 'ContainerConfiguration':
        """
        Get an existing ContainerConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_repository_created_on_first_push: Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        :param pulumi.Input[str] namespace: The tenancy namespace used in the container repository path.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerConfigurationState.__new__(_ContainerConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["is_repository_created_on_first_push"] = is_repository_created_on_first_push
        __props__.__dict__["namespace"] = namespace
        return ContainerConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="isRepositoryCreatedOnFirstPush")
    def is_repository_created_on_first_push(self) -> pulumi.Output[bool]:
        """
        Whether to create a new container repository when a container is pushed to a new repository path. Repositories created in this way belong to the root compartment.
        """
        return pulumi.get(self, "is_repository_created_on_first_push")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The tenancy namespace used in the container repository path.
        """
        return pulumi.get(self, "namespace")

