# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetEventsAuditEventResult',
    'GetEventsAuditEventDataResult',
    'GetEventsAuditEventDataIdentityResult',
    'GetEventsAuditEventDataRequestResult',
    'GetEventsAuditEventDataResponseResult',
    'GetEventsAuditEventDataStateChangeResult',
    'GetEventsFilterResult',
]

@pulumi.output_type
class GetEventsAuditEventResult(dict):
    def __init__(__self__, *,
                 cloud_events_version: str,
                 content_type: str,
                 datas: Sequence['outputs.GetEventsAuditEventDataResult'],
                 event_id: str,
                 event_time: str,
                 event_type: str,
                 event_type_version: str,
                 source: str):
        """
        :param str cloud_events_version: The version of the CloudEvents specification. The structure of the envelope follows the  [CloudEvents](https://github.com/cloudevents/spec) industry standard format hosted by the [Cloud Native Computing Foundation ( CNCF)](https://www.cncf.io/).
        :param str content_type: The content type of the data contained in `data`.  Example: `application/json`
        :param Sequence['GetEventsAuditEventDataArgs'] datas: The payload of the event. Information within `data` comes from the resource emitting the event.
        :param str event_id: The GUID of the event.
        :param str event_time: The time the event occurred, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2019-09-18T00:10:59.252Z`
        :param str event_type: The type of event that happened.
        :param str event_type_version: The version of the event type. This version applies to the payload of the event, not the envelope. Use `cloudEventsVersion` to determine the version of the envelope.  Example: `2.0`
        :param str source: The source of the event.  Example: `ComputeApi`
        """
        GetEventsAuditEventResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cloud_events_version=cloud_events_version,
            content_type=content_type,
            datas=datas,
            event_id=event_id,
            event_time=event_time,
            event_type=event_type,
            event_type_version=event_type_version,
            source=source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cloud_events_version: str,
             content_type: str,
             datas: Sequence['outputs.GetEventsAuditEventDataResult'],
             event_id: str,
             event_time: str,
             event_type: str,
             event_type_version: str,
             source: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cloudEventsVersion' in kwargs:
            cloud_events_version = kwargs['cloudEventsVersion']
        if 'contentType' in kwargs:
            content_type = kwargs['contentType']
        if 'eventId' in kwargs:
            event_id = kwargs['eventId']
        if 'eventTime' in kwargs:
            event_time = kwargs['eventTime']
        if 'eventType' in kwargs:
            event_type = kwargs['eventType']
        if 'eventTypeVersion' in kwargs:
            event_type_version = kwargs['eventTypeVersion']

        _setter("cloud_events_version", cloud_events_version)
        _setter("content_type", content_type)
        _setter("datas", datas)
        _setter("event_id", event_id)
        _setter("event_time", event_time)
        _setter("event_type", event_type)
        _setter("event_type_version", event_type_version)
        _setter("source", source)

    @property
    @pulumi.getter(name="cloudEventsVersion")
    def cloud_events_version(self) -> str:
        """
        The version of the CloudEvents specification. The structure of the envelope follows the  [CloudEvents](https://github.com/cloudevents/spec) industry standard format hosted by the [Cloud Native Computing Foundation ( CNCF)](https://www.cncf.io/).
        """
        return pulumi.get(self, "cloud_events_version")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the data contained in `data`.  Example: `application/json`
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetEventsAuditEventDataResult']:
        """
        The payload of the event. Information within `data` comes from the resource emitting the event.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="eventId")
    def event_id(self) -> str:
        """
        The GUID of the event.
        """
        return pulumi.get(self, "event_id")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> str:
        """
        The time the event occurred, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2019-09-18T00:10:59.252Z`
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> str:
        """
        The type of event that happened.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="eventTypeVersion")
    def event_type_version(self) -> str:
        """
        The version of the event type. This version applies to the payload of the event, not the envelope. Use `cloudEventsVersion` to determine the version of the envelope.  Example: `2.0`
        """
        return pulumi.get(self, "event_type_version")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source of the event.  Example: `ComputeApi`
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetEventsAuditEventDataResult(dict):
    def __init__(__self__, *,
                 additional_details: Mapping[str, Any],
                 availability_domain: str,
                 compartment_id: str,
                 compartment_name: str,
                 defined_tags: Mapping[str, Any],
                 event_grouping_id: str,
                 event_name: str,
                 freeform_tags: Mapping[str, Any],
                 identities: Sequence['outputs.GetEventsAuditEventDataIdentityResult'],
                 requests: Sequence['outputs.GetEventsAuditEventDataRequestResult'],
                 resource_id: str,
                 resource_name: str,
                 responses: Sequence['outputs.GetEventsAuditEventDataResponseResult'],
                 state_changes: Sequence['outputs.GetEventsAuditEventDataStateChangeResult']):
        """
        :param Mapping[str, Any] additional_details: A container object for attribues unique to the resource emitting the event.
        :param str availability_domain: The availability domain where the resource resides.
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param str compartment_name: The name of the compartment. This value is the friendly name associated with compartmentId. This value can change, but the service logs the value that appeared at the time of the audit event.  Example: `CompartmentA`
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str event_grouping_id: This value links multiple audit events that are part of the same API operation. For example,  a long running API operations that emit an event at the start and the end of an operation would use the same value in this field for both events.
        :param str event_name: Name of the API operation that generated this event.  Example: `GetInstance`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name,  type, or namespace. Exists for cross-compatibility only. For more information,  see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param Sequence['GetEventsAuditEventDataIdentityArgs'] identities: A container object for identity attributes.
        :param Sequence['GetEventsAuditEventDataRequestArgs'] requests: A container object for request attributes.
        :param str resource_id: An [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) or some other ID for the resource emitting the event.
        :param str resource_name: The name of the resource emitting the event.
        :param Sequence['GetEventsAuditEventDataResponseArgs'] responses: A container object for response attributes.
        :param Sequence['GetEventsAuditEventDataStateChangeArgs'] state_changes: A container object for state change attributes.
        """
        GetEventsAuditEventDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            additional_details=additional_details,
            availability_domain=availability_domain,
            compartment_id=compartment_id,
            compartment_name=compartment_name,
            defined_tags=defined_tags,
            event_grouping_id=event_grouping_id,
            event_name=event_name,
            freeform_tags=freeform_tags,
            identities=identities,
            requests=requests,
            resource_id=resource_id,
            resource_name=resource_name,
            responses=responses,
            state_changes=state_changes,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             additional_details: Mapping[str, Any],
             availability_domain: str,
             compartment_id: str,
             compartment_name: str,
             defined_tags: Mapping[str, Any],
             event_grouping_id: str,
             event_name: str,
             freeform_tags: Mapping[str, Any],
             identities: Sequence['outputs.GetEventsAuditEventDataIdentityResult'],
             requests: Sequence['outputs.GetEventsAuditEventDataRequestResult'],
             resource_id: str,
             resource_name: str,
             responses: Sequence['outputs.GetEventsAuditEventDataResponseResult'],
             state_changes: Sequence['outputs.GetEventsAuditEventDataStateChangeResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'additionalDetails' in kwargs:
            additional_details = kwargs['additionalDetails']
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'compartmentName' in kwargs:
            compartment_name = kwargs['compartmentName']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'eventGroupingId' in kwargs:
            event_grouping_id = kwargs['eventGroupingId']
        if 'eventName' in kwargs:
            event_name = kwargs['eventName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceName' in kwargs:
            resource_name = kwargs['resourceName']
        if 'stateChanges' in kwargs:
            state_changes = kwargs['stateChanges']

        _setter("additional_details", additional_details)
        _setter("availability_domain", availability_domain)
        _setter("compartment_id", compartment_id)
        _setter("compartment_name", compartment_name)
        _setter("defined_tags", defined_tags)
        _setter("event_grouping_id", event_grouping_id)
        _setter("event_name", event_name)
        _setter("freeform_tags", freeform_tags)
        _setter("identities", identities)
        _setter("requests", requests)
        _setter("resource_id", resource_id)
        _setter("resource_name", resource_name)
        _setter("responses", responses)
        _setter("state_changes", state_changes)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, Any]:
        """
        A container object for attribues unique to the resource emitting the event.
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain where the resource resides.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> str:
        """
        The name of the compartment. This value is the friendly name associated with compartmentId. This value can change, but the service logs the value that appeared at the time of the audit event.  Example: `CompartmentA`
        """
        return pulumi.get(self, "compartment_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="eventGroupingId")
    def event_grouping_id(self) -> str:
        """
        This value links multiple audit events that are part of the same API operation. For example,  a long running API operations that emit an event at the start and the end of an operation would use the same value in this field for both events.
        """
        return pulumi.get(self, "event_grouping_id")

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> str:
        """
        Name of the API operation that generated this event.  Example: `GetInstance`
        """
        return pulumi.get(self, "event_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name,  type, or namespace. Exists for cross-compatibility only. For more information,  see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetEventsAuditEventDataIdentityResult']:
        """
        A container object for identity attributes.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter
    def requests(self) -> Sequence['outputs.GetEventsAuditEventDataRequestResult']:
        """
        A container object for request attributes.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        An [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) or some other ID for the resource emitting the event.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The name of the resource emitting the event.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter
    def responses(self) -> Sequence['outputs.GetEventsAuditEventDataResponseResult']:
        """
        A container object for response attributes.
        """
        return pulumi.get(self, "responses")

    @property
    @pulumi.getter(name="stateChanges")
    def state_changes(self) -> Sequence['outputs.GetEventsAuditEventDataStateChangeResult']:
        """
        A container object for state change attributes.
        """
        return pulumi.get(self, "state_changes")


@pulumi.output_type
class GetEventsAuditEventDataIdentityResult(dict):
    def __init__(__self__, *,
                 auth_type: str,
                 caller_id: str,
                 caller_name: str,
                 console_session_id: str,
                 credentials: str,
                 ip_address: str,
                 principal_id: str,
                 principal_name: str,
                 tenant_id: str,
                 user_agent: str):
        """
        :param str auth_type: The type of authentication used.  Example: `natv`
        :param str caller_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the caller. The caller that made a  request on behalf of the prinicpal.
        :param str caller_name: The name of the user or service. This value is the friendly name associated with `callerId`.
        :param str console_session_id: This value identifies any Console session associated with this request.
        :param str credentials: The credential ID of the user. This value is extracted from the HTTP 'Authorization' request header. It consists of the tenantId, userId, and user fingerprint, all delimited by a slash (/).
        :param str ip_address: The IP address of the source of the request.  Example: `172.24.80.88`
        :param str principal_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the principal.
        :param str principal_name: The name of the user or service. This value is the friendly name associated with `principalId`.  Example: `ExampleName`
        :param str tenant_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenant.
        :param str user_agent: The user agent of the client that made the request.  Example: `Jersey/2.23 (HttpUrlConnection 1.8.0_212)`
        """
        GetEventsAuditEventDataIdentityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            auth_type=auth_type,
            caller_id=caller_id,
            caller_name=caller_name,
            console_session_id=console_session_id,
            credentials=credentials,
            ip_address=ip_address,
            principal_id=principal_id,
            principal_name=principal_name,
            tenant_id=tenant_id,
            user_agent=user_agent,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             auth_type: str,
             caller_id: str,
             caller_name: str,
             console_session_id: str,
             credentials: str,
             ip_address: str,
             principal_id: str,
             principal_name: str,
             tenant_id: str,
             user_agent: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'authType' in kwargs:
            auth_type = kwargs['authType']
        if 'callerId' in kwargs:
            caller_id = kwargs['callerId']
        if 'callerName' in kwargs:
            caller_name = kwargs['callerName']
        if 'consoleSessionId' in kwargs:
            console_session_id = kwargs['consoleSessionId']
        if 'ipAddress' in kwargs:
            ip_address = kwargs['ipAddress']
        if 'principalId' in kwargs:
            principal_id = kwargs['principalId']
        if 'principalName' in kwargs:
            principal_name = kwargs['principalName']
        if 'tenantId' in kwargs:
            tenant_id = kwargs['tenantId']
        if 'userAgent' in kwargs:
            user_agent = kwargs['userAgent']

        _setter("auth_type", auth_type)
        _setter("caller_id", caller_id)
        _setter("caller_name", caller_name)
        _setter("console_session_id", console_session_id)
        _setter("credentials", credentials)
        _setter("ip_address", ip_address)
        _setter("principal_id", principal_id)
        _setter("principal_name", principal_name)
        _setter("tenant_id", tenant_id)
        _setter("user_agent", user_agent)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        The type of authentication used.  Example: `natv`
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="callerId")
    def caller_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the caller. The caller that made a  request on behalf of the prinicpal.
        """
        return pulumi.get(self, "caller_id")

    @property
    @pulumi.getter(name="callerName")
    def caller_name(self) -> str:
        """
        The name of the user or service. This value is the friendly name associated with `callerId`.
        """
        return pulumi.get(self, "caller_name")

    @property
    @pulumi.getter(name="consoleSessionId")
    def console_session_id(self) -> str:
        """
        This value identifies any Console session associated with this request.
        """
        return pulumi.get(self, "console_session_id")

    @property
    @pulumi.getter
    def credentials(self) -> str:
        """
        The credential ID of the user. This value is extracted from the HTTP 'Authorization' request header. It consists of the tenantId, userId, and user fingerprint, all delimited by a slash (/).
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the source of the request.  Example: `172.24.80.88`
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the principal.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> str:
        """
        The name of the user or service. This value is the friendly name associated with `principalId`.  Example: `ExampleName`
        """
        return pulumi.get(self, "principal_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenant.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> str:
        """
        The user agent of the client that made the request.  Example: `Jersey/2.23 (HttpUrlConnection 1.8.0_212)`
        """
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class GetEventsAuditEventDataRequestResult(dict):
    def __init__(__self__, *,
                 action: str,
                 headers: Mapping[str, Any],
                 id: str,
                 parameters: Mapping[str, Any],
                 path: str):
        """
        :param str action: The HTTP method of the request.  Example: `GET`
        :param Mapping[str, Any] headers: The headers of the response.
        :param str id: The opc-request-id of the request.
        :param Mapping[str, Any] parameters: The parameters supplied by the caller during this operation.
        :param str path: The full path of the API request.  Example: `/20160918/instances/ocid1.instance.oc1.phx.<unique_ID>`
        """
        GetEventsAuditEventDataRequestResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            headers=headers,
            id=id,
            parameters=parameters,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             headers: Mapping[str, Any],
             id: str,
             parameters: Mapping[str, Any],
             path: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("action", action)
        _setter("headers", headers)
        _setter("id", id)
        _setter("parameters", parameters)
        _setter("path", path)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The HTTP method of the request.  Example: `GET`
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, Any]:
        """
        The headers of the response.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The opc-request-id of the request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, Any]:
        """
        The parameters supplied by the caller during this operation.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The full path of the API request.  Example: `/20160918/instances/ocid1.instance.oc1.phx.<unique_ID>`
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetEventsAuditEventDataResponseResult(dict):
    def __init__(__self__, *,
                 headers: Mapping[str, Any],
                 message: str,
                 payload: Mapping[str, Any],
                 response_time: str,
                 status: str):
        """
        :param Mapping[str, Any] headers: The headers of the response.
        :param str message: A friendly description of what happened during the operation. Use this for troubleshooting.
        :param Mapping[str, Any] payload: This value is included for backward compatibility with the Audit version 1 schema, where  it contained metadata of interest from the response payload.
        :param str response_time: The time of the response to the audited request, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2019-09-18T00:10:59.278Z`
        :param str status: The status code of the response.  Example: `200`
        """
        GetEventsAuditEventDataResponseResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            headers=headers,
            message=message,
            payload=payload,
            response_time=response_time,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             headers: Mapping[str, Any],
             message: str,
             payload: Mapping[str, Any],
             response_time: str,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'responseTime' in kwargs:
            response_time = kwargs['responseTime']

        _setter("headers", headers)
        _setter("message", message)
        _setter("payload", payload)
        _setter("response_time", response_time)
        _setter("status", status)

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, Any]:
        """
        The headers of the response.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A friendly description of what happened during the operation. Use this for troubleshooting.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def payload(self) -> Mapping[str, Any]:
        """
        This value is included for backward compatibility with the Audit version 1 schema, where  it contained metadata of interest from the response payload.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="responseTime")
    def response_time(self) -> str:
        """
        The time of the response to the audited request, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2019-09-18T00:10:59.278Z`
        """
        return pulumi.get(self, "response_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status code of the response.  Example: `200`
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEventsAuditEventDataStateChangeResult(dict):
    def __init__(__self__, *,
                 current: Mapping[str, Any],
                 previous: Mapping[str, Any]):
        """
        :param Mapping[str, Any] current: Provides the current state of fields that may have changed during an operation. To determine how the current operation changed a resource, compare the information in this attribute to  `previous`.
        :param Mapping[str, Any] previous: Provides the previous state of fields that may have changed during an operation. To determine how the current operation changed a resource, compare the information in this attribute to  `current`.
        """
        GetEventsAuditEventDataStateChangeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            current=current,
            previous=previous,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             current: Mapping[str, Any],
             previous: Mapping[str, Any],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("current", current)
        _setter("previous", previous)

    @property
    @pulumi.getter
    def current(self) -> Mapping[str, Any]:
        """
        Provides the current state of fields that may have changed during an operation. To determine how the current operation changed a resource, compare the information in this attribute to  `previous`.
        """
        return pulumi.get(self, "current")

    @property
    @pulumi.getter
    def previous(self) -> Mapping[str, Any]:
        """
        Provides the previous state of fields that may have changed during an operation. To determine how the current operation changed a resource, compare the information in this attribute to  `current`.
        """
        return pulumi.get(self, "previous")


@pulumi.output_type
class GetEventsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetEventsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


