# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AutoScalingConfigurationAutoScalingResources',
    'AutoScalingConfigurationPolicy',
    'AutoScalingConfigurationPolicyCapacity',
    'AutoScalingConfigurationPolicyExecutionSchedule',
    'AutoScalingConfigurationPolicyResourceAction',
    'AutoScalingConfigurationPolicyRule',
    'AutoScalingConfigurationPolicyRuleAction',
    'AutoScalingConfigurationPolicyRuleMetric',
    'AutoScalingConfigurationPolicyRuleMetricThreshold',
    'GetAutoScalingConfigurationAutoScalingResourceResult',
    'GetAutoScalingConfigurationPolicyResult',
    'GetAutoScalingConfigurationPolicyCapacityResult',
    'GetAutoScalingConfigurationPolicyExecutionScheduleResult',
    'GetAutoScalingConfigurationPolicyResourceActionResult',
    'GetAutoScalingConfigurationPolicyRuleResult',
    'GetAutoScalingConfigurationPolicyRuleActionResult',
    'GetAutoScalingConfigurationPolicyRuleMetricResult',
    'GetAutoScalingConfigurationPolicyRuleMetricThresholdResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult',
    'GetAutoScalingConfigurationsFilterResult',
]

@pulumi.output_type
class AutoScalingConfigurationAutoScalingResources(dict):
    def __init__(__self__, *,
                 id: str,
                 type: str):
        """
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        :param str type: The type of action to take.
        """
        AutoScalingConfigurationAutoScalingResources._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("id", id)
        _setter("type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AutoScalingConfigurationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "executionSchedule":
            suggest = "execution_schedule"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "resourceAction":
            suggest = "resource_action"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 capacity: Optional['outputs.AutoScalingConfigurationPolicyCapacity'] = None,
                 display_name: Optional[str] = None,
                 execution_schedule: Optional['outputs.AutoScalingConfigurationPolicyExecutionSchedule'] = None,
                 id: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 resource_action: Optional['outputs.AutoScalingConfigurationPolicyResourceAction'] = None,
                 rules: Optional[Sequence['outputs.AutoScalingConfigurationPolicyRule']] = None,
                 time_created: Optional[str] = None):
        """
        :param str policy_type: The type of autoscaling policy.
        :param 'AutoScalingConfigurationPolicyCapacityArgs' capacity: The capacity requirements of the autoscaling policy.
        :param 'AutoScalingConfigurationPolicyExecutionScheduleArgs' execution_schedule: An execution schedule for an autoscaling policy.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        :param bool is_enabled: Whether the autoscaling policy is enabled.
        :param 'AutoScalingConfigurationPolicyResourceActionArgs' resource_action: An action that can be executed against a resource.
        :param str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        AutoScalingConfigurationPolicy._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            policy_type=policy_type,
            capacity=capacity,
            display_name=display_name,
            execution_schedule=execution_schedule,
            id=id,
            is_enabled=is_enabled,
            resource_action=resource_action,
            rules=rules,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             policy_type: str,
             capacity: Optional['outputs.AutoScalingConfigurationPolicyCapacity'] = None,
             display_name: Optional[str] = None,
             execution_schedule: Optional['outputs.AutoScalingConfigurationPolicyExecutionSchedule'] = None,
             id: Optional[str] = None,
             is_enabled: Optional[bool] = None,
             resource_action: Optional['outputs.AutoScalingConfigurationPolicyResourceAction'] = None,
             rules: Optional[Sequence['outputs.AutoScalingConfigurationPolicyRule']] = None,
             time_created: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'policyType' in kwargs:
            policy_type = kwargs['policyType']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'executionSchedule' in kwargs:
            execution_schedule = kwargs['executionSchedule']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']
        if 'resourceAction' in kwargs:
            resource_action = kwargs['resourceAction']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("policy_type", policy_type)
        if capacity is not None:
            _setter("capacity", capacity)
        if display_name is not None:
            _setter("display_name", display_name)
        if execution_schedule is not None:
            _setter("execution_schedule", execution_schedule)
        if id is not None:
            _setter("id", id)
        if is_enabled is not None:
            _setter("is_enabled", is_enabled)
        if resource_action is not None:
            _setter("resource_action", resource_action)
        if rules is not None:
            _setter("rules", rules)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter
    def capacity(self) -> Optional['outputs.AutoScalingConfigurationPolicyCapacity']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionSchedule")
    def execution_schedule(self) -> Optional['outputs.AutoScalingConfigurationPolicyExecutionSchedule']:
        """
        An execution schedule for an autoscaling policy.
        """
        return pulumi.get(self, "execution_schedule")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="resourceAction")
    def resource_action(self) -> Optional['outputs.AutoScalingConfigurationPolicyResourceAction']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_action")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AutoScalingConfigurationPolicyRule']]:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class AutoScalingConfigurationPolicyCapacity(dict):
    def __init__(__self__, *,
                 initial: Optional[int] = None,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        :param int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
               
               For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        :param int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
               
               For a schedule-based autoscaling policy, this value is not used.
        :param int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
               
               For a schedule-based autoscaling policy, this value is not used.
        """
        AutoScalingConfigurationPolicyCapacity._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            initial=initial,
            max=max,
            min=min,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             initial: Optional[int] = None,
             max: Optional[int] = None,
             min: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if initial is not None:
            _setter("initial", initial)
        if max is not None:
            _setter("max", max)
        if min is not None:
            _setter("min", min)

    @property
    @pulumi.getter
    def initial(self) -> Optional[int]:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.

        For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).

        For a schedule-based autoscaling policy, this value is not used.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).

        For a schedule-based autoscaling policy, this value is not used.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingConfigurationPolicyExecutionSchedule(dict):
    def __init__(__self__, *,
                 expression: str,
                 timezone: str,
                 type: str):
        """
        :param str expression: A cron expression that represents the time at which to execute the autoscaling policy.
               
               Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`
               
               You can use special characters that are supported with the Quartz cron implementation.
               
               You must specify `0` as the value for seconds.
               
               Example: `0 15 10 ? * *`
        :param str timezone: The time zone for the execution schedule.
        :param str type: The type of action to take.
        """
        AutoScalingConfigurationPolicyExecutionSchedule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            expression=expression,
            timezone=timezone,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             expression: str,
             timezone: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("expression", expression)
        _setter("timezone", timezone)
        _setter("type", type)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.

        Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`

        You can use special characters that are supported with the Quartz cron implementation.

        You must specify `0` as the value for seconds.

        Example: `0 15 10 ? * *`
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AutoScalingConfigurationPolicyResourceAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyResourceAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyResourceAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyResourceAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 action_type: str):
        """
        :param str action: The action to take when autoscaling is triggered.
        :param str action_type: The type of resource action.
        """
        AutoScalingConfigurationPolicyResourceAction._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            action_type=action_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             action_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'actionType' in kwargs:
            action_type = kwargs['actionType']

        _setter("action", action)
        _setter("action_type", action_type)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class AutoScalingConfigurationPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 action: Optional['outputs.AutoScalingConfigurationPolicyRuleAction'] = None,
                 id: Optional[str] = None,
                 metric: Optional['outputs.AutoScalingConfigurationPolicyRuleMetric'] = None):
        """
        :param 'AutoScalingConfigurationPolicyRuleActionArgs' action: The action to take when autoscaling is triggered.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        :param 'AutoScalingConfigurationPolicyRuleMetricArgs' metric: Metric and threshold details for triggering an autoscaling action.
        """
        AutoScalingConfigurationPolicyRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            action=action,
            id=id,
            metric=metric,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             action: Optional['outputs.AutoScalingConfigurationPolicyRuleAction'] = None,
             id: Optional[str] = None,
             metric: Optional['outputs.AutoScalingConfigurationPolicyRuleMetric'] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']

        _setter("display_name", display_name)
        if action is not None:
            _setter("action", action)
        if id is not None:
            _setter("id", id)
        if metric is not None:
            _setter("metric", metric)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleAction']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metric(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleMetric']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleAction(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[int] = None):
        """
        :param str type: The type of action to take.
        :param int value: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        AutoScalingConfigurationPolicyRuleAction._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: Optional[str] = None,
             value: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if type is not None:
            _setter("type", type)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricType":
            suggest = "metric_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyRuleMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyRuleMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyRuleMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_type: Optional[str] = None,
                 threshold: Optional['outputs.AutoScalingConfigurationPolicyRuleMetricThreshold'] = None):
        AutoScalingConfigurationPolicyRuleMetric._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            metric_type=metric_type,
            threshold=threshold,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             metric_type: Optional[str] = None,
             threshold: Optional['outputs.AutoScalingConfigurationPolicyRuleMetricThreshold'] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'metricType' in kwargs:
            metric_type = kwargs['metricType']

        if metric_type is not None:
            _setter("metric_type", metric_type)
        if threshold is not None:
            _setter("threshold", threshold)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[str]:
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter
    def threshold(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleMetricThreshold']:
        return pulumi.get(self, "threshold")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleMetricThreshold(dict):
    def __init__(__self__, *,
                 operator: Optional[str] = None,
                 value: Optional[int] = None):
        """
        :param str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        :param int value: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        AutoScalingConfigurationPolicyRuleMetricThreshold._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            operator=operator,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             operator: Optional[str] = None,
             value: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if operator is not None:
            _setter("operator", operator)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationAutoScalingResourceResult(dict):
    def __init__(__self__, *,
                 id: str,
                 type: str):
        """
        :param str id: ID of the condition that is assigned after creation.
        :param str type: The type of action to take.
        """
        GetAutoScalingConfigurationAutoScalingResourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("id", id)
        _setter("type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence['outputs.GetAutoScalingConfigurationPolicyCapacityResult'],
                 display_name: str,
                 execution_schedules: Sequence['outputs.GetAutoScalingConfigurationPolicyExecutionScheduleResult'],
                 id: str,
                 is_enabled: bool,
                 policy_type: str,
                 resource_actions: Sequence['outputs.GetAutoScalingConfigurationPolicyResourceActionResult'],
                 rules: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleResult'],
                 time_created: str):
        """
        :param Sequence['GetAutoScalingConfigurationPolicyCapacityArgs'] capacities: The capacity requirements of the autoscaling policy.
        :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param Sequence['GetAutoScalingConfigurationPolicyExecutionScheduleArgs'] execution_schedules: The schedule for executing the autoscaling policy.
        :param str id: ID of the condition that is assigned after creation.
        :param bool is_enabled: Whether the autoscaling policy is enabled.
        :param str policy_type: The type of autoscaling policy.
        :param Sequence['GetAutoScalingConfigurationPolicyResourceActionArgs'] resource_actions: An action that can be executed against a resource.
        :param str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        GetAutoScalingConfigurationPolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            capacities=capacities,
            display_name=display_name,
            execution_schedules=execution_schedules,
            id=id,
            is_enabled=is_enabled,
            policy_type=policy_type,
            resource_actions=resource_actions,
            rules=rules,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             capacities: Sequence['outputs.GetAutoScalingConfigurationPolicyCapacityResult'],
             display_name: str,
             execution_schedules: Sequence['outputs.GetAutoScalingConfigurationPolicyExecutionScheduleResult'],
             id: str,
             is_enabled: bool,
             policy_type: str,
             resource_actions: Sequence['outputs.GetAutoScalingConfigurationPolicyResourceActionResult'],
             rules: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleResult'],
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'executionSchedules' in kwargs:
            execution_schedules = kwargs['executionSchedules']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']
        if 'policyType' in kwargs:
            policy_type = kwargs['policyType']
        if 'resourceActions' in kwargs:
            resource_actions = kwargs['resourceActions']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("capacities", capacities)
        _setter("display_name", display_name)
        _setter("execution_schedules", execution_schedules)
        _setter("id", id)
        _setter("is_enabled", is_enabled)
        _setter("policy_type", policy_type)
        _setter("resource_actions", resource_actions)
        _setter("rules", rules)
        _setter("time_created", time_created)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyCapacityResult']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionSchedules")
    def execution_schedules(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyExecutionScheduleResult']:
        """
        The schedule for executing the autoscaling policy.
        """
        return pulumi.get(self, "execution_schedules")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="resourceActions")
    def resource_actions(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyResourceActionResult']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_actions")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleResult']:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyCapacityResult(dict):
    def __init__(__self__, *,
                 initial: int,
                 max: int,
                 min: int):
        """
        :param int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        :param int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        :param int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        GetAutoScalingConfigurationPolicyCapacityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            initial=initial,
            max=max,
            min=min,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             initial: int,
             max: int,
             min: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("initial", initial)
        _setter("max", max)
        _setter("min", min)

    @property
    @pulumi.getter
    def initial(self) -> int:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def max(self) -> int:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> int:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyExecutionScheduleResult(dict):
    def __init__(__self__, *,
                 expression: str,
                 timezone: str,
                 type: str):
        """
        :param str expression: A cron expression that represents the time at which to execute the autoscaling policy.
        :param str timezone: The time zone for the execution schedule.
        :param str type: The type of action to take.
        """
        GetAutoScalingConfigurationPolicyExecutionScheduleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            expression=expression,
            timezone=timezone,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             expression: str,
             timezone: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("expression", expression)
        _setter("timezone", timezone)
        _setter("type", type)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyResourceActionResult(dict):
    def __init__(__self__, *,
                 action: str,
                 action_type: str):
        """
        :param str action: The action to take when autoscaling is triggered.
        :param str action_type: The type of resource action.
        """
        GetAutoScalingConfigurationPolicyResourceActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            action_type=action_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             action_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'actionType' in kwargs:
            action_type = kwargs['actionType']

        _setter("action", action)
        _setter("action_type", action_type)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleActionResult'],
                 display_name: str,
                 id: str,
                 metrics: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricResult']):
        """
        :param Sequence['GetAutoScalingConfigurationPolicyRuleActionArgs'] actions: The action to take when autoscaling is triggered.
        :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param str id: ID of the condition that is assigned after creation.
        :param Sequence['GetAutoScalingConfigurationPolicyRuleMetricArgs'] metrics: Metric and threshold details for triggering an autoscaling action.
        """
        GetAutoScalingConfigurationPolicyRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actions=actions,
            display_name=display_name,
            id=id,
            metrics=metrics,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actions: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleActionResult'],
             display_name: str,
             id: str,
             metrics: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']

        _setter("actions", actions)
        _setter("display_name", display_name)
        _setter("id", id)
        _setter("metrics", metrics)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleActionResult']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricResult']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: int):
        """
        :param str type: The type of action to take.
        """
        GetAutoScalingConfigurationPolicyRuleActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             value: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("type", type)
        _setter("value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleMetricResult(dict):
    def __init__(__self__, *,
                 metric_type: str,
                 thresholds: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricThresholdResult']):
        GetAutoScalingConfigurationPolicyRuleMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            metric_type=metric_type,
            thresholds=thresholds,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             metric_type: str,
             thresholds: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricThresholdResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'metricType' in kwargs:
            metric_type = kwargs['metricType']

        _setter("metric_type", metric_type)
        _setter("thresholds", thresholds)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> str:
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter
    def thresholds(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricThresholdResult']:
        return pulumi.get(self, "thresholds")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleMetricThresholdResult(dict):
    def __init__(__self__, *,
                 operator: str,
                 value: int):
        """
        :param str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        GetAutoScalingConfigurationPolicyRuleMetricThresholdResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            operator=operator,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             operator: str,
             value: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("operator", operator)
        _setter("value", value)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationResult(dict):
    def __init__(__self__, *,
                 auto_scaling_resources: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult'],
                 compartment_id: str,
                 cool_down_in_seconds: int,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_enabled: bool,
                 max_resource_count: int,
                 min_resource_count: int,
                 policies: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult'],
                 time_created: str):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceArgs'] auto_scaling_resources: A resource that is managed by an autoscaling configuration. The only supported type is "instancePool."
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.
        :param int cool_down_in_seconds: For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: ID of the condition that is assigned after creation.
        :param bool is_enabled: Whether the autoscaling policy is enabled.
        :param int max_resource_count: The maximum number of resources to scale out to.
        :param int min_resource_count: The minimum number of resources to scale in to.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyArgs'] policies: Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        :param str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            auto_scaling_resources=auto_scaling_resources,
            compartment_id=compartment_id,
            cool_down_in_seconds=cool_down_in_seconds,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_enabled=is_enabled,
            max_resource_count=max_resource_count,
            min_resource_count=min_resource_count,
            policies=policies,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             auto_scaling_resources: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult'],
             compartment_id: str,
             cool_down_in_seconds: int,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_enabled: bool,
             max_resource_count: int,
             min_resource_count: int,
             policies: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult'],
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'autoScalingResources' in kwargs:
            auto_scaling_resources = kwargs['autoScalingResources']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'coolDownInSeconds' in kwargs:
            cool_down_in_seconds = kwargs['coolDownInSeconds']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']
        if 'maxResourceCount' in kwargs:
            max_resource_count = kwargs['maxResourceCount']
        if 'minResourceCount' in kwargs:
            min_resource_count = kwargs['minResourceCount']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("auto_scaling_resources", auto_scaling_resources)
        _setter("compartment_id", compartment_id)
        _setter("cool_down_in_seconds", cool_down_in_seconds)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_enabled", is_enabled)
        _setter("max_resource_count", max_resource_count)
        _setter("min_resource_count", min_resource_count)
        _setter("policies", policies)
        _setter("time_created", time_created)

    @property
    @pulumi.getter(name="autoScalingResources")
    def auto_scaling_resources(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult']:
        """
        A resource that is managed by an autoscaling configuration. The only supported type is "instancePool."
        """
        return pulumi.get(self, "auto_scaling_resources")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="coolDownInSeconds")
    def cool_down_in_seconds(self) -> int:
        """
        For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
        """
        return pulumi.get(self, "cool_down_in_seconds")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxResourceCount")
    def max_resource_count(self) -> int:
        """
        The maximum number of resources to scale out to.
        """
        return pulumi.get(self, "max_resource_count")

    @property
    @pulumi.getter(name="minResourceCount")
    def min_resource_count(self) -> int:
        """
        The minimum number of resources to scale in to.
        """
        return pulumi.get(self, "min_resource_count")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult']:
        """
        Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult(dict):
    def __init__(__self__, *,
                 id: str,
                 type: str):
        """
        :param str id: ID of the condition that is assigned after creation.
        :param str type: The type of action to take.
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("id", id)
        _setter("type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult'],
                 display_name: str,
                 execution_schedules: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult'],
                 id: str,
                 is_enabled: bool,
                 policy_type: str,
                 resource_actions: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult'],
                 rules: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult'],
                 time_created: str):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityArgs'] capacities: The capacity requirements of the autoscaling policy.
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleArgs'] execution_schedules: The schedule for executing the autoscaling policy.
        :param str id: ID of the condition that is assigned after creation.
        :param bool is_enabled: Whether the autoscaling policy is enabled.
        :param str policy_type: The type of autoscaling policy.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionArgs'] resource_actions: An action that can be executed against a resource.
        :param str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            capacities=capacities,
            display_name=display_name,
            execution_schedules=execution_schedules,
            id=id,
            is_enabled=is_enabled,
            policy_type=policy_type,
            resource_actions=resource_actions,
            rules=rules,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             capacities: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult'],
             display_name: str,
             execution_schedules: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult'],
             id: str,
             is_enabled: bool,
             policy_type: str,
             resource_actions: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult'],
             rules: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult'],
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'executionSchedules' in kwargs:
            execution_schedules = kwargs['executionSchedules']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']
        if 'policyType' in kwargs:
            policy_type = kwargs['policyType']
        if 'resourceActions' in kwargs:
            resource_actions = kwargs['resourceActions']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("capacities", capacities)
        _setter("display_name", display_name)
        _setter("execution_schedules", execution_schedules)
        _setter("id", id)
        _setter("is_enabled", is_enabled)
        _setter("policy_type", policy_type)
        _setter("resource_actions", resource_actions)
        _setter("rules", rules)
        _setter("time_created", time_created)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionSchedules")
    def execution_schedules(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult']:
        """
        The schedule for executing the autoscaling policy.
        """
        return pulumi.get(self, "execution_schedules")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="resourceActions")
    def resource_actions(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_actions")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult']:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult(dict):
    def __init__(__self__, *,
                 initial: int,
                 max: int,
                 min: int):
        """
        :param int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        :param int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        :param int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            initial=initial,
            max=max,
            min=min,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             initial: int,
             max: int,
             min: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("initial", initial)
        _setter("max", max)
        _setter("min", min)

    @property
    @pulumi.getter
    def initial(self) -> int:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def max(self) -> int:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> int:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult(dict):
    def __init__(__self__, *,
                 expression: str,
                 timezone: str,
                 type: str):
        """
        :param str expression: A cron expression that represents the time at which to execute the autoscaling policy.
        :param str timezone: The time zone for the execution schedule.
        :param str type: The type of action to take.
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            expression=expression,
            timezone=timezone,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             expression: str,
             timezone: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("expression", expression)
        _setter("timezone", timezone)
        _setter("type", type)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult(dict):
    def __init__(__self__, *,
                 action: str,
                 action_type: str):
        """
        :param str action: The action to take when autoscaling is triggered.
        :param str action_type: The type of resource action.
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            action_type=action_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             action_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'actionType' in kwargs:
            action_type = kwargs['actionType']

        _setter("action", action)
        _setter("action_type", action_type)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult'],
                 display_name: str,
                 id: str,
                 metrics: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult']):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionArgs'] actions: The action to take when autoscaling is triggered.
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param str id: ID of the condition that is assigned after creation.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricArgs'] metrics: Metric and threshold details for triggering an autoscaling action.
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actions=actions,
            display_name=display_name,
            id=id,
            metrics=metrics,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actions: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult'],
             display_name: str,
             id: str,
             metrics: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']

        _setter("actions", actions)
        _setter("display_name", display_name)
        _setter("id", id)
        _setter("metrics", metrics)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: int):
        """
        :param str type: The type of action to take.
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             value: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("type", type)
        _setter("value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult(dict):
    def __init__(__self__, *,
                 metric_type: str,
                 thresholds: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult']):
        GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            metric_type=metric_type,
            thresholds=thresholds,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             metric_type: str,
             thresholds: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'metricType' in kwargs:
            metric_type = kwargs['metricType']

        _setter("metric_type", metric_type)
        _setter("thresholds", thresholds)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> str:
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter
    def thresholds(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult']:
        return pulumi.get(self, "thresholds")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult(dict):
    def __init__(__self__, *,
                 operator: str,
                 value: int):
        """
        :param str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            operator=operator,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             operator: str,
             value: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("operator", operator)
        _setter("value", value)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAutoScalingConfigurationsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


