# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAlertRulesAlertRuleResult',
    'GetAlertRulesFilterResult',
    'GetBudgetsBudgetResult',
    'GetBudgetsFilterResult',
]

@pulumi.output_type
class GetAlertRulesAlertRuleResult(dict):
    def __init__(__self__, *,
                 budget_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 message: str,
                 recipients: str,
                 state: str,
                 threshold: float,
                 threshold_type: str,
                 time_created: str,
                 time_updated: str,
                 type: str,
                 version: int):
        """
        :param str budget_id: The unique budget OCID.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: The description of the alert rule.
        :param str display_name: A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The OCID of the alert rule.
        :param str message: The custom message that will be sent when the alert is triggered.
        :param str recipients: The delimited list of email addresses to receive the alert when it triggers. Delimiter characters can be a comma, space, TAB, or semicolon.
        :param str state: The current state of the resource to filter by.
        :param float threshold: The threshold for triggering the alert. If the thresholdType is PERCENTAGE, the maximum value is 10000.
        :param str threshold_type: The type of threshold.
        :param str time_created: The time when the budget was created.
        :param str time_updated: The time when the budget was updated.
        :param str type: The type of the alert. Valid values are ACTUAL (the alert triggers based on actual usage), or FORECAST (the alert triggers based on predicted usage).
        :param int version: The version of the alert rule. Starts from 1 and increments by 1.
        """
        GetAlertRulesAlertRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            budget_id=budget_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            message=message,
            recipients=recipients,
            state=state,
            threshold=threshold,
            threshold_type=threshold_type,
            time_created=time_created,
            time_updated=time_updated,
            type=type,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             budget_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             message: str,
             recipients: str,
             state: str,
             threshold: float,
             threshold_type: str,
             time_created: str,
             time_updated: str,
             type: str,
             version: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'budgetId' in kwargs:
            budget_id = kwargs['budgetId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'thresholdType' in kwargs:
            threshold_type = kwargs['thresholdType']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("budget_id", budget_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("message", message)
        _setter("recipients", recipients)
        _setter("state", state)
        _setter("threshold", threshold)
        _setter("threshold_type", threshold_type)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("type", type)
        _setter("version", version)

    @property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> str:
        """
        The unique budget OCID.
        """
        return pulumi.get(self, "budget_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the alert rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the alert rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The custom message that will be sent when the alert is triggered.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recipients(self) -> str:
        """
        The delimited list of email addresses to receive the alert when it triggers. Delimiter characters can be a comma, space, TAB, or semicolon.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the resource to filter by.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The threshold for triggering the alert. If the thresholdType is PERCENTAGE, the maximum value is 10000.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> str:
        """
        The type of threshold.
        """
        return pulumi.get(self, "threshold_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the budget was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the alert. Valid values are ACTUAL (the alert triggers based on actual usage), or FORECAST (the alert triggers based on predicted usage).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the alert rule. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAlertRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAlertRulesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetBudgetsBudgetResult(dict):
    def __init__(__self__, *,
                 actual_spend: float,
                 alert_rule_count: int,
                 amount: int,
                 budget_processing_period_start_offset: int,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 end_date: str,
                 forecasted_spend: float,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 processing_period_type: str,
                 reset_period: str,
                 start_date: str,
                 state: str,
                 target_compartment_id: str,
                 target_type: str,
                 targets: Sequence[str],
                 time_created: str,
                 time_spend_computed: str,
                 time_updated: str,
                 version: int):
        """
        :param float actual_spend: The actual spend in currency for the current budget cycle.
        :param int alert_rule_count: The total number of alert rules in the budget.
        :param int amount: The amount of the budget, expressed in the currency of the customer's rate card.
        :param int budget_processing_period_start_offset: The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: The description of the budget.
        :param str display_name: A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        :param str end_date: The time when the one-time budget concludes. For example, - `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param float forecasted_spend: The forecasted spend in currency by the end of the current budget cycle.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The OCID of the budget.
        :param str processing_period_type: The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        :param str reset_period: The reset period for the budget.
        :param str start_date: The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param str state: The current state of the resource to filter by.
        :param str target_compartment_id: This is DEPRECATED. For backwards compatability, the property is populated when the targetType is "COMPARTMENT", and targets contain the specific target compartment OCID. For all other scenarios, this property will be left empty.
        :param str target_type: The type of target to filter by:
               * ALL - List all budgets
               * COMPARTMENT - List all budgets with targetType == "COMPARTMENT"
               * TAG - List all budgets with targetType == "TAG"
        :param Sequence[str] targets: The list of targets on which the budget is applied. If the targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If the targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}".
        :param str time_created: The time that the budget was created.
        :param str time_spend_computed: The time that the budget spend was last computed.
        :param str time_updated: The time that the budget was updated.
        :param int version: The version of the budget. Starts from 1 and increments by 1.
        """
        GetBudgetsBudgetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actual_spend=actual_spend,
            alert_rule_count=alert_rule_count,
            amount=amount,
            budget_processing_period_start_offset=budget_processing_period_start_offset,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            end_date=end_date,
            forecasted_spend=forecasted_spend,
            freeform_tags=freeform_tags,
            id=id,
            processing_period_type=processing_period_type,
            reset_period=reset_period,
            start_date=start_date,
            state=state,
            target_compartment_id=target_compartment_id,
            target_type=target_type,
            targets=targets,
            time_created=time_created,
            time_spend_computed=time_spend_computed,
            time_updated=time_updated,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actual_spend: float,
             alert_rule_count: int,
             amount: int,
             budget_processing_period_start_offset: int,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             end_date: str,
             forecasted_spend: float,
             freeform_tags: Mapping[str, Any],
             id: str,
             processing_period_type: str,
             reset_period: str,
             start_date: str,
             state: str,
             target_compartment_id: str,
             target_type: str,
             targets: Sequence[str],
             time_created: str,
             time_spend_computed: str,
             time_updated: str,
             version: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'actualSpend' in kwargs:
            actual_spend = kwargs['actualSpend']
        if 'alertRuleCount' in kwargs:
            alert_rule_count = kwargs['alertRuleCount']
        if 'budgetProcessingPeriodStartOffset' in kwargs:
            budget_processing_period_start_offset = kwargs['budgetProcessingPeriodStartOffset']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'endDate' in kwargs:
            end_date = kwargs['endDate']
        if 'forecastedSpend' in kwargs:
            forecasted_spend = kwargs['forecastedSpend']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'processingPeriodType' in kwargs:
            processing_period_type = kwargs['processingPeriodType']
        if 'resetPeriod' in kwargs:
            reset_period = kwargs['resetPeriod']
        if 'startDate' in kwargs:
            start_date = kwargs['startDate']
        if 'targetCompartmentId' in kwargs:
            target_compartment_id = kwargs['targetCompartmentId']
        if 'targetType' in kwargs:
            target_type = kwargs['targetType']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeSpendComputed' in kwargs:
            time_spend_computed = kwargs['timeSpendComputed']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("actual_spend", actual_spend)
        _setter("alert_rule_count", alert_rule_count)
        _setter("amount", amount)
        _setter("budget_processing_period_start_offset", budget_processing_period_start_offset)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("end_date", end_date)
        _setter("forecasted_spend", forecasted_spend)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("processing_period_type", processing_period_type)
        _setter("reset_period", reset_period)
        _setter("start_date", start_date)
        _setter("state", state)
        _setter("target_compartment_id", target_compartment_id)
        _setter("target_type", target_type)
        _setter("targets", targets)
        _setter("time_created", time_created)
        _setter("time_spend_computed", time_spend_computed)
        _setter("time_updated", time_updated)
        _setter("version", version)

    @property
    @pulumi.getter(name="actualSpend")
    def actual_spend(self) -> float:
        """
        The actual spend in currency for the current budget cycle.
        """
        return pulumi.get(self, "actual_spend")

    @property
    @pulumi.getter(name="alertRuleCount")
    def alert_rule_count(self) -> int:
        """
        The total number of alert rules in the budget.
        """
        return pulumi.get(self, "alert_rule_count")

    @property
    @pulumi.getter
    def amount(self) -> int:
        """
        The amount of the budget, expressed in the currency of the customer's rate card.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="budgetProcessingPeriodStartOffset")
    def budget_processing_period_start_offset(self) -> int:
        """
        The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        """
        return pulumi.get(self, "budget_processing_period_start_offset")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the budget.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        The time when the one-time budget concludes. For example, - `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="forecastedSpend")
    def forecasted_spend(self) -> float:
        """
        The forecasted spend in currency by the end of the current budget cycle.
        """
        return pulumi.get(self, "forecasted_spend")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the budget.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="processingPeriodType")
    def processing_period_type(self) -> str:
        """
        The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        """
        return pulumi.get(self, "processing_period_type")

    @property
    @pulumi.getter(name="resetPeriod")
    def reset_period(self) -> str:
        """
        The reset period for the budget.
        """
        return pulumi.get(self, "reset_period")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the resource to filter by.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> str:
        """
        This is DEPRECATED. For backwards compatability, the property is populated when the targetType is "COMPARTMENT", and targets contain the specific target compartment OCID. For all other scenarios, this property will be left empty.
        """
        warnings.warn("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""", DeprecationWarning)
        pulumi.log.warn("""target_compartment_id is deprecated: The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")

        return pulumi.get(self, "target_compartment_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> str:
        """
        The type of target to filter by:
        * ALL - List all budgets
        * COMPARTMENT - List all budgets with targetType == "COMPARTMENT"
        * TAG - List all budgets with targetType == "TAG"
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[str]:
        """
        The list of targets on which the budget is applied. If the targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If the targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}".
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time that the budget was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSpendComputed")
    def time_spend_computed(self) -> str:
        """
        The time that the budget spend was last computed.
        """
        return pulumi.get(self, "time_spend_computed")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time that the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the budget. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetBudgetsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetBudgetsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


