# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetProblemEntityResult',
    'AwaitableGetProblemEntityResult',
    'get_problem_entity',
    'get_problem_entity_output',
]

@pulumi.output_type
class GetProblemEntityResult:
    """
    A collection of values returned by getProblemEntity.
    """
    def __init__(__self__, id=None, items=None, problem_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if problem_id and not isinstance(problem_id, str):
            raise TypeError("Expected argument 'problem_id' to be a str")
        pulumi.set(__self__, "problem_id", problem_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProblemEntityItemResult']:
        """
        List of problem entities summaries related to a data source.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="problemId")
    def problem_id(self) -> str:
        """
        Attached problem id
        """
        return pulumi.get(self, "problem_id")


class AwaitableGetProblemEntityResult(GetProblemEntityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProblemEntityResult(
            id=self.id,
            items=self.items,
            problem_id=self.problem_id)


def get_problem_entity(problem_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProblemEntityResult:
    """
    This data source provides details about a specific Problem Entity resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of entities for a CloudGuard Problem

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_problem_entity = oci.CloudGuard.get_problem_entity(problem_id=oci_cloud_guard_problem["test_problem"]["id"])
    ```


    :param str problem_id: OCId of the problem.
    """
    __args__ = dict()
    __args__['problemId'] = problem_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getProblemEntity:getProblemEntity', __args__, opts=opts, typ=GetProblemEntityResult).value

    return AwaitableGetProblemEntityResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        problem_id=pulumi.get(__ret__, 'problem_id'))


@_utilities.lift_output_func(get_problem_entity)
def get_problem_entity_output(problem_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProblemEntityResult]:
    """
    This data source provides details about a specific Problem Entity resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of entities for a CloudGuard Problem

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_problem_entity = oci.CloudGuard.get_problem_entity(problem_id=oci_cloud_guard_problem["test_problem"]["id"])
    ```


    :param str problem_id: OCId of the problem.
    """
    ...
