# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetContainerInstancesResult',
    'AwaitableGetContainerInstancesResult',
    'get_container_instances',
    'get_container_instances_output',
]

@pulumi.output_type
class GetContainerInstancesResult:
    """
    A collection of values returned by getContainerInstances.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, container_instance_collections=None, display_name=None, filters=None, id=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if container_instance_collections and not isinstance(container_instance_collections, list):
            raise TypeError("Expected argument 'container_instance_collections' to be a list")
        pulumi.set(__self__, "container_instance_collections", container_instance_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The availability domain to place the container instance.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="containerInstanceCollections")
    def container_instance_collections(self) -> Sequence['outputs.GetContainerInstancesContainerInstanceCollectionResult']:
        """
        The list of container_instance_collection.
        """
        return pulumi.get(self, "container_instance_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetContainerInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the container instance.
        """
        return pulumi.get(self, "state")


class AwaitableGetContainerInstancesResult(GetContainerInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerInstancesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            container_instance_collections=self.container_instance_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_container_instances(availability_domain: Optional[str] = None,
                            compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetContainerInstancesFilterArgs']]] = None,
                            state: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerInstancesResult:
    """
    This data source provides the list of Container Instances in Oracle Cloud Infrastructure Container Instances service.

    Returns a list of container instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_instances = oci.ContainerInstances.get_container_instances(compartment_id=var["compartment_id"],
        availability_domain=var["container_instance_availability_domain"],
        display_name=var["container_instance_display_name"],
        state=var["container_instance_state"])
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: A filter to only return resources that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerInstances/getContainerInstances:getContainerInstances', __args__, opts=opts, typ=GetContainerInstancesResult).value

    return AwaitableGetContainerInstancesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        container_instance_collections=pulumi.get(__ret__, 'container_instance_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_container_instances)
def get_container_instances_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                                   compartment_id: Optional[pulumi.Input[str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetContainerInstancesFilterArgs']]]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetContainerInstancesResult]:
    """
    This data source provides the list of Container Instances in Oracle Cloud Infrastructure Container Instances service.

    Returns a list of container instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_instances = oci.ContainerInstances.get_container_instances(compartment_id=var["compartment_id"],
        availability_domain=var["container_instance_availability_domain"],
        display_name=var["container_instance_display_name"],
        state=var["container_instance_state"])
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: A filter to only return resources that match the given lifecycle state.
    """
    ...
