# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPrivateIpsResult',
    'AwaitableGetPrivateIpsResult',
    'get_private_ips',
    'get_private_ips_output',
]

@pulumi.output_type
class GetPrivateIpsResult:
    """
    A collection of values returned by getPrivateIps.
    """
    def __init__(__self__, filters=None, id=None, ip_address=None, private_ips=None, subnet_id=None, vlan_id=None, vnic_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if private_ips and not isinstance(private_ips, list):
            raise TypeError("Expected argument 'private_ips' to be a list")
        pulumi.set(__self__, "private_ips", private_ips)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id and not isinstance(vlan_id, str):
            raise TypeError("Expected argument 'vlan_id' to be a str")
        pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id and not isinstance(vnic_id, str):
            raise TypeError("Expected argument 'vnic_id' to be a str")
        pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPrivateIpsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The private IP address of the `privateIp` object. The address is within the CIDR of the VNIC's subnet.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence['outputs.GetPrivateIpsPrivateIpResult']:
        """
        The list of private_ips.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the VNIC is in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[str]:
        """
        Applicable only if the `PrivateIp` object is being used with a VLAN as part of the Oracle Cloud VMware Solution. The `vlanId` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN. See [Vlan](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Vlan).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC the private IP is assigned to. The VNIC and private IP must be in the same subnet. However, if the `PrivateIp` object is being used with a VLAN as part of the Oracle Cloud VMware Solution, the `vnicId` is null.
        """
        return pulumi.get(self, "vnic_id")


class AwaitableGetPrivateIpsResult(GetPrivateIpsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateIpsResult(
            filters=self.filters,
            id=self.id,
            ip_address=self.ip_address,
            private_ips=self.private_ips,
            subnet_id=self.subnet_id,
            vlan_id=self.vlan_id,
            vnic_id=self.vnic_id)


def get_private_ips(filters: Optional[Sequence[pulumi.InputType['GetPrivateIpsFilterArgs']]] = None,
                    ip_address: Optional[str] = None,
                    subnet_id: Optional[str] = None,
                    vlan_id: Optional[str] = None,
                    vnic_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateIpsResult:
    """
    This data source provides the list of Private Ips in Oracle Cloud Infrastructure Core service.

    Lists the [PrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/PrivateIp/) objects based
    on one of these filters:

      - Subnet [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
      - VNIC [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
      - Both private IP address and subnet OCID: This lets
          you get a `privateIP` object based on its private IP
          address (for example, 10.0.3.3) and not its [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). For comparison,
          [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/PrivateIp/GetPrivateIp)
          requires the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    If you're listing all the private IPs associated with a given subnet
    or VNIC, the response includes both primary and secondary private IPs.

    If you are an Oracle Cloud VMware Solution customer and have VLANs
    in your VCN, you can filter the list by VLAN [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). See [Vlan](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Vlan).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_ips_by_subnet = oci.Core.get_private_ips(subnet_id=var["private_ip_subnet_id"])
    ```
    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_ips_by_vnic = oci.Core.get_private_ips(vnic_id=oci_core_vnic["test_vnic"]["id"])
    ```
    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_ips_by_ip_address = oci.Core.get_private_ips(ip_address=var["private_ip_ip_address"],
        subnet_id=oci_core_subnet["test_subnet"]["id"],
        vlan_id=oci_core_vlan["test_vlan"]["id"],
        vnic_id=oci_core_vnic_attachment["test_vnic_attachment"]["id"])
    ```


    :param str ip_address: An IP address. This could be either IPv4 or IPv6, depending on the resource. Example: `10.0.3.3`
    :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
    :param str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN.
    :param str vnic_id: The OCID of the VNIC.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipAddress'] = ip_address
    __args__['subnetId'] = subnet_id
    __args__['vlanId'] = vlan_id
    __args__['vnicId'] = vnic_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getPrivateIps:getPrivateIps', __args__, opts=opts, typ=GetPrivateIpsResult).value

    return AwaitableGetPrivateIpsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        private_ips=pulumi.get(__ret__, 'private_ips'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        vlan_id=pulumi.get(__ret__, 'vlan_id'),
        vnic_id=pulumi.get(__ret__, 'vnic_id'))


@_utilities.lift_output_func(get_private_ips)
def get_private_ips_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetPrivateIpsFilterArgs']]]]] = None,
                           ip_address: Optional[pulumi.Input[Optional[str]]] = None,
                           subnet_id: Optional[pulumi.Input[Optional[str]]] = None,
                           vlan_id: Optional[pulumi.Input[Optional[str]]] = None,
                           vnic_id: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPrivateIpsResult]:
    """
    This data source provides the list of Private Ips in Oracle Cloud Infrastructure Core service.

    Lists the [PrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/PrivateIp/) objects based
    on one of these filters:

      - Subnet [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
      - VNIC [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
      - Both private IP address and subnet OCID: This lets
          you get a `privateIP` object based on its private IP
          address (for example, 10.0.3.3) and not its [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). For comparison,
          [GetPrivateIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/PrivateIp/GetPrivateIp)
          requires the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    If you're listing all the private IPs associated with a given subnet
    or VNIC, the response includes both primary and secondary private IPs.

    If you are an Oracle Cloud VMware Solution customer and have VLANs
    in your VCN, you can filter the list by VLAN [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). See [Vlan](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Vlan).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_ips_by_subnet = oci.Core.get_private_ips(subnet_id=var["private_ip_subnet_id"])
    ```
    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_ips_by_vnic = oci.Core.get_private_ips(vnic_id=oci_core_vnic["test_vnic"]["id"])
    ```
    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_ips_by_ip_address = oci.Core.get_private_ips(ip_address=var["private_ip_ip_address"],
        subnet_id=oci_core_subnet["test_subnet"]["id"],
        vlan_id=oci_core_vlan["test_vlan"]["id"],
        vnic_id=oci_core_vnic_attachment["test_vnic_attachment"]["id"])
    ```


    :param str ip_address: An IP address. This could be either IPv4 or IPv6, depending on the resource. Example: `10.0.3.3`
    :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
    :param str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN.
    :param str vnic_id: The OCID of the VNIC.
    """
    ...
