# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPublicIpsResult',
    'AwaitableGetPublicIpsResult',
    'get_public_ips',
    'get_public_ips_output',
]

@pulumi.output_type
class GetPublicIpsResult:
    """
    A collection of values returned by getPublicIps.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, id=None, lifetime=None, public_ip_pool_id=None, public_ips=None, scope=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifetime and not isinstance(lifetime, str):
            raise TypeError("Expected argument 'lifetime' to be a str")
        pulumi.set(__self__, "lifetime", lifetime)
        if public_ip_pool_id and not isinstance(public_ip_pool_id, str):
            raise TypeError("Expected argument 'public_ip_pool_id' to be a str")
        pulumi.set(__self__, "public_ip_pool_id", public_ip_pool_id)
        if public_ips and not isinstance(public_ips, list):
            raise TypeError("Expected argument 'public_ips' to be a list")
        pulumi.set(__self__, "public_ips", public_ips)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The public IP's availability domain. This property is set only for ephemeral public IPs that are assigned to a private IP (that is, when the `scope` of the public IP is set to AVAILABILITY_DOMAIN). The value is the availability domain of the assigned private IP.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the public IP. For an ephemeral public IP, this is the compartment of its assigned entity (which can be a private IP or a regional entity such as a NAT gateway). For a reserved public IP that is currently assigned, its compartment can be different from the assigned private IP's.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPublicIpsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[str]:
        """
        Defines when the public IP is deleted and released back to Oracle's public IP pool.
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter(name="publicIpPoolId")
    def public_ip_pool_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pool object created in the current tenancy.
        """
        return pulumi.get(self, "public_ip_pool_id")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence['outputs.GetPublicIpsPublicIpResult']:
        """
        The list of public_ips.
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Whether the public IP is regional or specific to a particular availability domain.
        """
        return pulumi.get(self, "scope")


class AwaitableGetPublicIpsResult(GetPublicIpsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicIpsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            lifetime=self.lifetime,
            public_ip_pool_id=self.public_ip_pool_id,
            public_ips=self.public_ips,
            scope=self.scope)


def get_public_ips(availability_domain: Optional[str] = None,
                   compartment_id: Optional[str] = None,
                   filters: Optional[Sequence[pulumi.InputType['GetPublicIpsFilterArgs']]] = None,
                   lifetime: Optional[str] = None,
                   public_ip_pool_id: Optional[str] = None,
                   scope: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicIpsResult:
    """
    This data source provides the list of Public Ips in Oracle Cloud Infrastructure Core service.

    Lists the [PublicIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/PublicIp/) objects
    in the specified compartment. You can filter the list by using query parameters.

    To list your reserved public IPs:
      * Set `scope` = `REGION`  (required)
      * Leave the `availabilityDomain` parameter empty
      * Set `lifetime` = `RESERVED`

    To list the ephemeral public IPs assigned to a regional entity such as a NAT gateway:
      * Set `scope` = `REGION`  (required)
      * Leave the `availabilityDomain` parameter empty
      * Set `lifetime` = `EPHEMERAL`

    To list the ephemeral public IPs assigned to private IPs:
      * Set `scope` = `AVAILABILITY_DOMAIN` (required)
      * Set the `availabilityDomain` parameter to the desired availability domain (required)
      * Set `lifetime` = `EPHEMERAL`

    **Note:** An ephemeral public IP assigned to a private IP
    is always in the same availability domain and compartment as the private IP.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_ips = oci.Core.get_public_ips(compartment_id=var["compartment_id"],
        scope=var["public_ip_scope"],
        availability_domain=var["public_ip_availability_domain"],
        lifetime=var["public_ip_lifetime"],
        public_ip_pool_id=oci_core_public_ip_pool["test_public_ip_pool"]["id"])
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str lifetime: A filter to return only public IPs that match given lifetime.
    :param str public_ip_pool_id: A filter to return only resources that belong to the given public IP pool.
    :param str scope: Whether the public IP is regional or specific to a particular availability domain.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['lifetime'] = lifetime
    __args__['publicIpPoolId'] = public_ip_pool_id
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getPublicIps:getPublicIps', __args__, opts=opts, typ=GetPublicIpsResult).value

    return AwaitableGetPublicIpsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifetime=pulumi.get(__ret__, 'lifetime'),
        public_ip_pool_id=pulumi.get(__ret__, 'public_ip_pool_id'),
        public_ips=pulumi.get(__ret__, 'public_ips'),
        scope=pulumi.get(__ret__, 'scope'))


@_utilities.lift_output_func(get_public_ips)
def get_public_ips_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                          compartment_id: Optional[pulumi.Input[str]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetPublicIpsFilterArgs']]]]] = None,
                          lifetime: Optional[pulumi.Input[Optional[str]]] = None,
                          public_ip_pool_id: Optional[pulumi.Input[Optional[str]]] = None,
                          scope: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublicIpsResult]:
    """
    This data source provides the list of Public Ips in Oracle Cloud Infrastructure Core service.

    Lists the [PublicIp](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/PublicIp/) objects
    in the specified compartment. You can filter the list by using query parameters.

    To list your reserved public IPs:
      * Set `scope` = `REGION`  (required)
      * Leave the `availabilityDomain` parameter empty
      * Set `lifetime` = `RESERVED`

    To list the ephemeral public IPs assigned to a regional entity such as a NAT gateway:
      * Set `scope` = `REGION`  (required)
      * Leave the `availabilityDomain` parameter empty
      * Set `lifetime` = `EPHEMERAL`

    To list the ephemeral public IPs assigned to private IPs:
      * Set `scope` = `AVAILABILITY_DOMAIN` (required)
      * Set the `availabilityDomain` parameter to the desired availability domain (required)
      * Set `lifetime` = `EPHEMERAL`

    **Note:** An ephemeral public IP assigned to a private IP
    is always in the same availability domain and compartment as the private IP.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_ips = oci.Core.get_public_ips(compartment_id=var["compartment_id"],
        scope=var["public_ip_scope"],
        availability_domain=var["public_ip_availability_domain"],
        lifetime=var["public_ip_lifetime"],
        public_ip_pool_id=oci_core_public_ip_pool["test_public_ip_pool"]["id"])
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str lifetime: A filter to return only public IPs that match given lifetime.
    :param str public_ip_pool_id: A filter to return only resources that belong to the given public IP pool.
    :param str scope: Whether the public IP is regional or specific to a particular availability domain.
    """
    ...
