# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ShapeManagementArgs', 'ShapeManagement']

@pulumi.input_type
class ShapeManagementArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 shape_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a ShapeManagement resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment containing the image.
        :param pulumi.Input[str] image_id: The OCID of the Image to which the shape should be added.
        :param pulumi.Input[str] shape_name: The compatible shape that is to be added to the compatible shapes list for the image.
        """
        ShapeManagementArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            image_id=image_id,
            shape_name=shape_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             image_id: pulumi.Input[str],
             shape_name: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'shapeName' in kwargs:
            shape_name = kwargs['shapeName']

        _setter("compartment_id", compartment_id)
        _setter("image_id", image_id)
        _setter("shape_name", shape_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment containing the image.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The OCID of the Image to which the shape should be added.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Input[str]:
        """
        The compatible shape that is to be added to the compatible shapes list for the image.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape_name", value)


@pulumi.input_type
class _ShapeManagementState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ShapeManagement resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment containing the image.
        :param pulumi.Input[str] image_id: The OCID of the Image to which the shape should be added.
        :param pulumi.Input[str] shape_name: The compatible shape that is to be added to the compatible shapes list for the image.
        """
        _ShapeManagementState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            image_id=image_id,
            shape_name=shape_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             image_id: Optional[pulumi.Input[str]] = None,
             shape_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'shapeName' in kwargs:
            shape_name = kwargs['shapeName']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if image_id is not None:
            _setter("image_id", image_id)
        if shape_name is not None:
            _setter("shape_name", shape_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment containing the image.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Image to which the shape should be added.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        The compatible shape that is to be added to the compatible shapes list for the image.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape_name", value)


class ShapeManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Shape Management resource in Oracle Cloud Infrastructure Core service.

        Add/Remove the specified shape from the compatible shapes list for the image.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment containing the image.
        :param pulumi.Input[str] image_id: The OCID of the Image to which the shape should be added.
        :param pulumi.Input[str] shape_name: The compatible shape that is to be added to the compatible shapes list for the image.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ShapeManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Shape Management resource in Oracle Cloud Infrastructure Core service.

        Add/Remove the specified shape from the compatible shapes list for the image.

        :param str resource_name: The name of the resource.
        :param ShapeManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ShapeManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ShapeManagementArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ShapeManagementArgs.__new__(ShapeManagementArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            if shape_name is None and not opts.urn:
                raise TypeError("Missing required property 'shape_name'")
            __props__.__dict__["shape_name"] = shape_name
        super(ShapeManagement, __self__).__init__(
            'oci:Core/shapeManagement:ShapeManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            shape_name: Optional[pulumi.Input[str]] = None) -> 'ShapeManagement':
        """
        Get an existing ShapeManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment containing the image.
        :param pulumi.Input[str] image_id: The OCID of the Image to which the shape should be added.
        :param pulumi.Input[str] shape_name: The compatible shape that is to be added to the compatible shapes list for the image.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ShapeManagementState.__new__(_ShapeManagementState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["shape_name"] = shape_name
        return ShapeManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment containing the image.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Image to which the shape should be added.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Output[str]:
        """
        The compatible shape that is to be added to the compatible shapes list for the image.
        """
        return pulumi.get(self, "shape_name")

