# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutonomousDatabaseBackupResult',
    'AwaitableGetAutonomousDatabaseBackupResult',
    'get_autonomous_database_backup',
    'get_autonomous_database_backup_output',
]

@pulumi.output_type
class GetAutonomousDatabaseBackupResult:
    """
    A collection of values returned by getAutonomousDatabaseBackup.
    """
    def __init__(__self__, autonomous_database_backup_id=None, autonomous_database_id=None, backup_destination_details=None, compartment_id=None, database_size_in_tbs=None, db_version=None, display_name=None, id=None, is_automatic=None, is_long_term_backup=None, is_restorable=None, key_store_id=None, key_store_wallet_name=None, kms_key_id=None, kms_key_version_id=None, lifecycle_details=None, retention_period_in_days=None, size_in_tbs=None, state=None, time_available_till=None, time_ended=None, time_started=None, type=None, vault_id=None):
        if autonomous_database_backup_id and not isinstance(autonomous_database_backup_id, str):
            raise TypeError("Expected argument 'autonomous_database_backup_id' to be a str")
        pulumi.set(__self__, "autonomous_database_backup_id", autonomous_database_backup_id)
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if backup_destination_details and not isinstance(backup_destination_details, list):
            raise TypeError("Expected argument 'backup_destination_details' to be a list")
        pulumi.set(__self__, "backup_destination_details", backup_destination_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_size_in_tbs and not isinstance(database_size_in_tbs, float):
            raise TypeError("Expected argument 'database_size_in_tbs' to be a float")
        pulumi.set(__self__, "database_size_in_tbs", database_size_in_tbs)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_automatic and not isinstance(is_automatic, bool):
            raise TypeError("Expected argument 'is_automatic' to be a bool")
        pulumi.set(__self__, "is_automatic", is_automatic)
        if is_long_term_backup and not isinstance(is_long_term_backup, bool):
            raise TypeError("Expected argument 'is_long_term_backup' to be a bool")
        pulumi.set(__self__, "is_long_term_backup", is_long_term_backup)
        if is_restorable and not isinstance(is_restorable, bool):
            raise TypeError("Expected argument 'is_restorable' to be a bool")
        pulumi.set(__self__, "is_restorable", is_restorable)
        if key_store_id and not isinstance(key_store_id, str):
            raise TypeError("Expected argument 'key_store_id' to be a str")
        pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name and not isinstance(key_store_wallet_name, str):
            raise TypeError("Expected argument 'key_store_wallet_name' to be a str")
        pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id and not isinstance(kms_key_version_id, str):
            raise TypeError("Expected argument 'kms_key_version_id' to be a str")
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if retention_period_in_days and not isinstance(retention_period_in_days, int):
            raise TypeError("Expected argument 'retention_period_in_days' to be a int")
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if size_in_tbs and not isinstance(size_in_tbs, float):
            raise TypeError("Expected argument 'size_in_tbs' to be a float")
        pulumi.set(__self__, "size_in_tbs", size_in_tbs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_available_till and not isinstance(time_available_till, str):
            raise TypeError("Expected argument 'time_available_till' to be a str")
        pulumi.set(__self__, "time_available_till", time_available_till)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="autonomousDatabaseBackupId")
    def autonomous_database_backup_id(self) -> str:
        return pulumi.get(self, "autonomous_database_backup_id")

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter(name="backupDestinationDetails")
    def backup_destination_details(self) -> Sequence['outputs.GetAutonomousDatabaseBackupBackupDestinationDetailResult']:
        """
        Backup destination details
        """
        return pulumi.get(self, "backup_destination_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseSizeInTbs")
    def database_size_in_tbs(self) -> float:
        """
        The size of the database in terabytes at the time the backup was taken.
        """
        return pulumi.get(self, "database_size_in_tbs")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        A valid Oracle Database version for Autonomous Database.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the backup. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutomatic")
    def is_automatic(self) -> bool:
        """
        Indicates whether the backup is user-initiated or automatic.
        """
        return pulumi.get(self, "is_automatic")

    @property
    @pulumi.getter(name="isLongTermBackup")
    def is_long_term_backup(self) -> bool:
        return pulumi.get(self, "is_long_term_backup")

    @property
    @pulumi.getter(name="isRestorable")
    def is_restorable(self) -> bool:
        """
        Indicates whether the backup can be used to restore the associated Autonomous Database.
        """
        return pulumi.get(self, "is_restorable")

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        """
        return pulumi.get(self, "key_store_id")

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> str:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> str:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> int:
        """
        Retention period, in days, for long-term backups
        """
        return pulumi.get(self, "retention_period_in_days")

    @property
    @pulumi.getter(name="sizeInTbs")
    def size_in_tbs(self) -> float:
        """
        The backup size in terrabytes (TB).
        """
        return pulumi.get(self, "size_in_tbs")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAvailableTill")
    def time_available_till(self) -> str:
        """
        Timestamp until when the backup will be available
        """
        return pulumi.get(self, "time_available_till")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The date and time the backup completed.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time the backup started.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of backup.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "vault_id")


class AwaitableGetAutonomousDatabaseBackupResult(GetAutonomousDatabaseBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseBackupResult(
            autonomous_database_backup_id=self.autonomous_database_backup_id,
            autonomous_database_id=self.autonomous_database_id,
            backup_destination_details=self.backup_destination_details,
            compartment_id=self.compartment_id,
            database_size_in_tbs=self.database_size_in_tbs,
            db_version=self.db_version,
            display_name=self.display_name,
            id=self.id,
            is_automatic=self.is_automatic,
            is_long_term_backup=self.is_long_term_backup,
            is_restorable=self.is_restorable,
            key_store_id=self.key_store_id,
            key_store_wallet_name=self.key_store_wallet_name,
            kms_key_id=self.kms_key_id,
            kms_key_version_id=self.kms_key_version_id,
            lifecycle_details=self.lifecycle_details,
            retention_period_in_days=self.retention_period_in_days,
            size_in_tbs=self.size_in_tbs,
            state=self.state,
            time_available_till=self.time_available_till,
            time_ended=self.time_ended,
            time_started=self.time_started,
            type=self.type,
            vault_id=self.vault_id)


def get_autonomous_database_backup(autonomous_database_backup_id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseBackupResult:
    """
    This data source provides details about a specific Autonomous Database Backup resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Autonomous Database backup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_backup = oci.Database.get_autonomous_database_backup(autonomous_database_backup_id=oci_database_autonomous_database_backup["test_autonomous_database_backup"]["id"])
    ```


    :param str autonomous_database_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
    """
    __args__ = dict()
    __args__['autonomousDatabaseBackupId'] = autonomous_database_backup_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseBackup:getAutonomousDatabaseBackup', __args__, opts=opts, typ=GetAutonomousDatabaseBackupResult).value

    return AwaitableGetAutonomousDatabaseBackupResult(
        autonomous_database_backup_id=pulumi.get(__ret__, 'autonomous_database_backup_id'),
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        backup_destination_details=pulumi.get(__ret__, 'backup_destination_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_size_in_tbs=pulumi.get(__ret__, 'database_size_in_tbs'),
        db_version=pulumi.get(__ret__, 'db_version'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        is_automatic=pulumi.get(__ret__, 'is_automatic'),
        is_long_term_backup=pulumi.get(__ret__, 'is_long_term_backup'),
        is_restorable=pulumi.get(__ret__, 'is_restorable'),
        key_store_id=pulumi.get(__ret__, 'key_store_id'),
        key_store_wallet_name=pulumi.get(__ret__, 'key_store_wallet_name'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        kms_key_version_id=pulumi.get(__ret__, 'kms_key_version_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        retention_period_in_days=pulumi.get(__ret__, 'retention_period_in_days'),
        size_in_tbs=pulumi.get(__ret__, 'size_in_tbs'),
        state=pulumi.get(__ret__, 'state'),
        time_available_till=pulumi.get(__ret__, 'time_available_till'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'),
        type=pulumi.get(__ret__, 'type'),
        vault_id=pulumi.get(__ret__, 'vault_id'))


@_utilities.lift_output_func(get_autonomous_database_backup)
def get_autonomous_database_backup_output(autonomous_database_backup_id: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDatabaseBackupResult]:
    """
    This data source provides details about a specific Autonomous Database Backup resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Autonomous Database backup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_backup = oci.Database.get_autonomous_database_backup(autonomous_database_backup_id=oci_database_autonomous_database_backup["test_autonomous_database_backup"]["id"])
    ```


    :param str autonomous_database_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
    """
    ...
