# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseSoftwareImagesResult',
    'AwaitableGetDatabaseSoftwareImagesResult',
    'get_database_software_images',
    'get_database_software_images_output',
]

@pulumi.output_type
class GetDatabaseSoftwareImagesResult:
    """
    A collection of values returned by getDatabaseSoftwareImages.
    """
    def __init__(__self__, compartment_id=None, database_software_images=None, display_name=None, filters=None, id=None, image_shape_family=None, image_type=None, is_upgrade_supported=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_software_images and not isinstance(database_software_images, list):
            raise TypeError("Expected argument 'database_software_images' to be a list")
        pulumi.set(__self__, "database_software_images", database_software_images)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_shape_family and not isinstance(image_shape_family, str):
            raise TypeError("Expected argument 'image_shape_family' to be a str")
        pulumi.set(__self__, "image_shape_family", image_shape_family)
        if image_type and not isinstance(image_type, str):
            raise TypeError("Expected argument 'image_type' to be a str")
        pulumi.set(__self__, "image_type", image_type)
        if is_upgrade_supported and not isinstance(is_upgrade_supported, bool):
            raise TypeError("Expected argument 'is_upgrade_supported' to be a bool")
        pulumi.set(__self__, "is_upgrade_supported", is_upgrade_supported)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseSoftwareImages")
    def database_software_images(self) -> Sequence['outputs.GetDatabaseSoftwareImagesDatabaseSoftwareImageResult']:
        """
        The list of database_software_images.
        """
        return pulumi.get(self, "database_software_images")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the database software image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseSoftwareImagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> Optional[str]:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[str]:
        """
        The type of software image. Can be grid or database.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="isUpgradeSupported")
    def is_upgrade_supported(self) -> Optional[bool]:
        """
        True if this Database software image is supported for Upgrade.
        """
        return pulumi.get(self, "is_upgrade_supported")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the database software image.
        """
        return pulumi.get(self, "state")


class AwaitableGetDatabaseSoftwareImagesResult(GetDatabaseSoftwareImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseSoftwareImagesResult(
            compartment_id=self.compartment_id,
            database_software_images=self.database_software_images,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            image_shape_family=self.image_shape_family,
            image_type=self.image_type,
            is_upgrade_supported=self.is_upgrade_supported,
            state=self.state)


def get_database_software_images(compartment_id: Optional[str] = None,
                                 display_name: Optional[str] = None,
                                 filters: Optional[Sequence[pulumi.InputType['GetDatabaseSoftwareImagesFilterArgs']]] = None,
                                 image_shape_family: Optional[str] = None,
                                 image_type: Optional[str] = None,
                                 is_upgrade_supported: Optional[bool] = None,
                                 state: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseSoftwareImagesResult:
    """
    This data source provides the list of Database Software Images in Oracle Cloud Infrastructure Database service.

    Gets a list of the database software images in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_software_images = oci.Database.get_database_software_images(compartment_id=var["compartment_id"],
        display_name=var["database_software_image_display_name"],
        image_shape_family=var["database_software_image_image_shape_family"],
        image_type=var["database_software_image_image_type"],
        is_upgrade_supported=var["database_software_image_is_upgrade_supported"],
        state=var["database_software_image_state"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str image_shape_family: A filter to return only resources that match the given image shape family exactly.
    :param str image_type: A filter to return only resources that match the given image type exactly.
    :param bool is_upgrade_supported: If provided, filters the results to the set of database versions which are supported for Upgrade.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['imageShapeFamily'] = image_shape_family
    __args__['imageType'] = image_type
    __args__['isUpgradeSupported'] = is_upgrade_supported
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabaseSoftwareImages:getDatabaseSoftwareImages', __args__, opts=opts, typ=GetDatabaseSoftwareImagesResult).value

    return AwaitableGetDatabaseSoftwareImagesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_software_images=pulumi.get(__ret__, 'database_software_images'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_shape_family=pulumi.get(__ret__, 'image_shape_family'),
        image_type=pulumi.get(__ret__, 'image_type'),
        is_upgrade_supported=pulumi.get(__ret__, 'is_upgrade_supported'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_database_software_images)
def get_database_software_images_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDatabaseSoftwareImagesFilterArgs']]]]] = None,
                                        image_shape_family: Optional[pulumi.Input[Optional[str]]] = None,
                                        image_type: Optional[pulumi.Input[Optional[str]]] = None,
                                        is_upgrade_supported: Optional[pulumi.Input[Optional[bool]]] = None,
                                        state: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseSoftwareImagesResult]:
    """
    This data source provides the list of Database Software Images in Oracle Cloud Infrastructure Database service.

    Gets a list of the database software images in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_software_images = oci.Database.get_database_software_images(compartment_id=var["compartment_id"],
        display_name=var["database_software_image_display_name"],
        image_shape_family=var["database_software_image_image_shape_family"],
        image_type=var["database_software_image_image_type"],
        is_upgrade_supported=var["database_software_image_is_upgrade_supported"],
        state=var["database_software_image_state"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str image_shape_family: A filter to return only resources that match the given image shape family exactly.
    :param str image_type: A filter to return only resources that match the given image type exactly.
    :param bool is_upgrade_supported: If provided, filters the results to the set of database versions which are supported for Upgrade.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    ...
