# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVmClusterUpdatesResult',
    'AwaitableGetVmClusterUpdatesResult',
    'get_vm_cluster_updates',
    'get_vm_cluster_updates_output',
]

@pulumi.output_type
class GetVmClusterUpdatesResult:
    """
    A collection of values returned by getVmClusterUpdates.
    """
    def __init__(__self__, filters=None, id=None, state=None, update_type=None, vm_cluster_id=None, vm_cluster_updates=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_type and not isinstance(update_type, str):
            raise TypeError("Expected argument 'update_type' to be a str")
        pulumi.set(__self__, "update_type", update_type)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)
        if vm_cluster_updates and not isinstance(vm_cluster_updates, list):
            raise TypeError("Expected argument 'vm_cluster_updates' to be a list")
        pulumi.set(__self__, "vm_cluster_updates", vm_cluster_updates)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVmClusterUpdatesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the maintenance update. Dependent on value of `lastAction`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateType")
    def update_type(self) -> Optional[str]:
        """
        The type of VM cluster maintenance update.
        """
        return pulumi.get(self, "update_type")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> str:
        return pulumi.get(self, "vm_cluster_id")

    @property
    @pulumi.getter(name="vmClusterUpdates")
    def vm_cluster_updates(self) -> Sequence['outputs.GetVmClusterUpdatesVmClusterUpdateResult']:
        """
        The list of vm_cluster_updates.
        """
        return pulumi.get(self, "vm_cluster_updates")


class AwaitableGetVmClusterUpdatesResult(GetVmClusterUpdatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterUpdatesResult(
            filters=self.filters,
            id=self.id,
            state=self.state,
            update_type=self.update_type,
            vm_cluster_id=self.vm_cluster_id,
            vm_cluster_updates=self.vm_cluster_updates)


def get_vm_cluster_updates(filters: Optional[Sequence[pulumi.InputType['GetVmClusterUpdatesFilterArgs']]] = None,
                           state: Optional[str] = None,
                           update_type: Optional[str] = None,
                           vm_cluster_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterUpdatesResult:
    """
    This data source provides the list of Vm Cluster Updates in Oracle Cloud Infrastructure Database service.

    Lists the maintenance updates that can be applied to the specified VM cluster. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_updates = oci.Database.get_vm_cluster_updates(vm_cluster_id=oci_database_vm_cluster["test_vm_cluster"]["id"],
        state=var["vm_cluster_update_state"],
        update_type=var["vm_cluster_update_update_type"])
    ```


    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str update_type: A filter to return only resources that match the given update type exactly.
    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['updateType'] = update_type
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusterUpdates:getVmClusterUpdates', __args__, opts=opts, typ=GetVmClusterUpdatesResult).value

    return AwaitableGetVmClusterUpdatesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        update_type=pulumi.get(__ret__, 'update_type'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'),
        vm_cluster_updates=pulumi.get(__ret__, 'vm_cluster_updates'))


@_utilities.lift_output_func(get_vm_cluster_updates)
def get_vm_cluster_updates_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVmClusterUpdatesFilterArgs']]]]] = None,
                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                  update_type: Optional[pulumi.Input[Optional[str]]] = None,
                                  vm_cluster_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVmClusterUpdatesResult]:
    """
    This data source provides the list of Vm Cluster Updates in Oracle Cloud Infrastructure Database service.

    Lists the maintenance updates that can be applied to the specified VM cluster. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_updates = oci.Database.get_vm_cluster_updates(vm_cluster_id=oci_database_vm_cluster["test_vm_cluster"]["id"],
        state=var["vm_cluster_update_state"],
        update_type=var["vm_cluster_update_update_type"])
    ```


    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str update_type: A filter to return only resources that match the given update type exactly.
    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
