# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalDbSystemsResult',
    'AwaitableGetExternalDbSystemsResult',
    'get_external_db_systems',
    'get_external_db_systems_output',
]

@pulumi.output_type
class GetExternalDbSystemsResult:
    """
    A collection of values returned by getExternalDbSystems.
    """
    def __init__(__self__, compartment_id=None, display_name=None, external_db_system_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_db_system_collections and not isinstance(external_db_system_collections, list):
            raise TypeError("Expected argument 'external_db_system_collections' to be a list")
        pulumi.set(__self__, "external_db_system_collections", external_db_system_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalDbSystemCollections")
    def external_db_system_collections(self) -> Sequence['outputs.GetExternalDbSystemsExternalDbSystemCollectionResult']:
        """
        The list of external_db_system_collection.
        """
        return pulumi.get(self, "external_db_system_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalDbSystemsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetExternalDbSystemsResult(GetExternalDbSystemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalDbSystemsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            external_db_system_collections=self.external_db_system_collections,
            filters=self.filters,
            id=self.id)


def get_external_db_systems(compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetExternalDbSystemsFilterArgs']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalDbSystemsResult:
    """
    This data source provides the list of External Db Systems in Oracle Cloud Infrastructure Database Management service.

    Lists the external DB systems in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_systems = oci.DatabaseManagement.get_external_db_systems(compartment_id=var["compartment_id"],
        display_name=var["external_db_system_display_name"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to only return the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalDbSystems:getExternalDbSystems', __args__, opts=opts, typ=GetExternalDbSystemsResult).value

    return AwaitableGetExternalDbSystemsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_db_system_collections=pulumi.get(__ret__, 'external_db_system_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_external_db_systems)
def get_external_db_systems_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetExternalDbSystemsFilterArgs']]]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalDbSystemsResult]:
    """
    This data source provides the list of External Db Systems in Oracle Cloud Infrastructure Database Management service.

    Lists the external DB systems in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_systems = oci.DatabaseManagement.get_external_db_systems(compartment_id=var["compartment_id"],
        display_name=var["external_db_system_display_name"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to only return the resources that match the entire display name.
    """
    ...
