# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseSqlPlanBaselinesResult',
    'AwaitableGetManagedDatabaseSqlPlanBaselinesResult',
    'get_managed_database_sql_plan_baselines',
    'get_managed_database_sql_plan_baselines_output',
]

@pulumi.output_type
class GetManagedDatabaseSqlPlanBaselinesResult:
    """
    A collection of values returned by getManagedDatabaseSqlPlanBaselines.
    """
    def __init__(__self__, filters=None, id=None, is_accepted=None, is_adaptive=None, is_enabled=None, is_fixed=None, is_reproduced=None, limit=None, managed_database_id=None, origin=None, plan_name=None, sql_handle=None, sql_plan_baseline_collections=None, sql_text=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_accepted and not isinstance(is_accepted, bool):
            raise TypeError("Expected argument 'is_accepted' to be a bool")
        pulumi.set(__self__, "is_accepted", is_accepted)
        if is_adaptive and not isinstance(is_adaptive, bool):
            raise TypeError("Expected argument 'is_adaptive' to be a bool")
        pulumi.set(__self__, "is_adaptive", is_adaptive)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_fixed and not isinstance(is_fixed, bool):
            raise TypeError("Expected argument 'is_fixed' to be a bool")
        pulumi.set(__self__, "is_fixed", is_fixed)
        if is_reproduced and not isinstance(is_reproduced, bool):
            raise TypeError("Expected argument 'is_reproduced' to be a bool")
        pulumi.set(__self__, "is_reproduced", is_reproduced)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if origin and not isinstance(origin, str):
            raise TypeError("Expected argument 'origin' to be a str")
        pulumi.set(__self__, "origin", origin)
        if plan_name and not isinstance(plan_name, str):
            raise TypeError("Expected argument 'plan_name' to be a str")
        pulumi.set(__self__, "plan_name", plan_name)
        if sql_handle and not isinstance(sql_handle, str):
            raise TypeError("Expected argument 'sql_handle' to be a str")
        pulumi.set(__self__, "sql_handle", sql_handle)
        if sql_plan_baseline_collections and not isinstance(sql_plan_baseline_collections, list):
            raise TypeError("Expected argument 'sql_plan_baseline_collections' to be a list")
        pulumi.set(__self__, "sql_plan_baseline_collections", sql_plan_baseline_collections)
        if sql_text and not isinstance(sql_text, str):
            raise TypeError("Expected argument 'sql_text' to be a str")
        pulumi.set(__self__, "sql_text", sql_text)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseSqlPlanBaselinesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAccepted")
    def is_accepted(self) -> Optional[bool]:
        return pulumi.get(self, "is_accepted")

    @property
    @pulumi.getter(name="isAdaptive")
    def is_adaptive(self) -> Optional[bool]:
        return pulumi.get(self, "is_adaptive")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isFixed")
    def is_fixed(self) -> Optional[bool]:
        return pulumi.get(self, "is_fixed")

    @property
    @pulumi.getter(name="isReproduced")
    def is_reproduced(self) -> Optional[bool]:
        return pulumi.get(self, "is_reproduced")

    @property
    @pulumi.getter
    def limit(self) -> Optional[int]:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def origin(self) -> Optional[str]:
        """
        The origin of the SQL plan baseline.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="planName")
    def plan_name(self) -> Optional[str]:
        """
        The unique plan identifier.
        """
        return pulumi.get(self, "plan_name")

    @property
    @pulumi.getter(name="sqlHandle")
    def sql_handle(self) -> Optional[str]:
        """
        The unique SQL identifier.
        """
        return pulumi.get(self, "sql_handle")

    @property
    @pulumi.getter(name="sqlPlanBaselineCollections")
    def sql_plan_baseline_collections(self) -> Sequence['outputs.GetManagedDatabaseSqlPlanBaselinesSqlPlanBaselineCollectionResult']:
        """
        The list of sql_plan_baseline_collection.
        """
        return pulumi.get(self, "sql_plan_baseline_collections")

    @property
    @pulumi.getter(name="sqlText")
    def sql_text(self) -> Optional[str]:
        """
        The SQL text.
        """
        return pulumi.get(self, "sql_text")


class AwaitableGetManagedDatabaseSqlPlanBaselinesResult(GetManagedDatabaseSqlPlanBaselinesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseSqlPlanBaselinesResult(
            filters=self.filters,
            id=self.id,
            is_accepted=self.is_accepted,
            is_adaptive=self.is_adaptive,
            is_enabled=self.is_enabled,
            is_fixed=self.is_fixed,
            is_reproduced=self.is_reproduced,
            limit=self.limit,
            managed_database_id=self.managed_database_id,
            origin=self.origin,
            plan_name=self.plan_name,
            sql_handle=self.sql_handle,
            sql_plan_baseline_collections=self.sql_plan_baseline_collections,
            sql_text=self.sql_text)


def get_managed_database_sql_plan_baselines(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseSqlPlanBaselinesFilterArgs']]] = None,
                                            is_accepted: Optional[bool] = None,
                                            is_adaptive: Optional[bool] = None,
                                            is_enabled: Optional[bool] = None,
                                            is_fixed: Optional[bool] = None,
                                            is_reproduced: Optional[bool] = None,
                                            limit: Optional[int] = None,
                                            managed_database_id: Optional[str] = None,
                                            origin: Optional[str] = None,
                                            plan_name: Optional[str] = None,
                                            sql_handle: Optional[str] = None,
                                            sql_text: Optional[str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseSqlPlanBaselinesResult:
    """
    This data source provides the list of Managed Database Sql Plan Baselines in Oracle Cloud Infrastructure Database Management service.

    Lists the SQL plan baselines for the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_plan_baselines = oci.DatabaseManagement.get_managed_database_sql_plan_baselines(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        is_accepted=var["managed_database_sql_plan_baseline_is_accepted"],
        is_adaptive=var["managed_database_sql_plan_baseline_is_adaptive"],
        is_enabled=var["managed_database_sql_plan_baseline_is_enabled"],
        is_fixed=var["managed_database_sql_plan_baseline_is_fixed"],
        is_reproduced=var["managed_database_sql_plan_baseline_is_reproduced"],
        origin=var["managed_database_sql_plan_baseline_origin"],
        plan_name=var["managed_database_sql_plan_baseline_plan_name"],
        sql_handle=var["managed_database_sql_plan_baseline_sql_handle"],
        sql_text=var["managed_database_sql_plan_baseline_sql_text"])
    ```


    :param bool is_accepted: A filter to return only SQL plan baselines that are either accepted or not accepted. By default, all SQL plan baselines are returned.
    :param bool is_adaptive: A filter to return only SQL plan baselines that are either adaptive or not adaptive. By default, all SQL plan baselines are returned.
    :param bool is_enabled: A filter to return only SQL plan baselines that are either enabled or not enabled. By default, all SQL plan baselines are returned.
    :param bool is_fixed: A filter to return only SQL plan baselines that are either fixed or not fixed. By default, all SQL plan baselines are returned.
    :param bool is_reproduced: A filter to return only SQL plan baselines that were either reproduced or not reproduced by the optimizer. By default, all SQL plan baselines are returned.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str origin: A filter to return all the SQL plan baselines that match the origin.
    :param str plan_name: A filter to return only SQL plan baselines that match the plan name.
    :param str sql_handle: A filter to return all the SQL plan baselines for the specified SQL handle.
    :param str sql_text: A filter to return all the SQL plan baselines that match the SQL text. By default, the search is case insensitive. To run an exact or case-sensitive search, double-quote the search string. You may also use the '%' symbol as a wildcard.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['isAccepted'] = is_accepted
    __args__['isAdaptive'] = is_adaptive
    __args__['isEnabled'] = is_enabled
    __args__['isFixed'] = is_fixed
    __args__['isReproduced'] = is_reproduced
    __args__['limit'] = limit
    __args__['managedDatabaseId'] = managed_database_id
    __args__['origin'] = origin
    __args__['planName'] = plan_name
    __args__['sqlHandle'] = sql_handle
    __args__['sqlText'] = sql_text
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseSqlPlanBaselines:getManagedDatabaseSqlPlanBaselines', __args__, opts=opts, typ=GetManagedDatabaseSqlPlanBaselinesResult).value

    return AwaitableGetManagedDatabaseSqlPlanBaselinesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_accepted=pulumi.get(__ret__, 'is_accepted'),
        is_adaptive=pulumi.get(__ret__, 'is_adaptive'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        is_fixed=pulumi.get(__ret__, 'is_fixed'),
        is_reproduced=pulumi.get(__ret__, 'is_reproduced'),
        limit=pulumi.get(__ret__, 'limit'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        origin=pulumi.get(__ret__, 'origin'),
        plan_name=pulumi.get(__ret__, 'plan_name'),
        sql_handle=pulumi.get(__ret__, 'sql_handle'),
        sql_plan_baseline_collections=pulumi.get(__ret__, 'sql_plan_baseline_collections'),
        sql_text=pulumi.get(__ret__, 'sql_text'))


@_utilities.lift_output_func(get_managed_database_sql_plan_baselines)
def get_managed_database_sql_plan_baselines_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseSqlPlanBaselinesFilterArgs']]]]] = None,
                                                   is_accepted: Optional[pulumi.Input[Optional[bool]]] = None,
                                                   is_adaptive: Optional[pulumi.Input[Optional[bool]]] = None,
                                                   is_enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                                                   is_fixed: Optional[pulumi.Input[Optional[bool]]] = None,
                                                   is_reproduced: Optional[pulumi.Input[Optional[bool]]] = None,
                                                   limit: Optional[pulumi.Input[Optional[int]]] = None,
                                                   managed_database_id: Optional[pulumi.Input[str]] = None,
                                                   origin: Optional[pulumi.Input[Optional[str]]] = None,
                                                   plan_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                   sql_handle: Optional[pulumi.Input[Optional[str]]] = None,
                                                   sql_text: Optional[pulumi.Input[Optional[str]]] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseSqlPlanBaselinesResult]:
    """
    This data source provides the list of Managed Database Sql Plan Baselines in Oracle Cloud Infrastructure Database Management service.

    Lists the SQL plan baselines for the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_plan_baselines = oci.DatabaseManagement.get_managed_database_sql_plan_baselines(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        is_accepted=var["managed_database_sql_plan_baseline_is_accepted"],
        is_adaptive=var["managed_database_sql_plan_baseline_is_adaptive"],
        is_enabled=var["managed_database_sql_plan_baseline_is_enabled"],
        is_fixed=var["managed_database_sql_plan_baseline_is_fixed"],
        is_reproduced=var["managed_database_sql_plan_baseline_is_reproduced"],
        origin=var["managed_database_sql_plan_baseline_origin"],
        plan_name=var["managed_database_sql_plan_baseline_plan_name"],
        sql_handle=var["managed_database_sql_plan_baseline_sql_handle"],
        sql_text=var["managed_database_sql_plan_baseline_sql_text"])
    ```


    :param bool is_accepted: A filter to return only SQL plan baselines that are either accepted or not accepted. By default, all SQL plan baselines are returned.
    :param bool is_adaptive: A filter to return only SQL plan baselines that are either adaptive or not adaptive. By default, all SQL plan baselines are returned.
    :param bool is_enabled: A filter to return only SQL plan baselines that are either enabled or not enabled. By default, all SQL plan baselines are returned.
    :param bool is_fixed: A filter to return only SQL plan baselines that are either fixed or not fixed. By default, all SQL plan baselines are returned.
    :param bool is_reproduced: A filter to return only SQL plan baselines that were either reproduced or not reproduced by the optimizer. By default, all SQL plan baselines are returned.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str origin: A filter to return all the SQL plan baselines that match the origin.
    :param str plan_name: A filter to return only SQL plan baselines that match the plan name.
    :param str sql_handle: A filter to return all the SQL plan baselines for the specified SQL handle.
    :param str sql_text: A filter to return all the SQL plan baselines that match the SQL text. By default, the search is case insensitive. To run an exact or case-sensitive search, double-quote the search string. You may also use the '%' symbol as a wildcard.
    """
    ...
