# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DiscoveryModArgs', 'DiscoveryMod']

@pulumi.input_type
class DiscoveryModArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 sensitive_data_model_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DiscoveryMod resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the discovery job resource should be created.
        :param pulumi.Input[str] sensitive_data_model_id: The OCID of the sensitive data model.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] discovery_type: The type of the discovery job. It defines the job's scope. NEW identifies new sensitive columns in the target database that are not in the sensitive data model. DELETED identifies columns that are present in the sensitive data model but have been deleted from the target database. MODIFIED identifies columns that are present in the target database as well as the sensitive data model but some of their attributes have been modified. ALL covers all the above three scenarios and reports new, deleted and modified columns.
        :param pulumi.Input[str] display_name: A user-friendly name for the discovery job. Does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_app_defined_relation_discovery_enabled: Indicates if the discovery job should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[bool] is_include_all_schemas: Indicates if all the schemas should be scanned by the discovery job. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        :param pulumi.Input[bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by the discovery job. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        :param pulumi.Input[bool] is_sample_data_collection_enabled: Indicates if the discovery job should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas_for_discoveries: The schemas to be scanned by the discovery job. If not provided, the schemasForDiscovery attribute of the sensitive data model is used to get the list of schemas.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sensitive_type_ids_for_discoveries: The OCIDs of the sensitive types to be used by the discovery job. If not provided, the sensitiveTypeIdsForDiscovery attribute of the sensitive data model is used to get the list of sensitive types. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        DiscoveryModArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            sensitive_data_model_id=sensitive_data_model_id,
            defined_tags=defined_tags,
            discovery_type=discovery_type,
            display_name=display_name,
            freeform_tags=freeform_tags,
            is_app_defined_relation_discovery_enabled=is_app_defined_relation_discovery_enabled,
            is_include_all_schemas=is_include_all_schemas,
            is_include_all_sensitive_types=is_include_all_sensitive_types,
            is_sample_data_collection_enabled=is_sample_data_collection_enabled,
            schemas_for_discoveries=schemas_for_discoveries,
            sensitive_type_ids_for_discoveries=sensitive_type_ids_for_discoveries,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             sensitive_data_model_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             discovery_type: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
             is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
             is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
             is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
             schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'sensitiveDataModelId' in kwargs:
            sensitive_data_model_id = kwargs['sensitiveDataModelId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'discoveryType' in kwargs:
            discovery_type = kwargs['discoveryType']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isAppDefinedRelationDiscoveryEnabled' in kwargs:
            is_app_defined_relation_discovery_enabled = kwargs['isAppDefinedRelationDiscoveryEnabled']
        if 'isIncludeAllSchemas' in kwargs:
            is_include_all_schemas = kwargs['isIncludeAllSchemas']
        if 'isIncludeAllSensitiveTypes' in kwargs:
            is_include_all_sensitive_types = kwargs['isIncludeAllSensitiveTypes']
        if 'isSampleDataCollectionEnabled' in kwargs:
            is_sample_data_collection_enabled = kwargs['isSampleDataCollectionEnabled']
        if 'schemasForDiscoveries' in kwargs:
            schemas_for_discoveries = kwargs['schemasForDiscoveries']
        if 'sensitiveTypeIdsForDiscoveries' in kwargs:
            sensitive_type_ids_for_discoveries = kwargs['sensitiveTypeIdsForDiscoveries']

        _setter("compartment_id", compartment_id)
        _setter("sensitive_data_model_id", sensitive_data_model_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if discovery_type is not None:
            _setter("discovery_type", discovery_type)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_app_defined_relation_discovery_enabled is not None:
            _setter("is_app_defined_relation_discovery_enabled", is_app_defined_relation_discovery_enabled)
        if is_include_all_schemas is not None:
            _setter("is_include_all_schemas", is_include_all_schemas)
        if is_include_all_sensitive_types is not None:
            _setter("is_include_all_sensitive_types", is_include_all_sensitive_types)
        if is_sample_data_collection_enabled is not None:
            _setter("is_sample_data_collection_enabled", is_sample_data_collection_enabled)
        if schemas_for_discoveries is not None:
            _setter("schemas_for_discoveries", schemas_for_discoveries)
        if sensitive_type_ids_for_discoveries is not None:
            _setter("sensitive_type_ids_for_discoveries", sensitive_type_ids_for_discoveries)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment where the discovery job resource should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> pulumi.Input[str]:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @sensitive_data_model_id.setter
    def sensitive_data_model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sensitive_data_model_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the discovery job. It defines the job's scope. NEW identifies new sensitive columns in the target database that are not in the sensitive data model. DELETED identifies columns that are present in the sensitive data model but have been deleted from the target database. MODIFIED identifies columns that are present in the target database as well as the sensitive data model but some of their attributes have been modified. ALL covers all the above three scenarios and reports new, deleted and modified columns.
        """
        return pulumi.get(self, "discovery_type")

    @discovery_type.setter
    def discovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the discovery job. Does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the discovery job should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @is_app_defined_relation_discovery_enabled.setter
    def is_app_defined_relation_discovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_app_defined_relation_discovery_enabled", value)

    @property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if all the schemas should be scanned by the discovery job. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        """
        return pulumi.get(self, "is_include_all_schemas")

    @is_include_all_schemas.setter
    def is_include_all_schemas(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_include_all_schemas", value)

    @property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if all the existing sensitive types should be used by the discovery job. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @is_include_all_sensitive_types.setter
    def is_include_all_sensitive_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_include_all_sensitive_types", value)

    @property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the discovery job should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @is_sample_data_collection_enabled.setter
    def is_sample_data_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_sample_data_collection_enabled", value)

    @property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The schemas to be scanned by the discovery job. If not provided, the schemasForDiscovery attribute of the sensitive data model is used to get the list of schemas.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @schemas_for_discoveries.setter
    def schemas_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas_for_discoveries", value)

    @property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The OCIDs of the sensitive types to be used by the discovery job. If not provided, the sensitiveTypeIdsForDiscovery attribute of the sensitive data model is used to get the list of sensitive types. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @sensitive_type_ids_for_discoveries.setter
    def sensitive_type_ids_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sensitive_type_ids_for_discoveries", value)


@pulumi.input_type
class _DiscoveryModState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 time_finished: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None,
                 total_columns_scanned: Optional[pulumi.Input[str]] = None,
                 total_deleted_sensitive_columns: Optional[pulumi.Input[str]] = None,
                 total_modified_sensitive_columns: Optional[pulumi.Input[str]] = None,
                 total_new_sensitive_columns: Optional[pulumi.Input[str]] = None,
                 total_objects_scanned: Optional[pulumi.Input[str]] = None,
                 total_schemas_scanned: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DiscoveryMod resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the discovery job resource should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] discovery_type: The type of the discovery job. It defines the job's scope. NEW identifies new sensitive columns in the target database that are not in the sensitive data model. DELETED identifies columns that are present in the sensitive data model but have been deleted from the target database. MODIFIED identifies columns that are present in the target database as well as the sensitive data model but some of their attributes have been modified. ALL covers all the above three scenarios and reports new, deleted and modified columns.
        :param pulumi.Input[str] display_name: A user-friendly name for the discovery job. Does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_app_defined_relation_discovery_enabled: Indicates if the discovery job should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[bool] is_include_all_schemas: Indicates if all the schemas should be scanned by the discovery job. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        :param pulumi.Input[bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by the discovery job. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        :param pulumi.Input[bool] is_sample_data_collection_enabled: Indicates if the discovery job should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas_for_discoveries: The schemas to be scanned by the discovery job. If not provided, the schemasForDiscovery attribute of the sensitive data model is used to get the list of schemas.
        :param pulumi.Input[str] sensitive_data_model_id: The OCID of the sensitive data model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sensitive_type_ids_for_discoveries: The OCIDs of the sensitive types to be used by the discovery job. If not provided, the sensitiveTypeIdsForDiscovery attribute of the sensitive data model is used to get the list of sensitive types. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the discovery job.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the target database associated with the discovery job.
        :param pulumi.Input[str] time_finished: The date and time the discovery job finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)..
        :param pulumi.Input[str] time_started: The date and time the discovery job started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] total_columns_scanned: The total number of columns scanned by the discovery job.
        :param pulumi.Input[str] total_deleted_sensitive_columns: The total number of deleted sensitive columns identified by the discovery job.
        :param pulumi.Input[str] total_modified_sensitive_columns: The total number of modified sensitive columns identified by the discovery job.
        :param pulumi.Input[str] total_new_sensitive_columns: The total number of new sensitive columns identified by the discovery job.
        :param pulumi.Input[str] total_objects_scanned: The total number of objects (tables and editioning views) scanned by the discovery job.
        :param pulumi.Input[str] total_schemas_scanned: The total number of schemas scanned by the discovery job.
        """
        _DiscoveryModState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            discovery_type=discovery_type,
            display_name=display_name,
            freeform_tags=freeform_tags,
            is_app_defined_relation_discovery_enabled=is_app_defined_relation_discovery_enabled,
            is_include_all_schemas=is_include_all_schemas,
            is_include_all_sensitive_types=is_include_all_sensitive_types,
            is_sample_data_collection_enabled=is_sample_data_collection_enabled,
            schemas_for_discoveries=schemas_for_discoveries,
            sensitive_data_model_id=sensitive_data_model_id,
            sensitive_type_ids_for_discoveries=sensitive_type_ids_for_discoveries,
            state=state,
            system_tags=system_tags,
            target_id=target_id,
            time_finished=time_finished,
            time_started=time_started,
            total_columns_scanned=total_columns_scanned,
            total_deleted_sensitive_columns=total_deleted_sensitive_columns,
            total_modified_sensitive_columns=total_modified_sensitive_columns,
            total_new_sensitive_columns=total_new_sensitive_columns,
            total_objects_scanned=total_objects_scanned,
            total_schemas_scanned=total_schemas_scanned,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             discovery_type: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
             is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
             is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
             is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
             schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
             sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             target_id: Optional[pulumi.Input[str]] = None,
             time_finished: Optional[pulumi.Input[str]] = None,
             time_started: Optional[pulumi.Input[str]] = None,
             total_columns_scanned: Optional[pulumi.Input[str]] = None,
             total_deleted_sensitive_columns: Optional[pulumi.Input[str]] = None,
             total_modified_sensitive_columns: Optional[pulumi.Input[str]] = None,
             total_new_sensitive_columns: Optional[pulumi.Input[str]] = None,
             total_objects_scanned: Optional[pulumi.Input[str]] = None,
             total_schemas_scanned: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'discoveryType' in kwargs:
            discovery_type = kwargs['discoveryType']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isAppDefinedRelationDiscoveryEnabled' in kwargs:
            is_app_defined_relation_discovery_enabled = kwargs['isAppDefinedRelationDiscoveryEnabled']
        if 'isIncludeAllSchemas' in kwargs:
            is_include_all_schemas = kwargs['isIncludeAllSchemas']
        if 'isIncludeAllSensitiveTypes' in kwargs:
            is_include_all_sensitive_types = kwargs['isIncludeAllSensitiveTypes']
        if 'isSampleDataCollectionEnabled' in kwargs:
            is_sample_data_collection_enabled = kwargs['isSampleDataCollectionEnabled']
        if 'schemasForDiscoveries' in kwargs:
            schemas_for_discoveries = kwargs['schemasForDiscoveries']
        if 'sensitiveDataModelId' in kwargs:
            sensitive_data_model_id = kwargs['sensitiveDataModelId']
        if 'sensitiveTypeIdsForDiscoveries' in kwargs:
            sensitive_type_ids_for_discoveries = kwargs['sensitiveTypeIdsForDiscoveries']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'targetId' in kwargs:
            target_id = kwargs['targetId']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeStarted' in kwargs:
            time_started = kwargs['timeStarted']
        if 'totalColumnsScanned' in kwargs:
            total_columns_scanned = kwargs['totalColumnsScanned']
        if 'totalDeletedSensitiveColumns' in kwargs:
            total_deleted_sensitive_columns = kwargs['totalDeletedSensitiveColumns']
        if 'totalModifiedSensitiveColumns' in kwargs:
            total_modified_sensitive_columns = kwargs['totalModifiedSensitiveColumns']
        if 'totalNewSensitiveColumns' in kwargs:
            total_new_sensitive_columns = kwargs['totalNewSensitiveColumns']
        if 'totalObjectsScanned' in kwargs:
            total_objects_scanned = kwargs['totalObjectsScanned']
        if 'totalSchemasScanned' in kwargs:
            total_schemas_scanned = kwargs['totalSchemasScanned']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if discovery_type is not None:
            _setter("discovery_type", discovery_type)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_app_defined_relation_discovery_enabled is not None:
            _setter("is_app_defined_relation_discovery_enabled", is_app_defined_relation_discovery_enabled)
        if is_include_all_schemas is not None:
            _setter("is_include_all_schemas", is_include_all_schemas)
        if is_include_all_sensitive_types is not None:
            _setter("is_include_all_sensitive_types", is_include_all_sensitive_types)
        if is_sample_data_collection_enabled is not None:
            _setter("is_sample_data_collection_enabled", is_sample_data_collection_enabled)
        if schemas_for_discoveries is not None:
            _setter("schemas_for_discoveries", schemas_for_discoveries)
        if sensitive_data_model_id is not None:
            _setter("sensitive_data_model_id", sensitive_data_model_id)
        if sensitive_type_ids_for_discoveries is not None:
            _setter("sensitive_type_ids_for_discoveries", sensitive_type_ids_for_discoveries)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if target_id is not None:
            _setter("target_id", target_id)
        if time_finished is not None:
            _setter("time_finished", time_finished)
        if time_started is not None:
            _setter("time_started", time_started)
        if total_columns_scanned is not None:
            _setter("total_columns_scanned", total_columns_scanned)
        if total_deleted_sensitive_columns is not None:
            _setter("total_deleted_sensitive_columns", total_deleted_sensitive_columns)
        if total_modified_sensitive_columns is not None:
            _setter("total_modified_sensitive_columns", total_modified_sensitive_columns)
        if total_new_sensitive_columns is not None:
            _setter("total_new_sensitive_columns", total_new_sensitive_columns)
        if total_objects_scanned is not None:
            _setter("total_objects_scanned", total_objects_scanned)
        if total_schemas_scanned is not None:
            _setter("total_schemas_scanned", total_schemas_scanned)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment where the discovery job resource should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the discovery job. It defines the job's scope. NEW identifies new sensitive columns in the target database that are not in the sensitive data model. DELETED identifies columns that are present in the sensitive data model but have been deleted from the target database. MODIFIED identifies columns that are present in the target database as well as the sensitive data model but some of their attributes have been modified. ALL covers all the above three scenarios and reports new, deleted and modified columns.
        """
        return pulumi.get(self, "discovery_type")

    @discovery_type.setter
    def discovery_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the discovery job. Does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the discovery job should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @is_app_defined_relation_discovery_enabled.setter
    def is_app_defined_relation_discovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_app_defined_relation_discovery_enabled", value)

    @property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if all the schemas should be scanned by the discovery job. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        """
        return pulumi.get(self, "is_include_all_schemas")

    @is_include_all_schemas.setter
    def is_include_all_schemas(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_include_all_schemas", value)

    @property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if all the existing sensitive types should be used by the discovery job. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @is_include_all_sensitive_types.setter
    def is_include_all_sensitive_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_include_all_sensitive_types", value)

    @property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the discovery job should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @is_sample_data_collection_enabled.setter
    def is_sample_data_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_sample_data_collection_enabled", value)

    @property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The schemas to be scanned by the discovery job. If not provided, the schemasForDiscovery attribute of the sensitive data model is used to get the list of schemas.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @schemas_for_discoveries.setter
    def schemas_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas_for_discoveries", value)

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @sensitive_data_model_id.setter
    def sensitive_data_model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sensitive_data_model_id", value)

    @property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The OCIDs of the sensitive types to be used by the discovery job. If not provided, the sensitiveTypeIdsForDiscovery attribute of the sensitive data model is used to get the list of sensitive types. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @sensitive_type_ids_for_discoveries.setter
    def sensitive_type_ids_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sensitive_type_ids_for_discoveries", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the discovery job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the target database associated with the discovery job.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the discovery job finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)..
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_finished", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the discovery job started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter(name="totalColumnsScanned")
    def total_columns_scanned(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of columns scanned by the discovery job.
        """
        return pulumi.get(self, "total_columns_scanned")

    @total_columns_scanned.setter
    def total_columns_scanned(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_columns_scanned", value)

    @property
    @pulumi.getter(name="totalDeletedSensitiveColumns")
    def total_deleted_sensitive_columns(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of deleted sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_deleted_sensitive_columns")

    @total_deleted_sensitive_columns.setter
    def total_deleted_sensitive_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_deleted_sensitive_columns", value)

    @property
    @pulumi.getter(name="totalModifiedSensitiveColumns")
    def total_modified_sensitive_columns(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of modified sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_modified_sensitive_columns")

    @total_modified_sensitive_columns.setter
    def total_modified_sensitive_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_modified_sensitive_columns", value)

    @property
    @pulumi.getter(name="totalNewSensitiveColumns")
    def total_new_sensitive_columns(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of new sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_new_sensitive_columns")

    @total_new_sensitive_columns.setter
    def total_new_sensitive_columns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_new_sensitive_columns", value)

    @property
    @pulumi.getter(name="totalObjectsScanned")
    def total_objects_scanned(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of objects (tables and editioning views) scanned by the discovery job.
        """
        return pulumi.get(self, "total_objects_scanned")

    @total_objects_scanned.setter
    def total_objects_scanned(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_objects_scanned", value)

    @property
    @pulumi.getter(name="totalSchemasScanned")
    def total_schemas_scanned(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of schemas scanned by the discovery job.
        """
        return pulumi.get(self, "total_schemas_scanned")

    @total_schemas_scanned.setter
    def total_schemas_scanned(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_schemas_scanned", value)


class DiscoveryMod(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Discovery Job resource in Oracle Cloud Infrastructure Data Safe service.

        Performs incremental data discovery for the specified sensitive data model. It uses the target database associated
        with the sensitive data model.
        After performing data discovery, you can use ListDiscoveryJobResults to view the discovery results, PatchDiscoveryJobResults
        to specify the action you want perform on these results, and then ApplyDiscoveryJobResults to process the results
        and apply them to the sensitive data model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_discovery_job = oci.data_safe.DiscoveryMod("testDiscoveryJob",
            compartment_id=var["compartment_id"],
            sensitive_data_model_id=oci_data_safe_sensitive_data_model["test_sensitive_data_model"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            discovery_type=var["discovery_job_discovery_type"],
            display_name=var["discovery_job_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            is_app_defined_relation_discovery_enabled=var["discovery_job_is_app_defined_relation_discovery_enabled"],
            is_include_all_schemas=var["discovery_job_is_include_all_schemas"],
            is_include_all_sensitive_types=var["discovery_job_is_include_all_sensitive_types"],
            is_sample_data_collection_enabled=var["discovery_job_is_sample_data_collection_enabled"],
            schemas_for_discoveries=var["discovery_job_schemas_for_discovery"],
            sensitive_type_ids_for_discoveries=var["discovery_job_sensitive_type_ids_for_discovery"])
        ```

        ## Import

        DiscoveryJobs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataSafe/discoveryMod:DiscoveryMod test_discovery_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the discovery job resource should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] discovery_type: The type of the discovery job. It defines the job's scope. NEW identifies new sensitive columns in the target database that are not in the sensitive data model. DELETED identifies columns that are present in the sensitive data model but have been deleted from the target database. MODIFIED identifies columns that are present in the target database as well as the sensitive data model but some of their attributes have been modified. ALL covers all the above three scenarios and reports new, deleted and modified columns.
        :param pulumi.Input[str] display_name: A user-friendly name for the discovery job. Does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_app_defined_relation_discovery_enabled: Indicates if the discovery job should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[bool] is_include_all_schemas: Indicates if all the schemas should be scanned by the discovery job. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        :param pulumi.Input[bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by the discovery job. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        :param pulumi.Input[bool] is_sample_data_collection_enabled: Indicates if the discovery job should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas_for_discoveries: The schemas to be scanned by the discovery job. If not provided, the schemasForDiscovery attribute of the sensitive data model is used to get the list of schemas.
        :param pulumi.Input[str] sensitive_data_model_id: The OCID of the sensitive data model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sensitive_type_ids_for_discoveries: The OCIDs of the sensitive types to be used by the discovery job. If not provided, the sensitiveTypeIdsForDiscovery attribute of the sensitive data model is used to get the list of sensitive types. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiscoveryModArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Discovery Job resource in Oracle Cloud Infrastructure Data Safe service.

        Performs incremental data discovery for the specified sensitive data model. It uses the target database associated
        with the sensitive data model.
        After performing data discovery, you can use ListDiscoveryJobResults to view the discovery results, PatchDiscoveryJobResults
        to specify the action you want perform on these results, and then ApplyDiscoveryJobResults to process the results
        and apply them to the sensitive data model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_discovery_job = oci.data_safe.DiscoveryMod("testDiscoveryJob",
            compartment_id=var["compartment_id"],
            sensitive_data_model_id=oci_data_safe_sensitive_data_model["test_sensitive_data_model"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            discovery_type=var["discovery_job_discovery_type"],
            display_name=var["discovery_job_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            is_app_defined_relation_discovery_enabled=var["discovery_job_is_app_defined_relation_discovery_enabled"],
            is_include_all_schemas=var["discovery_job_is_include_all_schemas"],
            is_include_all_sensitive_types=var["discovery_job_is_include_all_sensitive_types"],
            is_sample_data_collection_enabled=var["discovery_job_is_sample_data_collection_enabled"],
            schemas_for_discoveries=var["discovery_job_schemas_for_discovery"],
            sensitive_type_ids_for_discoveries=var["discovery_job_sensitive_type_ids_for_discovery"])
        ```

        ## Import

        DiscoveryJobs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataSafe/discoveryMod:DiscoveryMod test_discovery_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param DiscoveryModArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiscoveryModArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DiscoveryModArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 discovery_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiscoveryModArgs.__new__(DiscoveryModArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["discovery_type"] = discovery_type
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_app_defined_relation_discovery_enabled"] = is_app_defined_relation_discovery_enabled
            __props__.__dict__["is_include_all_schemas"] = is_include_all_schemas
            __props__.__dict__["is_include_all_sensitive_types"] = is_include_all_sensitive_types
            __props__.__dict__["is_sample_data_collection_enabled"] = is_sample_data_collection_enabled
            __props__.__dict__["schemas_for_discoveries"] = schemas_for_discoveries
            if sensitive_data_model_id is None and not opts.urn:
                raise TypeError("Missing required property 'sensitive_data_model_id'")
            __props__.__dict__["sensitive_data_model_id"] = sensitive_data_model_id
            __props__.__dict__["sensitive_type_ids_for_discoveries"] = sensitive_type_ids_for_discoveries
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_id"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["total_columns_scanned"] = None
            __props__.__dict__["total_deleted_sensitive_columns"] = None
            __props__.__dict__["total_modified_sensitive_columns"] = None
            __props__.__dict__["total_new_sensitive_columns"] = None
            __props__.__dict__["total_objects_scanned"] = None
            __props__.__dict__["total_schemas_scanned"] = None
        super(DiscoveryMod, __self__).__init__(
            'oci:DataSafe/discoveryMod:DiscoveryMod',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            discovery_type: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
            is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
            is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
            is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
            schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
            sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            time_finished: Optional[pulumi.Input[str]] = None,
            time_started: Optional[pulumi.Input[str]] = None,
            total_columns_scanned: Optional[pulumi.Input[str]] = None,
            total_deleted_sensitive_columns: Optional[pulumi.Input[str]] = None,
            total_modified_sensitive_columns: Optional[pulumi.Input[str]] = None,
            total_new_sensitive_columns: Optional[pulumi.Input[str]] = None,
            total_objects_scanned: Optional[pulumi.Input[str]] = None,
            total_schemas_scanned: Optional[pulumi.Input[str]] = None) -> 'DiscoveryMod':
        """
        Get an existing DiscoveryMod resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the discovery job resource should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] discovery_type: The type of the discovery job. It defines the job's scope. NEW identifies new sensitive columns in the target database that are not in the sensitive data model. DELETED identifies columns that are present in the sensitive data model but have been deleted from the target database. MODIFIED identifies columns that are present in the target database as well as the sensitive data model but some of their attributes have been modified. ALL covers all the above three scenarios and reports new, deleted and modified columns.
        :param pulumi.Input[str] display_name: A user-friendly name for the discovery job. Does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_app_defined_relation_discovery_enabled: Indicates if the discovery job should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[bool] is_include_all_schemas: Indicates if all the schemas should be scanned by the discovery job. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        :param pulumi.Input[bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by the discovery job. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        :param pulumi.Input[bool] is_sample_data_collection_enabled: Indicates if the discovery job should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas_for_discoveries: The schemas to be scanned by the discovery job. If not provided, the schemasForDiscovery attribute of the sensitive data model is used to get the list of schemas.
        :param pulumi.Input[str] sensitive_data_model_id: The OCID of the sensitive data model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sensitive_type_ids_for_discoveries: The OCIDs of the sensitive types to be used by the discovery job. If not provided, the sensitiveTypeIdsForDiscovery attribute of the sensitive data model is used to get the list of sensitive types. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the discovery job.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the target database associated with the discovery job.
        :param pulumi.Input[str] time_finished: The date and time the discovery job finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)..
        :param pulumi.Input[str] time_started: The date and time the discovery job started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] total_columns_scanned: The total number of columns scanned by the discovery job.
        :param pulumi.Input[str] total_deleted_sensitive_columns: The total number of deleted sensitive columns identified by the discovery job.
        :param pulumi.Input[str] total_modified_sensitive_columns: The total number of modified sensitive columns identified by the discovery job.
        :param pulumi.Input[str] total_new_sensitive_columns: The total number of new sensitive columns identified by the discovery job.
        :param pulumi.Input[str] total_objects_scanned: The total number of objects (tables and editioning views) scanned by the discovery job.
        :param pulumi.Input[str] total_schemas_scanned: The total number of schemas scanned by the discovery job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiscoveryModState.__new__(_DiscoveryModState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["discovery_type"] = discovery_type
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_app_defined_relation_discovery_enabled"] = is_app_defined_relation_discovery_enabled
        __props__.__dict__["is_include_all_schemas"] = is_include_all_schemas
        __props__.__dict__["is_include_all_sensitive_types"] = is_include_all_sensitive_types
        __props__.__dict__["is_sample_data_collection_enabled"] = is_sample_data_collection_enabled
        __props__.__dict__["schemas_for_discoveries"] = schemas_for_discoveries
        __props__.__dict__["sensitive_data_model_id"] = sensitive_data_model_id
        __props__.__dict__["sensitive_type_ids_for_discoveries"] = sensitive_type_ids_for_discoveries
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["total_columns_scanned"] = total_columns_scanned
        __props__.__dict__["total_deleted_sensitive_columns"] = total_deleted_sensitive_columns
        __props__.__dict__["total_modified_sensitive_columns"] = total_modified_sensitive_columns
        __props__.__dict__["total_new_sensitive_columns"] = total_new_sensitive_columns
        __props__.__dict__["total_objects_scanned"] = total_objects_scanned
        __props__.__dict__["total_schemas_scanned"] = total_schemas_scanned
        return DiscoveryMod(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment where the discovery job resource should be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> pulumi.Output[str]:
        """
        The type of the discovery job. It defines the job's scope. NEW identifies new sensitive columns in the target database that are not in the sensitive data model. DELETED identifies columns that are present in the sensitive data model but have been deleted from the target database. MODIFIED identifies columns that are present in the target database as well as the sensitive data model but some of their attributes have been modified. ALL covers all the above three scenarios and reports new, deleted and modified columns.
        """
        return pulumi.get(self, "discovery_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user-friendly name for the discovery job. Does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates if the discovery job should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> pulumi.Output[bool]:
        """
        Indicates if all the schemas should be scanned by the discovery job. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        """
        return pulumi.get(self, "is_include_all_schemas")

    @property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> pulumi.Output[bool]:
        """
        Indicates if all the existing sensitive types should be used by the discovery job. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery. If both attributes are not provided, the configuration from the sensitive data model is used.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates if the discovery job should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> pulumi.Output[Sequence[str]]:
        """
        The schemas to be scanned by the discovery job. If not provided, the schemasForDiscovery attribute of the sensitive data model is used to get the list of schemas.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> pulumi.Output[str]:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> pulumi.Output[Sequence[str]]:
        """
        The OCIDs of the sensitive types to be used by the discovery job. If not provided, the sensitiveTypeIdsForDiscovery attribute of the sensitive data model is used to get the list of sensitive types. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the discovery job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The OCID of the target database associated with the discovery job.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[str]:
        """
        The date and time the discovery job finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)..
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[str]:
        """
        The date and time the discovery job started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="totalColumnsScanned")
    def total_columns_scanned(self) -> pulumi.Output[str]:
        """
        The total number of columns scanned by the discovery job.
        """
        return pulumi.get(self, "total_columns_scanned")

    @property
    @pulumi.getter(name="totalDeletedSensitiveColumns")
    def total_deleted_sensitive_columns(self) -> pulumi.Output[str]:
        """
        The total number of deleted sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_deleted_sensitive_columns")

    @property
    @pulumi.getter(name="totalModifiedSensitiveColumns")
    def total_modified_sensitive_columns(self) -> pulumi.Output[str]:
        """
        The total number of modified sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_modified_sensitive_columns")

    @property
    @pulumi.getter(name="totalNewSensitiveColumns")
    def total_new_sensitive_columns(self) -> pulumi.Output[str]:
        """
        The total number of new sensitive columns identified by the discovery job.
        """
        return pulumi.get(self, "total_new_sensitive_columns")

    @property
    @pulumi.getter(name="totalObjectsScanned")
    def total_objects_scanned(self) -> pulumi.Output[str]:
        """
        The total number of objects (tables and editioning views) scanned by the discovery job.
        """
        return pulumi.get(self, "total_objects_scanned")

    @property
    @pulumi.getter(name="totalSchemasScanned")
    def total_schemas_scanned(self) -> pulumi.Output[str]:
        """
        The total number of schemas scanned by the discovery job.
        """
        return pulumi.get(self, "total_schemas_scanned")

