# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAuditProfileResult',
    'AwaitableGetAuditProfileResult',
    'get_audit_profile',
    'get_audit_profile_output',
]

@pulumi.output_type
class GetAuditProfileResult:
    """
    A collection of values returned by getAuditProfile.
    """
    def __init__(__self__, audit_collected_volume=None, audit_profile_id=None, audit_trails=None, change_retention_trigger=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_override_global_retention_setting=None, is_paid_usage_enabled=None, lifecycle_details=None, offline_months=None, online_months=None, state=None, system_tags=None, target_id=None, time_created=None, time_updated=None):
        if audit_collected_volume and not isinstance(audit_collected_volume, str):
            raise TypeError("Expected argument 'audit_collected_volume' to be a str")
        pulumi.set(__self__, "audit_collected_volume", audit_collected_volume)
        if audit_profile_id and not isinstance(audit_profile_id, str):
            raise TypeError("Expected argument 'audit_profile_id' to be a str")
        pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if audit_trails and not isinstance(audit_trails, list):
            raise TypeError("Expected argument 'audit_trails' to be a list")
        pulumi.set(__self__, "audit_trails", audit_trails)
        if change_retention_trigger and not isinstance(change_retention_trigger, int):
            raise TypeError("Expected argument 'change_retention_trigger' to be a int")
        pulumi.set(__self__, "change_retention_trigger", change_retention_trigger)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_override_global_retention_setting and not isinstance(is_override_global_retention_setting, bool):
            raise TypeError("Expected argument 'is_override_global_retention_setting' to be a bool")
        pulumi.set(__self__, "is_override_global_retention_setting", is_override_global_retention_setting)
        if is_paid_usage_enabled and not isinstance(is_paid_usage_enabled, bool):
            raise TypeError("Expected argument 'is_paid_usage_enabled' to be a bool")
        pulumi.set(__self__, "is_paid_usage_enabled", is_paid_usage_enabled)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if offline_months and not isinstance(offline_months, int):
            raise TypeError("Expected argument 'offline_months' to be a int")
        pulumi.set(__self__, "offline_months", offline_months)
        if online_months and not isinstance(online_months, int):
            raise TypeError("Expected argument 'online_months' to be a int")
        pulumi.set(__self__, "online_months", online_months)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="auditCollectedVolume")
    def audit_collected_volume(self) -> str:
        """
        Indicates number of audit records collected by Data Safe in the current calendar month.  Audit records for the Data Safe service account are excluded and are not counted towards your monthly free limit.
        """
        return pulumi.get(self, "audit_collected_volume")

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> str:
        """
        The OCID of the  parent audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @property
    @pulumi.getter(name="auditTrails")
    def audit_trails(self) -> Sequence['outputs.GetAuditProfileAuditTrailResult']:
        """
        Indicates the list of available audit trails on the target.
        """
        return pulumi.get(self, "audit_trails")

    @property
    @pulumi.getter(name="changeRetentionTrigger")
    def change_retention_trigger(self) -> int:
        return pulumi.get(self, "change_retention_trigger")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the audit.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the audit profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the audit profile.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the audit profile.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isOverrideGlobalRetentionSetting")
    def is_override_global_retention_setting(self) -> bool:
        """
        Indicates whether audit retention settings like online and offline months is set at the target level overriding the global audit retention settings.
        """
        return pulumi.get(self, "is_override_global_retention_setting")

    @property
    @pulumi.getter(name="isPaidUsageEnabled")
    def is_paid_usage_enabled(self) -> bool:
        """
        Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        return pulumi.get(self, "is_paid_usage_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the current state of the audit profile in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="offlineMonths")
    def offline_months(self) -> int:
        """
        Indicates the number of months the audit records will be stored offline in the Data Safe audit archive. Minimum: 0; Maximum: 72 months. If you have a requirement to store the audit data even longer in archive, please contact the Oracle Support.
        """
        return pulumi.get(self, "offline_months")

    @property
    @pulumi.getter(name="onlineMonths")
    def online_months(self) -> int:
        """
        Indicates the number of months the audit records will be stored online in Oracle Data Safe audit repository for immediate reporting and analysis.  Minimum: 1; Maximum:12 months
        """
        return pulumi.get(self, "online_months")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the audit profile.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the Data Safe target for which the audit profile is created.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the audit profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the audit profile was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAuditProfileResult(GetAuditProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditProfileResult(
            audit_collected_volume=self.audit_collected_volume,
            audit_profile_id=self.audit_profile_id,
            audit_trails=self.audit_trails,
            change_retention_trigger=self.change_retention_trigger,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_override_global_retention_setting=self.is_override_global_retention_setting,
            is_paid_usage_enabled=self.is_paid_usage_enabled,
            lifecycle_details=self.lifecycle_details,
            offline_months=self.offline_months,
            online_months=self.online_months,
            state=self.state,
            system_tags=self.system_tags,
            target_id=self.target_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_audit_profile(audit_profile_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditProfileResult:
    """
    This data source provides details about a specific Audit Profile resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of audit profile resource and associated audit trails of the audit profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profile = oci.DataSafe.get_audit_profile(audit_profile_id=oci_data_safe_audit_profile["test_audit_profile"]["id"])
    ```


    :param str audit_profile_id: The OCID of the audit.
    """
    __args__ = dict()
    __args__['auditProfileId'] = audit_profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditProfile:getAuditProfile', __args__, opts=opts, typ=GetAuditProfileResult).value

    return AwaitableGetAuditProfileResult(
        audit_collected_volume=pulumi.get(__ret__, 'audit_collected_volume'),
        audit_profile_id=pulumi.get(__ret__, 'audit_profile_id'),
        audit_trails=pulumi.get(__ret__, 'audit_trails'),
        change_retention_trigger=pulumi.get(__ret__, 'change_retention_trigger'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_override_global_retention_setting=pulumi.get(__ret__, 'is_override_global_retention_setting'),
        is_paid_usage_enabled=pulumi.get(__ret__, 'is_paid_usage_enabled'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        offline_months=pulumi.get(__ret__, 'offline_months'),
        online_months=pulumi.get(__ret__, 'online_months'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_audit_profile)
def get_audit_profile_output(audit_profile_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuditProfileResult]:
    """
    This data source provides details about a specific Audit Profile resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of audit profile resource and associated audit trails of the audit profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profile = oci.DataSafe.get_audit_profile(audit_profile_id=oci_data_safe_audit_profile["test_audit_profile"]["id"])
    ```


    :param str audit_profile_id: The OCID of the audit.
    """
    ...
