# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRepositoryMirrorRecordsResult',
    'AwaitableGetRepositoryMirrorRecordsResult',
    'get_repository_mirror_records',
    'get_repository_mirror_records_output',
]

@pulumi.output_type
class GetRepositoryMirrorRecordsResult:
    """
    A collection of values returned by getRepositoryMirrorRecords.
    """
    def __init__(__self__, filters=None, id=None, repository_id=None, repository_mirror_record_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if repository_mirror_record_collections and not isinstance(repository_mirror_record_collections, list):
            raise TypeError("Expected argument 'repository_mirror_record_collections' to be a list")
        pulumi.set(__self__, "repository_mirror_record_collections", repository_mirror_record_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRepositoryMirrorRecordsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryMirrorRecordCollections")
    def repository_mirror_record_collections(self) -> Sequence['outputs.GetRepositoryMirrorRecordsRepositoryMirrorRecordCollectionResult']:
        """
        The list of repository_mirror_record_collection.
        """
        return pulumi.get(self, "repository_mirror_record_collections")


class AwaitableGetRepositoryMirrorRecordsResult(GetRepositoryMirrorRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryMirrorRecordsResult(
            filters=self.filters,
            id=self.id,
            repository_id=self.repository_id,
            repository_mirror_record_collections=self.repository_mirror_record_collections)


def get_repository_mirror_records(filters: Optional[Sequence[pulumi.InputType['GetRepositoryMirrorRecordsFilterArgs']]] = None,
                                  repository_id: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryMirrorRecordsResult:
    """
    This data source provides the list of Repository Mirror Records in Oracle Cloud Infrastructure Devops service.

    Returns a list of mirror entry in history within 30 days.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_mirror_records = oci.DevOps.get_repository_mirror_records(repository_id=oci_devops_repository["test_repository"]["id"])
    ```


    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryMirrorRecords:getRepositoryMirrorRecords', __args__, opts=opts, typ=GetRepositoryMirrorRecordsResult).value

    return AwaitableGetRepositoryMirrorRecordsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        repository_mirror_record_collections=pulumi.get(__ret__, 'repository_mirror_record_collections'))


@_utilities.lift_output_func(get_repository_mirror_records)
def get_repository_mirror_records_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetRepositoryMirrorRecordsFilterArgs']]]]] = None,
                                         repository_id: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryMirrorRecordsResult]:
    """
    This data source provides the list of Repository Mirror Records in Oracle Cloud Infrastructure Devops service.

    Returns a list of mirror entry in history within 30 days.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_mirror_records = oci.DevOps.get_repository_mirror_records(repository_id=oci_devops_repository["test_repository"]["id"])
    ```


    :param str repository_id: Unique repository identifier.
    """
    ...
