# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRepositoryRefsResult',
    'AwaitableGetRepositoryRefsResult',
    'get_repository_refs',
    'get_repository_refs_output',
]

@pulumi.output_type
class GetRepositoryRefsResult:
    """
    A collection of values returned by getRepositoryRefs.
    """
    def __init__(__self__, commit_id=None, filters=None, id=None, ref_name=None, ref_type=None, repository_id=None, repository_ref_collections=None):
        if commit_id and not isinstance(commit_id, str):
            raise TypeError("Expected argument 'commit_id' to be a str")
        pulumi.set(__self__, "commit_id", commit_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ref_name and not isinstance(ref_name, str):
            raise TypeError("Expected argument 'ref_name' to be a str")
        pulumi.set(__self__, "ref_name", ref_name)
        if ref_type and not isinstance(ref_type, str):
            raise TypeError("Expected argument 'ref_type' to be a str")
        pulumi.set(__self__, "ref_type", ref_type)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if repository_ref_collections and not isinstance(repository_ref_collections, list):
            raise TypeError("Expected argument 'repository_ref_collections' to be a list")
        pulumi.set(__self__, "repository_ref_collections", repository_ref_collections)

    @property
    @pulumi.getter(name="commitId")
    def commit_id(self) -> Optional[str]:
        """
        Commit ID pointed to by the new branch.
        """
        return pulumi.get(self, "commit_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRepositoryRefsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="refName")
    def ref_name(self) -> Optional[str]:
        """
        Unique reference name inside a repository.
        """
        return pulumi.get(self, "ref_name")

    @property
    @pulumi.getter(name="refType")
    def ref_type(self) -> Optional[str]:
        """
        The type of reference (BRANCH or TAG).
        """
        return pulumi.get(self, "ref_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        """
        The OCID of the repository containing the reference.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryRefCollections")
    def repository_ref_collections(self) -> Sequence['outputs.GetRepositoryRefsRepositoryRefCollectionResult']:
        """
        The list of repository_ref_collection.
        """
        return pulumi.get(self, "repository_ref_collections")


class AwaitableGetRepositoryRefsResult(GetRepositoryRefsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryRefsResult(
            commit_id=self.commit_id,
            filters=self.filters,
            id=self.id,
            ref_name=self.ref_name,
            ref_type=self.ref_type,
            repository_id=self.repository_id,
            repository_ref_collections=self.repository_ref_collections)


def get_repository_refs(commit_id: Optional[str] = None,
                        filters: Optional[Sequence[pulumi.InputType['GetRepositoryRefsFilterArgs']]] = None,
                        ref_name: Optional[str] = None,
                        ref_type: Optional[str] = None,
                        repository_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryRefsResult:
    """
    This data source provides the list of Repository Refs in Oracle Cloud Infrastructure Devops service.

    Returns a list of references.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_refs = oci.DevOps.get_repository_refs(repository_id=oci_devops_repository["test_repository"]["id"],
        commit_id=oci_devops_commit["test_commit"]["id"],
        ref_name=var["repository_ref_ref_name"],
        ref_type=var["repository_ref_ref_type"])
    ```


    :param str commit_id: Commit ID in a repository.
    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str ref_type: Reference type to distinguish between branch and tag. If it is not specified, all references are returned.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['commitId'] = commit_id
    __args__['filters'] = filters
    __args__['refName'] = ref_name
    __args__['refType'] = ref_type
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryRefs:getRepositoryRefs', __args__, opts=opts, typ=GetRepositoryRefsResult).value

    return AwaitableGetRepositoryRefsResult(
        commit_id=pulumi.get(__ret__, 'commit_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ref_name=pulumi.get(__ret__, 'ref_name'),
        ref_type=pulumi.get(__ret__, 'ref_type'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        repository_ref_collections=pulumi.get(__ret__, 'repository_ref_collections'))


@_utilities.lift_output_func(get_repository_refs)
def get_repository_refs_output(commit_id: Optional[pulumi.Input[Optional[str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetRepositoryRefsFilterArgs']]]]] = None,
                               ref_name: Optional[pulumi.Input[Optional[str]]] = None,
                               ref_type: Optional[pulumi.Input[Optional[str]]] = None,
                               repository_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryRefsResult]:
    """
    This data source provides the list of Repository Refs in Oracle Cloud Infrastructure Devops service.

    Returns a list of references.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_refs = oci.DevOps.get_repository_refs(repository_id=oci_devops_repository["test_repository"]["id"],
        commit_id=oci_devops_commit["test_commit"]["id"],
        ref_name=var["repository_ref_ref_name"],
        ref_type=var["repository_ref_ref_type"])
    ```


    :param str commit_id: Commit ID in a repository.
    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str ref_type: Reference type to distinguish between branch and tag. If it is not specified, all references are returned.
    :param str repository_id: Unique repository identifier.
    """
    ...
