# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ActionCreateZoneFromZoneFileExternalDownstream',
    'ActionCreateZoneFromZoneFileExternalMaster',
    'ActionCreateZoneFromZoneFileNameserver',
    'ActionCreateZoneFromZoneFileZoneTransferServer',
    'ResolverAttachedView',
    'ResolverEndpoint',
    'ResolverRule',
    'RrsetItem',
    'SteeringPolicyAnswer',
    'SteeringPolicyRule',
    'SteeringPolicyRuleCase',
    'SteeringPolicyRuleCaseAnswerData',
    'SteeringPolicyRuleDefaultAnswerData',
    'ZoneExternalDownstream',
    'ZoneExternalMaster',
    'ZoneNameserver',
    'ZoneZoneTransferServer',
    'GetRecordsFilterResult',
    'GetRecordsRecordResult',
    'GetResolverAttachedViewResult',
    'GetResolverEndpointResult',
    'GetResolverEndpointsFilterResult',
    'GetResolverEndpointsResolverEndpointResult',
    'GetResolverRuleResult',
    'GetResolversFilterResult',
    'GetResolversResolverResult',
    'GetResolversResolverAttachedViewResult',
    'GetResolversResolverEndpointResult',
    'GetResolversResolverRuleResult',
    'GetRrsetItemResult',
    'GetRrsetsFilterResult',
    'GetRrsetsRrsetResult',
    'GetRrsetsRrsetItemResult',
    'GetSteeringPoliciesFilterResult',
    'GetSteeringPoliciesSteeringPolicyResult',
    'GetSteeringPoliciesSteeringPolicyAnswerResult',
    'GetSteeringPoliciesSteeringPolicyRuleResult',
    'GetSteeringPoliciesSteeringPolicyRuleCaseResult',
    'GetSteeringPoliciesSteeringPolicyRuleCaseAnswerDataResult',
    'GetSteeringPoliciesSteeringPolicyRuleDefaultAnswerDataResult',
    'GetSteeringPolicyAnswerResult',
    'GetSteeringPolicyAttachmentsFilterResult',
    'GetSteeringPolicyAttachmentsSteeringPolicyAttachmentResult',
    'GetSteeringPolicyRuleResult',
    'GetSteeringPolicyRuleCaseResult',
    'GetSteeringPolicyRuleCaseAnswerDataResult',
    'GetSteeringPolicyRuleDefaultAnswerDataResult',
    'GetTsigKeysFilterResult',
    'GetTsigKeysTsigKeyResult',
    'GetViewsFilterResult',
    'GetViewsViewResult',
    'GetZonesFilterResult',
    'GetZonesZoneResult',
    'GetZonesZoneExternalDownstreamResult',
    'GetZonesZoneExternalMasterResult',
    'GetZonesZoneNameserverResult',
    'GetZonesZoneZoneTransferServerResult',
]

@pulumi.output_type
class ActionCreateZoneFromZoneFileExternalDownstream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tsigKeyId":
            suggest = "tsig_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionCreateZoneFromZoneFileExternalDownstream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionCreateZoneFromZoneFileExternalDownstream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionCreateZoneFromZoneFileExternalDownstream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 port: Optional[int] = None,
                 tsig_key_id: Optional[str] = None):
        """
        :param str address: The server's IP address (IPv4 or IPv6).
        :param int port: The server's port.
        :param str tsig_key_id: The OCID of the TSIG key.
        """
        ActionCreateZoneFromZoneFileExternalDownstream._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            port=port,
            tsig_key_id=tsig_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             port: Optional[int] = None,
             tsig_key_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tsigKeyId' in kwargs:
            tsig_key_id = kwargs['tsigKeyId']

        if address is not None:
            _setter("address", address)
        if port is not None:
            _setter("port", port)
        if tsig_key_id is not None:
            _setter("tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The server's port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[str]:
        """
        The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")


@pulumi.output_type
class ActionCreateZoneFromZoneFileExternalMaster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tsigKeyId":
            suggest = "tsig_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionCreateZoneFromZoneFileExternalMaster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionCreateZoneFromZoneFileExternalMaster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionCreateZoneFromZoneFileExternalMaster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 port: Optional[int] = None,
                 tsig_key_id: Optional[str] = None):
        """
        :param str address: The server's IP address (IPv4 or IPv6).
        :param int port: The server's port.
        :param str tsig_key_id: The OCID of the TSIG key.
        """
        ActionCreateZoneFromZoneFileExternalMaster._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            port=port,
            tsig_key_id=tsig_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             port: Optional[int] = None,
             tsig_key_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tsigKeyId' in kwargs:
            tsig_key_id = kwargs['tsigKeyId']

        if address is not None:
            _setter("address", address)
        if port is not None:
            _setter("port", port)
        if tsig_key_id is not None:
            _setter("tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The server's port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[str]:
        """
        The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")


@pulumi.output_type
class ActionCreateZoneFromZoneFileNameserver(dict):
    def __init__(__self__, *,
                 hostname: Optional[str] = None):
        """
        :param str hostname: The hostname of the nameserver.
        """
        ActionCreateZoneFromZoneFileNameserver._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hostname=hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hostname: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if hostname is not None:
            _setter("hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        The hostname of the nameserver.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class ActionCreateZoneFromZoneFileZoneTransferServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isTransferDestination":
            suggest = "is_transfer_destination"
        elif key == "isTransferSource":
            suggest = "is_transfer_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionCreateZoneFromZoneFileZoneTransferServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionCreateZoneFromZoneFileZoneTransferServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionCreateZoneFromZoneFileZoneTransferServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 is_transfer_destination: Optional[bool] = None,
                 is_transfer_source: Optional[bool] = None,
                 port: Optional[int] = None):
        """
        :param str address: The server's IP address (IPv4 or IPv6).
        :param bool is_transfer_destination: A Boolean flag indicating whether or not the server is a zone data transfer destination.
        :param bool is_transfer_source: A Boolean flag indicating whether or not the server is a zone data transfer source.
        :param int port: The server's port.
        """
        ActionCreateZoneFromZoneFileZoneTransferServer._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            is_transfer_destination=is_transfer_destination,
            is_transfer_source=is_transfer_source,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             is_transfer_destination: Optional[bool] = None,
             is_transfer_source: Optional[bool] = None,
             port: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isTransferDestination' in kwargs:
            is_transfer_destination = kwargs['isTransferDestination']
        if 'isTransferSource' in kwargs:
            is_transfer_source = kwargs['isTransferSource']

        if address is not None:
            _setter("address", address)
        if is_transfer_destination is not None:
            _setter("is_transfer_destination", is_transfer_destination)
        if is_transfer_source is not None:
            _setter("is_transfer_source", is_transfer_source)
        if port is not None:
            _setter("port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="isTransferDestination")
    def is_transfer_destination(self) -> Optional[bool]:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer destination.
        """
        return pulumi.get(self, "is_transfer_destination")

    @property
    @pulumi.getter(name="isTransferSource")
    def is_transfer_source(self) -> Optional[bool]:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer source.
        """
        return pulumi.get(self, "is_transfer_source")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The server's port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ResolverAttachedView(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "viewId":
            suggest = "view_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverAttachedView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverAttachedView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverAttachedView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 view_id: str):
        """
        :param str view_id: (Updatable) The OCID of the view.
        """
        ResolverAttachedView._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            view_id=view_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             view_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'viewId' in kwargs:
            view_id = kwargs['viewId']

        _setter("view_id", view_id)

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> str:
        """
        (Updatable) The OCID of the view.
        """
        return pulumi.get(self, "view_id")


@pulumi.output_type
class ResolverEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "forwardingAddress":
            suggest = "forwarding_address"
        elif key == "isForwarding":
            suggest = "is_forwarding"
        elif key == "isListening":
            suggest = "is_listening"
        elif key == "listeningAddress":
            suggest = "listening_address"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[str] = None,
                 endpoint_type: Optional[str] = None,
                 forwarding_address: Optional[str] = None,
                 is_forwarding: Optional[bool] = None,
                 is_listening: Optional[bool] = None,
                 listening_address: Optional[str] = None,
                 name: Optional[str] = None,
                 self: Optional[str] = None,
                 state: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 time_created: Optional[str] = None,
                 time_updated: Optional[str] = None):
        """
        :param str compartment_id: (Updatable) The OCID of the owning compartment.
        :param str endpoint_type: The type of resolver endpoint. VNIC is currently the only supported type.
        :param str forwarding_address: An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        :param bool is_forwarding: A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        :param bool is_listening: A Boolean flag indicating whether or not the resolver endpoint is for listening.
        :param str listening_address: An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        :param str name: The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The current state of the resource.
        :param str subnet_id: The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
        :param str time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param str time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        ResolverEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            endpoint_type=endpoint_type,
            forwarding_address=forwarding_address,
            is_forwarding=is_forwarding,
            is_listening=is_listening,
            listening_address=listening_address,
            name=name,
            self=self,
            state=state,
            subnet_id=subnet_id,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[str] = None,
             endpoint_type: Optional[str] = None,
             forwarding_address: Optional[str] = None,
             is_forwarding: Optional[bool] = None,
             is_listening: Optional[bool] = None,
             listening_address: Optional[str] = None,
             name: Optional[str] = None,
             self: Optional[str] = None,
             state: Optional[str] = None,
             subnet_id: Optional[str] = None,
             time_created: Optional[str] = None,
             time_updated: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'endpointType' in kwargs:
            endpoint_type = kwargs['endpointType']
        if 'forwardingAddress' in kwargs:
            forwarding_address = kwargs['forwardingAddress']
        if 'isForwarding' in kwargs:
            is_forwarding = kwargs['isForwarding']
        if 'isListening' in kwargs:
            is_listening = kwargs['isListening']
        if 'listeningAddress' in kwargs:
            listening_address = kwargs['listeningAddress']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if endpoint_type is not None:
            _setter("endpoint_type", endpoint_type)
        if forwarding_address is not None:
            _setter("forwarding_address", forwarding_address)
        if is_forwarding is not None:
            _setter("is_forwarding", is_forwarding)
        if is_listening is not None:
            _setter("is_listening", is_listening)
        if listening_address is not None:
            _setter("listening_address", listening_address)
        if name is not None:
            _setter("name", name)
        if self is not None:
            _setter("self", self)
        if state is not None:
            _setter("state", state)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the owning compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[str]:
        """
        The type of resolver endpoint. VNIC is currently the only supported type.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="forwardingAddress")
    def forwarding_address(self) -> Optional[str]:
        """
        An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        """
        return pulumi.get(self, "forwarding_address")

    @property
    @pulumi.getter(name="isForwarding")
    def is_forwarding(self) -> Optional[bool]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        """
        return pulumi.get(self, "is_forwarding")

    @property
    @pulumi.getter(name="isListening")
    def is_listening(self) -> Optional[bool]:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for listening.
        """
        return pulumi.get(self, "is_listening")

    @property
    @pulumi.getter(name="listeningAddress")
    def listening_address(self) -> Optional[str]:
        """
        An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        """
        return pulumi.get(self, "listening_address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def self(self) -> Optional[str]:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[str]:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class ResolverRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "sourceEndpointName":
            suggest = "source_endpoint_name"
        elif key == "clientAddressConditions":
            suggest = "client_address_conditions"
        elif key == "qnameCoverConditions":
            suggest = "qname_cover_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 destination_addresses: Sequence[str],
                 source_endpoint_name: str,
                 client_address_conditions: Optional[Sequence[str]] = None,
                 qname_cover_conditions: Optional[Sequence[str]] = None):
        """
        :param str action: (Updatable) The action determines the behavior of the rule. If a query matches a supplied condition, the action will apply. If there are no conditions on the rule, all queries are subject to the specified action.
        :param Sequence[str] destination_addresses: (Updatable) IP addresses to which queries should be forwarded. Currently limited to a single address.
        :param str source_endpoint_name: (Updatable) Name of an endpoint, that is a sub-resource of the resolver, to use as the forwarding interface. The endpoint must have isForwarding set to true.
        :param Sequence[str] client_address_conditions: (Updatable) A list of CIDR blocks. The query must come from a client within one of the blocks in order for the rule action to apply.
        :param Sequence[str] qname_cover_conditions: (Updatable) A list of domain names. The query must be covered by one of the domains in order for the rule action to apply.
        """
        ResolverRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            destination_addresses=destination_addresses,
            source_endpoint_name=source_endpoint_name,
            client_address_conditions=client_address_conditions,
            qname_cover_conditions=qname_cover_conditions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             destination_addresses: Sequence[str],
             source_endpoint_name: str,
             client_address_conditions: Optional[Sequence[str]] = None,
             qname_cover_conditions: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'sourceEndpointName' in kwargs:
            source_endpoint_name = kwargs['sourceEndpointName']
        if 'clientAddressConditions' in kwargs:
            client_address_conditions = kwargs['clientAddressConditions']
        if 'qnameCoverConditions' in kwargs:
            qname_cover_conditions = kwargs['qnameCoverConditions']

        _setter("action", action)
        _setter("destination_addresses", destination_addresses)
        _setter("source_endpoint_name", source_endpoint_name)
        if client_address_conditions is not None:
            _setter("client_address_conditions", client_address_conditions)
        if qname_cover_conditions is not None:
            _setter("qname_cover_conditions", qname_cover_conditions)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        (Updatable) The action determines the behavior of the rule. If a query matches a supplied condition, the action will apply. If there are no conditions on the rule, all queries are subject to the specified action.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Sequence[str]:
        """
        (Updatable) IP addresses to which queries should be forwarded. Currently limited to a single address.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="sourceEndpointName")
    def source_endpoint_name(self) -> str:
        """
        (Updatable) Name of an endpoint, that is a sub-resource of the resolver, to use as the forwarding interface. The endpoint must have isForwarding set to true.
        """
        return pulumi.get(self, "source_endpoint_name")

    @property
    @pulumi.getter(name="clientAddressConditions")
    def client_address_conditions(self) -> Optional[Sequence[str]]:
        """
        (Updatable) A list of CIDR blocks. The query must come from a client within one of the blocks in order for the rule action to apply.
        """
        return pulumi.get(self, "client_address_conditions")

    @property
    @pulumi.getter(name="qnameCoverConditions")
    def qname_cover_conditions(self) -> Optional[Sequence[str]]:
        """
        (Updatable) A list of domain names. The query must be covered by one of the domains in order for the rule action to apply.
        """
        return pulumi.get(self, "qname_cover_conditions")


@pulumi.output_type
class RrsetItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isProtected":
            suggest = "is_protected"
        elif key == "recordHash":
            suggest = "record_hash"
        elif key == "rrsetVersion":
            suggest = "rrset_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RrsetItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RrsetItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RrsetItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: str,
                 rdata: str,
                 rtype: str,
                 ttl: int,
                 is_protected: Optional[bool] = None,
                 record_hash: Optional[str] = None,
                 rrset_version: Optional[str] = None):
        """
        :param str domain: The fully qualified domain name where the record can be located.
        :param str rdata: (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param str rtype: The type of the target RRSet within the target zone.
        :param int ttl: (Updatable) The Time To Live for the record, in seconds.
        :param bool is_protected: A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        :param str record_hash: A unique identifier for the record within its zone.
        :param str rrset_version: The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        RrsetItem._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain=domain,
            rdata=rdata,
            rtype=rtype,
            ttl=ttl,
            is_protected=is_protected,
            record_hash=record_hash,
            rrset_version=rrset_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain: str,
             rdata: str,
             rtype: str,
             ttl: int,
             is_protected: Optional[bool] = None,
             record_hash: Optional[str] = None,
             rrset_version: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isProtected' in kwargs:
            is_protected = kwargs['isProtected']
        if 'recordHash' in kwargs:
            record_hash = kwargs['recordHash']
        if 'rrsetVersion' in kwargs:
            rrset_version = kwargs['rrsetVersion']

        _setter("domain", domain)
        _setter("rdata", rdata)
        _setter("rtype", rtype)
        _setter("ttl", ttl)
        if is_protected is not None:
            _setter("is_protected", is_protected)
        if record_hash is not None:
            _setter("record_hash", record_hash)
        if rrset_version is not None:
            _setter("rrset_version", rrset_version)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The fully qualified domain name where the record can be located.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def rdata(self) -> str:
        """
        (Updatable) The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter
    def rtype(self) -> str:
        """
        The type of the target RRSet within the target zone.
        """
        return pulumi.get(self, "rtype")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        (Updatable) The Time To Live for the record, in seconds.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> Optional[bool]:
        """
        A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter(name="recordHash")
    def record_hash(self) -> Optional[str]:
        """
        A unique identifier for the record within its zone.
        """
        return pulumi.get(self, "record_hash")

    @property
    @pulumi.getter(name="rrsetVersion")
    def rrset_version(self) -> Optional[str]:
        """
        The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        return pulumi.get(self, "rrset_version")


@pulumi.output_type
class SteeringPolicyAnswer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDisabled":
            suggest = "is_disabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SteeringPolicyAnswer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SteeringPolicyAnswer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SteeringPolicyAnswer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 rdata: str,
                 rtype: str,
                 is_disabled: Optional[bool] = None,
                 pool: Optional[str] = None):
        """
        :param str name: A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        :param str rdata: The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        :param str rtype: The type of DNS record, such as A or CNAME. Only A, AAAA, and CNAME are supported. For more information, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        :param bool is_disabled: Set this property to `true` to indicate that the answer is administratively disabled, such as when the corresponding server is down for maintenance. An answer's `isDisabled` property can be referenced in `answerCondition` properties in rules using `answer.isDisabled`.
        :param str pool: The freeform name of a group of one or more records in which this record is included, such as "LAX data center". An answer's `pool` property can be referenced in `answerCondition` properties of rules using `answer.pool`.
        """
        SteeringPolicyAnswer._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            rdata=rdata,
            rtype=rtype,
            is_disabled=is_disabled,
            pool=pool,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             rdata: str,
             rtype: str,
             is_disabled: Optional[bool] = None,
             pool: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isDisabled' in kwargs:
            is_disabled = kwargs['isDisabled']

        _setter("name", name)
        _setter("rdata", rdata)
        _setter("rtype", rtype)
        if is_disabled is not None:
            _setter("is_disabled", is_disabled)
        if pool is not None:
            _setter("pool", pool)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rdata(self) -> str:
        """
        The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter
    def rtype(self) -> str:
        """
        The type of DNS record, such as A or CNAME. Only A, AAAA, and CNAME are supported. For more information, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        return pulumi.get(self, "rtype")

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[bool]:
        """
        Set this property to `true` to indicate that the answer is administratively disabled, such as when the corresponding server is down for maintenance. An answer's `isDisabled` property can be referenced in `answerCondition` properties in rules using `answer.isDisabled`.
        """
        return pulumi.get(self, "is_disabled")

    @property
    @pulumi.getter
    def pool(self) -> Optional[str]:
        """
        The freeform name of a group of one or more records in which this record is included, such as "LAX data center". An answer's `pool` property can be referenced in `answerCondition` properties of rules using `answer.pool`.
        """
        return pulumi.get(self, "pool")


@pulumi.output_type
class SteeringPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "defaultAnswerDatas":
            suggest = "default_answer_datas"
        elif key == "defaultCount":
            suggest = "default_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SteeringPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SteeringPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SteeringPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 cases: Optional[Sequence['outputs.SteeringPolicyRuleCase']] = None,
                 default_answer_datas: Optional[Sequence['outputs.SteeringPolicyRuleDefaultAnswerData']] = None,
                 default_count: Optional[int] = None,
                 description: Optional[str] = None):
        """
        :param str rule_type: The type of a rule determines its sorting/filtering behavior.
        :param Sequence['SteeringPolicyRuleCaseArgs'] cases: An array of `caseConditions`. A rule may optionally include a sequence of cases defining alternate configurations for how it should behave during processing for any given DNS query. When a rule has no sequence of `cases`, it is always evaluated with the same configuration during processing. When a rule has an empty sequence of `cases`, it is always ignored during processing. When a rule has a non-empty sequence of `cases`, its behavior during processing is configured by the first matching `case` in the sequence. When a rule has no matching cases the rule is ignored. A rule case with no `caseCondition` always matches. A rule case with a `caseCondition` matches only when that expression evaluates to true for the given query.
        :param Sequence['SteeringPolicyRuleDefaultAnswerDataArgs'] default_answer_datas: Defines a default set of answer conditions and values that are applied to an answer when `cases` is not defined for the rule, or a matching case does not have any matching `answerCondition`s in its `answerData`. `defaultAnswerData` is not applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed.
        :param int default_count: Defines a default count if `cases` is not defined for the rule or a matching case does not define `count`. `defaultCount` is **not** applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed. If no rules remain to be processed, the answer will be chosen from the remaining list of answers.
        :param str description: A user-defined description of the rule's purpose or behavior.
        """
        SteeringPolicyRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            rule_type=rule_type,
            cases=cases,
            default_answer_datas=default_answer_datas,
            default_count=default_count,
            description=description,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             rule_type: str,
             cases: Optional[Sequence['outputs.SteeringPolicyRuleCase']] = None,
             default_answer_datas: Optional[Sequence['outputs.SteeringPolicyRuleDefaultAnswerData']] = None,
             default_count: Optional[int] = None,
             description: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ruleType' in kwargs:
            rule_type = kwargs['ruleType']
        if 'defaultAnswerDatas' in kwargs:
            default_answer_datas = kwargs['defaultAnswerDatas']
        if 'defaultCount' in kwargs:
            default_count = kwargs['defaultCount']

        _setter("rule_type", rule_type)
        if cases is not None:
            _setter("cases", cases)
        if default_answer_datas is not None:
            _setter("default_answer_datas", default_answer_datas)
        if default_count is not None:
            _setter("default_count", default_count)
        if description is not None:
            _setter("description", description)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of a rule determines its sorting/filtering behavior.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def cases(self) -> Optional[Sequence['outputs.SteeringPolicyRuleCase']]:
        """
        An array of `caseConditions`. A rule may optionally include a sequence of cases defining alternate configurations for how it should behave during processing for any given DNS query. When a rule has no sequence of `cases`, it is always evaluated with the same configuration during processing. When a rule has an empty sequence of `cases`, it is always ignored during processing. When a rule has a non-empty sequence of `cases`, its behavior during processing is configured by the first matching `case` in the sequence. When a rule has no matching cases the rule is ignored. A rule case with no `caseCondition` always matches. A rule case with a `caseCondition` matches only when that expression evaluates to true for the given query.
        """
        return pulumi.get(self, "cases")

    @property
    @pulumi.getter(name="defaultAnswerDatas")
    def default_answer_datas(self) -> Optional[Sequence['outputs.SteeringPolicyRuleDefaultAnswerData']]:
        """
        Defines a default set of answer conditions and values that are applied to an answer when `cases` is not defined for the rule, or a matching case does not have any matching `answerCondition`s in its `answerData`. `defaultAnswerData` is not applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed.
        """
        return pulumi.get(self, "default_answer_datas")

    @property
    @pulumi.getter(name="defaultCount")
    def default_count(self) -> Optional[int]:
        """
        Defines a default count if `cases` is not defined for the rule or a matching case does not define `count`. `defaultCount` is **not** applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed. If no rules remain to be processed, the answer will be chosen from the remaining list of answers.
        """
        return pulumi.get(self, "default_count")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A user-defined description of the rule's purpose or behavior.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class SteeringPolicyRuleCase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "answerDatas":
            suggest = "answer_datas"
        elif key == "caseCondition":
            suggest = "case_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SteeringPolicyRuleCase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SteeringPolicyRuleCase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SteeringPolicyRuleCase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 answer_datas: Optional[Sequence['outputs.SteeringPolicyRuleCaseAnswerData']] = None,
                 case_condition: Optional[str] = None,
                 count: Optional[int] = None):
        """
        :param Sequence['SteeringPolicyRuleCaseAnswerDataArgs'] answer_datas: An array of `SteeringPolicyPriorityAnswerData` objects.
        :param str case_condition: An expression that uses conditions at the time of a DNS query to indicate whether a case matches. Conditions may include the geographical location, IP subnet, or ASN the DNS query originated. **Example:** If you have an office that uses the subnet `192.0.2.0/24` you could use a `caseCondition` expression `query.client.subnet in ('192.0.2.0/24')` to define a case that matches queries from that office.
        :param int count: The number of answers allowed to remain after the limit rule has been processed, keeping only the first of the remaining answers in the list. Example: If the `count` property is set to `2` and four answers remain before the limit rule is processed, only the first two answers in the list will remain after the limit rule has been processed.
        """
        SteeringPolicyRuleCase._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_datas=answer_datas,
            case_condition=case_condition,
            count=count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_datas: Optional[Sequence['outputs.SteeringPolicyRuleCaseAnswerData']] = None,
             case_condition: Optional[str] = None,
             count: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerDatas' in kwargs:
            answer_datas = kwargs['answerDatas']
        if 'caseCondition' in kwargs:
            case_condition = kwargs['caseCondition']

        if answer_datas is not None:
            _setter("answer_datas", answer_datas)
        if case_condition is not None:
            _setter("case_condition", case_condition)
        if count is not None:
            _setter("count", count)

    @property
    @pulumi.getter(name="answerDatas")
    def answer_datas(self) -> Optional[Sequence['outputs.SteeringPolicyRuleCaseAnswerData']]:
        """
        An array of `SteeringPolicyPriorityAnswerData` objects.
        """
        return pulumi.get(self, "answer_datas")

    @property
    @pulumi.getter(name="caseCondition")
    def case_condition(self) -> Optional[str]:
        """
        An expression that uses conditions at the time of a DNS query to indicate whether a case matches. Conditions may include the geographical location, IP subnet, or ASN the DNS query originated. **Example:** If you have an office that uses the subnet `192.0.2.0/24` you could use a `caseCondition` expression `query.client.subnet in ('192.0.2.0/24')` to define a case that matches queries from that office.
        """
        return pulumi.get(self, "case_condition")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The number of answers allowed to remain after the limit rule has been processed, keeping only the first of the remaining answers in the list. Example: If the `count` property is set to `2` and four answers remain before the limit rule is processed, only the first two answers in the list will remain after the limit rule has been processed.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class SteeringPolicyRuleCaseAnswerData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "answerCondition":
            suggest = "answer_condition"
        elif key == "shouldKeep":
            suggest = "should_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SteeringPolicyRuleCaseAnswerData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SteeringPolicyRuleCaseAnswerData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SteeringPolicyRuleCaseAnswerData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 answer_condition: Optional[str] = None,
                 should_keep: Optional[bool] = None,
                 value: Optional[int] = None):
        """
        :param str answer_condition: An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        :param bool should_keep: Keeps the answer only if the value is `true`.
        :param int value: The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        SteeringPolicyRuleCaseAnswerData._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_condition=answer_condition,
            should_keep=should_keep,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_condition: Optional[str] = None,
             should_keep: Optional[bool] = None,
             value: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerCondition' in kwargs:
            answer_condition = kwargs['answerCondition']
        if 'shouldKeep' in kwargs:
            should_keep = kwargs['shouldKeep']

        if answer_condition is not None:
            _setter("answer_condition", answer_condition)
        if should_keep is not None:
            _setter("should_keep", should_keep)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter(name="answerCondition")
    def answer_condition(self) -> Optional[str]:
        """
        An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        """
        return pulumi.get(self, "answer_condition")

    @property
    @pulumi.getter(name="shouldKeep")
    def should_keep(self) -> Optional[bool]:
        """
        Keeps the answer only if the value is `true`.
        """
        return pulumi.get(self, "should_keep")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SteeringPolicyRuleDefaultAnswerData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "answerCondition":
            suggest = "answer_condition"
        elif key == "shouldKeep":
            suggest = "should_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SteeringPolicyRuleDefaultAnswerData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SteeringPolicyRuleDefaultAnswerData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SteeringPolicyRuleDefaultAnswerData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 answer_condition: Optional[str] = None,
                 should_keep: Optional[bool] = None,
                 value: Optional[int] = None):
        """
        :param str answer_condition: An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        :param bool should_keep: Keeps the answer only if the value is `true`.
        :param int value: The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        SteeringPolicyRuleDefaultAnswerData._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_condition=answer_condition,
            should_keep=should_keep,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_condition: Optional[str] = None,
             should_keep: Optional[bool] = None,
             value: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerCondition' in kwargs:
            answer_condition = kwargs['answerCondition']
        if 'shouldKeep' in kwargs:
            should_keep = kwargs['shouldKeep']

        if answer_condition is not None:
            _setter("answer_condition", answer_condition)
        if should_keep is not None:
            _setter("should_keep", should_keep)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter(name="answerCondition")
    def answer_condition(self) -> Optional[str]:
        """
        An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        """
        return pulumi.get(self, "answer_condition")

    @property
    @pulumi.getter(name="shouldKeep")
    def should_keep(self) -> Optional[bool]:
        """
        Keeps the answer only if the value is `true`.
        """
        return pulumi.get(self, "should_keep")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ZoneExternalDownstream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tsigKeyId":
            suggest = "tsig_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneExternalDownstream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneExternalDownstream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneExternalDownstream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 port: Optional[int] = None,
                 tsig_key_id: Optional[str] = None):
        """
        :param str address: (Updatable) The server's IP address (IPv4 or IPv6).
        :param int port: (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        :param str tsig_key_id: (Updatable) The OCID of the TSIG key.
        """
        ZoneExternalDownstream._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            port=port,
            tsig_key_id=tsig_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             port: Optional[int] = None,
             tsig_key_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tsigKeyId' in kwargs:
            tsig_key_id = kwargs['tsigKeyId']

        _setter("address", address)
        if port is not None:
            _setter("port", port)
        if tsig_key_id is not None:
            _setter("tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        (Updatable) The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")


@pulumi.output_type
class ZoneExternalMaster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tsigKeyId":
            suggest = "tsig_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneExternalMaster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneExternalMaster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneExternalMaster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 port: Optional[int] = None,
                 tsig_key_id: Optional[str] = None):
        """
        :param str address: (Updatable) The server's IP address (IPv4 or IPv6).
        :param int port: (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        :param str tsig_key_id: (Updatable) The OCID of the TSIG key.
        """
        ZoneExternalMaster._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            port=port,
            tsig_key_id=tsig_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             port: Optional[int] = None,
             tsig_key_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tsigKeyId' in kwargs:
            tsig_key_id = kwargs['tsigKeyId']

        _setter("address", address)
        if port is not None:
            _setter("port", port)
        if tsig_key_id is not None:
            _setter("tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        (Updatable) The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")


@pulumi.output_type
class ZoneNameserver(dict):
    def __init__(__self__, *,
                 hostname: Optional[str] = None):
        """
        :param str hostname: The hostname of the nameserver.
        """
        ZoneNameserver._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hostname=hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hostname: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if hostname is not None:
            _setter("hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        The hostname of the nameserver.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class ZoneZoneTransferServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isTransferDestination":
            suggest = "is_transfer_destination"
        elif key == "isTransferSource":
            suggest = "is_transfer_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneZoneTransferServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneZoneTransferServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneZoneTransferServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 is_transfer_destination: Optional[bool] = None,
                 is_transfer_source: Optional[bool] = None,
                 port: Optional[int] = None):
        """
        :param str address: (Updatable) The server's IP address (IPv4 or IPv6).
        :param bool is_transfer_destination: A Boolean flag indicating whether or not the server is a zone data transfer destination.
        :param bool is_transfer_source: A Boolean flag indicating whether or not the server is a zone data transfer source.
        :param int port: (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        ZoneZoneTransferServer._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            is_transfer_destination=is_transfer_destination,
            is_transfer_source=is_transfer_source,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             is_transfer_destination: Optional[bool] = None,
             is_transfer_source: Optional[bool] = None,
             port: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isTransferDestination' in kwargs:
            is_transfer_destination = kwargs['isTransferDestination']
        if 'isTransferSource' in kwargs:
            is_transfer_source = kwargs['isTransferSource']

        if address is not None:
            _setter("address", address)
        if is_transfer_destination is not None:
            _setter("is_transfer_destination", is_transfer_destination)
        if is_transfer_source is not None:
            _setter("is_transfer_source", is_transfer_source)
        if port is not None:
            _setter("port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        (Updatable) The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="isTransferDestination")
    def is_transfer_destination(self) -> Optional[bool]:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer destination.
        """
        return pulumi.get(self, "is_transfer_destination")

    @property
    @pulumi.getter(name="isTransferSource")
    def is_transfer_source(self) -> Optional[bool]:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer source.
        """
        return pulumi.get(self, "is_transfer_source")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        (Updatable) The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRecordsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetRecordsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRecordsRecordResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 is_protected: bool,
                 record_hash: str,
                 rrset_version: str,
                 rtype: str,
                 zone_name_or_id: str,
                 compartment_id: Optional[str] = None,
                 rdata: Optional[str] = None,
                 ttl: Optional[int] = None):
        """
        :param str domain: Search by domain. Will match any record whose domain (case-insensitive) equals the provided value.
        :param bool is_protected: A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        :param str record_hash: A unique identifier for the record within its zone.
        :param str rrset_version: The latest version of the record's zone in which its RRSet differs from the preceding version.
        :param str rtype: Search by record type. Will match any record whose [type](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4) (case-insensitive) equals the provided value.
        :param str zone_name_or_id: The name or OCID of the target zone.
        :param str compartment_id: The OCID of the compartment the resource belongs to.
        :param str rdata: The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param int ttl: The Time To Live for the record, in seconds.
        """
        GetRecordsRecordResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain=domain,
            is_protected=is_protected,
            record_hash=record_hash,
            rrset_version=rrset_version,
            rtype=rtype,
            zone_name_or_id=zone_name_or_id,
            compartment_id=compartment_id,
            rdata=rdata,
            ttl=ttl,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain: str,
             is_protected: bool,
             record_hash: str,
             rrset_version: str,
             rtype: str,
             zone_name_or_id: str,
             compartment_id: Optional[str] = None,
             rdata: Optional[str] = None,
             ttl: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isProtected' in kwargs:
            is_protected = kwargs['isProtected']
        if 'recordHash' in kwargs:
            record_hash = kwargs['recordHash']
        if 'rrsetVersion' in kwargs:
            rrset_version = kwargs['rrsetVersion']
        if 'zoneNameOrId' in kwargs:
            zone_name_or_id = kwargs['zoneNameOrId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']

        _setter("domain", domain)
        _setter("is_protected", is_protected)
        _setter("record_hash", record_hash)
        _setter("rrset_version", rrset_version)
        _setter("rtype", rtype)
        _setter("zone_name_or_id", zone_name_or_id)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if rdata is not None:
            _setter("rdata", rdata)
        if ttl is not None:
            _setter("ttl", ttl)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Search by domain. Will match any record whose domain (case-insensitive) equals the provided value.
        """
        warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
        pulumi.log.warn("""domain is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")

        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> bool:
        """
        A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter(name="recordHash")
    def record_hash(self) -> str:
        """
        A unique identifier for the record within its zone.
        """
        return pulumi.get(self, "record_hash")

    @property
    @pulumi.getter(name="rrsetVersion")
    def rrset_version(self) -> str:
        """
        The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        return pulumi.get(self, "rrset_version")

    @property
    @pulumi.getter
    def rtype(self) -> str:
        """
        Search by record type. Will match any record whose [type](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4) (case-insensitive) equals the provided value.
        """
        warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
        pulumi.log.warn("""rtype is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")

        return pulumi.get(self, "rtype")

    @property
    @pulumi.getter(name="zoneNameOrId")
    def zone_name_or_id(self) -> str:
        """
        The name or OCID of the target zone.
        """
        warnings.warn("""The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""", DeprecationWarning)
        pulumi.log.warn("""zone_name_or_id is deprecated: The 'oci_dns_record' resource has been deprecated. Please use 'oci_dns_rrset' instead.""")

        return pulumi.get(self, "zone_name_or_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def rdata(self) -> Optional[str]:
        """
        The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[int]:
        """
        The Time To Live for the record, in seconds.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetResolverAttachedViewResult(dict):
    def __init__(__self__, *,
                 view_id: str):
        """
        :param str view_id: The OCID of the view.
        """
        GetResolverAttachedViewResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            view_id=view_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             view_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'viewId' in kwargs:
            view_id = kwargs['viewId']

        _setter("view_id", view_id)

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> str:
        """
        The OCID of the view.
        """
        return pulumi.get(self, "view_id")


@pulumi.output_type
class GetResolverEndpointResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 endpoint_type: str,
                 forwarding_address: str,
                 is_forwarding: bool,
                 is_listening: bool,
                 listening_address: str,
                 name: str,
                 self: str,
                 state: str,
                 subnet_id: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        :param str endpoint_type: The type of resolver endpoint. VNIC is currently the only supported type.
        :param str forwarding_address: An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        :param bool is_forwarding: A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        :param bool is_listening: A Boolean flag indicating whether or not the resolver endpoint is for listening.
        :param str listening_address: An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        :param str name: The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The current state of the resource.
        :param str subnet_id: The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
        :param str time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param str time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        GetResolverEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            endpoint_type=endpoint_type,
            forwarding_address=forwarding_address,
            is_forwarding=is_forwarding,
            is_listening=is_listening,
            listening_address=listening_address,
            name=name,
            self=self,
            state=state,
            subnet_id=subnet_id,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             endpoint_type: str,
             forwarding_address: str,
             is_forwarding: bool,
             is_listening: bool,
             listening_address: str,
             name: str,
             self: str,
             state: str,
             subnet_id: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'endpointType' in kwargs:
            endpoint_type = kwargs['endpointType']
        if 'forwardingAddress' in kwargs:
            forwarding_address = kwargs['forwardingAddress']
        if 'isForwarding' in kwargs:
            is_forwarding = kwargs['isForwarding']
        if 'isListening' in kwargs:
            is_listening = kwargs['isListening']
        if 'listeningAddress' in kwargs:
            listening_address = kwargs['listeningAddress']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("endpoint_type", endpoint_type)
        _setter("forwarding_address", forwarding_address)
        _setter("is_forwarding", is_forwarding)
        _setter("is_listening", is_listening)
        _setter("listening_address", listening_address)
        _setter("name", name)
        _setter("self", self)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of resolver endpoint. VNIC is currently the only supported type.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="forwardingAddress")
    def forwarding_address(self) -> str:
        """
        An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        """
        return pulumi.get(self, "forwarding_address")

    @property
    @pulumi.getter(name="isForwarding")
    def is_forwarding(self) -> bool:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        """
        return pulumi.get(self, "is_forwarding")

    @property
    @pulumi.getter(name="isListening")
    def is_listening(self) -> bool:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for listening.
        """
        return pulumi.get(self, "is_listening")

    @property
    @pulumi.getter(name="listeningAddress")
    def listening_address(self) -> str:
        """
        An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        """
        return pulumi.get(self, "listening_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resolver endpoint. Must be unique, case-insensitive, within the resolver.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetResolverEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of a resource.
        """
        GetResolverEndpointsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResolverEndpointsResolverEndpointResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 endpoint_type: str,
                 forwarding_address: str,
                 is_forwarding: bool,
                 is_listening: bool,
                 listening_address: str,
                 name: str,
                 resolver_id: str,
                 self: str,
                 state: str,
                 subnet_id: str,
                 time_created: str,
                 time_updated: str,
                 nsg_ids: Optional[Sequence[str]] = None,
                 scope: Optional[str] = None):
        """
        :param str compartment_id: The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        :param str endpoint_type: The type of resolver endpoint. VNIC is currently the only supported type.
        :param str forwarding_address: An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        :param bool is_forwarding: A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        :param bool is_listening: A Boolean flag indicating whether or not the resolver endpoint is for listening.
        :param str listening_address: An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        :param str name: The name of a resource.
        :param str resolver_id: The OCID of the target resolver.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The state of a resource.
        :param str subnet_id: The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
        :param str time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param str time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param Sequence[str] nsg_ids: An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        :param str scope: Value must be `PRIVATE` when listing private name resolver endpoints.
        """
        GetResolverEndpointsResolverEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            endpoint_type=endpoint_type,
            forwarding_address=forwarding_address,
            is_forwarding=is_forwarding,
            is_listening=is_listening,
            listening_address=listening_address,
            name=name,
            resolver_id=resolver_id,
            self=self,
            state=state,
            subnet_id=subnet_id,
            time_created=time_created,
            time_updated=time_updated,
            nsg_ids=nsg_ids,
            scope=scope,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             endpoint_type: str,
             forwarding_address: str,
             is_forwarding: bool,
             is_listening: bool,
             listening_address: str,
             name: str,
             resolver_id: str,
             self: str,
             state: str,
             subnet_id: str,
             time_created: str,
             time_updated: str,
             nsg_ids: Optional[Sequence[str]] = None,
             scope: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'endpointType' in kwargs:
            endpoint_type = kwargs['endpointType']
        if 'forwardingAddress' in kwargs:
            forwarding_address = kwargs['forwardingAddress']
        if 'isForwarding' in kwargs:
            is_forwarding = kwargs['isForwarding']
        if 'isListening' in kwargs:
            is_listening = kwargs['isListening']
        if 'listeningAddress' in kwargs:
            listening_address = kwargs['listeningAddress']
        if 'resolverId' in kwargs:
            resolver_id = kwargs['resolverId']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']

        _setter("compartment_id", compartment_id)
        _setter("endpoint_type", endpoint_type)
        _setter("forwarding_address", forwarding_address)
        _setter("is_forwarding", is_forwarding)
        _setter("is_listening", is_listening)
        _setter("listening_address", listening_address)
        _setter("name", name)
        _setter("resolver_id", resolver_id)
        _setter("self", self)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)
        if scope is not None:
            _setter("scope", scope)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of resolver endpoint. VNIC is currently the only supported type.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="forwardingAddress")
    def forwarding_address(self) -> str:
        """
        An IP address from which forwarded queries may be sent. For VNIC endpoints, this IP address must be part of the subnet and will be assigned by the system if unspecified when isForwarding is true.
        """
        return pulumi.get(self, "forwarding_address")

    @property
    @pulumi.getter(name="isForwarding")
    def is_forwarding(self) -> bool:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for forwarding.
        """
        return pulumi.get(self, "is_forwarding")

    @property
    @pulumi.getter(name="isListening")
    def is_listening(self) -> bool:
        """
        A Boolean flag indicating whether or not the resolver endpoint is for listening.
        """
        return pulumi.get(self, "is_listening")

    @property
    @pulumi.getter(name="listeningAddress")
    def listening_address(self) -> str:
        """
        An IP address to listen to queries on. For VNIC endpoints this IP address must be part of the subnet and will be assigned by the system if unspecified when isListening is true.
        """
        return pulumi.get(self, "listening_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resolverId")
    def resolver_id(self) -> str:
        """
        The OCID of the target resolver.
        """
        return pulumi.get(self, "resolver_id")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of a resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of a subnet. Must be part of the VCN that the resolver is attached to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[str]]:
        """
        An array of network security group OCIDs for the resolver endpoint. These must be part of the VCN that the resolver endpoint is a part of.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        Value must be `PRIVATE` when listing private name resolver endpoints.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class GetResolverRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 client_address_conditions: Sequence[str],
                 destination_addresses: Sequence[str],
                 qname_cover_conditions: Sequence[str],
                 source_endpoint_name: str):
        """
        :param str action: The action determines the behavior of the rule. If a query matches a supplied condition, the action will apply. If there are no conditions on the rule, all queries are subject to the specified action.
        :param Sequence[str] client_address_conditions: A list of CIDR blocks. The query must come from a client within one of the blocks in order for the rule action to apply.
        :param Sequence[str] destination_addresses: IP addresses to which queries should be forwarded. Currently limited to a single address.
        :param Sequence[str] qname_cover_conditions: A list of domain names. The query must be covered by one of the domains in order for the rule action to apply.
        :param str source_endpoint_name: Case-insensitive name of an endpoint, that is a sub-resource of the resolver, to use as the forwarding interface. The endpoint must have isForwarding set to true.
        """
        GetResolverRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            client_address_conditions=client_address_conditions,
            destination_addresses=destination_addresses,
            qname_cover_conditions=qname_cover_conditions,
            source_endpoint_name=source_endpoint_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             client_address_conditions: Sequence[str],
             destination_addresses: Sequence[str],
             qname_cover_conditions: Sequence[str],
             source_endpoint_name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientAddressConditions' in kwargs:
            client_address_conditions = kwargs['clientAddressConditions']
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'qnameCoverConditions' in kwargs:
            qname_cover_conditions = kwargs['qnameCoverConditions']
        if 'sourceEndpointName' in kwargs:
            source_endpoint_name = kwargs['sourceEndpointName']

        _setter("action", action)
        _setter("client_address_conditions", client_address_conditions)
        _setter("destination_addresses", destination_addresses)
        _setter("qname_cover_conditions", qname_cover_conditions)
        _setter("source_endpoint_name", source_endpoint_name)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action determines the behavior of the rule. If a query matches a supplied condition, the action will apply. If there are no conditions on the rule, all queries are subject to the specified action.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="clientAddressConditions")
    def client_address_conditions(self) -> Sequence[str]:
        """
        A list of CIDR blocks. The query must come from a client within one of the blocks in order for the rule action to apply.
        """
        return pulumi.get(self, "client_address_conditions")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Sequence[str]:
        """
        IP addresses to which queries should be forwarded. Currently limited to a single address.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="qnameCoverConditions")
    def qname_cover_conditions(self) -> Sequence[str]:
        """
        A list of domain names. The query must be covered by one of the domains in order for the rule action to apply.
        """
        return pulumi.get(self, "qname_cover_conditions")

    @property
    @pulumi.getter(name="sourceEndpointName")
    def source_endpoint_name(self) -> str:
        """
        Case-insensitive name of an endpoint, that is a sub-resource of the resolver, to use as the forwarding interface. The endpoint must have isForwarding set to true.
        """
        return pulumi.get(self, "source_endpoint_name")


@pulumi.output_type
class GetResolversFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetResolversFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResolversResolverResult(dict):
    def __init__(__self__, *,
                 attached_vcn_id: str,
                 attached_views: Sequence['outputs.GetResolversResolverAttachedViewResult'],
                 compartment_id: str,
                 default_view_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 endpoints: Sequence['outputs.GetResolversResolverEndpointResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_protected: bool,
                 resolver_id: str,
                 rules: Sequence['outputs.GetResolversResolverRuleResult'],
                 scope: str,
                 self: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str attached_vcn_id: The OCID of the attached VCN.
        :param str compartment_id: The OCID of the compartment the resource belongs to.
        :param str default_view_id: The OCID of the default view.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param str display_name: The displayName of a resource.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param str id: The OCID of a resource.
        :param bool is_protected: A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        :param str scope: Value must be `PRIVATE` when listing private name resolvers.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The state of a resource.
        :param str time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param str time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        GetResolversResolverResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            attached_vcn_id=attached_vcn_id,
            attached_views=attached_views,
            compartment_id=compartment_id,
            default_view_id=default_view_id,
            defined_tags=defined_tags,
            display_name=display_name,
            endpoints=endpoints,
            freeform_tags=freeform_tags,
            id=id,
            is_protected=is_protected,
            resolver_id=resolver_id,
            rules=rules,
            scope=scope,
            self=self,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             attached_vcn_id: str,
             attached_views: Sequence['outputs.GetResolversResolverAttachedViewResult'],
             compartment_id: str,
             default_view_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             endpoints: Sequence['outputs.GetResolversResolverEndpointResult'],
             freeform_tags: Mapping[str, Any],
             id: str,
             is_protected: bool,
             resolver_id: str,
             rules: Sequence['outputs.GetResolversResolverRuleResult'],
             scope: str,
             self: str,
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'attachedVcnId' in kwargs:
            attached_vcn_id = kwargs['attachedVcnId']
        if 'attachedViews' in kwargs:
            attached_views = kwargs['attachedViews']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'defaultViewId' in kwargs:
            default_view_id = kwargs['defaultViewId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isProtected' in kwargs:
            is_protected = kwargs['isProtected']
        if 'resolverId' in kwargs:
            resolver_id = kwargs['resolverId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("attached_vcn_id", attached_vcn_id)
        _setter("attached_views", attached_views)
        _setter("compartment_id", compartment_id)
        _setter("default_view_id", default_view_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("endpoints", endpoints)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_protected", is_protected)
        _setter("resolver_id", resolver_id)
        _setter("rules", rules)
        _setter("scope", scope)
        _setter("self", self)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="attachedVcnId")
    def attached_vcn_id(self) -> str:
        """
        The OCID of the attached VCN.
        """
        return pulumi.get(self, "attached_vcn_id")

    @property
    @pulumi.getter(name="attachedViews")
    def attached_views(self) -> Sequence['outputs.GetResolversResolverAttachedViewResult']:
        return pulumi.get(self, "attached_views")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultViewId")
    def default_view_id(self) -> str:
        """
        The OCID of the default view.
        """
        return pulumi.get(self, "default_view_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The displayName of a resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetResolversResolverEndpointResult']:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of a resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> bool:
        """
        A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter(name="resolverId")
    def resolver_id(self) -> str:
        return pulumi.get(self, "resolver_id")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetResolversResolverRuleResult']:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Value must be `PRIVATE` when listing private name resolvers.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of a resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetResolversResolverAttachedViewResult(dict):
    def __init__(__self__, *,
                 view_id: str):
        GetResolversResolverAttachedViewResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            view_id=view_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             view_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'viewId' in kwargs:
            view_id = kwargs['viewId']

        _setter("view_id", view_id)

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> str:
        return pulumi.get(self, "view_id")


@pulumi.output_type
class GetResolversResolverEndpointResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 endpoint_type: str,
                 forwarding_address: str,
                 is_forwarding: bool,
                 is_listening: bool,
                 listening_address: str,
                 name: str,
                 self: str,
                 state: str,
                 subnet_id: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the compartment the resource belongs to.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The state of a resource.
        :param str time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param str time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        GetResolversResolverEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            endpoint_type=endpoint_type,
            forwarding_address=forwarding_address,
            is_forwarding=is_forwarding,
            is_listening=is_listening,
            listening_address=listening_address,
            name=name,
            self=self,
            state=state,
            subnet_id=subnet_id,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             endpoint_type: str,
             forwarding_address: str,
             is_forwarding: bool,
             is_listening: bool,
             listening_address: str,
             name: str,
             self: str,
             state: str,
             subnet_id: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'endpointType' in kwargs:
            endpoint_type = kwargs['endpointType']
        if 'forwardingAddress' in kwargs:
            forwarding_address = kwargs['forwardingAddress']
        if 'isForwarding' in kwargs:
            is_forwarding = kwargs['isForwarding']
        if 'isListening' in kwargs:
            is_listening = kwargs['isListening']
        if 'listeningAddress' in kwargs:
            listening_address = kwargs['listeningAddress']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("endpoint_type", endpoint_type)
        _setter("forwarding_address", forwarding_address)
        _setter("is_forwarding", is_forwarding)
        _setter("is_listening", is_listening)
        _setter("listening_address", listening_address)
        _setter("name", name)
        _setter("self", self)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="forwardingAddress")
    def forwarding_address(self) -> str:
        return pulumi.get(self, "forwarding_address")

    @property
    @pulumi.getter(name="isForwarding")
    def is_forwarding(self) -> bool:
        return pulumi.get(self, "is_forwarding")

    @property
    @pulumi.getter(name="isListening")
    def is_listening(self) -> bool:
        return pulumi.get(self, "is_listening")

    @property
    @pulumi.getter(name="listeningAddress")
    def listening_address(self) -> str:
        return pulumi.get(self, "listening_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of a resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetResolversResolverRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 client_address_conditions: Sequence[str],
                 destination_addresses: Sequence[str],
                 qname_cover_conditions: Sequence[str],
                 source_endpoint_name: str):
        GetResolversResolverRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            client_address_conditions=client_address_conditions,
            destination_addresses=destination_addresses,
            qname_cover_conditions=qname_cover_conditions,
            source_endpoint_name=source_endpoint_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             client_address_conditions: Sequence[str],
             destination_addresses: Sequence[str],
             qname_cover_conditions: Sequence[str],
             source_endpoint_name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientAddressConditions' in kwargs:
            client_address_conditions = kwargs['clientAddressConditions']
        if 'destinationAddresses' in kwargs:
            destination_addresses = kwargs['destinationAddresses']
        if 'qnameCoverConditions' in kwargs:
            qname_cover_conditions = kwargs['qnameCoverConditions']
        if 'sourceEndpointName' in kwargs:
            source_endpoint_name = kwargs['sourceEndpointName']

        _setter("action", action)
        _setter("client_address_conditions", client_address_conditions)
        _setter("destination_addresses", destination_addresses)
        _setter("qname_cover_conditions", qname_cover_conditions)
        _setter("source_endpoint_name", source_endpoint_name)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="clientAddressConditions")
    def client_address_conditions(self) -> Sequence[str]:
        return pulumi.get(self, "client_address_conditions")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="qnameCoverConditions")
    def qname_cover_conditions(self) -> Sequence[str]:
        return pulumi.get(self, "qname_cover_conditions")

    @property
    @pulumi.getter(name="sourceEndpointName")
    def source_endpoint_name(self) -> str:
        return pulumi.get(self, "source_endpoint_name")


@pulumi.output_type
class GetRrsetItemResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 is_protected: bool,
                 rdata: str,
                 record_hash: str,
                 rrset_version: str,
                 rtype: str,
                 ttl: int):
        """
        :param str domain: The target fully-qualified domain name (FQDN) within the target zone.
        :param bool is_protected: A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        :param str rdata: The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param str record_hash: A unique identifier for the record within its zone.
        :param str rrset_version: The latest version of the record's zone in which its RRSet differs from the preceding version.
        :param str rtype: The type of the target RRSet within the target zone.
        :param int ttl: The Time To Live for the record, in seconds.
        """
        GetRrsetItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain=domain,
            is_protected=is_protected,
            rdata=rdata,
            record_hash=record_hash,
            rrset_version=rrset_version,
            rtype=rtype,
            ttl=ttl,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain: str,
             is_protected: bool,
             rdata: str,
             record_hash: str,
             rrset_version: str,
             rtype: str,
             ttl: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isProtected' in kwargs:
            is_protected = kwargs['isProtected']
        if 'recordHash' in kwargs:
            record_hash = kwargs['recordHash']
        if 'rrsetVersion' in kwargs:
            rrset_version = kwargs['rrsetVersion']

        _setter("domain", domain)
        _setter("is_protected", is_protected)
        _setter("rdata", rdata)
        _setter("record_hash", record_hash)
        _setter("rrset_version", rrset_version)
        _setter("rtype", rtype)
        _setter("ttl", ttl)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The target fully-qualified domain name (FQDN) within the target zone.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> bool:
        """
        A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter
    def rdata(self) -> str:
        """
        The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter(name="recordHash")
    def record_hash(self) -> str:
        """
        A unique identifier for the record within its zone.
        """
        return pulumi.get(self, "record_hash")

    @property
    @pulumi.getter(name="rrsetVersion")
    def rrset_version(self) -> str:
        """
        The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        return pulumi.get(self, "rrset_version")

    @property
    @pulumi.getter
    def rtype(self) -> str:
        """
        The type of the target RRSet within the target zone.
        """
        return pulumi.get(self, "rtype")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The Time To Live for the record, in seconds.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetRrsetsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetRrsetsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRrsetsRrsetResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 items: Sequence['outputs.GetRrsetsRrsetItemResult'],
                 rtype: str):
        """
        :param str domain: The target fully-qualified domain name (FQDN) within the target zone.
        :param str rtype: Search by record type. Will match any record whose [type](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4) (case-insensitive) equals the provided value.
        """
        GetRrsetsRrsetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain=domain,
            items=items,
            rtype=rtype,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain: str,
             items: Sequence['outputs.GetRrsetsRrsetItemResult'],
             rtype: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("domain", domain)
        _setter("items", items)
        _setter("rtype", rtype)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The target fully-qualified domain name (FQDN) within the target zone.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRrsetsRrsetItemResult']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def rtype(self) -> str:
        """
        Search by record type. Will match any record whose [type](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4) (case-insensitive) equals the provided value.
        """
        return pulumi.get(self, "rtype")


@pulumi.output_type
class GetRrsetsRrsetItemResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 is_protected: bool,
                 rdata: str,
                 record_hash: str,
                 rrset_version: str,
                 rtype: str,
                 ttl: int):
        """
        :param str domain: The target fully-qualified domain name (FQDN) within the target zone.
        :param bool is_protected: A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        :param str rdata: The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        :param str record_hash: A unique identifier for the record within its zone.
        :param str rrset_version: The latest version of the record's zone in which its RRSet differs from the preceding version.
        :param str rtype: Search by record type. Will match any record whose [type](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4) (case-insensitive) equals the provided value.
        :param int ttl: The Time To Live for the record, in seconds.
        """
        GetRrsetsRrsetItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain=domain,
            is_protected=is_protected,
            rdata=rdata,
            record_hash=record_hash,
            rrset_version=rrset_version,
            rtype=rtype,
            ttl=ttl,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain: str,
             is_protected: bool,
             rdata: str,
             record_hash: str,
             rrset_version: str,
             rtype: str,
             ttl: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isProtected' in kwargs:
            is_protected = kwargs['isProtected']
        if 'recordHash' in kwargs:
            record_hash = kwargs['recordHash']
        if 'rrsetVersion' in kwargs:
            rrset_version = kwargs['rrsetVersion']

        _setter("domain", domain)
        _setter("is_protected", is_protected)
        _setter("rdata", rdata)
        _setter("record_hash", record_hash)
        _setter("rrset_version", rrset_version)
        _setter("rtype", rtype)
        _setter("ttl", ttl)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The target fully-qualified domain name (FQDN) within the target zone.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> bool:
        """
        A Boolean flag indicating whether or not parts of the record are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter
    def rdata(self) -> str:
        """
        The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm)
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter(name="recordHash")
    def record_hash(self) -> str:
        """
        A unique identifier for the record within its zone.
        """
        return pulumi.get(self, "record_hash")

    @property
    @pulumi.getter(name="rrsetVersion")
    def rrset_version(self) -> str:
        """
        The latest version of the record's zone in which its RRSet differs from the preceding version.
        """
        return pulumi.get(self, "rrset_version")

    @property
    @pulumi.getter
    def rtype(self) -> str:
        """
        Search by record type. Will match any record whose [type](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-4) (case-insensitive) equals the provided value.
        """
        return pulumi.get(self, "rtype")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The Time To Live for the record, in seconds.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetSteeringPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        """
        GetSteeringPoliciesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSteeringPoliciesSteeringPolicyResult(dict):
    def __init__(__self__, *,
                 answers: Sequence['outputs.GetSteeringPoliciesSteeringPolicyAnswerResult'],
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 health_check_monitor_id: str,
                 id: str,
                 rules: Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleResult'],
                 self: str,
                 state: str,
                 template: str,
                 time_created: str,
                 ttl: int):
        """
        :param Sequence['GetSteeringPoliciesSteeringPolicyAnswerArgs'] answers: The set of all answers that can potentially issue from the steering policy.
        :param str compartment_id: The OCID of the compartment the resource belongs to.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param str display_name: The displayName of a resource.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param str health_check_monitor_id: Search by health check monitor OCID. Will match any resource whose health check monitor ID matches the provided value.
        :param str id: The OCID of a resource.
        :param Sequence['GetSteeringPoliciesSteeringPolicyRuleArgs'] rules: The series of rules that will be processed in sequence to reduce the pool of answers to a response for any given request.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The state of a resource.
        :param str template: Search by steering template type. Will match any resource whose template type matches the provided value.
        :param str time_created: The date and time the resource was created, expressed in RFC 3339 timestamp format.
        :param int ttl: The Time To Live (TTL) for responses from the steering policy, in seconds. If not specified during creation, a value of 30 seconds will be used.
        """
        GetSteeringPoliciesSteeringPolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answers=answers,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            health_check_monitor_id=health_check_monitor_id,
            id=id,
            rules=rules,
            self=self,
            state=state,
            template=template,
            time_created=time_created,
            ttl=ttl,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answers: Sequence['outputs.GetSteeringPoliciesSteeringPolicyAnswerResult'],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             health_check_monitor_id: str,
             id: str,
             rules: Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleResult'],
             self: str,
             state: str,
             template: str,
             time_created: str,
             ttl: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'healthCheckMonitorId' in kwargs:
            health_check_monitor_id = kwargs['healthCheckMonitorId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("answers", answers)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("health_check_monitor_id", health_check_monitor_id)
        _setter("id", id)
        _setter("rules", rules)
        _setter("self", self)
        _setter("state", state)
        _setter("template", template)
        _setter("time_created", time_created)
        _setter("ttl", ttl)

    @property
    @pulumi.getter
    def answers(self) -> Sequence['outputs.GetSteeringPoliciesSteeringPolicyAnswerResult']:
        """
        The set of all answers that can potentially issue from the steering policy.
        """
        return pulumi.get(self, "answers")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The displayName of a resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="healthCheckMonitorId")
    def health_check_monitor_id(self) -> str:
        """
        Search by health check monitor OCID. Will match any resource whose health check monitor ID matches the provided value.
        """
        return pulumi.get(self, "health_check_monitor_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of a resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleResult']:
        """
        The series of rules that will be processed in sequence to reduce the pool of answers to a response for any given request.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of a resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def template(self) -> str:
        """
        Search by steering template type. Will match any resource whose template type matches the provided value.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The Time To Live (TTL) for responses from the steering policy, in seconds. If not specified during creation, a value of 30 seconds will be used.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetSteeringPoliciesSteeringPolicyAnswerResult(dict):
    def __init__(__self__, *,
                 is_disabled: bool,
                 name: str,
                 pool: str,
                 rdata: str,
                 rtype: str):
        """
        :param bool is_disabled: Set this property to `true` to indicate that the answer is administratively disabled, such as when the corresponding server is down for maintenance. An answer's `isDisabled` property can be referenced in `answerCondition` properties in rules using `answer.isDisabled`.
        :param str name: A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        :param str pool: The freeform name of a group of one or more records in which this record is included, such as "LAX data center". An answer's `pool` property can be referenced in `answerCondition` properties of rules using `answer.pool`.
        :param str rdata: The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        :param str rtype: The type of DNS record, such as A or CNAME. Only A, AAAA, and CNAME are supported. For more information, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        GetSteeringPoliciesSteeringPolicyAnswerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_disabled=is_disabled,
            name=name,
            pool=pool,
            rdata=rdata,
            rtype=rtype,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_disabled: bool,
             name: str,
             pool: str,
             rdata: str,
             rtype: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isDisabled' in kwargs:
            is_disabled = kwargs['isDisabled']

        _setter("is_disabled", is_disabled)
        _setter("name", name)
        _setter("pool", pool)
        _setter("rdata", rdata)
        _setter("rtype", rtype)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> bool:
        """
        Set this property to `true` to indicate that the answer is administratively disabled, such as when the corresponding server is down for maintenance. An answer's `isDisabled` property can be referenced in `answerCondition` properties in rules using `answer.isDisabled`.
        """
        return pulumi.get(self, "is_disabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pool(self) -> str:
        """
        The freeform name of a group of one or more records in which this record is included, such as "LAX data center". An answer's `pool` property can be referenced in `answerCondition` properties of rules using `answer.pool`.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def rdata(self) -> str:
        """
        The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter
    def rtype(self) -> str:
        """
        The type of DNS record, such as A or CNAME. Only A, AAAA, and CNAME are supported. For more information, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        return pulumi.get(self, "rtype")


@pulumi.output_type
class GetSteeringPoliciesSteeringPolicyRuleResult(dict):
    def __init__(__self__, *,
                 cases: Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleCaseResult'],
                 default_answer_datas: Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleDefaultAnswerDataResult'],
                 default_count: int,
                 description: str,
                 rule_type: str):
        """
        :param Sequence['GetSteeringPoliciesSteeringPolicyRuleCaseArgs'] cases: An array of `caseConditions`. A rule may optionally include a sequence of cases defining alternate configurations for how it should behave during processing for any given DNS query. When a rule has no sequence of `cases`, it is always evaluated with the same configuration during processing. When a rule has an empty sequence of `cases`, it is always ignored during processing. When a rule has a non-empty sequence of `cases`, its behavior during processing is configured by the first matching `case` in the sequence. When a rule has no matching cases the rule is ignored. A rule case with no `caseCondition` always matches. A rule case with a `caseCondition` matches only when that expression evaluates to true for the given query.
        :param Sequence['GetSteeringPoliciesSteeringPolicyRuleDefaultAnswerDataArgs'] default_answer_datas: Defines a default set of answer conditions and values that are applied to an answer when `cases` is not defined for the rule, or a matching case does not have any matching `answerCondition`s in its `answerData`. `defaultAnswerData` is not applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed.
        :param int default_count: Defines a default count if `cases` is not defined for the rule or a matching case does not define `count`. `defaultCount` is **not** applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed. If no rules remain to be processed, the answer will be chosen from the remaining list of answers.
        :param str description: A user-defined description of the rule's purpose or behavior.
        :param str rule_type: The type of a rule determines its sorting/filtering behavior.
        """
        GetSteeringPoliciesSteeringPolicyRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cases=cases,
            default_answer_datas=default_answer_datas,
            default_count=default_count,
            description=description,
            rule_type=rule_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cases: Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleCaseResult'],
             default_answer_datas: Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleDefaultAnswerDataResult'],
             default_count: int,
             description: str,
             rule_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'defaultAnswerDatas' in kwargs:
            default_answer_datas = kwargs['defaultAnswerDatas']
        if 'defaultCount' in kwargs:
            default_count = kwargs['defaultCount']
        if 'ruleType' in kwargs:
            rule_type = kwargs['ruleType']

        _setter("cases", cases)
        _setter("default_answer_datas", default_answer_datas)
        _setter("default_count", default_count)
        _setter("description", description)
        _setter("rule_type", rule_type)

    @property
    @pulumi.getter
    def cases(self) -> Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleCaseResult']:
        """
        An array of `caseConditions`. A rule may optionally include a sequence of cases defining alternate configurations for how it should behave during processing for any given DNS query. When a rule has no sequence of `cases`, it is always evaluated with the same configuration during processing. When a rule has an empty sequence of `cases`, it is always ignored during processing. When a rule has a non-empty sequence of `cases`, its behavior during processing is configured by the first matching `case` in the sequence. When a rule has no matching cases the rule is ignored. A rule case with no `caseCondition` always matches. A rule case with a `caseCondition` matches only when that expression evaluates to true for the given query.
        """
        return pulumi.get(self, "cases")

    @property
    @pulumi.getter(name="defaultAnswerDatas")
    def default_answer_datas(self) -> Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleDefaultAnswerDataResult']:
        """
        Defines a default set of answer conditions and values that are applied to an answer when `cases` is not defined for the rule, or a matching case does not have any matching `answerCondition`s in its `answerData`. `defaultAnswerData` is not applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed.
        """
        return pulumi.get(self, "default_answer_datas")

    @property
    @pulumi.getter(name="defaultCount")
    def default_count(self) -> int:
        """
        Defines a default count if `cases` is not defined for the rule or a matching case does not define `count`. `defaultCount` is **not** applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed. If no rules remain to be processed, the answer will be chosen from the remaining list of answers.
        """
        return pulumi.get(self, "default_count")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-defined description of the rule's purpose or behavior.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of a rule determines its sorting/filtering behavior.
        """
        return pulumi.get(self, "rule_type")


@pulumi.output_type
class GetSteeringPoliciesSteeringPolicyRuleCaseResult(dict):
    def __init__(__self__, *,
                 answer_datas: Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleCaseAnswerDataResult'],
                 case_condition: str,
                 count: int):
        """
        :param Sequence['GetSteeringPoliciesSteeringPolicyRuleCaseAnswerDataArgs'] answer_datas: An array of `SteeringPolicyPriorityAnswerData` objects.
        :param str case_condition: An expression that uses conditions at the time of a DNS query to indicate whether a case matches. Conditions may include the geographical location, IP subnet, or ASN the DNS query originated. **Example:** If you have an office that uses the subnet `192.0.2.0/24` you could use a `caseCondition` expression `query.client.subnet in ('192.0.2.0/24')` to define a case that matches queries from that office.
        :param int count: The number of answers allowed to remain after the limit rule has been processed, keeping only the first of the remaining answers in the list. Example: If the `count` property is set to `2` and four answers remain before the limit rule is processed, only the first two answers in the list will remain after the limit rule has been processed.
        """
        GetSteeringPoliciesSteeringPolicyRuleCaseResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_datas=answer_datas,
            case_condition=case_condition,
            count=count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_datas: Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleCaseAnswerDataResult'],
             case_condition: str,
             count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerDatas' in kwargs:
            answer_datas = kwargs['answerDatas']
        if 'caseCondition' in kwargs:
            case_condition = kwargs['caseCondition']

        _setter("answer_datas", answer_datas)
        _setter("case_condition", case_condition)
        _setter("count", count)

    @property
    @pulumi.getter(name="answerDatas")
    def answer_datas(self) -> Sequence['outputs.GetSteeringPoliciesSteeringPolicyRuleCaseAnswerDataResult']:
        """
        An array of `SteeringPolicyPriorityAnswerData` objects.
        """
        return pulumi.get(self, "answer_datas")

    @property
    @pulumi.getter(name="caseCondition")
    def case_condition(self) -> str:
        """
        An expression that uses conditions at the time of a DNS query to indicate whether a case matches. Conditions may include the geographical location, IP subnet, or ASN the DNS query originated. **Example:** If you have an office that uses the subnet `192.0.2.0/24` you could use a `caseCondition` expression `query.client.subnet in ('192.0.2.0/24')` to define a case that matches queries from that office.
        """
        return pulumi.get(self, "case_condition")

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of answers allowed to remain after the limit rule has been processed, keeping only the first of the remaining answers in the list. Example: If the `count` property is set to `2` and four answers remain before the limit rule is processed, only the first two answers in the list will remain after the limit rule has been processed.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class GetSteeringPoliciesSteeringPolicyRuleCaseAnswerDataResult(dict):
    def __init__(__self__, *,
                 answer_condition: str,
                 should_keep: bool,
                 value: int):
        """
        :param str answer_condition: An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        :param bool should_keep: Keeps the answer only if the value is `true`.
        :param int value: The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        GetSteeringPoliciesSteeringPolicyRuleCaseAnswerDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_condition=answer_condition,
            should_keep=should_keep,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_condition: str,
             should_keep: bool,
             value: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerCondition' in kwargs:
            answer_condition = kwargs['answerCondition']
        if 'shouldKeep' in kwargs:
            should_keep = kwargs['shouldKeep']

        _setter("answer_condition", answer_condition)
        _setter("should_keep", should_keep)
        _setter("value", value)

    @property
    @pulumi.getter(name="answerCondition")
    def answer_condition(self) -> str:
        """
        An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        """
        return pulumi.get(self, "answer_condition")

    @property
    @pulumi.getter(name="shouldKeep")
    def should_keep(self) -> bool:
        """
        Keeps the answer only if the value is `true`.
        """
        return pulumi.get(self, "should_keep")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSteeringPoliciesSteeringPolicyRuleDefaultAnswerDataResult(dict):
    def __init__(__self__, *,
                 answer_condition: str,
                 should_keep: bool,
                 value: int):
        """
        :param str answer_condition: An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        :param bool should_keep: Keeps the answer only if the value is `true`.
        :param int value: The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        GetSteeringPoliciesSteeringPolicyRuleDefaultAnswerDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_condition=answer_condition,
            should_keep=should_keep,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_condition: str,
             should_keep: bool,
             value: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerCondition' in kwargs:
            answer_condition = kwargs['answerCondition']
        if 'shouldKeep' in kwargs:
            should_keep = kwargs['shouldKeep']

        _setter("answer_condition", answer_condition)
        _setter("should_keep", should_keep)
        _setter("value", value)

    @property
    @pulumi.getter(name="answerCondition")
    def answer_condition(self) -> str:
        """
        An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        """
        return pulumi.get(self, "answer_condition")

    @property
    @pulumi.getter(name="shouldKeep")
    def should_keep(self) -> bool:
        """
        Keeps the answer only if the value is `true`.
        """
        return pulumi.get(self, "should_keep")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSteeringPolicyAnswerResult(dict):
    def __init__(__self__, *,
                 is_disabled: bool,
                 name: str,
                 pool: str,
                 rdata: str,
                 rtype: str):
        """
        :param bool is_disabled: Set this property to `true` to indicate that the answer is administratively disabled, such as when the corresponding server is down for maintenance. An answer's `isDisabled` property can be referenced in `answerCondition` properties in rules using `answer.isDisabled`.
        :param str name: A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        :param str pool: The freeform name of a group of one or more records in which this record is included, such as "LAX data center". An answer's `pool` property can be referenced in `answerCondition` properties of rules using `answer.pool`.
        :param str rdata: The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        :param str rtype: The type of DNS record, such as A or CNAME. Only A, AAAA, and CNAME are supported. For more information, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        GetSteeringPolicyAnswerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_disabled=is_disabled,
            name=name,
            pool=pool,
            rdata=rdata,
            rtype=rtype,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_disabled: bool,
             name: str,
             pool: str,
             rdata: str,
             rtype: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isDisabled' in kwargs:
            is_disabled = kwargs['isDisabled']

        _setter("is_disabled", is_disabled)
        _setter("name", name)
        _setter("pool", pool)
        _setter("rdata", rdata)
        _setter("rtype", rtype)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> bool:
        """
        Set this property to `true` to indicate that the answer is administratively disabled, such as when the corresponding server is down for maintenance. An answer's `isDisabled` property can be referenced in `answerCondition` properties in rules using `answer.isDisabled`.
        """
        return pulumi.get(self, "is_disabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-friendly name for the answer, unique within the steering policy. An answer's `name` property can be referenced in `answerCondition` properties of rules using `answer.name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pool(self) -> str:
        """
        The freeform name of a group of one or more records in which this record is included, such as "LAX data center". An answer's `pool` property can be referenced in `answerCondition` properties of rules using `answer.pool`.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def rdata(self) -> str:
        """
        The record's data, as whitespace-delimited tokens in type-specific presentation format. All RDATA is normalized and the returned presentation of your RDATA may differ from its initial input. For more information about RDATA, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        return pulumi.get(self, "rdata")

    @property
    @pulumi.getter
    def rtype(self) -> str:
        """
        The type of DNS record, such as A or CNAME. Only A, AAAA, and CNAME are supported. For more information, see [Supported DNS Resource Record Types](https://docs.cloud.oracle.com/iaas/Content/DNS/Reference/supporteddnsresource.htm).
        """
        return pulumi.get(self, "rtype")


@pulumi.output_type
class GetSteeringPolicyAttachmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetSteeringPolicyAttachmentsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSteeringPolicyAttachmentsSteeringPolicyAttachmentResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 display_name: str,
                 domain_name: str,
                 id: str,
                 rtypes: Sequence[str],
                 self: str,
                 state: str,
                 steering_policy_id: str,
                 time_created: str,
                 zone_id: str):
        """
        :param str compartment_id: The OCID of the compartment the resource belongs to.
        :param str display_name: The displayName of a resource.
        :param str domain_name: The attached domain within the attached zone.
        :param str id: The OCID of a resource.
        :param Sequence[str] rtypes: The record types covered by the attachment at the domain. The set of record types is determined by aggregating the record types from the answers defined in the steering policy.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The state of a resource.
        :param str steering_policy_id: Search by steering policy OCID. Will match any resource whose steering policy ID matches the provided value.
        :param str time_created: The date and time the resource was created, expressed in RFC 3339 timestamp format.
        :param str zone_id: Search by zone OCID. Will match any resource whose zone ID matches the provided value.
        """
        GetSteeringPolicyAttachmentsSteeringPolicyAttachmentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            display_name=display_name,
            domain_name=domain_name,
            id=id,
            rtypes=rtypes,
            self=self,
            state=state,
            steering_policy_id=steering_policy_id,
            time_created=time_created,
            zone_id=zone_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             display_name: str,
             domain_name: str,
             id: str,
             rtypes: Sequence[str],
             self: str,
             state: str,
             steering_policy_id: str,
             time_created: str,
             zone_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'domainName' in kwargs:
            domain_name = kwargs['domainName']
        if 'steeringPolicyId' in kwargs:
            steering_policy_id = kwargs['steeringPolicyId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'zoneId' in kwargs:
            zone_id = kwargs['zoneId']

        _setter("compartment_id", compartment_id)
        _setter("display_name", display_name)
        _setter("domain_name", domain_name)
        _setter("id", id)
        _setter("rtypes", rtypes)
        _setter("self", self)
        _setter("state", state)
        _setter("steering_policy_id", steering_policy_id)
        _setter("time_created", time_created)
        _setter("zone_id", zone_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The displayName of a resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The attached domain within the attached zone.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of a resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rtypes(self) -> Sequence[str]:
        """
        The record types covered by the attachment at the domain. The set of record types is determined by aggregating the record types from the answers defined in the steering policy.
        """
        return pulumi.get(self, "rtypes")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of a resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="steeringPolicyId")
    def steering_policy_id(self) -> str:
        """
        Search by steering policy OCID. Will match any resource whose steering policy ID matches the provided value.
        """
        return pulumi.get(self, "steering_policy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        Search by zone OCID. Will match any resource whose zone ID matches the provided value.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetSteeringPolicyRuleResult(dict):
    def __init__(__self__, *,
                 cases: Sequence['outputs.GetSteeringPolicyRuleCaseResult'],
                 default_answer_datas: Sequence['outputs.GetSteeringPolicyRuleDefaultAnswerDataResult'],
                 default_count: int,
                 description: str,
                 rule_type: str):
        """
        :param Sequence['GetSteeringPolicyRuleCaseArgs'] cases: An array of `caseConditions`. A rule may optionally include a sequence of cases defining alternate configurations for how it should behave during processing for any given DNS query. When a rule has no sequence of `cases`, it is always evaluated with the same configuration during processing. When a rule has an empty sequence of `cases`, it is always ignored during processing. When a rule has a non-empty sequence of `cases`, its behavior during processing is configured by the first matching `case` in the sequence. When a rule has no matching cases the rule is ignored. A rule case with no `caseCondition` always matches. A rule case with a `caseCondition` matches only when that expression evaluates to true for the given query.
        :param Sequence['GetSteeringPolicyRuleDefaultAnswerDataArgs'] default_answer_datas: Defines a default set of answer conditions and values that are applied to an answer when `cases` is not defined for the rule, or a matching case does not have any matching `answerCondition`s in its `answerData`. `defaultAnswerData` is not applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed.
        :param int default_count: Defines a default count if `cases` is not defined for the rule or a matching case does not define `count`. `defaultCount` is **not** applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed. If no rules remain to be processed, the answer will be chosen from the remaining list of answers.
        :param str description: A user-defined description of the rule's purpose or behavior.
        :param str rule_type: The type of a rule determines its sorting/filtering behavior.
        """
        GetSteeringPolicyRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cases=cases,
            default_answer_datas=default_answer_datas,
            default_count=default_count,
            description=description,
            rule_type=rule_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cases: Sequence['outputs.GetSteeringPolicyRuleCaseResult'],
             default_answer_datas: Sequence['outputs.GetSteeringPolicyRuleDefaultAnswerDataResult'],
             default_count: int,
             description: str,
             rule_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'defaultAnswerDatas' in kwargs:
            default_answer_datas = kwargs['defaultAnswerDatas']
        if 'defaultCount' in kwargs:
            default_count = kwargs['defaultCount']
        if 'ruleType' in kwargs:
            rule_type = kwargs['ruleType']

        _setter("cases", cases)
        _setter("default_answer_datas", default_answer_datas)
        _setter("default_count", default_count)
        _setter("description", description)
        _setter("rule_type", rule_type)

    @property
    @pulumi.getter
    def cases(self) -> Sequence['outputs.GetSteeringPolicyRuleCaseResult']:
        """
        An array of `caseConditions`. A rule may optionally include a sequence of cases defining alternate configurations for how it should behave during processing for any given DNS query. When a rule has no sequence of `cases`, it is always evaluated with the same configuration during processing. When a rule has an empty sequence of `cases`, it is always ignored during processing. When a rule has a non-empty sequence of `cases`, its behavior during processing is configured by the first matching `case` in the sequence. When a rule has no matching cases the rule is ignored. A rule case with no `caseCondition` always matches. A rule case with a `caseCondition` matches only when that expression evaluates to true for the given query.
        """
        return pulumi.get(self, "cases")

    @property
    @pulumi.getter(name="defaultAnswerDatas")
    def default_answer_datas(self) -> Sequence['outputs.GetSteeringPolicyRuleDefaultAnswerDataResult']:
        """
        Defines a default set of answer conditions and values that are applied to an answer when `cases` is not defined for the rule, or a matching case does not have any matching `answerCondition`s in its `answerData`. `defaultAnswerData` is not applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed.
        """
        return pulumi.get(self, "default_answer_datas")

    @property
    @pulumi.getter(name="defaultCount")
    def default_count(self) -> int:
        """
        Defines a default count if `cases` is not defined for the rule or a matching case does not define `count`. `defaultCount` is **not** applied if `cases` is defined and there are no matching cases. In this scenario, the next rule will be processed. If no rules remain to be processed, the answer will be chosen from the remaining list of answers.
        """
        return pulumi.get(self, "default_count")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-defined description of the rule's purpose or behavior.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of a rule determines its sorting/filtering behavior.
        """
        return pulumi.get(self, "rule_type")


@pulumi.output_type
class GetSteeringPolicyRuleCaseResult(dict):
    def __init__(__self__, *,
                 answer_datas: Sequence['outputs.GetSteeringPolicyRuleCaseAnswerDataResult'],
                 case_condition: str,
                 count: int):
        """
        :param Sequence['GetSteeringPolicyRuleCaseAnswerDataArgs'] answer_datas: An array of `SteeringPolicyPriorityAnswerData` objects.
        :param str case_condition: An expression that uses conditions at the time of a DNS query to indicate whether a case matches. Conditions may include the geographical location, IP subnet, or ASN the DNS query originated. **Example:** If you have an office that uses the subnet `192.0.2.0/24` you could use a `caseCondition` expression `query.client.subnet in ('192.0.2.0/24')` to define a case that matches queries from that office.
        :param int count: The number of answers allowed to remain after the limit rule has been processed, keeping only the first of the remaining answers in the list. Example: If the `count` property is set to `2` and four answers remain before the limit rule is processed, only the first two answers in the list will remain after the limit rule has been processed.
        """
        GetSteeringPolicyRuleCaseResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_datas=answer_datas,
            case_condition=case_condition,
            count=count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_datas: Sequence['outputs.GetSteeringPolicyRuleCaseAnswerDataResult'],
             case_condition: str,
             count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerDatas' in kwargs:
            answer_datas = kwargs['answerDatas']
        if 'caseCondition' in kwargs:
            case_condition = kwargs['caseCondition']

        _setter("answer_datas", answer_datas)
        _setter("case_condition", case_condition)
        _setter("count", count)

    @property
    @pulumi.getter(name="answerDatas")
    def answer_datas(self) -> Sequence['outputs.GetSteeringPolicyRuleCaseAnswerDataResult']:
        """
        An array of `SteeringPolicyPriorityAnswerData` objects.
        """
        return pulumi.get(self, "answer_datas")

    @property
    @pulumi.getter(name="caseCondition")
    def case_condition(self) -> str:
        """
        An expression that uses conditions at the time of a DNS query to indicate whether a case matches. Conditions may include the geographical location, IP subnet, or ASN the DNS query originated. **Example:** If you have an office that uses the subnet `192.0.2.0/24` you could use a `caseCondition` expression `query.client.subnet in ('192.0.2.0/24')` to define a case that matches queries from that office.
        """
        return pulumi.get(self, "case_condition")

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of answers allowed to remain after the limit rule has been processed, keeping only the first of the remaining answers in the list. Example: If the `count` property is set to `2` and four answers remain before the limit rule is processed, only the first two answers in the list will remain after the limit rule has been processed.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class GetSteeringPolicyRuleCaseAnswerDataResult(dict):
    def __init__(__self__, *,
                 answer_condition: str,
                 should_keep: bool,
                 value: int):
        """
        :param str answer_condition: An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        :param bool should_keep: Keeps the answer only if the value is `true`.
        :param int value: The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        GetSteeringPolicyRuleCaseAnswerDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_condition=answer_condition,
            should_keep=should_keep,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_condition: str,
             should_keep: bool,
             value: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerCondition' in kwargs:
            answer_condition = kwargs['answerCondition']
        if 'shouldKeep' in kwargs:
            should_keep = kwargs['shouldKeep']

        _setter("answer_condition", answer_condition)
        _setter("should_keep", should_keep)
        _setter("value", value)

    @property
    @pulumi.getter(name="answerCondition")
    def answer_condition(self) -> str:
        """
        An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        """
        return pulumi.get(self, "answer_condition")

    @property
    @pulumi.getter(name="shouldKeep")
    def should_keep(self) -> bool:
        """
        Keeps the answer only if the value is `true`.
        """
        return pulumi.get(self, "should_keep")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSteeringPolicyRuleDefaultAnswerDataResult(dict):
    def __init__(__self__, *,
                 answer_condition: str,
                 should_keep: bool,
                 value: int):
        """
        :param str answer_condition: An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        :param bool should_keep: Keeps the answer only if the value is `true`.
        :param int value: The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        GetSteeringPolicyRuleDefaultAnswerDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            answer_condition=answer_condition,
            should_keep=should_keep,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             answer_condition: str,
             should_keep: bool,
             value: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'answerCondition' in kwargs:
            answer_condition = kwargs['answerCondition']
        if 'shouldKeep' in kwargs:
            should_keep = kwargs['shouldKeep']

        _setter("answer_condition", answer_condition)
        _setter("should_keep", should_keep)
        _setter("value", value)

    @property
    @pulumi.getter(name="answerCondition")
    def answer_condition(self) -> str:
        """
        An expression that is used to select a set of answers that match a condition. For example, answers with matching pool properties.
        """
        return pulumi.get(self, "answer_condition")

    @property
    @pulumi.getter(name="shouldKeep")
    def should_keep(self) -> bool:
        """
        Keeps the answer only if the value is `true`.
        """
        return pulumi.get(self, "should_keep")

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        The rank assigned to the set of answers that match the expression in `answerCondition`. Answers with the lowest values move to the beginning of the list without changing the relative order of those with the same value. Answers can be given a value between `0` and `255`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetTsigKeysFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of a resource.
        """
        GetTsigKeysFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetTsigKeysTsigKeyResult(dict):
    def __init__(__self__, *,
                 algorithm: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 name: str,
                 secret: str,
                 self: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str algorithm: TSIG key algorithms are encoded as domain names, but most consist of only one non-empty label, which is not required to be explicitly absolute. Applicable algorithms include: hmac-sha1, hmac-sha224, hmac-sha256, hmac-sha512. For more information on these algorithms, see [RFC 4635](https://tools.ietf.org/html/rfc4635#section-2).
        :param str compartment_id: The OCID of the compartment the resource belongs to.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param str id: The OCID of a resource.
        :param str name: The name of a resource.
        :param str secret: A base64 string encoding the binary shared secret.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The state of a resource.
        :param str time_created: The date and time the resource was created, expressed in RFC 3339 timestamp format.
        :param str time_updated: The date and time the resource was last updated, expressed in RFC 3339 timestamp format.
        """
        GetTsigKeysTsigKeyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            algorithm=algorithm,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            id=id,
            name=name,
            secret=secret,
            self=self,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             algorithm: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             id: str,
             name: str,
             secret: str,
             self: str,
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("algorithm", algorithm)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("name", name)
        _setter("secret", secret)
        _setter("self", self)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        TSIG key algorithms are encoded as domain names, but most consist of only one non-empty label, which is not required to be explicitly absolute. Applicable algorithms include: hmac-sha1, hmac-sha224, hmac-sha256, hmac-sha512. For more information on these algorithms, see [RFC 4635](https://tools.ietf.org/html/rfc4635#section-2).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of a resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        A base64 string encoding the binary shared secret.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of a resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetViewsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetViewsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetViewsViewResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_protected: bool,
                 scope: str,
                 self: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the compartment the resource belongs to.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param str display_name: The displayName of a resource.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param str id: The OCID of a resource.
        :param bool is_protected: A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        :param str scope: Value must be `PRIVATE` when listing private views.
        :param str self: The canonical absolute URL of the resource.
        :param str state: The state of a resource.
        :param str time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param str time_updated: The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        GetViewsViewResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_protected=is_protected,
            scope=scope,
            self=self,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_protected: bool,
             scope: str,
             self: str,
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isProtected' in kwargs:
            is_protected = kwargs['isProtected']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_protected", is_protected)
        _setter("scope", scope)
        _setter("self", self)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The displayName of a resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of a resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> bool:
        """
        A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Value must be `PRIVATE` when listing private views.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of a resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetZonesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
        """
        GetZonesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 external_downstreams: Sequence['outputs.GetZonesZoneExternalDownstreamResult'],
                 external_masters: Sequence['outputs.GetZonesZoneExternalMasterResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_protected: bool,
                 name: str,
                 nameservers: Sequence['outputs.GetZonesZoneNameserverResult'],
                 scope: str,
                 self: str,
                 serial: int,
                 state: str,
                 time_created: str,
                 version: str,
                 view_id: str,
                 zone_transfer_servers: Sequence['outputs.GetZonesZoneZoneTransferServerResult'],
                 zone_type: str):
        """
        :param str compartment_id: The OCID of the compartment the resource belongs to.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param Sequence['GetZonesZoneExternalDownstreamArgs'] external_downstreams: External secondary servers for the zone. This field is currently not supported when `zoneType` is `SECONDARY` or `scope` is `PRIVATE`.
        :param Sequence['GetZonesZoneExternalMasterArgs'] external_masters: External master servers for the zone. `externalMasters` becomes a required parameter when the `zoneType` value is `SECONDARY`.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param str id: The OCID of the zone.
        :param bool is_protected: A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        :param str name: A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
        :param Sequence['GetZonesZoneNameserverArgs'] nameservers: The authoritative nameservers for the zone.
        :param str scope: Specifies to operate only on resources that have a matching DNS scope. This value will be null 
               for zones in the global DNS and `PRIVATE` when listing private zones.
        :param str self: The canonical absolute URL of the resource.
        :param int serial: The current serial of the zone. As seen in the zone's SOA record.
        :param str state: The state of a resource.
        :param str time_created: The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        :param str version: Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived.
        :param str view_id: The OCID of the view the resource is associated with.
        :param Sequence['GetZonesZoneZoneTransferServerArgs'] zone_transfer_servers: The Oracle Cloud Infrastructure nameservers that transfer the zone data with external nameservers.
        :param str zone_type: Search by zone type, `PRIMARY` or `SECONDARY`. Will match any zone whose type equals the provided value.
        """
        GetZonesZoneResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            external_downstreams=external_downstreams,
            external_masters=external_masters,
            freeform_tags=freeform_tags,
            id=id,
            is_protected=is_protected,
            name=name,
            nameservers=nameservers,
            scope=scope,
            self=self,
            serial=serial,
            state=state,
            time_created=time_created,
            version=version,
            view_id=view_id,
            zone_transfer_servers=zone_transfer_servers,
            zone_type=zone_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             external_downstreams: Sequence['outputs.GetZonesZoneExternalDownstreamResult'],
             external_masters: Sequence['outputs.GetZonesZoneExternalMasterResult'],
             freeform_tags: Mapping[str, Any],
             id: str,
             is_protected: bool,
             name: str,
             nameservers: Sequence['outputs.GetZonesZoneNameserverResult'],
             scope: str,
             self: str,
             serial: int,
             state: str,
             time_created: str,
             version: str,
             view_id: str,
             zone_transfer_servers: Sequence['outputs.GetZonesZoneZoneTransferServerResult'],
             zone_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'externalDownstreams' in kwargs:
            external_downstreams = kwargs['externalDownstreams']
        if 'externalMasters' in kwargs:
            external_masters = kwargs['externalMasters']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isProtected' in kwargs:
            is_protected = kwargs['isProtected']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'viewId' in kwargs:
            view_id = kwargs['viewId']
        if 'zoneTransferServers' in kwargs:
            zone_transfer_servers = kwargs['zoneTransferServers']
        if 'zoneType' in kwargs:
            zone_type = kwargs['zoneType']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("external_downstreams", external_downstreams)
        _setter("external_masters", external_masters)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_protected", is_protected)
        _setter("name", name)
        _setter("nameservers", nameservers)
        _setter("scope", scope)
        _setter("self", self)
        _setter("serial", serial)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("version", version)
        _setter("view_id", view_id)
        _setter("zone_transfer_servers", zone_transfer_servers)
        _setter("zone_type", zone_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="externalDownstreams")
    def external_downstreams(self) -> Sequence['outputs.GetZonesZoneExternalDownstreamResult']:
        """
        External secondary servers for the zone. This field is currently not supported when `zoneType` is `SECONDARY` or `scope` is `PRIVATE`.
        """
        return pulumi.get(self, "external_downstreams")

    @property
    @pulumi.getter(name="externalMasters")
    def external_masters(self) -> Sequence['outputs.GetZonesZoneExternalMasterResult']:
        """
        External master servers for the zone. `externalMasters` becomes a required parameter when the `zoneType` value is `SECONDARY`.
        """
        return pulumi.get(self, "external_masters")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the zone.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> bool:
        """
        A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A case-sensitive filter for zone names. Will match any zone with a name that equals the provided value.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nameservers(self) -> Sequence['outputs.GetZonesZoneNameserverResult']:
        """
        The authoritative nameservers for the zone.
        """
        return pulumi.get(self, "nameservers")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Specifies to operate only on resources that have a matching DNS scope. This value will be null 
        for zones in the global DNS and `PRIVATE` when listing private zones.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def serial(self) -> int:
        """
        The current serial of the zone. As seen in the zone's SOA record.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of a resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> str:
        """
        The OCID of the view the resource is associated with.
        """
        return pulumi.get(self, "view_id")

    @property
    @pulumi.getter(name="zoneTransferServers")
    def zone_transfer_servers(self) -> Sequence['outputs.GetZonesZoneZoneTransferServerResult']:
        """
        The Oracle Cloud Infrastructure nameservers that transfer the zone data with external nameservers.
        """
        return pulumi.get(self, "zone_transfer_servers")

    @property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> str:
        """
        Search by zone type, `PRIMARY` or `SECONDARY`. Will match any zone whose type equals the provided value.
        """
        return pulumi.get(self, "zone_type")


@pulumi.output_type
class GetZonesZoneExternalDownstreamResult(dict):
    def __init__(__self__, *,
                 address: str,
                 port: int,
                 tsig_key_id: str):
        """
        :param str address: The server's IP address (IPv4 or IPv6).
        :param int port: The server's port. Port value must be a value of 53, otherwise omit the port value.
        :param str tsig_key_id: Search for zones that are associated with a TSIG key.
        """
        GetZonesZoneExternalDownstreamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            port=port,
            tsig_key_id=tsig_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             port: int,
             tsig_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tsigKeyId' in kwargs:
            tsig_key_id = kwargs['tsigKeyId']

        _setter("address", address)
        _setter("port", port)
        _setter("tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> str:
        """
        Search for zones that are associated with a TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")


@pulumi.output_type
class GetZonesZoneExternalMasterResult(dict):
    def __init__(__self__, *,
                 address: str,
                 port: int,
                 tsig_key_id: str):
        """
        :param str address: The server's IP address (IPv4 or IPv6).
        :param int port: The server's port. Port value must be a value of 53, otherwise omit the port value.
        :param str tsig_key_id: Search for zones that are associated with a TSIG key.
        """
        GetZonesZoneExternalMasterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            port=port,
            tsig_key_id=tsig_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             port: int,
             tsig_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tsigKeyId' in kwargs:
            tsig_key_id = kwargs['tsigKeyId']

        _setter("address", address)
        _setter("port", port)
        _setter("tsig_key_id", tsig_key_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tsigKeyId")
    def tsig_key_id(self) -> str:
        """
        Search for zones that are associated with a TSIG key.
        """
        return pulumi.get(self, "tsig_key_id")


@pulumi.output_type
class GetZonesZoneNameserverResult(dict):
    def __init__(__self__, *,
                 hostname: str):
        """
        :param str hostname: The hostname of the nameserver.
        """
        GetZonesZoneNameserverResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hostname=hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hostname: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("hostname", hostname)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname of the nameserver.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetZonesZoneZoneTransferServerResult(dict):
    def __init__(__self__, *,
                 address: str,
                 is_transfer_destination: bool,
                 is_transfer_source: bool,
                 port: int):
        """
        :param str address: The server's IP address (IPv4 or IPv6).
        :param bool is_transfer_destination: A Boolean flag indicating whether or not the server is a zone data transfer destination.
        :param bool is_transfer_source: A Boolean flag indicating whether or not the server is a zone data transfer source.
        :param int port: The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        GetZonesZoneZoneTransferServerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            is_transfer_destination=is_transfer_destination,
            is_transfer_source=is_transfer_source,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             is_transfer_destination: bool,
             is_transfer_source: bool,
             port: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isTransferDestination' in kwargs:
            is_transfer_destination = kwargs['isTransferDestination']
        if 'isTransferSource' in kwargs:
            is_transfer_source = kwargs['isTransferSource']

        _setter("address", address)
        _setter("is_transfer_destination", is_transfer_destination)
        _setter("is_transfer_source", is_transfer_source)
        _setter("port", port)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The server's IP address (IPv4 or IPv6).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="isTransferDestination")
    def is_transfer_destination(self) -> bool:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer destination.
        """
        return pulumi.get(self, "is_transfer_destination")

    @property
    @pulumi.getter(name="isTransferSource")
    def is_transfer_source(self) -> bool:
        """
        A Boolean flag indicating whether or not the server is a zone data transfer source.
        """
        return pulumi.get(self, "is_transfer_source")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The server's port. Port value must be a value of 53, otherwise omit the port value.
        """
        return pulumi.get(self, "port")


