# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filesystem_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 source_snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[str] availability_domain: The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        :param pulumi.Input[str] filesystem_snapshot_policy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.
               
               May be unset as a blank value.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        :param pulumi.Input[str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        FileSystemArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            filesystem_snapshot_policy_id=filesystem_snapshot_policy_id,
            freeform_tags=freeform_tags,
            kms_key_id=kms_key_id,
            source_snapshot_id=source_snapshot_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: pulumi.Input[str],
             compartment_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             filesystem_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             kms_key_id: Optional[pulumi.Input[str]] = None,
             source_snapshot_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'filesystemSnapshotPolicyId' in kwargs:
            filesystem_snapshot_policy_id = kwargs['filesystemSnapshotPolicyId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'sourceSnapshotId' in kwargs:
            source_snapshot_id = kwargs['sourceSnapshotId']

        _setter("availability_domain", availability_domain)
        _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if filesystem_snapshot_policy_id is not None:
            _setter("filesystem_snapshot_policy_id", filesystem_snapshot_policy_id)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)
        if source_snapshot_id is not None:
            _setter("source_snapshot_id", source_snapshot_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.

        May be unset as a blank value.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @filesystem_snapshot_policy_id.setter
    def filesystem_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filesystem_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_snapshot_id")

    @source_snapshot_id.setter
    def source_snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot_id", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filesystem_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_clone_parent: Optional[pulumi.Input[bool]] = None,
                 is_hydrated: Optional[pulumi.Input[bool]] = None,
                 is_targetable: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 metered_bytes: Optional[pulumi.Input[str]] = None,
                 replication_target_id: Optional[pulumi.Input[str]] = None,
                 source_details: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]]] = None,
                 source_snapshot_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[str] availability_domain: The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        :param pulumi.Input[str] filesystem_snapshot_policy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.
               
               May be unset as a blank value.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_clone_parent: Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param pulumi.Input[bool] is_hydrated: Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        :param pulumi.Input[bool] is_targetable: Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current 'lifecycleState'.
        :param pulumi.Input[str] metered_bytes: The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        :param pulumi.Input[str] replication_target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        :param pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]] source_details: Source information for the file system.
        :param pulumi.Input[str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the file system.
        :param pulumi.Input[str] time_created: The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        _FileSystemState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            filesystem_snapshot_policy_id=filesystem_snapshot_policy_id,
            freeform_tags=freeform_tags,
            is_clone_parent=is_clone_parent,
            is_hydrated=is_hydrated,
            is_targetable=is_targetable,
            kms_key_id=kms_key_id,
            lifecycle_details=lifecycle_details,
            metered_bytes=metered_bytes,
            replication_target_id=replication_target_id,
            source_details=source_details,
            source_snapshot_id=source_snapshot_id,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             filesystem_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_clone_parent: Optional[pulumi.Input[bool]] = None,
             is_hydrated: Optional[pulumi.Input[bool]] = None,
             is_targetable: Optional[pulumi.Input[bool]] = None,
             kms_key_id: Optional[pulumi.Input[str]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             metered_bytes: Optional[pulumi.Input[str]] = None,
             replication_target_id: Optional[pulumi.Input[str]] = None,
             source_details: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]]] = None,
             source_snapshot_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'filesystemSnapshotPolicyId' in kwargs:
            filesystem_snapshot_policy_id = kwargs['filesystemSnapshotPolicyId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isCloneParent' in kwargs:
            is_clone_parent = kwargs['isCloneParent']
        if 'isHydrated' in kwargs:
            is_hydrated = kwargs['isHydrated']
        if 'isTargetable' in kwargs:
            is_targetable = kwargs['isTargetable']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'meteredBytes' in kwargs:
            metered_bytes = kwargs['meteredBytes']
        if 'replicationTargetId' in kwargs:
            replication_target_id = kwargs['replicationTargetId']
        if 'sourceDetails' in kwargs:
            source_details = kwargs['sourceDetails']
        if 'sourceSnapshotId' in kwargs:
            source_snapshot_id = kwargs['sourceSnapshotId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        if availability_domain is not None:
            _setter("availability_domain", availability_domain)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if filesystem_snapshot_policy_id is not None:
            _setter("filesystem_snapshot_policy_id", filesystem_snapshot_policy_id)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_clone_parent is not None:
            _setter("is_clone_parent", is_clone_parent)
        if is_hydrated is not None:
            _setter("is_hydrated", is_hydrated)
        if is_targetable is not None:
            _setter("is_targetable", is_targetable)
        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if metered_bytes is not None:
            _setter("metered_bytes", metered_bytes)
        if replication_target_id is not None:
            _setter("replication_target_id", replication_target_id)
        if source_details is not None:
            _setter("source_details", source_details)
        if source_snapshot_id is not None:
            _setter("source_snapshot_id", source_snapshot_id)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.

        May be unset as a blank value.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @filesystem_snapshot_policy_id.setter
    def filesystem_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filesystem_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isCloneParent")
    def is_clone_parent(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "is_clone_parent")

    @is_clone_parent.setter
    def is_clone_parent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_clone_parent", value)

    @property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        """
        return pulumi.get(self, "is_hydrated")

    @is_hydrated.setter
    def is_hydrated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hydrated", value)

    @property
    @pulumi.getter(name="isTargetable")
    def is_targetable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        """
        return pulumi.get(self, "is_targetable")

    @is_targetable.setter
    def is_targetable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_targetable", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="meteredBytes")
    def metered_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        """
        return pulumi.get(self, "metered_bytes")

    @metered_bytes.setter
    def metered_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metered_bytes", value)

    @property
    @pulumi.getter(name="replicationTargetId")
    def replication_target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        """
        return pulumi.get(self, "replication_target_id")

    @replication_target_id.setter
    def replication_target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_target_id", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]]]:
        """
        Source information for the file system.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemSourceDetailArgs']]]]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_snapshot_id")

    @source_snapshot_id.setter
    def source_snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the file system.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filesystem_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 source_snapshot_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the File System resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new file system in the specified compartment and
        availability domain. Instances can mount file systems in
        another availability domain, but doing so might increase
        latency when compared to mounting instances in the same
        availability domain.

        After you create a file system, you can associate it with a mount
        target. Instances can then mount the file system by connecting to the
        mount target's IP address. You can associate a file system with
        more than one mount target at a time.

        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about Network Security Groups access control, see
        [Network Security Groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure resources, including
        file systems, get an Oracle-assigned, unique ID called an Oracle
        Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_file_system = oci.file_storage.FileSystem("testFileSystem",
            availability_domain=var["file_system_availability_domain"],
            compartment_id=var["compartment_id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["file_system_display_name"],
            filesystem_snapshot_policy_id=oci_file_storage_filesystem_snapshot_policy["test_filesystem_snapshot_policy"]["id"],
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=oci_kms_key["test_key"]["id"],
            source_snapshot_id=oci_file_storage_snapshot["test_snapshot"]["id"])
        ```

        ## Import

        FileSystems can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:FileStorage/fileSystem:FileSystem test_file_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        :param pulumi.Input[str] filesystem_snapshot_policy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.
               
               May be unset as a blank value.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        :param pulumi.Input[str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the File System resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new file system in the specified compartment and
        availability domain. Instances can mount file systems in
        another availability domain, but doing so might increase
        latency when compared to mounting instances in the same
        availability domain.

        After you create a file system, you can associate it with a mount
        target. Instances can then mount the file system by connecting to the
        mount target's IP address. You can associate a file system with
        more than one mount target at a time.

        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about Network Security Groups access control, see
        [Network Security Groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure resources, including
        file systems, get an Oracle-assigned, unique ID called an Oracle
        Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_file_system = oci.file_storage.FileSystem("testFileSystem",
            availability_domain=var["file_system_availability_domain"],
            compartment_id=var["compartment_id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["file_system_display_name"],
            filesystem_snapshot_policy_id=oci_file_storage_filesystem_snapshot_policy["test_filesystem_snapshot_policy"]["id"],
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=oci_kms_key["test_key"]["id"],
            source_snapshot_id=oci_file_storage_snapshot["test_snapshot"]["id"])
        ```

        ## Import

        FileSystems can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:FileStorage/fileSystem:FileSystem test_file_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            FileSystemArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filesystem_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 source_snapshot_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["filesystem_snapshot_policy_id"] = filesystem_snapshot_policy_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["source_snapshot_id"] = source_snapshot_id
            __props__.__dict__["is_clone_parent"] = None
            __props__.__dict__["is_hydrated"] = None
            __props__.__dict__["is_targetable"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["metered_bytes"] = None
            __props__.__dict__["replication_target_id"] = None
            __props__.__dict__["source_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(FileSystem, __self__).__init__(
            'oci:FileStorage/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            filesystem_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_clone_parent: Optional[pulumi.Input[bool]] = None,
            is_hydrated: Optional[pulumi.Input[bool]] = None,
            is_targetable: Optional[pulumi.Input[bool]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            metered_bytes: Optional[pulumi.Input[str]] = None,
            replication_target_id: Optional[pulumi.Input[str]] = None,
            source_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemSourceDetailArgs']]]]] = None,
            source_snapshot_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        :param pulumi.Input[str] filesystem_snapshot_policy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.
               
               May be unset as a blank value.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_clone_parent: Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param pulumi.Input[bool] is_hydrated: Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        :param pulumi.Input[bool] is_targetable: Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current 'lifecycleState'.
        :param pulumi.Input[str] metered_bytes: The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        :param pulumi.Input[str] replication_target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileSystemSourceDetailArgs']]]] source_details: Source information for the file system.
        :param pulumi.Input[str] source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the file system.
        :param pulumi.Input[str] time_created: The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["filesystem_snapshot_policy_id"] = filesystem_snapshot_policy_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_clone_parent"] = is_clone_parent
        __props__.__dict__["is_hydrated"] = is_hydrated
        __props__.__dict__["is_targetable"] = is_targetable
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["metered_bytes"] = metered_bytes
        __props__.__dict__["replication_target_id"] = replication_target_id
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["source_snapshot_id"] = source_snapshot_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain to create the file system in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the file system in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My file system`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated file system snapshot policy, which controls the frequency of snapshot creation and retention period of the taken snapshots.

        May be unset as a blank value.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isCloneParent")
    def is_clone_parent(self) -> pulumi.Output[bool]:
        """
        Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "is_clone_parent")

    @property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> pulumi.Output[bool]:
        """
        Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        """
        return pulumi.get(self, "is_hydrated")

    @property
    @pulumi.getter(name="isTargetable")
    def is_targetable(self) -> pulumi.Output[bool]:
        """
        Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        """
        return pulumi.get(self, "is_targetable")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The OCID of KMS key used to encrypt the encryption keys associated with this file system. May be unset as a blank or deleted from the configuration to remove the KMS key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="meteredBytes")
    def metered_bytes(self) -> pulumi.Output[str]:
        """
        The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        """
        return pulumi.get(self, "metered_bytes")

    @property
    @pulumi.getter(name="replicationTargetId")
    def replication_target_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        """
        return pulumi.get(self, "replication_target_id")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output[Sequence['outputs.FileSystemSourceDetail']]:
        """
        Source information for the file system.
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_snapshot_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the file system.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

