# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationImagePolicyConfig',
    'ApplicationImagePolicyConfigKeyDetail',
    'ApplicationTraceConfig',
    'FunctionProvisionedConcurrencyConfig',
    'FunctionSourceDetails',
    'FunctionTraceConfig',
    'GetApplicationImagePolicyConfigResult',
    'GetApplicationImagePolicyConfigKeyDetailResult',
    'GetApplicationTraceConfigResult',
    'GetApplicationsApplicationResult',
    'GetApplicationsApplicationImagePolicyConfigResult',
    'GetApplicationsApplicationImagePolicyConfigKeyDetailResult',
    'GetApplicationsApplicationTraceConfigResult',
    'GetApplicationsFilterResult',
    'GetFunctionProvisionedConcurrencyConfigResult',
    'GetFunctionSourceDetailResult',
    'GetFunctionTraceConfigResult',
    'GetFunctionsFilterResult',
    'GetFunctionsFunctionResult',
    'GetFunctionsFunctionProvisionedConcurrencyConfigResult',
    'GetFunctionsFunctionSourceDetailResult',
    'GetFunctionsFunctionTraceConfigResult',
    'GetFusionEnvironmentAdminUserItemResult',
    'GetFusionEnvironmentAdminUsersAdminUserCollectionResult',
    'GetFusionEnvironmentAdminUsersAdminUserCollectionItemResult',
    'GetFusionEnvironmentAdminUsersAdminUserCollectionItemItemResult',
    'GetFusionEnvironmentAdminUsersFilterResult',
    'GetFusionEnvironmentCreateFusionEnvironmentAdminUserDetailResult',
    'GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionResult',
    'GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionItemResult',
    'GetFusionEnvironmentDataMaskingActivitiesFilterResult',
    'GetFusionEnvironmentFamiliesFilterResult',
    'GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionResult',
    'GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemResult',
    'GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemFamilyMaintenancePolicyResult',
    'GetFusionEnvironmentFamilyFamilyMaintenancePolicyResult',
    'GetFusionEnvironmentFamilyLimitsAndUsageDevelopmentLimitAndUsageResult',
    'GetFusionEnvironmentFamilyLimitsAndUsageProductionLimitAndUsageResult',
    'GetFusionEnvironmentFamilyLimitsAndUsageTestLimitAndUsageResult',
    'GetFusionEnvironmentFamilySubscriptionDetailSubscriptionResult',
    'GetFusionEnvironmentFamilySubscriptionDetailSubscriptionSkusResult',
    'GetFusionEnvironmentKmsKeyInfoResult',
    'GetFusionEnvironmentMaintenancePolicyResult',
    'GetFusionEnvironmentMaintenancePolicyQuarterlyUpgradeBeginTimeResult',
    'GetFusionEnvironmentRefreshResult',
    'GetFusionEnvironmentRefreshActivitiesFilterResult',
    'GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionResult',
    'GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemResult',
    'GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemRefreshIssueDetailsListResult',
    'GetFusionEnvironmentRefreshActivityRefreshIssueDetailsListResult',
    'GetFusionEnvironmentRuleResult',
    'GetFusionEnvironmentRuleConditionResult',
    'GetFusionEnvironmentScheduledActivitiesFilterResult',
    'GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionResult',
    'GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemResult',
    'GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemActionResult',
    'GetFusionEnvironmentScheduledActivityActionResult',
    'GetFusionEnvironmentServiceAttachmentsFilterResult',
    'GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionResult',
    'GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionItemResult',
    'GetFusionEnvironmentTimeAvailableForRefreshItemResult',
    'GetFusionEnvironmentTimeAvailableForRefreshsFilterResult',
    'GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionResult',
    'GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionItemResult',
    'GetFusionEnvironmentsFilterResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionItemResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionItemCreateFusionEnvironmentAdminUserDetailResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionItemKmsKeyInfoResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyQuarterlyUpgradeBeginTimeResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionItemRefreshResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleResult',
    'GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleConditionResult',
    'GetPbfListingPublisherDetailResult',
    'GetPbfListingTriggerResult',
    'GetPbfListingTriggersFilterResult',
    'GetPbfListingTriggersTriggersCollectionResult',
    'GetPbfListingTriggersTriggersCollectionItemResult',
    'GetPbfListingVersionConfigResult',
    'GetPbfListingVersionRequirementResult',
    'GetPbfListingVersionRequirementPolicyResult',
    'GetPbfListingVersionTriggerResult',
    'GetPbfListingVersionsFilterResult',
    'GetPbfListingVersionsPbfListingVersionsCollectionResult',
    'GetPbfListingVersionsPbfListingVersionsCollectionItemResult',
    'GetPbfListingVersionsPbfListingVersionsCollectionItemConfigResult',
    'GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementResult',
    'GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementPolicyResult',
    'GetPbfListingVersionsPbfListingVersionsCollectionItemTriggerResult',
    'GetPbfListingsFilterResult',
    'GetPbfListingsPbfListingsCollectionResult',
    'GetPbfListingsPbfListingsCollectionItemResult',
    'GetPbfListingsPbfListingsCollectionItemPublisherDetailResult',
    'GetPbfListingsPbfListingsCollectionItemTriggerResult',
]

@pulumi.output_type
class ApplicationImagePolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPolicyEnabled":
            suggest = "is_policy_enabled"
        elif key == "keyDetails":
            suggest = "key_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationImagePolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationImagePolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationImagePolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_policy_enabled: bool,
                 key_details: Optional[Sequence['outputs.ApplicationImagePolicyConfigKeyDetail']] = None):
        """
        :param bool is_policy_enabled: (Updatable) Define if image signature verification policy is enabled for the application.
        :param Sequence['ApplicationImagePolicyConfigKeyDetailArgs'] key_details: (Updatable) A list of KMS key details.
        """
        ApplicationImagePolicyConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_policy_enabled=is_policy_enabled,
            key_details=key_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_policy_enabled: bool,
             key_details: Optional[Sequence['outputs.ApplicationImagePolicyConfigKeyDetail']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPolicyEnabled' in kwargs:
            is_policy_enabled = kwargs['isPolicyEnabled']
        if 'keyDetails' in kwargs:
            key_details = kwargs['keyDetails']

        _setter("is_policy_enabled", is_policy_enabled)
        if key_details is not None:
            _setter("key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> bool:
        """
        (Updatable) Define if image signature verification policy is enabled for the application.
        """
        return pulumi.get(self, "is_policy_enabled")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Optional[Sequence['outputs.ApplicationImagePolicyConfigKeyDetail']]:
        """
        (Updatable) A list of KMS key details.
        """
        return pulumi.get(self, "key_details")


@pulumi.output_type
class ApplicationImagePolicyConfigKeyDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationImagePolicyConfigKeyDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationImagePolicyConfigKeyDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationImagePolicyConfigKeyDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: str):
        """
        :param str kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the KMS key that will be used to verify the image signature.
        """
        ApplicationImagePolicyConfigKeyDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kms_key_id=kms_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kms_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']

        _setter("kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the KMS key that will be used to verify the image signature.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ApplicationTraceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainId":
            suggest = "domain_id"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationTraceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationTraceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationTraceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_id: Optional[str] = None,
                 is_enabled: Optional[bool] = None):
        """
        :param str domain_id: (Updatable) The OCID of the collector (e.g. an APM Domain) trace events will be sent to.
        :param bool is_enabled: (Updatable) Define if tracing is enabled for the resource. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ApplicationTraceConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain_id=domain_id,
            is_enabled=is_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain_id: Optional[str] = None,
             is_enabled: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'domainId' in kwargs:
            domain_id = kwargs['domainId']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']

        if domain_id is not None:
            _setter("domain_id", domain_id)
        if is_enabled is not None:
            _setter("is_enabled", is_enabled)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the collector (e.g. an APM Domain) trace events will be sent to.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        (Updatable) Define if tracing is enabled for the resource. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class FunctionProvisionedConcurrencyConfig(dict):
    def __init__(__self__, *,
                 strategy: str,
                 count: Optional[int] = None):
        """
        :param str strategy: (Updatable) The strategy for provisioned concurrency to be used.
        :param int count: (Updatable) Configuration specifying a constant amount of provisioned concurrency.
        """
        FunctionProvisionedConcurrencyConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            strategy=strategy,
            count=count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             strategy: str,
             count: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("strategy", strategy)
        if count is not None:
            _setter("count", count)

    @property
    @pulumi.getter
    def strategy(self) -> str:
        """
        (Updatable) The strategy for provisioned concurrency to be used.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        (Updatable) Configuration specifying a constant amount of provisioned concurrency.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class FunctionSourceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pbfListingId":
            suggest = "pbf_listing_id"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSourceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSourceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSourceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pbf_listing_id: str,
                 source_type: str):
        """
        :param str pbf_listing_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PbfListing this function is sourced from.
        :param str source_type: Type of the Function Source. Possible values: PRE_BUILT_FUNCTIONS.
        """
        FunctionSourceDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            pbf_listing_id=pbf_listing_id,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             pbf_listing_id: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'pbfListingId' in kwargs:
            pbf_listing_id = kwargs['pbfListingId']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        _setter("pbf_listing_id", pbf_listing_id)
        _setter("source_type", source_type)

    @property
    @pulumi.getter(name="pbfListingId")
    def pbf_listing_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PbfListing this function is sourced from.
        """
        return pulumi.get(self, "pbf_listing_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Type of the Function Source. Possible values: PRE_BUILT_FUNCTIONS.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class FunctionTraceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionTraceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionTraceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionTraceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None):
        """
        :param bool is_enabled: (Updatable) Define if tracing is enabled for the resource. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        FunctionTraceConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_enabled=is_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_enabled: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']

        if is_enabled is not None:
            _setter("is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        (Updatable) Define if tracing is enabled for the resource. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetApplicationImagePolicyConfigResult(dict):
    def __init__(__self__, *,
                 is_policy_enabled: bool,
                 key_details: Sequence['outputs.GetApplicationImagePolicyConfigKeyDetailResult']):
        """
        :param bool is_policy_enabled: Define if image signature verification policy is enabled for the application.
        :param Sequence['GetApplicationImagePolicyConfigKeyDetailArgs'] key_details: A list of KMS key details.
        """
        GetApplicationImagePolicyConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_policy_enabled=is_policy_enabled,
            key_details=key_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_policy_enabled: bool,
             key_details: Sequence['outputs.GetApplicationImagePolicyConfigKeyDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPolicyEnabled' in kwargs:
            is_policy_enabled = kwargs['isPolicyEnabled']
        if 'keyDetails' in kwargs:
            key_details = kwargs['keyDetails']

        _setter("is_policy_enabled", is_policy_enabled)
        _setter("key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> bool:
        """
        Define if image signature verification policy is enabled for the application.
        """
        return pulumi.get(self, "is_policy_enabled")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Sequence['outputs.GetApplicationImagePolicyConfigKeyDetailResult']:
        """
        A list of KMS key details.
        """
        return pulumi.get(self, "key_details")


@pulumi.output_type
class GetApplicationImagePolicyConfigKeyDetailResult(dict):
    def __init__(__self__, *,
                 kms_key_id: str):
        """
        :param str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the KMS key that will be used to verify the image signature.
        """
        GetApplicationImagePolicyConfigKeyDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kms_key_id=kms_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kms_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']

        _setter("kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the KMS key that will be used to verify the image signature.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetApplicationTraceConfigResult(dict):
    def __init__(__self__, *,
                 domain_id: str,
                 is_enabled: bool):
        """
        :param str domain_id: The OCID of the collector (e.g. an APM Domain) trace events will be sent to.
        :param bool is_enabled: Define if tracing is enabled for the resource.
        """
        GetApplicationTraceConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain_id=domain_id,
            is_enabled=is_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain_id: str,
             is_enabled: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'domainId' in kwargs:
            domain_id = kwargs['domainId']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']

        _setter("domain_id", domain_id)
        _setter("is_enabled", is_enabled)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        """
        The OCID of the collector (e.g. an APM Domain) trace events will be sent to.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Define if tracing is enabled for the resource.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetApplicationsApplicationResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 config: Mapping[str, Any],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 image_policy_configs: Sequence['outputs.GetApplicationsApplicationImagePolicyConfigResult'],
                 network_security_group_ids: Sequence[str],
                 shape: str,
                 state: str,
                 subnet_ids: Sequence[str],
                 syslog_url: str,
                 time_created: str,
                 time_updated: str,
                 trace_configs: Sequence['outputs.GetApplicationsApplicationTraceConfigResult']):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this resource belongs.
        :param Mapping[str, Any] config: Application configuration for functions in this application (passed as environment variables). Can be overridden by function configuration. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only applications with display names that match the display name string. Matching is exact.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: A filter to return only applications with the specified OCID.
        :param Sequence['GetApplicationsApplicationImagePolicyConfigArgs'] image_policy_configs: Define the image signature verification policy for an application.
        :param Sequence[str] network_security_group_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the Network Security Groups to add the application to.
        :param str shape: Valid values are `GENERIC_X86`, `GENERIC_ARM` and `GENERIC_X86_ARM`. Default is `GENERIC_X86`. Setting this to `GENERIC_X86`, will run the functions in the application on X86 processor architecture. Setting this to `GENERIC_ARM`, will run the functions in the application on ARM processor architecture. When set to `GENERIC_X86_ARM`, functions in the application are run on either X86 or ARM processor architecture. Accepted values are: `GENERIC_X86`, `GENERIC_ARM`, `GENERIC_X86_ARM`
        :param str state: A filter to return only applications that match the lifecycle state in this parameter. Example: `Creating`
        :param Sequence[str] subnet_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the subnets in which to run functions in the application.
        :param str syslog_url: A syslog URL to which to send all function logs. Supports tcp, udp, and tcp+tls. The syslog URL must be reachable from all of the subnets configured for the application. Note: If you enable the Oracle Cloud Infrastructure Logging service for this application, the syslogUrl value is ignored. Function logs are sent to the Oracle Cloud Infrastructure Logging service, and not to the syslog URL.  Example: `tcp://logserver.myserver:1234`
        :param str time_created: The time the application was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param str time_updated: The time the application was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-09-12T22:47:12.613Z`
        :param Sequence['GetApplicationsApplicationTraceConfigArgs'] trace_configs: Define the tracing configuration for an application.
        """
        GetApplicationsApplicationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            config=config,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            image_policy_configs=image_policy_configs,
            network_security_group_ids=network_security_group_ids,
            shape=shape,
            state=state,
            subnet_ids=subnet_ids,
            syslog_url=syslog_url,
            time_created=time_created,
            time_updated=time_updated,
            trace_configs=trace_configs,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             config: Mapping[str, Any],
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             image_policy_configs: Sequence['outputs.GetApplicationsApplicationImagePolicyConfigResult'],
             network_security_group_ids: Sequence[str],
             shape: str,
             state: str,
             subnet_ids: Sequence[str],
             syslog_url: str,
             time_created: str,
             time_updated: str,
             trace_configs: Sequence['outputs.GetApplicationsApplicationTraceConfigResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'imagePolicyConfigs' in kwargs:
            image_policy_configs = kwargs['imagePolicyConfigs']
        if 'networkSecurityGroupIds' in kwargs:
            network_security_group_ids = kwargs['networkSecurityGroupIds']
        if 'subnetIds' in kwargs:
            subnet_ids = kwargs['subnetIds']
        if 'syslogUrl' in kwargs:
            syslog_url = kwargs['syslogUrl']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'traceConfigs' in kwargs:
            trace_configs = kwargs['traceConfigs']

        _setter("compartment_id", compartment_id)
        _setter("config", config)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("image_policy_configs", image_policy_configs)
        _setter("network_security_group_ids", network_security_group_ids)
        _setter("shape", shape)
        _setter("state", state)
        _setter("subnet_ids", subnet_ids)
        _setter("syslog_url", syslog_url)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("trace_configs", trace_configs)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this resource belongs.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def config(self) -> Mapping[str, Any]:
        """
        Application configuration for functions in this application (passed as environment variables). Can be overridden by function configuration. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only applications with display names that match the display name string. Matching is exact.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only applications with the specified OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imagePolicyConfigs")
    def image_policy_configs(self) -> Sequence['outputs.GetApplicationsApplicationImagePolicyConfigResult']:
        """
        Define the image signature verification policy for an application.
        """
        return pulumi.get(self, "image_policy_configs")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the Network Security Groups to add the application to.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        Valid values are `GENERIC_X86`, `GENERIC_ARM` and `GENERIC_X86_ARM`. Default is `GENERIC_X86`. Setting this to `GENERIC_X86`, will run the functions in the application on X86 processor architecture. Setting this to `GENERIC_ARM`, will run the functions in the application on ARM processor architecture. When set to `GENERIC_X86_ARM`, functions in the application are run on either X86 or ARM processor architecture. Accepted values are: `GENERIC_X86`, `GENERIC_ARM`, `GENERIC_X86_ARM`
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only applications that match the lifecycle state in this parameter. Example: `Creating`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the subnets in which to run functions in the application.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="syslogUrl")
    def syslog_url(self) -> str:
        """
        A syslog URL to which to send all function logs. Supports tcp, udp, and tcp+tls. The syslog URL must be reachable from all of the subnets configured for the application. Note: If you enable the Oracle Cloud Infrastructure Logging service for this application, the syslogUrl value is ignored. Function logs are sent to the Oracle Cloud Infrastructure Logging service, and not to the syslog URL.  Example: `tcp://logserver.myserver:1234`
        """
        return pulumi.get(self, "syslog_url")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the application was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the application was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="traceConfigs")
    def trace_configs(self) -> Sequence['outputs.GetApplicationsApplicationTraceConfigResult']:
        """
        Define the tracing configuration for an application.
        """
        return pulumi.get(self, "trace_configs")


@pulumi.output_type
class GetApplicationsApplicationImagePolicyConfigResult(dict):
    def __init__(__self__, *,
                 is_policy_enabled: bool,
                 key_details: Sequence['outputs.GetApplicationsApplicationImagePolicyConfigKeyDetailResult']):
        """
        :param bool is_policy_enabled: Define if image signature verification policy is enabled for the application.
        :param Sequence['GetApplicationsApplicationImagePolicyConfigKeyDetailArgs'] key_details: A list of KMS key details.
        """
        GetApplicationsApplicationImagePolicyConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_policy_enabled=is_policy_enabled,
            key_details=key_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_policy_enabled: bool,
             key_details: Sequence['outputs.GetApplicationsApplicationImagePolicyConfigKeyDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPolicyEnabled' in kwargs:
            is_policy_enabled = kwargs['isPolicyEnabled']
        if 'keyDetails' in kwargs:
            key_details = kwargs['keyDetails']

        _setter("is_policy_enabled", is_policy_enabled)
        _setter("key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> bool:
        """
        Define if image signature verification policy is enabled for the application.
        """
        return pulumi.get(self, "is_policy_enabled")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Sequence['outputs.GetApplicationsApplicationImagePolicyConfigKeyDetailResult']:
        """
        A list of KMS key details.
        """
        return pulumi.get(self, "key_details")


@pulumi.output_type
class GetApplicationsApplicationImagePolicyConfigKeyDetailResult(dict):
    def __init__(__self__, *,
                 kms_key_id: str):
        """
        :param str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the KMS key that will be used to verify the image signature.
        """
        GetApplicationsApplicationImagePolicyConfigKeyDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kms_key_id=kms_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kms_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']

        _setter("kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of the KMS key that will be used to verify the image signature.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetApplicationsApplicationTraceConfigResult(dict):
    def __init__(__self__, *,
                 domain_id: str,
                 is_enabled: bool):
        """
        :param str domain_id: The OCID of the collector (e.g. an APM Domain) trace events will be sent to.
        :param bool is_enabled: Define if tracing is enabled for the resource.
        """
        GetApplicationsApplicationTraceConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            domain_id=domain_id,
            is_enabled=is_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             domain_id: str,
             is_enabled: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'domainId' in kwargs:
            domain_id = kwargs['domainId']
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']

        _setter("domain_id", domain_id)
        _setter("is_enabled", is_enabled)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        """
        The OCID of the collector (e.g. an APM Domain) trace events will be sent to.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Define if tracing is enabled for the resource.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetApplicationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetApplicationsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFunctionProvisionedConcurrencyConfigResult(dict):
    def __init__(__self__, *,
                 count: int,
                 strategy: str):
        """
        :param int count: Configuration specifying a constant amount of provisioned concurrency.
        :param str strategy: The strategy for provisioned concurrency to be used.
        """
        GetFunctionProvisionedConcurrencyConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            strategy=strategy,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: int,
             strategy: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("count", count)
        _setter("strategy", strategy)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        Configuration specifying a constant amount of provisioned concurrency.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        """
        The strategy for provisioned concurrency to be used.
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class GetFunctionSourceDetailResult(dict):
    def __init__(__self__, *,
                 pbf_listing_id: str,
                 source_type: str):
        """
        :param str pbf_listing_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PbfListing this function is sourced from.
        :param str source_type: Type of the Function Source. Possible values: PRE_BUILT_FUNCTIONS.
        """
        GetFunctionSourceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            pbf_listing_id=pbf_listing_id,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             pbf_listing_id: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'pbfListingId' in kwargs:
            pbf_listing_id = kwargs['pbfListingId']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        _setter("pbf_listing_id", pbf_listing_id)
        _setter("source_type", source_type)

    @property
    @pulumi.getter(name="pbfListingId")
    def pbf_listing_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PbfListing this function is sourced from.
        """
        return pulumi.get(self, "pbf_listing_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Type of the Function Source. Possible values: PRE_BUILT_FUNCTIONS.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetFunctionTraceConfigResult(dict):
    def __init__(__self__, *,
                 is_enabled: bool):
        """
        :param bool is_enabled: Define if tracing is enabled for the resource.
        """
        GetFunctionTraceConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_enabled=is_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_enabled: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']

        _setter("is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Define if tracing is enabled for the resource.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetFunctionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFunctionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFunctionsFunctionResult(dict):
    def __init__(__self__, *,
                 application_id: str,
                 compartment_id: str,
                 config: Mapping[str, Any],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 image: str,
                 image_digest: str,
                 invoke_endpoint: str,
                 memory_in_mbs: str,
                 provisioned_concurrency_configs: Sequence['outputs.GetFunctionsFunctionProvisionedConcurrencyConfigResult'],
                 shape: str,
                 source_details: Sequence['outputs.GetFunctionsFunctionSourceDetailResult'],
                 state: str,
                 time_created: str,
                 time_updated: str,
                 timeout_in_seconds: int,
                 trace_configs: Sequence['outputs.GetFunctionsFunctionTraceConfigResult']):
        """
        :param str application_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the application to which this function belongs.
        :param str compartment_id: The OCID of the compartment that contains the function.
        :param Mapping[str, Any] config: Function configuration. Overrides application configuration. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only functions with display names that match the display name string. Matching is exact.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: A filter to return only functions with the specified OCID.
        :param str image: The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        :param str image_digest: The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        :param str invoke_endpoint: The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        :param str memory_in_mbs: Maximum usable memory for the function (MiB).
        :param Sequence['GetFunctionsFunctionProvisionedConcurrencyConfigArgs'] provisioned_concurrency_configs: Define the strategy for provisioned concurrency for the function.
        :param str shape: The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        :param Sequence['GetFunctionsFunctionSourceDetailArgs'] source_details: The source details for the Function. The function can be created from various sources.
        :param str state: A filter to return only functions that match the lifecycle state in this parameter. Example: `Creating`
        :param str time_created: The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param str time_updated: The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        :param int timeout_in_seconds: Timeout for executions of the function. Value in seconds.
        :param Sequence['GetFunctionsFunctionTraceConfigArgs'] trace_configs: Define the tracing configuration for a function.
        """
        GetFunctionsFunctionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_id=application_id,
            compartment_id=compartment_id,
            config=config,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            image=image,
            image_digest=image_digest,
            invoke_endpoint=invoke_endpoint,
            memory_in_mbs=memory_in_mbs,
            provisioned_concurrency_configs=provisioned_concurrency_configs,
            shape=shape,
            source_details=source_details,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
            timeout_in_seconds=timeout_in_seconds,
            trace_configs=trace_configs,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_id: str,
             compartment_id: str,
             config: Mapping[str, Any],
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             image: str,
             image_digest: str,
             invoke_endpoint: str,
             memory_in_mbs: str,
             provisioned_concurrency_configs: Sequence['outputs.GetFunctionsFunctionProvisionedConcurrencyConfigResult'],
             shape: str,
             source_details: Sequence['outputs.GetFunctionsFunctionSourceDetailResult'],
             state: str,
             time_created: str,
             time_updated: str,
             timeout_in_seconds: int,
             trace_configs: Sequence['outputs.GetFunctionsFunctionTraceConfigResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'applicationId' in kwargs:
            application_id = kwargs['applicationId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'imageDigest' in kwargs:
            image_digest = kwargs['imageDigest']
        if 'invokeEndpoint' in kwargs:
            invoke_endpoint = kwargs['invokeEndpoint']
        if 'memoryInMbs' in kwargs:
            memory_in_mbs = kwargs['memoryInMbs']
        if 'provisionedConcurrencyConfigs' in kwargs:
            provisioned_concurrency_configs = kwargs['provisionedConcurrencyConfigs']
        if 'sourceDetails' in kwargs:
            source_details = kwargs['sourceDetails']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'timeoutInSeconds' in kwargs:
            timeout_in_seconds = kwargs['timeoutInSeconds']
        if 'traceConfigs' in kwargs:
            trace_configs = kwargs['traceConfigs']

        _setter("application_id", application_id)
        _setter("compartment_id", compartment_id)
        _setter("config", config)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("image", image)
        _setter("image_digest", image_digest)
        _setter("invoke_endpoint", invoke_endpoint)
        _setter("memory_in_mbs", memory_in_mbs)
        _setter("provisioned_concurrency_configs", provisioned_concurrency_configs)
        _setter("shape", shape)
        _setter("source_details", source_details)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("timeout_in_seconds", timeout_in_seconds)
        _setter("trace_configs", trace_configs)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the application to which this function belongs.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the function.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def config(self) -> Mapping[str, Any]:
        """
        Function configuration. Overrides application configuration. Keys must be ASCII strings consisting solely of letters, digits, and the '_' (underscore) character, and must not begin with a digit. Values should be limited to printable unicode characters.  Example: `{"MY_FUNCTION_CONFIG": "ConfVal"}`
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only functions with display names that match the display name string. Matching is exact.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only functions with the specified OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The qualified name of the Docker image to use in the function, including the image tag. The image should be in the Oracle Cloud Infrastructure Registry that is in the same region as the function itself. Example: `phx.ocir.io/ten/functions/function:0.0.1`
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> str:
        """
        The image digest for the version of the image that will be pulled when invoking this function. If no value is specified, the digest currently associated with the image in the Oracle Cloud Infrastructure Registry will be used. Example: `sha256:ca0eeb6fb05351dfc8759c20733c91def84cb8007aa89a5bf606bc8b315b9fc7`
        """
        return pulumi.get(self, "image_digest")

    @property
    @pulumi.getter(name="invokeEndpoint")
    def invoke_endpoint(self) -> str:
        """
        The base https invoke URL to set on a client in order to invoke a function. This URL will never change over the lifetime of the function and can be cached.
        """
        return pulumi.get(self, "invoke_endpoint")

    @property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> str:
        """
        Maximum usable memory for the function (MiB).
        """
        return pulumi.get(self, "memory_in_mbs")

    @property
    @pulumi.getter(name="provisionedConcurrencyConfigs")
    def provisioned_concurrency_configs(self) -> Sequence['outputs.GetFunctionsFunctionProvisionedConcurrencyConfigResult']:
        """
        Define the strategy for provisioned concurrency for the function.
        """
        return pulumi.get(self, "provisioned_concurrency_configs")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The processor shape (`GENERIC_X86`/`GENERIC_ARM`) on which to run functions in the application, extracted from the image manifest.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Sequence['outputs.GetFunctionsFunctionSourceDetailResult']:
        """
        The source details for the Function. The function can be created from various sources.
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only functions that match the lifecycle state in this parameter. Example: `Creating`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the function was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the function was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-09-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        Timeout for executions of the function. Value in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="traceConfigs")
    def trace_configs(self) -> Sequence['outputs.GetFunctionsFunctionTraceConfigResult']:
        """
        Define the tracing configuration for a function.
        """
        return pulumi.get(self, "trace_configs")


@pulumi.output_type
class GetFunctionsFunctionProvisionedConcurrencyConfigResult(dict):
    def __init__(__self__, *,
                 count: int,
                 strategy: str):
        """
        :param int count: Configuration specifying a constant amount of provisioned concurrency.
        :param str strategy: The strategy for provisioned concurrency to be used.
        """
        GetFunctionsFunctionProvisionedConcurrencyConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            strategy=strategy,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: int,
             strategy: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("count", count)
        _setter("strategy", strategy)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        Configuration specifying a constant amount of provisioned concurrency.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        """
        The strategy for provisioned concurrency to be used.
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class GetFunctionsFunctionSourceDetailResult(dict):
    def __init__(__self__, *,
                 pbf_listing_id: str,
                 source_type: str):
        """
        :param str pbf_listing_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PbfListing this function is sourced from.
        :param str source_type: Type of the Function Source. Possible values: PRE_BUILT_FUNCTIONS.
        """
        GetFunctionsFunctionSourceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            pbf_listing_id=pbf_listing_id,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             pbf_listing_id: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'pbfListingId' in kwargs:
            pbf_listing_id = kwargs['pbfListingId']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        _setter("pbf_listing_id", pbf_listing_id)
        _setter("source_type", source_type)

    @property
    @pulumi.getter(name="pbfListingId")
    def pbf_listing_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PbfListing this function is sourced from.
        """
        return pulumi.get(self, "pbf_listing_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Type of the Function Source. Possible values: PRE_BUILT_FUNCTIONS.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetFunctionsFunctionTraceConfigResult(dict):
    def __init__(__self__, *,
                 is_enabled: bool):
        """
        :param bool is_enabled: Define if tracing is enabled for the resource.
        """
        GetFunctionsFunctionTraceConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_enabled=is_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_enabled: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isEnabled' in kwargs:
            is_enabled = kwargs['isEnabled']

        _setter("is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Define if tracing is enabled for the resource.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetFusionEnvironmentAdminUserItemResult(dict):
    def __init__(__self__, *,
                 email_address: str,
                 first_name: str,
                 last_name: str,
                 username: str):
        """
        :param str email_address: Admin users email address
        :param str first_name: Admin users first name
        :param str last_name: Admin users last name
        :param str username: Admin username
        """
        GetFusionEnvironmentAdminUserItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email_address=email_address,
            first_name=first_name,
            last_name=last_name,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email_address: str,
             first_name: str,
             last_name: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'emailAddress' in kwargs:
            email_address = kwargs['emailAddress']
        if 'firstName' in kwargs:
            first_name = kwargs['firstName']
        if 'lastName' in kwargs:
            last_name = kwargs['lastName']

        _setter("email_address", email_address)
        _setter("first_name", first_name)
        _setter("last_name", last_name)
        _setter("username", username)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        Admin users email address
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        Admin users first name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        Admin users last name
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Admin username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetFusionEnvironmentAdminUsersAdminUserCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFusionEnvironmentAdminUsersAdminUserCollectionItemResult']):
        """
        :param Sequence['GetFusionEnvironmentAdminUsersAdminUserCollectionItemArgs'] items: A page of AdminUserSummary objects.
        """
        GetFusionEnvironmentAdminUsersAdminUserCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetFusionEnvironmentAdminUsersAdminUserCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentAdminUsersAdminUserCollectionItemResult']:
        """
        A page of AdminUserSummary objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFusionEnvironmentAdminUsersAdminUserCollectionItemResult(dict):
    def __init__(__self__, *,
                 email_address: str,
                 first_name: str,
                 fusion_environment_id: str,
                 id: str,
                 items: Sequence['outputs.GetFusionEnvironmentAdminUsersAdminUserCollectionItemItemResult'],
                 last_name: str,
                 password: str,
                 username: str):
        """
        :param str email_address: Admin users email address
        :param str first_name: Admin users first name
        :param str fusion_environment_id: unique FusionEnvironment identifier
        :param Sequence['GetFusionEnvironmentAdminUsersAdminUserCollectionItemItemArgs'] items: A page of AdminUserSummary objects.
        :param str last_name: Admin users last name
        :param str username: Admin username
        """
        GetFusionEnvironmentAdminUsersAdminUserCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email_address=email_address,
            first_name=first_name,
            fusion_environment_id=fusion_environment_id,
            id=id,
            items=items,
            last_name=last_name,
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email_address: str,
             first_name: str,
             fusion_environment_id: str,
             id: str,
             items: Sequence['outputs.GetFusionEnvironmentAdminUsersAdminUserCollectionItemItemResult'],
             last_name: str,
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'emailAddress' in kwargs:
            email_address = kwargs['emailAddress']
        if 'firstName' in kwargs:
            first_name = kwargs['firstName']
        if 'fusionEnvironmentId' in kwargs:
            fusion_environment_id = kwargs['fusionEnvironmentId']
        if 'lastName' in kwargs:
            last_name = kwargs['lastName']

        _setter("email_address", email_address)
        _setter("first_name", first_name)
        _setter("fusion_environment_id", fusion_environment_id)
        _setter("id", id)
        _setter("items", items)
        _setter("last_name", last_name)
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        Admin users email address
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        Admin users first name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentAdminUsersAdminUserCollectionItemItemResult']:
        """
        A page of AdminUserSummary objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        Admin users last name
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Admin username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetFusionEnvironmentAdminUsersAdminUserCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 email_address: str,
                 first_name: str,
                 last_name: str,
                 username: str):
        """
        :param str email_address: Admin users email address
        :param str first_name: Admin users first name
        :param str last_name: Admin users last name
        :param str username: Admin username
        """
        GetFusionEnvironmentAdminUsersAdminUserCollectionItemItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email_address=email_address,
            first_name=first_name,
            last_name=last_name,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email_address: str,
             first_name: str,
             last_name: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'emailAddress' in kwargs:
            email_address = kwargs['emailAddress']
        if 'firstName' in kwargs:
            first_name = kwargs['firstName']
        if 'lastName' in kwargs:
            last_name = kwargs['lastName']

        _setter("email_address", email_address)
        _setter("first_name", first_name)
        _setter("last_name", last_name)
        _setter("username", username)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        Admin users email address
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        Admin users first name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        Admin users last name
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Admin username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetFusionEnvironmentAdminUsersFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFusionEnvironmentAdminUsersFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFusionEnvironmentCreateFusionEnvironmentAdminUserDetailResult(dict):
    def __init__(__self__, *,
                 email_address: str,
                 first_name: str,
                 last_name: str,
                 password: str,
                 username: str):
        GetFusionEnvironmentCreateFusionEnvironmentAdminUserDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email_address=email_address,
            first_name=first_name,
            last_name=last_name,
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email_address: str,
             first_name: str,
             last_name: str,
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'emailAddress' in kwargs:
            email_address = kwargs['emailAddress']
        if 'firstName' in kwargs:
            first_name = kwargs['firstName']
        if 'lastName' in kwargs:
            last_name = kwargs['lastName']

        _setter("email_address", email_address)
        _setter("first_name", first_name)
        _setter("last_name", last_name)
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionItemResult']):
        GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionItemResult(dict):
    def __init__(__self__, *,
                 fusion_environment_id: str,
                 id: str,
                 is_resume_data_masking: bool,
                 state: str,
                 time_masking_finish: str,
                 time_masking_start: str):
        """
        :param str fusion_environment_id: unique FusionEnvironment identifier
        :param str id: Unique identifier that is immutable on creation.
        :param str state: A filter that returns all resources that match the specified status
        :param str time_masking_finish: The time the data masking activity ended. An RFC3339 formatted datetime string.
        :param str time_masking_start: The time the data masking activity started. An RFC3339 formatted datetime string.
        """
        GetFusionEnvironmentDataMaskingActivitiesDataMaskingActivityCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fusion_environment_id=fusion_environment_id,
            id=id,
            is_resume_data_masking=is_resume_data_masking,
            state=state,
            time_masking_finish=time_masking_finish,
            time_masking_start=time_masking_start,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fusion_environment_id: str,
             id: str,
             is_resume_data_masking: bool,
             state: str,
             time_masking_finish: str,
             time_masking_start: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'fusionEnvironmentId' in kwargs:
            fusion_environment_id = kwargs['fusionEnvironmentId']
        if 'isResumeDataMasking' in kwargs:
            is_resume_data_masking = kwargs['isResumeDataMasking']
        if 'timeMaskingFinish' in kwargs:
            time_masking_finish = kwargs['timeMaskingFinish']
        if 'timeMaskingStart' in kwargs:
            time_masking_start = kwargs['timeMaskingStart']

        _setter("fusion_environment_id", fusion_environment_id)
        _setter("id", id)
        _setter("is_resume_data_masking", is_resume_data_masking)
        _setter("state", state)
        _setter("time_masking_finish", time_masking_finish)
        _setter("time_masking_start", time_masking_start)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isResumeDataMasking")
    def is_resume_data_masking(self) -> bool:
        return pulumi.get(self, "is_resume_data_masking")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns all resources that match the specified status
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeMaskingFinish")
    def time_masking_finish(self) -> str:
        """
        The time the data masking activity ended. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_masking_finish")

    @property
    @pulumi.getter(name="timeMaskingStart")
    def time_masking_start(self) -> str:
        """
        The time the data masking activity started. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_masking_start")


@pulumi.output_type
class GetFusionEnvironmentDataMaskingActivitiesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFusionEnvironmentDataMaskingActivitiesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFusionEnvironmentFamiliesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFusionEnvironmentFamiliesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemResult']):
        GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 family_maintenance_policies: Sequence['outputs.GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemFamilyMaintenancePolicyResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_subscription_update_needed: bool,
                 lifecycle_details: str,
                 state: str,
                 subscription_ids: Sequence[str],
                 system_name: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemFamilyMaintenancePolicyArgs'] family_maintenance_policies: The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The unique identifier (OCID) of the environment family. Can't be changed after creation.
        :param bool is_subscription_update_needed: When set to True, a subscription update is required for the environment family.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str state: A filter that returns all resources that match the specified lifecycle state.
        :param Sequence[str] subscription_ids: The list of the IDs of the applications subscriptions that are associated with the environment family.
        :param str system_name: Environment Specific Guid/ System Name
        :param str time_created: The time the the FusionEnvironmentFamily was created. An RFC3339 formatted datetime string.
        """
        GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            family_maintenance_policies=family_maintenance_policies,
            freeform_tags=freeform_tags,
            id=id,
            is_subscription_update_needed=is_subscription_update_needed,
            lifecycle_details=lifecycle_details,
            state=state,
            subscription_ids=subscription_ids,
            system_name=system_name,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             family_maintenance_policies: Sequence['outputs.GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemFamilyMaintenancePolicyResult'],
             freeform_tags: Mapping[str, Any],
             id: str,
             is_subscription_update_needed: bool,
             lifecycle_details: str,
             state: str,
             subscription_ids: Sequence[str],
             system_name: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'familyMaintenancePolicies' in kwargs:
            family_maintenance_policies = kwargs['familyMaintenancePolicies']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isSubscriptionUpdateNeeded' in kwargs:
            is_subscription_update_needed = kwargs['isSubscriptionUpdateNeeded']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'subscriptionIds' in kwargs:
            subscription_ids = kwargs['subscriptionIds']
        if 'systemName' in kwargs:
            system_name = kwargs['systemName']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("family_maintenance_policies", family_maintenance_policies)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_subscription_update_needed", is_subscription_update_needed)
        _setter("lifecycle_details", lifecycle_details)
        _setter("state", state)
        _setter("subscription_ids", subscription_ids)
        _setter("system_name", system_name)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="familyMaintenancePolicies")
    def family_maintenance_policies(self) -> Sequence['outputs.GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemFamilyMaintenancePolicyResult']:
        """
        The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        """
        return pulumi.get(self, "family_maintenance_policies")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier (OCID) of the environment family. Can't be changed after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSubscriptionUpdateNeeded")
    def is_subscription_update_needed(self) -> bool:
        """
        When set to True, a subscription update is required for the environment family.
        """
        return pulumi.get(self, "is_subscription_update_needed")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns all resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionIds")
    def subscription_ids(self) -> Sequence[str]:
        """
        The list of the IDs of the applications subscriptions that are associated with the environment family.
        """
        return pulumi.get(self, "subscription_ids")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> str:
        """
        Environment Specific Guid/ System Name
        """
        return pulumi.get(self, "system_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the FusionEnvironmentFamily was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemFamilyMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 concurrent_maintenance: str,
                 is_monthly_patching_enabled: bool,
                 quarterly_upgrade_begin_times: str):
        """
        :param str concurrent_maintenance: Option to upgrade both production and non-production environments at the same time. When set to PROD both types of environnments are upgraded on the production schedule. When set to NON_PROD both types of environments are upgraded on the non-production schedule.
        :param bool is_monthly_patching_enabled: When True, monthly patching is enabled for the environment family.
        :param str quarterly_upgrade_begin_times: The quarterly maintenance month group schedule of the Fusion environment family.
        """
        GetFusionEnvironmentFamiliesFusionEnvironmentFamilyCollectionItemFamilyMaintenancePolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            concurrent_maintenance=concurrent_maintenance,
            is_monthly_patching_enabled=is_monthly_patching_enabled,
            quarterly_upgrade_begin_times=quarterly_upgrade_begin_times,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             concurrent_maintenance: str,
             is_monthly_patching_enabled: bool,
             quarterly_upgrade_begin_times: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'concurrentMaintenance' in kwargs:
            concurrent_maintenance = kwargs['concurrentMaintenance']
        if 'isMonthlyPatchingEnabled' in kwargs:
            is_monthly_patching_enabled = kwargs['isMonthlyPatchingEnabled']
        if 'quarterlyUpgradeBeginTimes' in kwargs:
            quarterly_upgrade_begin_times = kwargs['quarterlyUpgradeBeginTimes']

        _setter("concurrent_maintenance", concurrent_maintenance)
        _setter("is_monthly_patching_enabled", is_monthly_patching_enabled)
        _setter("quarterly_upgrade_begin_times", quarterly_upgrade_begin_times)

    @property
    @pulumi.getter(name="concurrentMaintenance")
    def concurrent_maintenance(self) -> str:
        """
        Option to upgrade both production and non-production environments at the same time. When set to PROD both types of environnments are upgraded on the production schedule. When set to NON_PROD both types of environments are upgraded on the non-production schedule.
        """
        return pulumi.get(self, "concurrent_maintenance")

    @property
    @pulumi.getter(name="isMonthlyPatchingEnabled")
    def is_monthly_patching_enabled(self) -> bool:
        """
        When True, monthly patching is enabled for the environment family.
        """
        return pulumi.get(self, "is_monthly_patching_enabled")

    @property
    @pulumi.getter(name="quarterlyUpgradeBeginTimes")
    def quarterly_upgrade_begin_times(self) -> str:
        """
        The quarterly maintenance month group schedule of the Fusion environment family.
        """
        return pulumi.get(self, "quarterly_upgrade_begin_times")


@pulumi.output_type
class GetFusionEnvironmentFamilyFamilyMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 concurrent_maintenance: str,
                 is_monthly_patching_enabled: bool,
                 quarterly_upgrade_begin_times: str):
        """
        :param str concurrent_maintenance: Option to upgrade both production and non-production environments at the same time. When set to PROD both types of environnments are upgraded on the production schedule. When set to NON_PROD both types of environments are upgraded on the non-production schedule.
        :param bool is_monthly_patching_enabled: When True, monthly patching is enabled for the environment family.
        :param str quarterly_upgrade_begin_times: The quarterly maintenance month group schedule of the Fusion environment family.
        """
        GetFusionEnvironmentFamilyFamilyMaintenancePolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            concurrent_maintenance=concurrent_maintenance,
            is_monthly_patching_enabled=is_monthly_patching_enabled,
            quarterly_upgrade_begin_times=quarterly_upgrade_begin_times,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             concurrent_maintenance: str,
             is_monthly_patching_enabled: bool,
             quarterly_upgrade_begin_times: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'concurrentMaintenance' in kwargs:
            concurrent_maintenance = kwargs['concurrentMaintenance']
        if 'isMonthlyPatchingEnabled' in kwargs:
            is_monthly_patching_enabled = kwargs['isMonthlyPatchingEnabled']
        if 'quarterlyUpgradeBeginTimes' in kwargs:
            quarterly_upgrade_begin_times = kwargs['quarterlyUpgradeBeginTimes']

        _setter("concurrent_maintenance", concurrent_maintenance)
        _setter("is_monthly_patching_enabled", is_monthly_patching_enabled)
        _setter("quarterly_upgrade_begin_times", quarterly_upgrade_begin_times)

    @property
    @pulumi.getter(name="concurrentMaintenance")
    def concurrent_maintenance(self) -> str:
        """
        Option to upgrade both production and non-production environments at the same time. When set to PROD both types of environnments are upgraded on the production schedule. When set to NON_PROD both types of environments are upgraded on the non-production schedule.
        """
        return pulumi.get(self, "concurrent_maintenance")

    @property
    @pulumi.getter(name="isMonthlyPatchingEnabled")
    def is_monthly_patching_enabled(self) -> bool:
        """
        When True, monthly patching is enabled for the environment family.
        """
        return pulumi.get(self, "is_monthly_patching_enabled")

    @property
    @pulumi.getter(name="quarterlyUpgradeBeginTimes")
    def quarterly_upgrade_begin_times(self) -> str:
        """
        The quarterly maintenance month group schedule of the Fusion environment family.
        """
        return pulumi.get(self, "quarterly_upgrade_begin_times")


@pulumi.output_type
class GetFusionEnvironmentFamilyLimitsAndUsageDevelopmentLimitAndUsageResult(dict):
    def __init__(__self__, *,
                 limit: int,
                 usage: int):
        """
        :param int usage: The usage of current environment.
        """
        GetFusionEnvironmentFamilyLimitsAndUsageDevelopmentLimitAndUsageResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            limit=limit,
            usage=usage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             limit: int,
             usage: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("limit", limit)
        _setter("usage", usage)

    @property
    @pulumi.getter
    def limit(self) -> int:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def usage(self) -> int:
        """
        The usage of current environment.
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class GetFusionEnvironmentFamilyLimitsAndUsageProductionLimitAndUsageResult(dict):
    def __init__(__self__, *,
                 limit: int,
                 usage: int):
        """
        :param int usage: The usage of current environment.
        """
        GetFusionEnvironmentFamilyLimitsAndUsageProductionLimitAndUsageResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            limit=limit,
            usage=usage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             limit: int,
             usage: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("limit", limit)
        _setter("usage", usage)

    @property
    @pulumi.getter
    def limit(self) -> int:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def usage(self) -> int:
        """
        The usage of current environment.
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class GetFusionEnvironmentFamilyLimitsAndUsageTestLimitAndUsageResult(dict):
    def __init__(__self__, *,
                 limit: int,
                 usage: int):
        """
        :param int usage: The usage of current environment.
        """
        GetFusionEnvironmentFamilyLimitsAndUsageTestLimitAndUsageResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            limit=limit,
            usage=usage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             limit: int,
             usage: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("limit", limit)
        _setter("usage", usage)

    @property
    @pulumi.getter
    def limit(self) -> int:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def usage(self) -> int:
        """
        The usage of current environment.
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class GetFusionEnvironmentFamilySubscriptionDetailSubscriptionResult(dict):
    def __init__(__self__, *,
                 classic_subscription_id: str,
                 id: str,
                 service_name: str,
                 skuses: Sequence['outputs.GetFusionEnvironmentFamilySubscriptionDetailSubscriptionSkusResult']):
        """
        :param str classic_subscription_id: Subscription id.
        :param str id: OCID of the subscription details for particular root compartment or tenancy.
        :param str service_name: The type of subscription, such as 'CLOUDCM'/'SAAS'/'CRM', etc.
        :param Sequence['GetFusionEnvironmentFamilySubscriptionDetailSubscriptionSkusArgs'] skuses: Stock keeping unit.
        """
        GetFusionEnvironmentFamilySubscriptionDetailSubscriptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            classic_subscription_id=classic_subscription_id,
            id=id,
            service_name=service_name,
            skuses=skuses,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             classic_subscription_id: str,
             id: str,
             service_name: str,
             skuses: Sequence['outputs.GetFusionEnvironmentFamilySubscriptionDetailSubscriptionSkusResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'classicSubscriptionId' in kwargs:
            classic_subscription_id = kwargs['classicSubscriptionId']
        if 'serviceName' in kwargs:
            service_name = kwargs['serviceName']

        _setter("classic_subscription_id", classic_subscription_id)
        _setter("id", id)
        _setter("service_name", service_name)
        _setter("skuses", skuses)

    @property
    @pulumi.getter(name="classicSubscriptionId")
    def classic_subscription_id(self) -> str:
        """
        Subscription id.
        """
        return pulumi.get(self, "classic_subscription_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID of the subscription details for particular root compartment or tenancy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The type of subscription, such as 'CLOUDCM'/'SAAS'/'CRM', etc.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def skuses(self) -> Sequence['outputs.GetFusionEnvironmentFamilySubscriptionDetailSubscriptionSkusResult']:
        """
        Stock keeping unit.
        """
        return pulumi.get(self, "skuses")


@pulumi.output_type
class GetFusionEnvironmentFamilySubscriptionDetailSubscriptionSkusResult(dict):
    def __init__(__self__, *,
                 description: str,
                 license_part_description: str,
                 metric_name: str,
                 quantity: int,
                 sku: str):
        """
        :param str description: Description of the stock units.
        :param str license_part_description: Description of the covered product belonging to this Sku.
        :param str metric_name: Base metric for billing the service.
        :param int quantity: Quantity of the stock units.
        :param str sku: Stock keeping unit id.
        """
        GetFusionEnvironmentFamilySubscriptionDetailSubscriptionSkusResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            license_part_description=license_part_description,
            metric_name=metric_name,
            quantity=quantity,
            sku=sku,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             license_part_description: str,
             metric_name: str,
             quantity: int,
             sku: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'licensePartDescription' in kwargs:
            license_part_description = kwargs['licensePartDescription']
        if 'metricName' in kwargs:
            metric_name = kwargs['metricName']

        _setter("description", description)
        _setter("license_part_description", license_part_description)
        _setter("metric_name", metric_name)
        _setter("quantity", quantity)
        _setter("sku", sku)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the stock units.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="licensePartDescription")
    def license_part_description(self) -> str:
        """
        Description of the covered product belonging to this Sku.
        """
        return pulumi.get(self, "license_part_description")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Base metric for billing the service.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        Quantity of the stock units.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        Stock keeping unit id.
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class GetFusionEnvironmentKmsKeyInfoResult(dict):
    def __init__(__self__, *,
                 active_key_id: str,
                 active_key_version: str,
                 current_key_lifecycle_state: str,
                 scheduled_key_id: str,
                 scheduled_key_status: str,
                 scheduled_key_version: str,
                 scheduled_lifecycle_state: str):
        GetFusionEnvironmentKmsKeyInfoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            active_key_id=active_key_id,
            active_key_version=active_key_version,
            current_key_lifecycle_state=current_key_lifecycle_state,
            scheduled_key_id=scheduled_key_id,
            scheduled_key_status=scheduled_key_status,
            scheduled_key_version=scheduled_key_version,
            scheduled_lifecycle_state=scheduled_lifecycle_state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             active_key_id: str,
             active_key_version: str,
             current_key_lifecycle_state: str,
             scheduled_key_id: str,
             scheduled_key_status: str,
             scheduled_key_version: str,
             scheduled_lifecycle_state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'activeKeyId' in kwargs:
            active_key_id = kwargs['activeKeyId']
        if 'activeKeyVersion' in kwargs:
            active_key_version = kwargs['activeKeyVersion']
        if 'currentKeyLifecycleState' in kwargs:
            current_key_lifecycle_state = kwargs['currentKeyLifecycleState']
        if 'scheduledKeyId' in kwargs:
            scheduled_key_id = kwargs['scheduledKeyId']
        if 'scheduledKeyStatus' in kwargs:
            scheduled_key_status = kwargs['scheduledKeyStatus']
        if 'scheduledKeyVersion' in kwargs:
            scheduled_key_version = kwargs['scheduledKeyVersion']
        if 'scheduledLifecycleState' in kwargs:
            scheduled_lifecycle_state = kwargs['scheduledLifecycleState']

        _setter("active_key_id", active_key_id)
        _setter("active_key_version", active_key_version)
        _setter("current_key_lifecycle_state", current_key_lifecycle_state)
        _setter("scheduled_key_id", scheduled_key_id)
        _setter("scheduled_key_status", scheduled_key_status)
        _setter("scheduled_key_version", scheduled_key_version)
        _setter("scheduled_lifecycle_state", scheduled_lifecycle_state)

    @property
    @pulumi.getter(name="activeKeyId")
    def active_key_id(self) -> str:
        return pulumi.get(self, "active_key_id")

    @property
    @pulumi.getter(name="activeKeyVersion")
    def active_key_version(self) -> str:
        return pulumi.get(self, "active_key_version")

    @property
    @pulumi.getter(name="currentKeyLifecycleState")
    def current_key_lifecycle_state(self) -> str:
        return pulumi.get(self, "current_key_lifecycle_state")

    @property
    @pulumi.getter(name="scheduledKeyId")
    def scheduled_key_id(self) -> str:
        return pulumi.get(self, "scheduled_key_id")

    @property
    @pulumi.getter(name="scheduledKeyStatus")
    def scheduled_key_status(self) -> str:
        return pulumi.get(self, "scheduled_key_status")

    @property
    @pulumi.getter(name="scheduledKeyVersion")
    def scheduled_key_version(self) -> str:
        return pulumi.get(self, "scheduled_key_version")

    @property
    @pulumi.getter(name="scheduledLifecycleState")
    def scheduled_lifecycle_state(self) -> str:
        return pulumi.get(self, "scheduled_lifecycle_state")


@pulumi.output_type
class GetFusionEnvironmentMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 environment_maintenance_override: str,
                 monthly_patching_override: str,
                 quarterly_upgrade_begin_times: Sequence['outputs.GetFusionEnvironmentMaintenancePolicyQuarterlyUpgradeBeginTimeResult']):
        """
        :param str environment_maintenance_override: User choice to upgrade both production and non-production environments at the same time. Overrides the Fusion environment family setting.
        :param str monthly_patching_override: Whether the Fusion environment will be updated monthly or updated on the quarterly cycle. This setting overrides the monthly patching setting of its Fusion environment family.
        :param Sequence['GetFusionEnvironmentMaintenancePolicyQuarterlyUpgradeBeginTimeArgs'] quarterly_upgrade_begin_times: Determines the quarterly upgrade begin times (monthly maintenance group schedule ) of the Fusion environment.
        """
        GetFusionEnvironmentMaintenancePolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            environment_maintenance_override=environment_maintenance_override,
            monthly_patching_override=monthly_patching_override,
            quarterly_upgrade_begin_times=quarterly_upgrade_begin_times,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             environment_maintenance_override: str,
             monthly_patching_override: str,
             quarterly_upgrade_begin_times: Sequence['outputs.GetFusionEnvironmentMaintenancePolicyQuarterlyUpgradeBeginTimeResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'environmentMaintenanceOverride' in kwargs:
            environment_maintenance_override = kwargs['environmentMaintenanceOverride']
        if 'monthlyPatchingOverride' in kwargs:
            monthly_patching_override = kwargs['monthlyPatchingOverride']
        if 'quarterlyUpgradeBeginTimes' in kwargs:
            quarterly_upgrade_begin_times = kwargs['quarterlyUpgradeBeginTimes']

        _setter("environment_maintenance_override", environment_maintenance_override)
        _setter("monthly_patching_override", monthly_patching_override)
        _setter("quarterly_upgrade_begin_times", quarterly_upgrade_begin_times)

    @property
    @pulumi.getter(name="environmentMaintenanceOverride")
    def environment_maintenance_override(self) -> str:
        """
        User choice to upgrade both production and non-production environments at the same time. Overrides the Fusion environment family setting.
        """
        return pulumi.get(self, "environment_maintenance_override")

    @property
    @pulumi.getter(name="monthlyPatchingOverride")
    def monthly_patching_override(self) -> str:
        """
        Whether the Fusion environment will be updated monthly or updated on the quarterly cycle. This setting overrides the monthly patching setting of its Fusion environment family.
        """
        return pulumi.get(self, "monthly_patching_override")

    @property
    @pulumi.getter(name="quarterlyUpgradeBeginTimes")
    def quarterly_upgrade_begin_times(self) -> Sequence['outputs.GetFusionEnvironmentMaintenancePolicyQuarterlyUpgradeBeginTimeResult']:
        """
        Determines the quarterly upgrade begin times (monthly maintenance group schedule ) of the Fusion environment.
        """
        return pulumi.get(self, "quarterly_upgrade_begin_times")


@pulumi.output_type
class GetFusionEnvironmentMaintenancePolicyQuarterlyUpgradeBeginTimeResult(dict):
    def __init__(__self__, *,
                 begin_times_value: str,
                 override_type: str):
        """
        :param str begin_times_value: The frequency and month when maintenance occurs for the Fusion environment.
        :param str override_type: Determines if the maintenance schedule of the Fusion environment is inherited from the Fusion environment family.
        """
        GetFusionEnvironmentMaintenancePolicyQuarterlyUpgradeBeginTimeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            begin_times_value=begin_times_value,
            override_type=override_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             begin_times_value: str,
             override_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'beginTimesValue' in kwargs:
            begin_times_value = kwargs['beginTimesValue']
        if 'overrideType' in kwargs:
            override_type = kwargs['overrideType']

        _setter("begin_times_value", begin_times_value)
        _setter("override_type", override_type)

    @property
    @pulumi.getter(name="beginTimesValue")
    def begin_times_value(self) -> str:
        """
        The frequency and month when maintenance occurs for the Fusion environment.
        """
        return pulumi.get(self, "begin_times_value")

    @property
    @pulumi.getter(name="overrideType")
    def override_type(self) -> str:
        """
        Determines if the maintenance schedule of the Fusion environment is inherited from the Fusion environment family.
        """
        return pulumi.get(self, "override_type")


@pulumi.output_type
class GetFusionEnvironmentRefreshResult(dict):
    def __init__(__self__, *,
                 source_fusion_environment_id: str,
                 time_finished: str,
                 time_of_restoration_point: str):
        """
        :param str source_fusion_environment_id: The source environment id for the last refresh
        :param str time_finished: The time of when the last refresh finish
        :param str time_of_restoration_point: The point of time of the latest DB backup for the last refresh
        """
        GetFusionEnvironmentRefreshResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            source_fusion_environment_id=source_fusion_environment_id,
            time_finished=time_finished,
            time_of_restoration_point=time_of_restoration_point,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             source_fusion_environment_id: str,
             time_finished: str,
             time_of_restoration_point: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'sourceFusionEnvironmentId' in kwargs:
            source_fusion_environment_id = kwargs['sourceFusionEnvironmentId']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeOfRestorationPoint' in kwargs:
            time_of_restoration_point = kwargs['timeOfRestorationPoint']

        _setter("source_fusion_environment_id", source_fusion_environment_id)
        _setter("time_finished", time_finished)
        _setter("time_of_restoration_point", time_of_restoration_point)

    @property
    @pulumi.getter(name="sourceFusionEnvironmentId")
    def source_fusion_environment_id(self) -> str:
        """
        The source environment id for the last refresh
        """
        return pulumi.get(self, "source_fusion_environment_id")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The time of when the last refresh finish
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeOfRestorationPoint")
    def time_of_restoration_point(self) -> str:
        """
        The point of time of the latest DB backup for the last refresh
        """
        return pulumi.get(self, "time_of_restoration_point")


@pulumi.output_type
class GetFusionEnvironmentRefreshActivitiesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFusionEnvironmentRefreshActivitiesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemResult']):
        GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 fusion_environment_id: str,
                 id: str,
                 lifecycle_details: str,
                 refresh_activity_id: str,
                 refresh_issue_details_lists: Sequence['outputs.GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemRefreshIssueDetailsListResult'],
                 service_availability: str,
                 source_fusion_environment_id: str,
                 state: str,
                 time_accepted: str,
                 time_expected_finish: str,
                 time_finished: str,
                 time_of_restoration_point: str,
                 time_updated: str):
        """
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str fusion_environment_id: unique FusionEnvironment identifier
        :param str id: The unique identifier (OCID) of the refresh activity. Can't be changed after creation.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemRefreshIssueDetailsListArgs'] refresh_issue_details_lists: Details of refresh investigation information, each item represents a different issue.
        :param str service_availability: Service availability / impact during refresh activity execution up down
        :param str source_fusion_environment_id: The OCID of the Fusion environment that is the source environment for the refresh.
        :param str state: A filter that returns all resources that match the specified status
        :param str time_accepted: The time the refresh activity record was created. An RFC3339 formatted datetime string.
        :param str time_expected_finish: The time the refresh activity is scheduled to end. An RFC3339 formatted datetime string.
        :param str time_finished: The time the refresh activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        :param str time_of_restoration_point: The date and time of the most recent source environment backup used for the environment refresh.
        :param str time_updated: The time the refresh activity record was updated. An RFC3339 formatted datetime string.
        """
        GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            fusion_environment_id=fusion_environment_id,
            id=id,
            lifecycle_details=lifecycle_details,
            refresh_activity_id=refresh_activity_id,
            refresh_issue_details_lists=refresh_issue_details_lists,
            service_availability=service_availability,
            source_fusion_environment_id=source_fusion_environment_id,
            state=state,
            time_accepted=time_accepted,
            time_expected_finish=time_expected_finish,
            time_finished=time_finished,
            time_of_restoration_point=time_of_restoration_point,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             fusion_environment_id: str,
             id: str,
             lifecycle_details: str,
             refresh_activity_id: str,
             refresh_issue_details_lists: Sequence['outputs.GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemRefreshIssueDetailsListResult'],
             service_availability: str,
             source_fusion_environment_id: str,
             state: str,
             time_accepted: str,
             time_expected_finish: str,
             time_finished: str,
             time_of_restoration_point: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'fusionEnvironmentId' in kwargs:
            fusion_environment_id = kwargs['fusionEnvironmentId']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'refreshActivityId' in kwargs:
            refresh_activity_id = kwargs['refreshActivityId']
        if 'refreshIssueDetailsLists' in kwargs:
            refresh_issue_details_lists = kwargs['refreshIssueDetailsLists']
        if 'serviceAvailability' in kwargs:
            service_availability = kwargs['serviceAvailability']
        if 'sourceFusionEnvironmentId' in kwargs:
            source_fusion_environment_id = kwargs['sourceFusionEnvironmentId']
        if 'timeAccepted' in kwargs:
            time_accepted = kwargs['timeAccepted']
        if 'timeExpectedFinish' in kwargs:
            time_expected_finish = kwargs['timeExpectedFinish']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeOfRestorationPoint' in kwargs:
            time_of_restoration_point = kwargs['timeOfRestorationPoint']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("display_name", display_name)
        _setter("fusion_environment_id", fusion_environment_id)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("refresh_activity_id", refresh_activity_id)
        _setter("refresh_issue_details_lists", refresh_issue_details_lists)
        _setter("service_availability", service_availability)
        _setter("source_fusion_environment_id", source_fusion_environment_id)
        _setter("state", state)
        _setter("time_accepted", time_accepted)
        _setter("time_expected_finish", time_expected_finish)
        _setter("time_finished", time_finished)
        _setter("time_of_restoration_point", time_of_restoration_point)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier (OCID) of the refresh activity. Can't be changed after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="refreshActivityId")
    def refresh_activity_id(self) -> str:
        return pulumi.get(self, "refresh_activity_id")

    @property
    @pulumi.getter(name="refreshIssueDetailsLists")
    def refresh_issue_details_lists(self) -> Sequence['outputs.GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemRefreshIssueDetailsListResult']:
        """
        Details of refresh investigation information, each item represents a different issue.
        """
        return pulumi.get(self, "refresh_issue_details_lists")

    @property
    @pulumi.getter(name="serviceAvailability")
    def service_availability(self) -> str:
        """
        Service availability / impact during refresh activity execution up down
        """
        return pulumi.get(self, "service_availability")

    @property
    @pulumi.getter(name="sourceFusionEnvironmentId")
    def source_fusion_environment_id(self) -> str:
        """
        The OCID of the Fusion environment that is the source environment for the refresh.
        """
        return pulumi.get(self, "source_fusion_environment_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns all resources that match the specified status
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> str:
        """
        The time the refresh activity record was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeExpectedFinish")
    def time_expected_finish(self) -> str:
        """
        The time the refresh activity is scheduled to end. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expected_finish")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The time the refresh activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeOfRestorationPoint")
    def time_of_restoration_point(self) -> str:
        """
        The date and time of the most recent source environment backup used for the environment refresh.
        """
        return pulumi.get(self, "time_of_restoration_point")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the refresh activity record was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemRefreshIssueDetailsListResult(dict):
    def __init__(__self__, *,
                 refresh_issues: str):
        """
        :param str refresh_issues: Detail reasons of refresh failure or validation failure that needs to be shown to customer.
        """
        GetFusionEnvironmentRefreshActivitiesRefreshActivityCollectionItemRefreshIssueDetailsListResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            refresh_issues=refresh_issues,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             refresh_issues: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'refreshIssues' in kwargs:
            refresh_issues = kwargs['refreshIssues']

        _setter("refresh_issues", refresh_issues)

    @property
    @pulumi.getter(name="refreshIssues")
    def refresh_issues(self) -> str:
        """
        Detail reasons of refresh failure or validation failure that needs to be shown to customer.
        """
        return pulumi.get(self, "refresh_issues")


@pulumi.output_type
class GetFusionEnvironmentRefreshActivityRefreshIssueDetailsListResult(dict):
    def __init__(__self__, *,
                 refresh_issues: str):
        """
        :param str refresh_issues: Detail reasons of refresh failure or validation failure that needs to be shown to customer.
        """
        GetFusionEnvironmentRefreshActivityRefreshIssueDetailsListResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            refresh_issues=refresh_issues,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             refresh_issues: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'refreshIssues' in kwargs:
            refresh_issues = kwargs['refreshIssues']

        _setter("refresh_issues", refresh_issues)

    @property
    @pulumi.getter(name="refreshIssues")
    def refresh_issues(self) -> str:
        """
        Detail reasons of refresh failure or validation failure that needs to be shown to customer.
        """
        return pulumi.get(self, "refresh_issues")


@pulumi.output_type
class GetFusionEnvironmentRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.GetFusionEnvironmentRuleConditionResult'],
                 description: str):
        """
        :param str action: Rule type
        :param str description: A brief description of the access control rule. Avoid entering confidential information. example: `192.168.0.0/16 and 2001:db8::/32 are trusted clients. Whitelist them.`
        """
        GetFusionEnvironmentRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            conditions=conditions,
            description=description,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             conditions: Sequence['outputs.GetFusionEnvironmentRuleConditionResult'],
             description: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("action", action)
        _setter("conditions", conditions)
        _setter("description", description)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Rule type
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetFusionEnvironmentRuleConditionResult']:
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A brief description of the access control rule. Avoid entering confidential information. example: `192.168.0.0/16 and 2001:db8::/32 are trusted clients. Whitelist them.`
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetFusionEnvironmentRuleConditionResult(dict):
    def __init__(__self__, *,
                 attribute_name: str,
                 attribute_value: str):
        """
        :param str attribute_name: RuleCondition type
        :param str attribute_value: The OCID of the originating VCN that an incoming packet must match. You can use this condition in conjunction with `SourceVcnIpAddressCondition`. **NOTE:** If you define this condition for a rule without a `SourceVcnIpAddressCondition`, this condition matches all incoming traffic in the specified VCN.
        """
        GetFusionEnvironmentRuleConditionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            attribute_name=attribute_name,
            attribute_value=attribute_value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             attribute_name: str,
             attribute_value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'attributeName' in kwargs:
            attribute_name = kwargs['attributeName']
        if 'attributeValue' in kwargs:
            attribute_value = kwargs['attributeValue']

        _setter("attribute_name", attribute_name)
        _setter("attribute_value", attribute_value)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> str:
        """
        RuleCondition type
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> str:
        """
        The OCID of the originating VCN that an incoming packet must match. You can use this condition in conjunction with `SourceVcnIpAddressCondition`. **NOTE:** If you define this condition for a rule without a `SourceVcnIpAddressCondition`, this condition matches all incoming traffic in the specified VCN.
        """
        return pulumi.get(self, "attribute_value")


@pulumi.output_type
class GetFusionEnvironmentScheduledActivitiesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFusionEnvironmentScheduledActivitiesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemResult']):
        GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemActionResult'],
                 delay_in_hours: int,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 fusion_environment_id: str,
                 id: str,
                 lifecycle_details: str,
                 run_cycle: str,
                 service_availability: str,
                 state: str,
                 time_accepted: str,
                 time_expected_finish: str,
                 time_finished: str,
                 time_scheduled_start: str,
                 time_updated: str):
        """
        :param Sequence['GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemActionArgs'] actions: List of actions
        :param int delay_in_hours: Cumulative delay hours
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str fusion_environment_id: unique FusionEnvironment identifier
        :param str id: Unique identifier that is immutable on creation.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str run_cycle: A filter that returns all resources that match the specified run cycle.
        :param str service_availability: Service availability / impact during scheduled activity execution up down
        :param str state: A filter that returns all resources that match the specified status
        :param str time_expected_finish: Current time the scheduled activity is scheduled to end. An RFC3339 formatted datetime string.
        :param str time_finished: The time the scheduled activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        :param str time_scheduled_start: Current time the scheduled activity is scheduled to start. An RFC3339 formatted datetime string.
        :param str time_updated: The time the scheduled activity record was updated. An RFC3339 formatted datetime string.
        """
        GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actions=actions,
            delay_in_hours=delay_in_hours,
            display_name=display_name,
            freeform_tags=freeform_tags,
            fusion_environment_id=fusion_environment_id,
            id=id,
            lifecycle_details=lifecycle_details,
            run_cycle=run_cycle,
            service_availability=service_availability,
            state=state,
            time_accepted=time_accepted,
            time_expected_finish=time_expected_finish,
            time_finished=time_finished,
            time_scheduled_start=time_scheduled_start,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actions: Sequence['outputs.GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemActionResult'],
             delay_in_hours: int,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             fusion_environment_id: str,
             id: str,
             lifecycle_details: str,
             run_cycle: str,
             service_availability: str,
             state: str,
             time_accepted: str,
             time_expected_finish: str,
             time_finished: str,
             time_scheduled_start: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'delayInHours' in kwargs:
            delay_in_hours = kwargs['delayInHours']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'fusionEnvironmentId' in kwargs:
            fusion_environment_id = kwargs['fusionEnvironmentId']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'runCycle' in kwargs:
            run_cycle = kwargs['runCycle']
        if 'serviceAvailability' in kwargs:
            service_availability = kwargs['serviceAvailability']
        if 'timeAccepted' in kwargs:
            time_accepted = kwargs['timeAccepted']
        if 'timeExpectedFinish' in kwargs:
            time_expected_finish = kwargs['timeExpectedFinish']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeScheduledStart' in kwargs:
            time_scheduled_start = kwargs['timeScheduledStart']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("actions", actions)
        _setter("delay_in_hours", delay_in_hours)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("fusion_environment_id", fusion_environment_id)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("run_cycle", run_cycle)
        _setter("service_availability", service_availability)
        _setter("state", state)
        _setter("time_accepted", time_accepted)
        _setter("time_expected_finish", time_expected_finish)
        _setter("time_finished", time_finished)
        _setter("time_scheduled_start", time_scheduled_start)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemActionResult']:
        """
        List of actions
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="delayInHours")
    def delay_in_hours(self) -> int:
        """
        Cumulative delay hours
        """
        return pulumi.get(self, "delay_in_hours")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="runCycle")
    def run_cycle(self) -> str:
        """
        A filter that returns all resources that match the specified run cycle.
        """
        return pulumi.get(self, "run_cycle")

    @property
    @pulumi.getter(name="serviceAvailability")
    def service_availability(self) -> str:
        """
        Service availability / impact during scheduled activity execution up down
        """
        return pulumi.get(self, "service_availability")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns all resources that match the specified status
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> str:
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeExpectedFinish")
    def time_expected_finish(self) -> str:
        """
        Current time the scheduled activity is scheduled to end. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expected_finish")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The time the scheduled activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeScheduledStart")
    def time_scheduled_start(self) -> str:
        """
        Current time the scheduled activity is scheduled to start. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_scheduled_start")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the scheduled activity record was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemActionResult(dict):
    def __init__(__self__, *,
                 action_type: str,
                 artifact: str,
                 category: str,
                 description: str,
                 mode: str,
                 qualifier: str,
                 reference_key: str,
                 state: str,
                 version: str):
        """
        :param str action_type: Type of action
        :param str artifact: patch that delivered the vertex update prerequisite
        :param str category: patch artifact category
        :param str description: A string that describes the details of the action. It does not have to be unique, and you can change it. Avoid entering confidential information.
        :param str mode: A string that describeds whether the change is applied hot or cold
        :param str qualifier: month qualifier
        :param str reference_key: Unique identifier of the object that represents the action
        :param str state: A filter that returns all resources that match the specified status
        :param str version: name of the repo
        """
        GetFusionEnvironmentScheduledActivitiesScheduledActivityCollectionItemActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action_type=action_type,
            artifact=artifact,
            category=category,
            description=description,
            mode=mode,
            qualifier=qualifier,
            reference_key=reference_key,
            state=state,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action_type: str,
             artifact: str,
             category: str,
             description: str,
             mode: str,
             qualifier: str,
             reference_key: str,
             state: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'actionType' in kwargs:
            action_type = kwargs['actionType']
        if 'referenceKey' in kwargs:
            reference_key = kwargs['referenceKey']

        _setter("action_type", action_type)
        _setter("artifact", artifact)
        _setter("category", category)
        _setter("description", description)
        _setter("mode", mode)
        _setter("qualifier", qualifier)
        _setter("reference_key", reference_key)
        _setter("state", state)
        _setter("version", version)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        Type of action
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def artifact(self) -> str:
        """
        patch that delivered the vertex update prerequisite
        """
        return pulumi.get(self, "artifact")

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        patch artifact category
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A string that describes the details of the action. It does not have to be unique, and you can change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        A string that describeds whether the change is applied hot or cold
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def qualifier(self) -> str:
        """
        month qualifier
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter(name="referenceKey")
    def reference_key(self) -> str:
        """
        Unique identifier of the object that represents the action
        """
        return pulumi.get(self, "reference_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns all resources that match the specified status
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        name of the repo
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFusionEnvironmentScheduledActivityActionResult(dict):
    def __init__(__self__, *,
                 action_type: str,
                 artifact: str,
                 category: str,
                 description: str,
                 mode: str,
                 qualifier: str,
                 reference_key: str,
                 state: str,
                 version: str):
        """
        :param str action_type: Type of action
        :param str artifact: patch that delivered the vertex update prerequisite
        :param str category: patch artifact category
        :param str description: A string that describes the details of the action. It does not have to be unique, and you can change it. Avoid entering confidential information.
        :param str mode: A string that describeds whether the change is applied hot or cold
        :param str qualifier: month qualifier
        :param str reference_key: Unique identifier of the object that represents the action
        :param str state: The current state of the scheduledActivity.
        :param str version: name of the repo
        """
        GetFusionEnvironmentScheduledActivityActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action_type=action_type,
            artifact=artifact,
            category=category,
            description=description,
            mode=mode,
            qualifier=qualifier,
            reference_key=reference_key,
            state=state,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action_type: str,
             artifact: str,
             category: str,
             description: str,
             mode: str,
             qualifier: str,
             reference_key: str,
             state: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'actionType' in kwargs:
            action_type = kwargs['actionType']
        if 'referenceKey' in kwargs:
            reference_key = kwargs['referenceKey']

        _setter("action_type", action_type)
        _setter("artifact", artifact)
        _setter("category", category)
        _setter("description", description)
        _setter("mode", mode)
        _setter("qualifier", qualifier)
        _setter("reference_key", reference_key)
        _setter("state", state)
        _setter("version", version)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        Type of action
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def artifact(self) -> str:
        """
        patch that delivered the vertex update prerequisite
        """
        return pulumi.get(self, "artifact")

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        patch artifact category
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A string that describes the details of the action. It does not have to be unique, and you can change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        A string that describeds whether the change is applied hot or cold
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def qualifier(self) -> str:
        """
        month qualifier
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter(name="referenceKey")
    def reference_key(self) -> str:
        """
        Unique identifier of the object that represents the action
        """
        return pulumi.get(self, "reference_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the scheduledActivity.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        name of the repo
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFusionEnvironmentServiceAttachmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFusionEnvironmentServiceAttachmentsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionItemResult']):
        GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 fusion_environment_id: str,
                 id: str,
                 is_sku_based: bool,
                 service_instance_id: str,
                 service_instance_type: str,
                 service_url: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: Compartment Identifier
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str fusion_environment_id: unique FusionEnvironment identifier
        :param str id: Unique identifier that is immutable on creation
        :param bool is_sku_based: Whether this service is provisioned due to the customer being subscribed to a specific SKU
        :param str service_instance_id: The ID of the service instance created that can be used to identify this on the service control plane
        :param str service_instance_type: A filter that returns all resources that match the specified lifecycle state.
        :param str service_url: Public URL
        :param str state: A filter that returns all resources that match the specified lifecycle state.
        :param str time_created: The time the the ServiceInstance was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the ServiceInstance was updated. An RFC3339 formatted datetime string
        """
        GetFusionEnvironmentServiceAttachmentsServiceAttachmentCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            fusion_environment_id=fusion_environment_id,
            id=id,
            is_sku_based=is_sku_based,
            service_instance_id=service_instance_id,
            service_instance_type=service_instance_type,
            service_url=service_url,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             fusion_environment_id: str,
             id: str,
             is_sku_based: bool,
             service_instance_id: str,
             service_instance_type: str,
             service_url: str,
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'fusionEnvironmentId' in kwargs:
            fusion_environment_id = kwargs['fusionEnvironmentId']
        if 'isSkuBased' in kwargs:
            is_sku_based = kwargs['isSkuBased']
        if 'serviceInstanceId' in kwargs:
            service_instance_id = kwargs['serviceInstanceId']
        if 'serviceInstanceType' in kwargs:
            service_instance_type = kwargs['serviceInstanceType']
        if 'serviceUrl' in kwargs:
            service_url = kwargs['serviceUrl']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("fusion_environment_id", fusion_environment_id)
        _setter("id", id)
        _setter("is_sku_based", is_sku_based)
        _setter("service_instance_id", service_instance_id)
        _setter("service_instance_type", service_instance_type)
        _setter("service_url", service_url)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSkuBased")
    def is_sku_based(self) -> bool:
        """
        Whether this service is provisioned due to the customer being subscribed to a specific SKU
        """
        return pulumi.get(self, "is_sku_based")

    @property
    @pulumi.getter(name="serviceInstanceId")
    def service_instance_id(self) -> str:
        """
        The ID of the service instance created that can be used to identify this on the service control plane
        """
        return pulumi.get(self, "service_instance_id")

    @property
    @pulumi.getter(name="serviceInstanceType")
    def service_instance_type(self) -> str:
        """
        A filter that returns all resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "service_instance_type")

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> str:
        """
        Public URL
        """
        return pulumi.get(self, "service_url")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns all resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the ServiceInstance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the ServiceInstance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFusionEnvironmentTimeAvailableForRefreshItemResult(dict):
    def __init__(__self__, *,
                 time_available_for_refresh: str):
        """
        :param str time_available_for_refresh: refresh time.
        """
        GetFusionEnvironmentTimeAvailableForRefreshItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_available_for_refresh=time_available_for_refresh,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_available_for_refresh: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeAvailableForRefresh' in kwargs:
            time_available_for_refresh = kwargs['timeAvailableForRefresh']

        _setter("time_available_for_refresh", time_available_for_refresh)

    @property
    @pulumi.getter(name="timeAvailableForRefresh")
    def time_available_for_refresh(self) -> str:
        """
        refresh time.
        """
        return pulumi.get(self, "time_available_for_refresh")


@pulumi.output_type
class GetFusionEnvironmentTimeAvailableForRefreshsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFusionEnvironmentTimeAvailableForRefreshsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionItemResult']):
        """
        :param Sequence['GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionItemArgs'] items: A list of available refresh time objects.
        """
        GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionItemResult']:
        """
        A list of available refresh time objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionItemResult(dict):
    def __init__(__self__, *,
                 time_available_for_refresh: str):
        """
        :param str time_available_for_refresh: refresh time.
        """
        GetFusionEnvironmentTimeAvailableForRefreshsTimeAvailableForRefreshCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_available_for_refresh=time_available_for_refresh,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_available_for_refresh: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeAvailableForRefresh' in kwargs:
            time_available_for_refresh = kwargs['timeAvailableForRefresh']

        _setter("time_available_for_refresh", time_available_for_refresh)

    @property
    @pulumi.getter(name="timeAvailableForRefresh")
    def time_available_for_refresh(self) -> str:
        """
        refresh time.
        """
        return pulumi.get(self, "time_available_for_refresh")


@pulumi.output_type
class GetFusionEnvironmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetFusionEnvironmentsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemResult']):
        GetFusionEnvironmentsFusionEnvironmentCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 additional_language_packs: Sequence[str],
                 applied_patch_bundles: Sequence[str],
                 compartment_id: str,
                 create_fusion_environment_admin_user_details: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemCreateFusionEnvironmentAdminUserDetailResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 dns_prefix: str,
                 domain_id: str,
                 freeform_tags: Mapping[str, Any],
                 fusion_environment_family_id: str,
                 fusion_environment_type: str,
                 id: str,
                 idcs_domain_url: str,
                 is_break_glass_enabled: bool,
                 kms_key_id: str,
                 kms_key_infos: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemKmsKeyInfoResult'],
                 lifecycle_details: str,
                 lockbox_id: str,
                 maintenance_policies: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyResult'],
                 public_url: str,
                 refreshes: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRefreshResult'],
                 rules: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleResult'],
                 state: str,
                 subscription_ids: Sequence[str],
                 system_name: str,
                 time_created: str,
                 time_upcoming_maintenance: str,
                 time_updated: str,
                 version: str):
        """
        :param Sequence[str] additional_language_packs: Language packs
        :param Sequence[str] applied_patch_bundles: Patch bundle names
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str dns_prefix: DNS prefix
        :param str domain_id: The IDCS domain created for the fusion instance
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str fusion_environment_family_id: The ID of the fusion environment family in which to list resources.
        :param str fusion_environment_type: Type of the FusionEnvironment.
        :param str id: Unique identifier that is immutable on creation
        :param str idcs_domain_url: The IDCS Domain URL
        :param bool is_break_glass_enabled: If it's true, then the Break Glass feature is enabled
        :param str kms_key_id: BYOK key id
        :param Sequence['GetFusionEnvironmentsFusionEnvironmentCollectionItemKmsKeyInfoArgs'] kms_key_infos: BYOK key info
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str lockbox_id: The lockbox Id of this fusion environment. If there's no lockbox id, this field will be null
        :param Sequence['GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyArgs'] maintenance_policies: The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        :param str public_url: Public URL
        :param Sequence['GetFusionEnvironmentsFusionEnvironmentCollectionItemRefreshArgs'] refreshes: Describes a refresh of a fusion environment
        :param Sequence['GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleArgs'] rules: Network Access Control Rules
        :param str state: A filter that returns all resources that match the specified lifecycle state.
        :param Sequence[str] subscription_ids: List of subscription IDs.
        :param str system_name: Environment Specific Guid/ System Name
        :param str time_created: The time the the FusionEnvironment was created. An RFC3339 formatted datetime string
        :param str time_upcoming_maintenance: The next maintenance for this environment
        :param str time_updated: The time the FusionEnvironment was updated. An RFC3339 formatted datetime string
        :param str version: Version of Fusion Apps used by this environment
        """
        GetFusionEnvironmentsFusionEnvironmentCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            additional_language_packs=additional_language_packs,
            applied_patch_bundles=applied_patch_bundles,
            compartment_id=compartment_id,
            create_fusion_environment_admin_user_details=create_fusion_environment_admin_user_details,
            defined_tags=defined_tags,
            display_name=display_name,
            dns_prefix=dns_prefix,
            domain_id=domain_id,
            freeform_tags=freeform_tags,
            fusion_environment_family_id=fusion_environment_family_id,
            fusion_environment_type=fusion_environment_type,
            id=id,
            idcs_domain_url=idcs_domain_url,
            is_break_glass_enabled=is_break_glass_enabled,
            kms_key_id=kms_key_id,
            kms_key_infos=kms_key_infos,
            lifecycle_details=lifecycle_details,
            lockbox_id=lockbox_id,
            maintenance_policies=maintenance_policies,
            public_url=public_url,
            refreshes=refreshes,
            rules=rules,
            state=state,
            subscription_ids=subscription_ids,
            system_name=system_name,
            time_created=time_created,
            time_upcoming_maintenance=time_upcoming_maintenance,
            time_updated=time_updated,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             additional_language_packs: Sequence[str],
             applied_patch_bundles: Sequence[str],
             compartment_id: str,
             create_fusion_environment_admin_user_details: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemCreateFusionEnvironmentAdminUserDetailResult'],
             defined_tags: Mapping[str, Any],
             display_name: str,
             dns_prefix: str,
             domain_id: str,
             freeform_tags: Mapping[str, Any],
             fusion_environment_family_id: str,
             fusion_environment_type: str,
             id: str,
             idcs_domain_url: str,
             is_break_glass_enabled: bool,
             kms_key_id: str,
             kms_key_infos: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemKmsKeyInfoResult'],
             lifecycle_details: str,
             lockbox_id: str,
             maintenance_policies: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyResult'],
             public_url: str,
             refreshes: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRefreshResult'],
             rules: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleResult'],
             state: str,
             subscription_ids: Sequence[str],
             system_name: str,
             time_created: str,
             time_upcoming_maintenance: str,
             time_updated: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'additionalLanguagePacks' in kwargs:
            additional_language_packs = kwargs['additionalLanguagePacks']
        if 'appliedPatchBundles' in kwargs:
            applied_patch_bundles = kwargs['appliedPatchBundles']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'createFusionEnvironmentAdminUserDetails' in kwargs:
            create_fusion_environment_admin_user_details = kwargs['createFusionEnvironmentAdminUserDetails']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'dnsPrefix' in kwargs:
            dns_prefix = kwargs['dnsPrefix']
        if 'domainId' in kwargs:
            domain_id = kwargs['domainId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'fusionEnvironmentFamilyId' in kwargs:
            fusion_environment_family_id = kwargs['fusionEnvironmentFamilyId']
        if 'fusionEnvironmentType' in kwargs:
            fusion_environment_type = kwargs['fusionEnvironmentType']
        if 'idcsDomainUrl' in kwargs:
            idcs_domain_url = kwargs['idcsDomainUrl']
        if 'isBreakGlassEnabled' in kwargs:
            is_break_glass_enabled = kwargs['isBreakGlassEnabled']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'kmsKeyInfos' in kwargs:
            kms_key_infos = kwargs['kmsKeyInfos']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'lockboxId' in kwargs:
            lockbox_id = kwargs['lockboxId']
        if 'maintenancePolicies' in kwargs:
            maintenance_policies = kwargs['maintenancePolicies']
        if 'publicUrl' in kwargs:
            public_url = kwargs['publicUrl']
        if 'subscriptionIds' in kwargs:
            subscription_ids = kwargs['subscriptionIds']
        if 'systemName' in kwargs:
            system_name = kwargs['systemName']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpcomingMaintenance' in kwargs:
            time_upcoming_maintenance = kwargs['timeUpcomingMaintenance']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("additional_language_packs", additional_language_packs)
        _setter("applied_patch_bundles", applied_patch_bundles)
        _setter("compartment_id", compartment_id)
        _setter("create_fusion_environment_admin_user_details", create_fusion_environment_admin_user_details)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("dns_prefix", dns_prefix)
        _setter("domain_id", domain_id)
        _setter("freeform_tags", freeform_tags)
        _setter("fusion_environment_family_id", fusion_environment_family_id)
        _setter("fusion_environment_type", fusion_environment_type)
        _setter("id", id)
        _setter("idcs_domain_url", idcs_domain_url)
        _setter("is_break_glass_enabled", is_break_glass_enabled)
        _setter("kms_key_id", kms_key_id)
        _setter("kms_key_infos", kms_key_infos)
        _setter("lifecycle_details", lifecycle_details)
        _setter("lockbox_id", lockbox_id)
        _setter("maintenance_policies", maintenance_policies)
        _setter("public_url", public_url)
        _setter("refreshes", refreshes)
        _setter("rules", rules)
        _setter("state", state)
        _setter("subscription_ids", subscription_ids)
        _setter("system_name", system_name)
        _setter("time_created", time_created)
        _setter("time_upcoming_maintenance", time_upcoming_maintenance)
        _setter("time_updated", time_updated)
        _setter("version", version)

    @property
    @pulumi.getter(name="additionalLanguagePacks")
    def additional_language_packs(self) -> Sequence[str]:
        """
        Language packs
        """
        return pulumi.get(self, "additional_language_packs")

    @property
    @pulumi.getter(name="appliedPatchBundles")
    def applied_patch_bundles(self) -> Sequence[str]:
        """
        Patch bundle names
        """
        return pulumi.get(self, "applied_patch_bundles")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createFusionEnvironmentAdminUserDetails")
    def create_fusion_environment_admin_user_details(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemCreateFusionEnvironmentAdminUserDetailResult']:
        return pulumi.get(self, "create_fusion_environment_admin_user_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> str:
        """
        DNS prefix
        """
        return pulumi.get(self, "dns_prefix")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        """
        The IDCS domain created for the fusion instance
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="fusionEnvironmentFamilyId")
    def fusion_environment_family_id(self) -> str:
        """
        The ID of the fusion environment family in which to list resources.
        """
        return pulumi.get(self, "fusion_environment_family_id")

    @property
    @pulumi.getter(name="fusionEnvironmentType")
    def fusion_environment_type(self) -> str:
        """
        Type of the FusionEnvironment.
        """
        return pulumi.get(self, "fusion_environment_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsDomainUrl")
    def idcs_domain_url(self) -> str:
        """
        The IDCS Domain URL
        """
        return pulumi.get(self, "idcs_domain_url")

    @property
    @pulumi.getter(name="isBreakGlassEnabled")
    def is_break_glass_enabled(self) -> bool:
        """
        If it's true, then the Break Glass feature is enabled
        """
        return pulumi.get(self, "is_break_glass_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        BYOK key id
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyInfos")
    def kms_key_infos(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemKmsKeyInfoResult']:
        """
        BYOK key info
        """
        return pulumi.get(self, "kms_key_infos")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lockboxId")
    def lockbox_id(self) -> str:
        """
        The lockbox Id of this fusion environment. If there's no lockbox id, this field will be null
        """
        return pulumi.get(self, "lockbox_id")

    @property
    @pulumi.getter(name="maintenancePolicies")
    def maintenance_policies(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyResult']:
        """
        The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        """
        return pulumi.get(self, "maintenance_policies")

    @property
    @pulumi.getter(name="publicUrl")
    def public_url(self) -> str:
        """
        Public URL
        """
        return pulumi.get(self, "public_url")

    @property
    @pulumi.getter
    def refreshes(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRefreshResult']:
        """
        Describes a refresh of a fusion environment
        """
        return pulumi.get(self, "refreshes")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleResult']:
        """
        Network Access Control Rules
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns all resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionIds")
    def subscription_ids(self) -> Sequence[str]:
        """
        List of subscription IDs.
        """
        return pulumi.get(self, "subscription_ids")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> str:
        """
        Environment Specific Guid/ System Name
        """
        return pulumi.get(self, "system_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the FusionEnvironment was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpcomingMaintenance")
    def time_upcoming_maintenance(self) -> str:
        """
        The next maintenance for this environment
        """
        return pulumi.get(self, "time_upcoming_maintenance")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the FusionEnvironment was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of Fusion Apps used by this environment
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionItemCreateFusionEnvironmentAdminUserDetailResult(dict):
    def __init__(__self__, *,
                 email_address: str,
                 first_name: str,
                 last_name: str,
                 password: str,
                 username: str):
        GetFusionEnvironmentsFusionEnvironmentCollectionItemCreateFusionEnvironmentAdminUserDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email_address=email_address,
            first_name=first_name,
            last_name=last_name,
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email_address: str,
             first_name: str,
             last_name: str,
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'emailAddress' in kwargs:
            email_address = kwargs['emailAddress']
        if 'firstName' in kwargs:
            first_name = kwargs['firstName']
        if 'lastName' in kwargs:
            last_name = kwargs['lastName']

        _setter("email_address", email_address)
        _setter("first_name", first_name)
        _setter("last_name", last_name)
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionItemKmsKeyInfoResult(dict):
    def __init__(__self__, *,
                 active_key_id: str,
                 active_key_version: str,
                 current_key_lifecycle_state: str,
                 scheduled_key_id: str,
                 scheduled_key_status: str,
                 scheduled_key_version: str,
                 scheduled_lifecycle_state: str):
        GetFusionEnvironmentsFusionEnvironmentCollectionItemKmsKeyInfoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            active_key_id=active_key_id,
            active_key_version=active_key_version,
            current_key_lifecycle_state=current_key_lifecycle_state,
            scheduled_key_id=scheduled_key_id,
            scheduled_key_status=scheduled_key_status,
            scheduled_key_version=scheduled_key_version,
            scheduled_lifecycle_state=scheduled_lifecycle_state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             active_key_id: str,
             active_key_version: str,
             current_key_lifecycle_state: str,
             scheduled_key_id: str,
             scheduled_key_status: str,
             scheduled_key_version: str,
             scheduled_lifecycle_state: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'activeKeyId' in kwargs:
            active_key_id = kwargs['activeKeyId']
        if 'activeKeyVersion' in kwargs:
            active_key_version = kwargs['activeKeyVersion']
        if 'currentKeyLifecycleState' in kwargs:
            current_key_lifecycle_state = kwargs['currentKeyLifecycleState']
        if 'scheduledKeyId' in kwargs:
            scheduled_key_id = kwargs['scheduledKeyId']
        if 'scheduledKeyStatus' in kwargs:
            scheduled_key_status = kwargs['scheduledKeyStatus']
        if 'scheduledKeyVersion' in kwargs:
            scheduled_key_version = kwargs['scheduledKeyVersion']
        if 'scheduledLifecycleState' in kwargs:
            scheduled_lifecycle_state = kwargs['scheduledLifecycleState']

        _setter("active_key_id", active_key_id)
        _setter("active_key_version", active_key_version)
        _setter("current_key_lifecycle_state", current_key_lifecycle_state)
        _setter("scheduled_key_id", scheduled_key_id)
        _setter("scheduled_key_status", scheduled_key_status)
        _setter("scheduled_key_version", scheduled_key_version)
        _setter("scheduled_lifecycle_state", scheduled_lifecycle_state)

    @property
    @pulumi.getter(name="activeKeyId")
    def active_key_id(self) -> str:
        return pulumi.get(self, "active_key_id")

    @property
    @pulumi.getter(name="activeKeyVersion")
    def active_key_version(self) -> str:
        return pulumi.get(self, "active_key_version")

    @property
    @pulumi.getter(name="currentKeyLifecycleState")
    def current_key_lifecycle_state(self) -> str:
        return pulumi.get(self, "current_key_lifecycle_state")

    @property
    @pulumi.getter(name="scheduledKeyId")
    def scheduled_key_id(self) -> str:
        return pulumi.get(self, "scheduled_key_id")

    @property
    @pulumi.getter(name="scheduledKeyStatus")
    def scheduled_key_status(self) -> str:
        return pulumi.get(self, "scheduled_key_status")

    @property
    @pulumi.getter(name="scheduledKeyVersion")
    def scheduled_key_version(self) -> str:
        return pulumi.get(self, "scheduled_key_version")

    @property
    @pulumi.getter(name="scheduledLifecycleState")
    def scheduled_lifecycle_state(self) -> str:
        return pulumi.get(self, "scheduled_lifecycle_state")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyResult(dict):
    def __init__(__self__, *,
                 environment_maintenance_override: str,
                 monthly_patching_override: str,
                 quarterly_upgrade_begin_times: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyQuarterlyUpgradeBeginTimeResult']):
        """
        :param str environment_maintenance_override: User choice to upgrade both production and non-production environments at the same time. Overrides the Fusion environment family setting.
        :param str monthly_patching_override: Whether the Fusion environment will be updated monthly or updated on the quarterly cycle. This setting overrides the monthly patching setting of its Fusion environment family.
        :param Sequence['GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyQuarterlyUpgradeBeginTimeArgs'] quarterly_upgrade_begin_times: Determines the quarterly upgrade begin times (monthly maintenance group schedule ) of the Fusion environment.
        """
        GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            environment_maintenance_override=environment_maintenance_override,
            monthly_patching_override=monthly_patching_override,
            quarterly_upgrade_begin_times=quarterly_upgrade_begin_times,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             environment_maintenance_override: str,
             monthly_patching_override: str,
             quarterly_upgrade_begin_times: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyQuarterlyUpgradeBeginTimeResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'environmentMaintenanceOverride' in kwargs:
            environment_maintenance_override = kwargs['environmentMaintenanceOverride']
        if 'monthlyPatchingOverride' in kwargs:
            monthly_patching_override = kwargs['monthlyPatchingOverride']
        if 'quarterlyUpgradeBeginTimes' in kwargs:
            quarterly_upgrade_begin_times = kwargs['quarterlyUpgradeBeginTimes']

        _setter("environment_maintenance_override", environment_maintenance_override)
        _setter("monthly_patching_override", monthly_patching_override)
        _setter("quarterly_upgrade_begin_times", quarterly_upgrade_begin_times)

    @property
    @pulumi.getter(name="environmentMaintenanceOverride")
    def environment_maintenance_override(self) -> str:
        """
        User choice to upgrade both production and non-production environments at the same time. Overrides the Fusion environment family setting.
        """
        return pulumi.get(self, "environment_maintenance_override")

    @property
    @pulumi.getter(name="monthlyPatchingOverride")
    def monthly_patching_override(self) -> str:
        """
        Whether the Fusion environment will be updated monthly or updated on the quarterly cycle. This setting overrides the monthly patching setting of its Fusion environment family.
        """
        return pulumi.get(self, "monthly_patching_override")

    @property
    @pulumi.getter(name="quarterlyUpgradeBeginTimes")
    def quarterly_upgrade_begin_times(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyQuarterlyUpgradeBeginTimeResult']:
        """
        Determines the quarterly upgrade begin times (monthly maintenance group schedule ) of the Fusion environment.
        """
        return pulumi.get(self, "quarterly_upgrade_begin_times")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyQuarterlyUpgradeBeginTimeResult(dict):
    def __init__(__self__, *,
                 begin_times_value: str,
                 override_type: str):
        """
        :param str begin_times_value: The frequency and month when maintenance occurs for the Fusion environment.
        :param str override_type: Determines if the maintenance schedule of the Fusion environment is inherited from the Fusion environment family.
        """
        GetFusionEnvironmentsFusionEnvironmentCollectionItemMaintenancePolicyQuarterlyUpgradeBeginTimeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            begin_times_value=begin_times_value,
            override_type=override_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             begin_times_value: str,
             override_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'beginTimesValue' in kwargs:
            begin_times_value = kwargs['beginTimesValue']
        if 'overrideType' in kwargs:
            override_type = kwargs['overrideType']

        _setter("begin_times_value", begin_times_value)
        _setter("override_type", override_type)

    @property
    @pulumi.getter(name="beginTimesValue")
    def begin_times_value(self) -> str:
        """
        The frequency and month when maintenance occurs for the Fusion environment.
        """
        return pulumi.get(self, "begin_times_value")

    @property
    @pulumi.getter(name="overrideType")
    def override_type(self) -> str:
        """
        Determines if the maintenance schedule of the Fusion environment is inherited from the Fusion environment family.
        """
        return pulumi.get(self, "override_type")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionItemRefreshResult(dict):
    def __init__(__self__, *,
                 source_fusion_environment_id: str,
                 time_finished: str,
                 time_of_restoration_point: str):
        """
        :param str source_fusion_environment_id: The source environment id for the last refresh
        :param str time_finished: The time of when the last refresh finish
        :param str time_of_restoration_point: The point of time of the latest DB backup for the last refresh
        """
        GetFusionEnvironmentsFusionEnvironmentCollectionItemRefreshResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            source_fusion_environment_id=source_fusion_environment_id,
            time_finished=time_finished,
            time_of_restoration_point=time_of_restoration_point,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             source_fusion_environment_id: str,
             time_finished: str,
             time_of_restoration_point: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'sourceFusionEnvironmentId' in kwargs:
            source_fusion_environment_id = kwargs['sourceFusionEnvironmentId']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeOfRestorationPoint' in kwargs:
            time_of_restoration_point = kwargs['timeOfRestorationPoint']

        _setter("source_fusion_environment_id", source_fusion_environment_id)
        _setter("time_finished", time_finished)
        _setter("time_of_restoration_point", time_of_restoration_point)

    @property
    @pulumi.getter(name="sourceFusionEnvironmentId")
    def source_fusion_environment_id(self) -> str:
        """
        The source environment id for the last refresh
        """
        return pulumi.get(self, "source_fusion_environment_id")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The time of when the last refresh finish
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeOfRestorationPoint")
    def time_of_restoration_point(self) -> str:
        """
        The point of time of the latest DB backup for the last refresh
        """
        return pulumi.get(self, "time_of_restoration_point")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleConditionResult'],
                 description: str):
        """
        :param str action: Rule type
        :param str description: A brief description of the access control rule. Avoid entering confidential information. example: `192.168.0.0/16 and 2001:db8::/32 are trusted clients. Whitelist them.`
        """
        GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            conditions=conditions,
            description=description,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             conditions: Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleConditionResult'],
             description: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("action", action)
        _setter("conditions", conditions)
        _setter("description", description)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Rule type
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleConditionResult']:
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A brief description of the access control rule. Avoid entering confidential information. example: `192.168.0.0/16 and 2001:db8::/32 are trusted clients. Whitelist them.`
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleConditionResult(dict):
    def __init__(__self__, *,
                 attribute_name: str,
                 attribute_value: str):
        """
        :param str attribute_name: RuleCondition type
        :param str attribute_value: The OCID of the originating VCN that an incoming packet must match. You can use this condition in conjunction with `SourceVcnIpAddressCondition`. **NOTE:** If you define this condition for a rule without a `SourceVcnIpAddressCondition`, this condition matches all incoming traffic in the specified VCN.
        """
        GetFusionEnvironmentsFusionEnvironmentCollectionItemRuleConditionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            attribute_name=attribute_name,
            attribute_value=attribute_value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             attribute_name: str,
             attribute_value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'attributeName' in kwargs:
            attribute_name = kwargs['attributeName']
        if 'attributeValue' in kwargs:
            attribute_value = kwargs['attributeValue']

        _setter("attribute_name", attribute_name)
        _setter("attribute_value", attribute_value)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> str:
        """
        RuleCondition type
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> str:
        """
        The OCID of the originating VCN that an incoming packet must match. You can use this condition in conjunction with `SourceVcnIpAddressCondition`. **NOTE:** If you define this condition for a rule without a `SourceVcnIpAddressCondition`, this condition matches all incoming traffic in the specified VCN.
        """
        return pulumi.get(self, "attribute_value")


@pulumi.output_type
class GetPbfListingPublisherDetailResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: A brief descriptive name for the PBF trigger.
        """
        GetPbfListingPublisherDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A brief descriptive name for the PBF trigger.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPbfListingTriggerResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: A brief descriptive name for the PBF trigger.
        """
        GetPbfListingTriggerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A brief descriptive name for the PBF trigger.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPbfListingTriggersFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the service trigger source of a PBF.
        """
        GetPbfListingTriggersFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the service trigger source of a PBF.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPbfListingTriggersTriggersCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPbfListingTriggersTriggersCollectionItemResult']):
        """
        :param Sequence['GetPbfListingTriggersTriggersCollectionItemArgs'] items: List of TriggerSummary.
        """
        GetPbfListingTriggersTriggersCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetPbfListingTriggersTriggersCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPbfListingTriggersTriggersCollectionItemResult']:
        """
        List of TriggerSummary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPbfListingTriggersTriggersCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: A filter to return only resources that match the service trigger source of a PBF.
        """
        GetPbfListingTriggersTriggersCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the service trigger source of a PBF.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPbfListingVersionConfigResult(dict):
    def __init__(__self__, *,
                 description: str,
                 is_optional: bool,
                 key: str):
        """
        :param str description: Details about why this policy is required and what it will be used for.
        :param bool is_optional: Is this a required config or an optional one. Requests with required config params missing will be rejected.
        :param str key: The key name of the config param.
        """
        GetPbfListingVersionConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            is_optional=is_optional,
            key=key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             is_optional: bool,
             key: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isOptional' in kwargs:
            is_optional = kwargs['isOptional']

        _setter("description", description)
        _setter("is_optional", is_optional)
        _setter("key", key)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Details about why this policy is required and what it will be used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOptional")
    def is_optional(self) -> bool:
        """
        Is this a required config or an optional one. Requests with required config params missing will be rejected.
        """
        return pulumi.get(self, "is_optional")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the config param.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetPbfListingVersionRequirementResult(dict):
    def __init__(__self__, *,
                 min_memory_required_in_mbs: str,
                 policies: Sequence['outputs.GetPbfListingVersionRequirementPolicyResult']):
        """
        :param str min_memory_required_in_mbs: Minimum memory required by this PBF. The user should use memory greater than or equal to  this value while configuring the Function.
        :param Sequence['GetPbfListingVersionRequirementPolicyArgs'] policies: List of policies required for this PBF execution.
        """
        GetPbfListingVersionRequirementResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            min_memory_required_in_mbs=min_memory_required_in_mbs,
            policies=policies,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             min_memory_required_in_mbs: str,
             policies: Sequence['outputs.GetPbfListingVersionRequirementPolicyResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'minMemoryRequiredInMbs' in kwargs:
            min_memory_required_in_mbs = kwargs['minMemoryRequiredInMbs']

        _setter("min_memory_required_in_mbs", min_memory_required_in_mbs)
        _setter("policies", policies)

    @property
    @pulumi.getter(name="minMemoryRequiredInMbs")
    def min_memory_required_in_mbs(self) -> str:
        """
        Minimum memory required by this PBF. The user should use memory greater than or equal to  this value while configuring the Function.
        """
        return pulumi.get(self, "min_memory_required_in_mbs")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetPbfListingVersionRequirementPolicyResult']:
        """
        List of policies required for this PBF execution.
        """
        return pulumi.get(self, "policies")


@pulumi.output_type
class GetPbfListingVersionRequirementPolicyResult(dict):
    def __init__(__self__, *,
                 description: str,
                 policy: str):
        """
        :param str description: Details about why this policy is required and what it will be used for.
        :param str policy: Policy required for PBF execution
        """
        GetPbfListingVersionRequirementPolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            policy=policy,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             policy: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("description", description)
        _setter("policy", policy)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Details about why this policy is required and what it will be used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        Policy required for PBF execution
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class GetPbfListingVersionTriggerResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: A brief descriptive name for the PBF trigger.
        """
        GetPbfListingVersionTriggerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A brief descriptive name for the PBF trigger.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPbfListingVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Matches a PbfListingVersion based on a provided semantic version name for a PbfListingVersion.  Each PbfListingVersion name is unique with respect to its associated PbfListing.
        """
        GetPbfListingVersionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Matches a PbfListingVersion based on a provided semantic version name for a PbfListingVersion.  Each PbfListingVersion name is unique with respect to its associated PbfListing.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPbfListingVersionsPbfListingVersionsCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemResult']):
        """
        :param Sequence['GetPbfListingVersionsPbfListingVersionsCollectionItemArgs'] items: List of PbfListingVersionSummary.
        """
        GetPbfListingVersionsPbfListingVersionsCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemResult']:
        """
        List of PbfListingVersionSummary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPbfListingVersionsPbfListingVersionsCollectionItemResult(dict):
    def __init__(__self__, *,
                 change_summary: str,
                 configs: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemConfigResult'],
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 name: str,
                 pbf_listing_id: str,
                 requirements: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 triggers: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemTriggerResult']):
        """
        :param str change_summary: Details changes are included in this version.
        :param Sequence['GetPbfListingVersionsPbfListingVersionsCollectionItemConfigArgs'] configs: Details about the required and optional Function configurations needed for proper performance of the PBF.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier that is immutable on creation
        :param str name: Matches a PbfListingVersion based on a provided semantic version name for a PbfListingVersion.  Each PbfListingVersion name is unique with respect to its associated PbfListing.
        :param str pbf_listing_id: unique PbfListing identifier
        :param Sequence['GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementArgs'] requirements: Minimum memory required by this PBF. The user should use memory greater than or equal to this value  while configuring the Function.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, Any] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the PbfListingVersion was created. An RFC3339 formatted datetime string.
        :param str time_updated: The last time the PbfListingVersion was updated. An RFC3339 formatted datetime string.
        :param Sequence['GetPbfListingVersionsPbfListingVersionsCollectionItemTriggerArgs'] triggers: An array of Trigger. A list of triggers that may activate the PBF.
        """
        GetPbfListingVersionsPbfListingVersionsCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            change_summary=change_summary,
            configs=configs,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            id=id,
            name=name,
            pbf_listing_id=pbf_listing_id,
            requirements=requirements,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            triggers=triggers,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             change_summary: str,
             configs: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemConfigResult'],
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             id: str,
             name: str,
             pbf_listing_id: str,
             requirements: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementResult'],
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             triggers: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemTriggerResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'changeSummary' in kwargs:
            change_summary = kwargs['changeSummary']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'pbfListingId' in kwargs:
            pbf_listing_id = kwargs['pbfListingId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("change_summary", change_summary)
        _setter("configs", configs)
        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("name", name)
        _setter("pbf_listing_id", pbf_listing_id)
        _setter("requirements", requirements)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("triggers", triggers)

    @property
    @pulumi.getter(name="changeSummary")
    def change_summary(self) -> str:
        """
        Details changes are included in this version.
        """
        return pulumi.get(self, "change_summary")

    @property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemConfigResult']:
        """
        Details about the required and optional Function configurations needed for proper performance of the PBF.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Matches a PbfListingVersion based on a provided semantic version name for a PbfListingVersion.  Each PbfListingVersion name is unique with respect to its associated PbfListing.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pbfListingId")
    def pbf_listing_id(self) -> str:
        """
        unique PbfListing identifier
        """
        return pulumi.get(self, "pbf_listing_id")

    @property
    @pulumi.getter
    def requirements(self) -> Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementResult']:
        """
        Minimum memory required by this PBF. The user should use memory greater than or equal to this value  while configuring the Function.
        """
        return pulumi.get(self, "requirements")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the PbfListingVersion was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The last time the PbfListingVersion was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemTriggerResult']:
        """
        An array of Trigger. A list of triggers that may activate the PBF.
        """
        return pulumi.get(self, "triggers")


@pulumi.output_type
class GetPbfListingVersionsPbfListingVersionsCollectionItemConfigResult(dict):
    def __init__(__self__, *,
                 description: str,
                 is_optional: bool,
                 key: str):
        """
        :param str description: Details about why this policy is required and what it will be used for.
        :param bool is_optional: Is this a required config or an optional one. Requests with required config params missing will be rejected.
        :param str key: The key name of the config param.
        """
        GetPbfListingVersionsPbfListingVersionsCollectionItemConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            is_optional=is_optional,
            key=key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             is_optional: bool,
             key: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isOptional' in kwargs:
            is_optional = kwargs['isOptional']

        _setter("description", description)
        _setter("is_optional", is_optional)
        _setter("key", key)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Details about why this policy is required and what it will be used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isOptional")
    def is_optional(self) -> bool:
        """
        Is this a required config or an optional one. Requests with required config params missing will be rejected.
        """
        return pulumi.get(self, "is_optional")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the config param.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementResult(dict):
    def __init__(__self__, *,
                 min_memory_required_in_mbs: str,
                 policies: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementPolicyResult']):
        """
        :param str min_memory_required_in_mbs: Minimum memory required by this PBF. The user should use memory greater than or equal to  this value while configuring the Function.
        :param Sequence['GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementPolicyArgs'] policies: List of policies required for this PBF execution.
        """
        GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            min_memory_required_in_mbs=min_memory_required_in_mbs,
            policies=policies,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             min_memory_required_in_mbs: str,
             policies: Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementPolicyResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'minMemoryRequiredInMbs' in kwargs:
            min_memory_required_in_mbs = kwargs['minMemoryRequiredInMbs']

        _setter("min_memory_required_in_mbs", min_memory_required_in_mbs)
        _setter("policies", policies)

    @property
    @pulumi.getter(name="minMemoryRequiredInMbs")
    def min_memory_required_in_mbs(self) -> str:
        """
        Minimum memory required by this PBF. The user should use memory greater than or equal to  this value while configuring the Function.
        """
        return pulumi.get(self, "min_memory_required_in_mbs")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementPolicyResult']:
        """
        List of policies required for this PBF execution.
        """
        return pulumi.get(self, "policies")


@pulumi.output_type
class GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementPolicyResult(dict):
    def __init__(__self__, *,
                 description: str,
                 policy: str):
        """
        :param str description: Details about why this policy is required and what it will be used for.
        :param str policy: Policy required for PBF execution
        """
        GetPbfListingVersionsPbfListingVersionsCollectionItemRequirementPolicyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            policy=policy,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             policy: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("description", description)
        _setter("policy", policy)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Details about why this policy is required and what it will be used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        Policy required for PBF execution
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class GetPbfListingVersionsPbfListingVersionsCollectionItemTriggerResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Matches a PbfListingVersion based on a provided semantic version name for a PbfListingVersion.  Each PbfListingVersion name is unique with respect to its associated PbfListing.
        """
        GetPbfListingVersionsPbfListingVersionsCollectionItemTriggerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Matches a PbfListingVersion based on a provided semantic version name for a PbfListingVersion.  Each PbfListingVersion name is unique with respect to its associated PbfListing.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPbfListingsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire PBF name given.
        """
        GetPbfListingsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire PBF name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPbfListingsPbfListingsCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPbfListingsPbfListingsCollectionItemResult']):
        """
        :param Sequence['GetPbfListingsPbfListingsCollectionItemArgs'] items: List of PbfListingSummary.
        """
        GetPbfListingsPbfListingsCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetPbfListingsPbfListingsCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPbfListingsPbfListingsCollectionItemResult']:
        """
        List of PbfListingSummary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPbfListingsPbfListingsCollectionItemResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 name: str,
                 publisher_details: Sequence['outputs.GetPbfListingsPbfListingsCollectionItemPublisherDetailResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 triggers: Sequence['outputs.GetPbfListingsPbfListingsCollectionItemTriggerResult']):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A short overview of the PBF Listing: the purpose of the PBF and and associated information.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier that is immutable on creation.
        :param str name: A filter to return only resources that match the entire PBF name given.
        :param Sequence['GetPbfListingsPbfListingsCollectionItemPublisherDetailArgs'] publisher_details: Contains details about the publisher of this PBF Listing.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, Any] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the PbfListing was created. An RFC3339 formatted datetime string.
        :param str time_updated: The last time the PbfListing was updated. An RFC3339 formatted datetime string.
        :param Sequence['GetPbfListingsPbfListingsCollectionItemTriggerArgs'] triggers: An array of Trigger. A list of triggers that may activate the PBF.
        """
        GetPbfListingsPbfListingsCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            id=id,
            name=name,
            publisher_details=publisher_details,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            triggers=triggers,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Mapping[str, Any],
             description: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             name: str,
             publisher_details: Sequence['outputs.GetPbfListingsPbfListingsCollectionItemPublisherDetailResult'],
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             triggers: Sequence['outputs.GetPbfListingsPbfListingsCollectionItemTriggerResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'publisherDetails' in kwargs:
            publisher_details = kwargs['publisherDetails']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("name", name)
        _setter("publisher_details", publisher_details)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("triggers", triggers)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short overview of the PBF Listing: the purpose of the PBF and and associated information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire PBF name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publisherDetails")
    def publisher_details(self) -> Sequence['outputs.GetPbfListingsPbfListingsCollectionItemPublisherDetailResult']:
        """
        Contains details about the publisher of this PBF Listing.
        """
        return pulumi.get(self, "publisher_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the PbfListing was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The last time the PbfListing was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.GetPbfListingsPbfListingsCollectionItemTriggerResult']:
        """
        An array of Trigger. A list of triggers that may activate the PBF.
        """
        return pulumi.get(self, "triggers")


@pulumi.output_type
class GetPbfListingsPbfListingsCollectionItemPublisherDetailResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: A filter to return only resources that match the entire PBF name given.
        """
        GetPbfListingsPbfListingsCollectionItemPublisherDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire PBF name given.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPbfListingsPbfListingsCollectionItemTriggerResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: A filter to return only resources that match the entire PBF name given.
        """
        GetPbfListingsPbfListingsCollectionItemTriggerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire PBF name given.
        """
        return pulumi.get(self, "name")


