# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConnectionAdditionalAttributeArgs',
    'ConnectionBootstrapServerArgs',
    'ConnectionIngressIpArgs',
    'DeploymentDeploymentDiagnosticDataArgs',
    'DeploymentMaintenanceConfigurationArgs',
    'DeploymentMaintenanceWindowArgs',
    'DeploymentOggDataArgs',
    'GetConnectionAssignmentsFilterArgs',
    'GetConnectionsFilterArgs',
    'GetDatabaseRegistrationsFilterArgs',
    'GetDeploymentBackupsFilterArgs',
    'GetDeploymentTypesFilterArgs',
    'GetDeploymentUpgradesFilterArgs',
    'GetDeploymentVersionsFilterArgs',
    'GetDeploymentsFilterArgs',
    'GetMessagesFilterArgs',
    'GetTrailFilesFilterArgs',
    'GetTrailSequencesFilterArgs',
]

@pulumi.input_type
class ConnectionAdditionalAttributeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) The name of the property entry.
        :param pulumi.Input[str] value: (Updatable) The value of the property entry.
        """
        ConnectionAdditionalAttributeArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if name is not None:
            _setter("name", name)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the property entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The value of the property entry.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ConnectionBootstrapServerArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host: (Updatable) The name or address of a host.
        :param pulumi.Input[int] port: (Updatable) The port of an endpoint usually specified for a connection.
        :param pulumi.Input[str] private_ip: (Updatable) The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        ConnectionBootstrapServerArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            port=port,
            private_ip=private_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: Optional[pulumi.Input[str]] = None,
             port: Optional[pulumi.Input[int]] = None,
             private_ip: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']

        if host is not None:
            _setter("host", host)
        if port is not None:
            _setter("port", port)
        if private_ip is not None:
            _setter("private_ip", private_ip)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name or address of a host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The port of an endpoint usually specified for a connection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)


@pulumi.input_type
class ConnectionIngressIpArgs:
    def __init__(__self__, *,
                 ingress_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ingress_ip: A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        ConnectionIngressIpArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ingress_ip=ingress_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ingress_ip: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ingressIp' in kwargs:
            ingress_ip = kwargs['ingressIp']

        if ingress_ip is not None:
            _setter("ingress_ip", ingress_ip)

    @property
    @pulumi.getter(name="ingressIp")
    def ingress_ip(self) -> Optional[pulumi.Input[str]]:
        """
        A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        return pulumi.get(self, "ingress_ip")

    @ingress_ip.setter
    def ingress_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_ip", value)


@pulumi.input_type
class DeploymentDeploymentDiagnosticDataArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 diagnostic_state: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 time_diagnostic_end: Optional[pulumi.Input[str]] = None,
                 time_diagnostic_start: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Name of the bucket where the object is to be uploaded in the object storage
        :param pulumi.Input[str] diagnostic_state: The state of the deployment diagnostic collection.
        :param pulumi.Input[str] namespace: Name of namespace that serves as a container for all of your buckets
        :param pulumi.Input[str] object: Name of the diagnostic collected and uploaded to object storage
        :param pulumi.Input[str] time_diagnostic_end: The time until which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_diagnostic_start: The time from which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        DeploymentDeploymentDiagnosticDataArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            diagnostic_state=diagnostic_state,
            namespace=namespace,
            object=object,
            time_diagnostic_end=time_diagnostic_end,
            time_diagnostic_start=time_diagnostic_start,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[pulumi.Input[str]] = None,
             diagnostic_state: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             object: Optional[pulumi.Input[str]] = None,
             time_diagnostic_end: Optional[pulumi.Input[str]] = None,
             time_diagnostic_start: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'diagnosticState' in kwargs:
            diagnostic_state = kwargs['diagnosticState']
        if 'timeDiagnosticEnd' in kwargs:
            time_diagnostic_end = kwargs['timeDiagnosticEnd']
        if 'timeDiagnosticStart' in kwargs:
            time_diagnostic_start = kwargs['timeDiagnosticStart']

        if bucket is not None:
            _setter("bucket", bucket)
        if diagnostic_state is not None:
            _setter("diagnostic_state", diagnostic_state)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)
        if time_diagnostic_end is not None:
            _setter("time_diagnostic_end", time_diagnostic_end)
        if time_diagnostic_start is not None:
            _setter("time_diagnostic_start", time_diagnostic_start)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the bucket where the object is to be uploaded in the object storage
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="diagnosticState")
    def diagnostic_state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the deployment diagnostic collection.
        """
        return pulumi.get(self, "diagnostic_state")

    @diagnostic_state.setter
    def diagnostic_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "diagnostic_state", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Name of namespace that serves as a container for all of your buckets
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the diagnostic collected and uploaded to object storage
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="timeDiagnosticEnd")
    def time_diagnostic_end(self) -> Optional[pulumi.Input[str]]:
        """
        The time until which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_diagnostic_end")

    @time_diagnostic_end.setter
    def time_diagnostic_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_diagnostic_end", value)

    @property
    @pulumi.getter(name="timeDiagnosticStart")
    def time_diagnostic_start(self) -> Optional[pulumi.Input[str]]:
        """
        The time from which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_diagnostic_start")

    @time_diagnostic_start.setter
    def time_diagnostic_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_diagnostic_start", value)


@pulumi.input_type
class DeploymentMaintenanceConfigurationArgs:
    def __init__(__self__, *,
                 bundle_release_upgrade_period_in_days: Optional[pulumi.Input[int]] = None,
                 interim_release_upgrade_period_in_days: Optional[pulumi.Input[int]] = None,
                 is_interim_release_auto_upgrade_enabled: Optional[pulumi.Input[bool]] = None,
                 major_release_upgrade_period_in_days: Optional[pulumi.Input[int]] = None,
                 security_patch_upgrade_period_in_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] bundle_release_upgrade_period_in_days: (Updatable) Defines auto upgrade period for bundle releases. Manually configured period cannot be longer than service defined period for bundle releases. This period must be shorter or equal to major release upgrade period. Not passing this field during create will equate to using the service default.
        :param pulumi.Input[int] interim_release_upgrade_period_in_days: (Updatable) Defines auto upgrade period for interim releases. This period must be shorter or equal to bundle release upgrade period.
        :param pulumi.Input[bool] is_interim_release_auto_upgrade_enabled: (Updatable) By default auto upgrade for interim releases are not enabled. If auto-upgrade is enabled for interim release,  you have to specify interimReleaseUpgradePeriodInDays too.
        :param pulumi.Input[int] major_release_upgrade_period_in_days: (Updatable) Defines auto upgrade period for major releases. Manually configured period cannot be longer than service defined period for major releases. Not passing this field during create will equate to using the service default.
        :param pulumi.Input[int] security_patch_upgrade_period_in_days: (Updatable) Defines auto upgrade period for releases with security fix. Manually configured period cannot be longer than service defined period for security releases. Not passing this field during create will equate to using the service default.
        """
        DeploymentMaintenanceConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bundle_release_upgrade_period_in_days=bundle_release_upgrade_period_in_days,
            interim_release_upgrade_period_in_days=interim_release_upgrade_period_in_days,
            is_interim_release_auto_upgrade_enabled=is_interim_release_auto_upgrade_enabled,
            major_release_upgrade_period_in_days=major_release_upgrade_period_in_days,
            security_patch_upgrade_period_in_days=security_patch_upgrade_period_in_days,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bundle_release_upgrade_period_in_days: Optional[pulumi.Input[int]] = None,
             interim_release_upgrade_period_in_days: Optional[pulumi.Input[int]] = None,
             is_interim_release_auto_upgrade_enabled: Optional[pulumi.Input[bool]] = None,
             major_release_upgrade_period_in_days: Optional[pulumi.Input[int]] = None,
             security_patch_upgrade_period_in_days: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'bundleReleaseUpgradePeriodInDays' in kwargs:
            bundle_release_upgrade_period_in_days = kwargs['bundleReleaseUpgradePeriodInDays']
        if 'interimReleaseUpgradePeriodInDays' in kwargs:
            interim_release_upgrade_period_in_days = kwargs['interimReleaseUpgradePeriodInDays']
        if 'isInterimReleaseAutoUpgradeEnabled' in kwargs:
            is_interim_release_auto_upgrade_enabled = kwargs['isInterimReleaseAutoUpgradeEnabled']
        if 'majorReleaseUpgradePeriodInDays' in kwargs:
            major_release_upgrade_period_in_days = kwargs['majorReleaseUpgradePeriodInDays']
        if 'securityPatchUpgradePeriodInDays' in kwargs:
            security_patch_upgrade_period_in_days = kwargs['securityPatchUpgradePeriodInDays']

        if bundle_release_upgrade_period_in_days is not None:
            _setter("bundle_release_upgrade_period_in_days", bundle_release_upgrade_period_in_days)
        if interim_release_upgrade_period_in_days is not None:
            _setter("interim_release_upgrade_period_in_days", interim_release_upgrade_period_in_days)
        if is_interim_release_auto_upgrade_enabled is not None:
            _setter("is_interim_release_auto_upgrade_enabled", is_interim_release_auto_upgrade_enabled)
        if major_release_upgrade_period_in_days is not None:
            _setter("major_release_upgrade_period_in_days", major_release_upgrade_period_in_days)
        if security_patch_upgrade_period_in_days is not None:
            _setter("security_patch_upgrade_period_in_days", security_patch_upgrade_period_in_days)

    @property
    @pulumi.getter(name="bundleReleaseUpgradePeriodInDays")
    def bundle_release_upgrade_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Defines auto upgrade period for bundle releases. Manually configured period cannot be longer than service defined period for bundle releases. This period must be shorter or equal to major release upgrade period. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "bundle_release_upgrade_period_in_days")

    @bundle_release_upgrade_period_in_days.setter
    def bundle_release_upgrade_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bundle_release_upgrade_period_in_days", value)

    @property
    @pulumi.getter(name="interimReleaseUpgradePeriodInDays")
    def interim_release_upgrade_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Defines auto upgrade period for interim releases. This period must be shorter or equal to bundle release upgrade period.
        """
        return pulumi.get(self, "interim_release_upgrade_period_in_days")

    @interim_release_upgrade_period_in_days.setter
    def interim_release_upgrade_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interim_release_upgrade_period_in_days", value)

    @property
    @pulumi.getter(name="isInterimReleaseAutoUpgradeEnabled")
    def is_interim_release_auto_upgrade_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) By default auto upgrade for interim releases are not enabled. If auto-upgrade is enabled for interim release,  you have to specify interimReleaseUpgradePeriodInDays too.
        """
        return pulumi.get(self, "is_interim_release_auto_upgrade_enabled")

    @is_interim_release_auto_upgrade_enabled.setter
    def is_interim_release_auto_upgrade_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_interim_release_auto_upgrade_enabled", value)

    @property
    @pulumi.getter(name="majorReleaseUpgradePeriodInDays")
    def major_release_upgrade_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Defines auto upgrade period for major releases. Manually configured period cannot be longer than service defined period for major releases. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "major_release_upgrade_period_in_days")

    @major_release_upgrade_period_in_days.setter
    def major_release_upgrade_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "major_release_upgrade_period_in_days", value)

    @property
    @pulumi.getter(name="securityPatchUpgradePeriodInDays")
    def security_patch_upgrade_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Defines auto upgrade period for releases with security fix. Manually configured period cannot be longer than service defined period for security releases. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "security_patch_upgrade_period_in_days")

    @security_patch_upgrade_period_in_days.setter
    def security_patch_upgrade_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "security_patch_upgrade_period_in_days", value)


@pulumi.input_type
class DeploymentMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[str],
                 start_hour: pulumi.Input[int]):
        """
        :param pulumi.Input[str] day: (Updatable) Days of the week.
        :param pulumi.Input[int] start_hour: (Updatable) Start hour for maintenance period. Hour is in UTC.
        """
        DeploymentMaintenanceWindowArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            day=day,
            start_hour=start_hour,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             day: pulumi.Input[str],
             start_hour: pulumi.Input[int],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'startHour' in kwargs:
            start_hour = kwargs['startHour']

        _setter("day", day)
        _setter("start_hour", start_hour)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input[str]:
        """
        (Updatable) Days of the week.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[str]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> pulumi.Input[int]:
        """
        (Updatable) Start hour for maintenance period. Hour is in UTC.
        """
        return pulumi.get(self, "start_hour")

    @start_hour.setter
    def start_hour(self, value: pulumi.Input[int]):
        pulumi.set(self, "start_hour", value)


@pulumi.input_type
class DeploymentOggDataArgs:
    def __init__(__self__, *,
                 deployment_name: pulumi.Input[str],
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 credential_store: Optional[pulumi.Input[str]] = None,
                 identity_domain_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 ogg_version: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] deployment_name: The name given to the GoldenGate service deployment. The name must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter.
        :param pulumi.Input[str] admin_password: (Updatable) The password associated with the GoldenGate deployment console username. The password must be 8 to 30 characters long and must contain at least 1 uppercase, 1 lowercase, 1 numeric, and 1 special character. Special characters such as ‘$’, ‘^’, or ‘?’ are not allowed. This field will be deprecated and replaced by "passwordSecretId".
        :param pulumi.Input[str] admin_username: (Updatable) The GoldenGate deployment console username.
        :param pulumi.Input[str] certificate: (Updatable) A PEM-encoded SSL certificate.
        :param pulumi.Input[str] credential_store: (Updatable) The type of credential store for OGG.
        :param pulumi.Input[str] identity_domain_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Identity Domain when IAM credential store is used.
        :param pulumi.Input[str] key: (Updatable) A PEM-encoded private key.
        :param pulumi.Input[str] ogg_version: (Updatable) Version of ogg to use by deployment. By updating version you can upgrade your deployment to a newer version. Downgrade to older version is not supported.
        :param pulumi.Input[str] password_secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the deployment password is stored.
        """
        DeploymentOggDataArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_name=deployment_name,
            admin_password=admin_password,
            admin_username=admin_username,
            certificate=certificate,
            credential_store=credential_store,
            identity_domain_id=identity_domain_id,
            key=key,
            ogg_version=ogg_version,
            password_secret_id=password_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_name: pulumi.Input[str],
             admin_password: Optional[pulumi.Input[str]] = None,
             admin_username: Optional[pulumi.Input[str]] = None,
             certificate: Optional[pulumi.Input[str]] = None,
             credential_store: Optional[pulumi.Input[str]] = None,
             identity_domain_id: Optional[pulumi.Input[str]] = None,
             key: Optional[pulumi.Input[str]] = None,
             ogg_version: Optional[pulumi.Input[str]] = None,
             password_secret_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'deploymentName' in kwargs:
            deployment_name = kwargs['deploymentName']
        if 'adminPassword' in kwargs:
            admin_password = kwargs['adminPassword']
        if 'adminUsername' in kwargs:
            admin_username = kwargs['adminUsername']
        if 'credentialStore' in kwargs:
            credential_store = kwargs['credentialStore']
        if 'identityDomainId' in kwargs:
            identity_domain_id = kwargs['identityDomainId']
        if 'oggVersion' in kwargs:
            ogg_version = kwargs['oggVersion']
        if 'passwordSecretId' in kwargs:
            password_secret_id = kwargs['passwordSecretId']

        _setter("deployment_name", deployment_name)
        if admin_password is not None:
            _setter("admin_password", admin_password)
        if admin_username is not None:
            _setter("admin_username", admin_username)
        if certificate is not None:
            _setter("certificate", certificate)
        if credential_store is not None:
            _setter("credential_store", credential_store)
        if identity_domain_id is not None:
            _setter("identity_domain_id", identity_domain_id)
        if key is not None:
            _setter("key", key)
        if ogg_version is not None:
            _setter("ogg_version", ogg_version)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> pulumi.Input[str]:
        """
        The name given to the GoldenGate service deployment. The name must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter.
        """
        return pulumi.get(self, "deployment_name")

    @deployment_name.setter
    def deployment_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_name", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password associated with the GoldenGate deployment console username. The password must be 8 to 30 characters long and must contain at least 1 uppercase, 1 lowercase, 1 numeric, and 1 special character. Special characters such as ‘$’, ‘^’, or ‘?’ are not allowed. This field will be deprecated and replaced by "passwordSecretId".
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The GoldenGate deployment console username.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A PEM-encoded SSL certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="credentialStore")
    def credential_store(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of credential store for OGG.
        """
        return pulumi.get(self, "credential_store")

    @credential_store.setter
    def credential_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_store", value)

    @property
    @pulumi.getter(name="identityDomainId")
    def identity_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Identity Domain when IAM credential store is used.
        """
        return pulumi.get(self, "identity_domain_id")

    @identity_domain_id.setter
    def identity_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_domain_id", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A PEM-encoded private key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Version of ogg to use by deployment. By updating version you can upgrade your deployment to a newer version. Downgrade to older version is not supported.
        """
        return pulumi.get(self, "ogg_version")

    @ogg_version.setter
    def ogg_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ogg_version", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the deployment password is stored.
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)


@pulumi.input_type
class GetConnectionAssignmentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the connection in the assignment (aliasName).
        """
        GetConnectionAssignmentsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the connection in the assignment (aliasName).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetConnectionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the property entry.
        """
        GetConnectionsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the property entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDatabaseRegistrationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDatabaseRegistrationsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDeploymentBackupsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentBackupsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDeploymentTypesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentTypesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDeploymentUpgradesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentUpgradesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDeploymentVersionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentVersionsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDeploymentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMessagesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetMessagesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetTrailFilesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetTrailFilesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetTrailSequencesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetTrailSequencesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


