# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTagStandardTagNamespaceTemplateResult',
    'AwaitableGetTagStandardTagNamespaceTemplateResult',
    'get_tag_standard_tag_namespace_template',
    'get_tag_standard_tag_namespace_template_output',
]

@pulumi.output_type
class GetTagStandardTagNamespaceTemplateResult:
    """
    A collection of values returned by getTagStandardTagNamespaceTemplate.
    """
    def __init__(__self__, compartment_id=None, description=None, id=None, standard_tag_namespace_name=None, status=None, tag_definition_templates=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if standard_tag_namespace_name and not isinstance(standard_tag_namespace_name, str):
            raise TypeError("Expected argument 'standard_tag_namespace_name' to be a str")
        pulumi.set(__self__, "standard_tag_namespace_name", standard_tag_namespace_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tag_definition_templates and not isinstance(tag_definition_templates, list):
            raise TypeError("Expected argument 'tag_definition_templates' to be a list")
        pulumi.set(__self__, "tag_definition_templates", tag_definition_templates)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The default description of the tag namespace that users can use to create the tag definition
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="standardTagNamespaceName")
    def standard_tag_namespace_name(self) -> str:
        """
        The reserved name of this standard tag namespace
        """
        return pulumi.get(self, "standard_tag_namespace_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the standard tag namespace
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tagDefinitionTemplates")
    def tag_definition_templates(self) -> Sequence['outputs.GetTagStandardTagNamespaceTemplateTagDefinitionTemplateResult']:
        """
        The template of the tag definition. This object includes necessary details to create the provided standard tag definition.
        """
        return pulumi.get(self, "tag_definition_templates")


class AwaitableGetTagStandardTagNamespaceTemplateResult(GetTagStandardTagNamespaceTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagStandardTagNamespaceTemplateResult(
            compartment_id=self.compartment_id,
            description=self.description,
            id=self.id,
            standard_tag_namespace_name=self.standard_tag_namespace_name,
            status=self.status,
            tag_definition_templates=self.tag_definition_templates)


def get_tag_standard_tag_namespace_template(compartment_id: Optional[str] = None,
                                            standard_tag_namespace_name: Optional[str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagStandardTagNamespaceTemplateResult:
    """
    This data source provides details about a specific Tag Standard Tag Namespace Template resource in Oracle Cloud Infrastructure Identity service.

    Retrieve the standard tag namespace template given the standard tag namespace name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tag_standard_tag_namespace_template = oci.Identity.get_tag_standard_tag_namespace_template(compartment_id=var["compartment_id"],
        standard_tag_namespace_name=oci_identity_tag_namespace["test_tag_namespace"]["name"])
    ```


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str standard_tag_namespace_name: The name of the standard tag namespace tempate that is requested
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['standardTagNamespaceName'] = standard_tag_namespace_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getTagStandardTagNamespaceTemplate:getTagStandardTagNamespaceTemplate', __args__, opts=opts, typ=GetTagStandardTagNamespaceTemplateResult).value

    return AwaitableGetTagStandardTagNamespaceTemplateResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        standard_tag_namespace_name=pulumi.get(__ret__, 'standard_tag_namespace_name'),
        status=pulumi.get(__ret__, 'status'),
        tag_definition_templates=pulumi.get(__ret__, 'tag_definition_templates'))


@_utilities.lift_output_func(get_tag_standard_tag_namespace_template)
def get_tag_standard_tag_namespace_template_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                   standard_tag_namespace_name: Optional[pulumi.Input[str]] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTagStandardTagNamespaceTemplateResult]:
    """
    This data source provides details about a specific Tag Standard Tag Namespace Template resource in Oracle Cloud Infrastructure Identity service.

    Retrieve the standard tag namespace template given the standard tag namespace name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tag_standard_tag_namespace_template = oci.Identity.get_tag_standard_tag_namespace_template(compartment_id=var["compartment_id"],
        standard_tag_namespace_name=oci_identity_tag_namespace["test_tag_namespace"]["name"])
    ```


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str standard_tag_namespace_name: The name of the standard tag namespace tempate that is requested
    """
    ...
