# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] description: (Updatable) The description you assign to the user during creation. Does not have to be unique, and it's changeable.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the user.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] email: (Updatable) The email you assign to the user. Has to be unique across the tenancy.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name: The name you assign to the user during creation. This is the user's login for the Console. The name must be unique across all users in the tenancy and cannot be changed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        UserArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            email=email,
            freeform_tags=freeform_tags,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: pulumi.Input[str],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             email: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("description", description)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if email is not None:
            _setter("email", email)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if name is not None:
            _setter("name", name)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        (Updatable) The description you assign to the user during creation. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the tenancy containing the user.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The email you assign to the user. Has to be unique across the tenancy.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you assign to the user during creation. This is the user's login for the Console. The name must be unique across all users in the tenancy and cannot be changed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['UserCapabilityArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 db_user_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 email_verified: Optional[pulumi.Input[bool]] = None,
                 external_identifier: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 identity_provider_id: Optional[pulumi.Input[str]] = None,
                 inactive_state: Optional[pulumi.Input[str]] = None,
                 last_successful_login_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 previous_successful_login_time: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[Sequence[pulumi.Input['UserCapabilityArgs']]] capabilities: Properties indicating how the user is allowed to authenticate.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the user.
        :param pulumi.Input[str] db_user_name: DB username of the DB credential. Has to be unique across the tenancy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description you assign to the user during creation. Does not have to be unique, and it's changeable.
        :param pulumi.Input[str] email: (Updatable) The email you assign to the user. Has to be unique across the tenancy.
        :param pulumi.Input[bool] email_verified: Whether the email address has been validated.
        :param pulumi.Input[str] external_identifier: Identifier of the user in the identity provider
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] identity_provider_id: The OCID of the `IdentityProvider` this user belongs to.
        :param pulumi.Input[str] inactive_state: Returned only if the user's `lifecycleState` is INACTIVE. A 16-bit value showing the reason why the user is inactive:
               * bit 0: SUSPENDED (reserved for future use)
               * bit 1: DISABLED (reserved for future use)
               * bit 2: BLOCKED (the user has exceeded the maximum number of failed login attempts for the Console)
        :param pulumi.Input[str] last_successful_login_time: The date and time of when the user most recently logged in the format defined by RFC3339 (ex. `2016-08-25T21:10:29.600Z`). If there is no login history, this field is null.
        :param pulumi.Input[str] name: The name you assign to the user during creation. This is the user's login for the Console. The name must be unique across all users in the tenancy and cannot be changed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] previous_successful_login_time: The date and time of when the user most recently logged in the format defined by RFC3339 (ex. `2016-08-25T21:10:29.600Z`). If there is no login history, this field is null.
        :param pulumi.Input[str] state: The user's current state.
        :param pulumi.Input[str] time_created: Date and time the user was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        _UserState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            capabilities=capabilities,
            compartment_id=compartment_id,
            db_user_name=db_user_name,
            defined_tags=defined_tags,
            description=description,
            email=email,
            email_verified=email_verified,
            external_identifier=external_identifier,
            freeform_tags=freeform_tags,
            identity_provider_id=identity_provider_id,
            inactive_state=inactive_state,
            last_successful_login_time=last_successful_login_time,
            name=name,
            previous_successful_login_time=previous_successful_login_time,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['UserCapabilityArgs']]]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             db_user_name: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             email: Optional[pulumi.Input[str]] = None,
             email_verified: Optional[pulumi.Input[bool]] = None,
             external_identifier: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             identity_provider_id: Optional[pulumi.Input[str]] = None,
             inactive_state: Optional[pulumi.Input[str]] = None,
             last_successful_login_time: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             previous_successful_login_time: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'dbUserName' in kwargs:
            db_user_name = kwargs['dbUserName']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'emailVerified' in kwargs:
            email_verified = kwargs['emailVerified']
        if 'externalIdentifier' in kwargs:
            external_identifier = kwargs['externalIdentifier']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'identityProviderId' in kwargs:
            identity_provider_id = kwargs['identityProviderId']
        if 'inactiveState' in kwargs:
            inactive_state = kwargs['inactiveState']
        if 'lastSuccessfulLoginTime' in kwargs:
            last_successful_login_time = kwargs['lastSuccessfulLoginTime']
        if 'previousSuccessfulLoginTime' in kwargs:
            previous_successful_login_time = kwargs['previousSuccessfulLoginTime']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        if capabilities is not None:
            _setter("capabilities", capabilities)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if db_user_name is not None:
            _setter("db_user_name", db_user_name)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if email is not None:
            _setter("email", email)
        if email_verified is not None:
            _setter("email_verified", email_verified)
        if external_identifier is not None:
            _setter("external_identifier", external_identifier)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if identity_provider_id is not None:
            _setter("identity_provider_id", identity_provider_id)
        if inactive_state is not None:
            _setter("inactive_state", inactive_state)
        if last_successful_login_time is not None:
            _setter("last_successful_login_time", last_successful_login_time)
        if name is not None:
            _setter("name", name)
        if previous_successful_login_time is not None:
            _setter("previous_successful_login_time", previous_successful_login_time)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserCapabilityArgs']]]]:
        """
        Properties indicating how the user is allowed to authenticate.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the tenancy containing the user.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        DB username of the DB credential. Has to be unique across the tenancy.
        """
        return pulumi.get(self, "db_user_name")

    @db_user_name.setter
    def db_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description you assign to the user during creation. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The email you assign to the user. Has to be unique across the tenancy.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="emailVerified")
    def email_verified(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the email address has been validated.
        """
        return pulumi.get(self, "email_verified")

    @email_verified.setter
    def email_verified(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_verified", value)

    @property
    @pulumi.getter(name="externalIdentifier")
    def external_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the user in the identity provider
        """
        return pulumi.get(self, "external_identifier")

    @external_identifier.setter
    def external_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_identifier", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="identityProviderId")
    def identity_provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the `IdentityProvider` this user belongs to.
        """
        return pulumi.get(self, "identity_provider_id")

    @identity_provider_id.setter
    def identity_provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider_id", value)

    @property
    @pulumi.getter(name="inactiveState")
    def inactive_state(self) -> Optional[pulumi.Input[str]]:
        """
        Returned only if the user's `lifecycleState` is INACTIVE. A 16-bit value showing the reason why the user is inactive:
        * bit 0: SUSPENDED (reserved for future use)
        * bit 1: DISABLED (reserved for future use)
        * bit 2: BLOCKED (the user has exceeded the maximum number of failed login attempts for the Console)
        """
        return pulumi.get(self, "inactive_state")

    @inactive_state.setter
    def inactive_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inactive_state", value)

    @property
    @pulumi.getter(name="lastSuccessfulLoginTime")
    def last_successful_login_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the user most recently logged in the format defined by RFC3339 (ex. `2016-08-25T21:10:29.600Z`). If there is no login history, this field is null.
        """
        return pulumi.get(self, "last_successful_login_time")

    @last_successful_login_time.setter
    def last_successful_login_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_successful_login_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you assign to the user during creation. This is the user's login for the Console. The name must be unique across all users in the tenancy and cannot be changed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="previousSuccessfulLoginTime")
    def previous_successful_login_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the user most recently logged in the format defined by RFC3339 (ex. `2016-08-25T21:10:29.600Z`). If there is no login history, this field is null.
        """
        return pulumi.get(self, "previous_successful_login_time")

    @previous_successful_login_time.setter
    def previous_successful_login_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "previous_successful_login_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The user's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the user was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the User resource in Oracle Cloud Infrastructure Identity service.

        Creates a new user in your tenancy. For conceptual information about users, your tenancy, and other
        IAM Service components, see [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        You must specify your tenancy's OCID as the compartment ID in the request object (remember that the
        tenancy is simply the root compartment). Notice that IAM resources (users, groups, compartments, and
        some policies) reside within the tenancy itself, unlike cloud resources such as compute instances,
        which typically reside within compartments inside the tenancy. For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You must also specify a *name* for the user, which must be unique across all users in your tenancy
        and cannot be changed. Allowed characters: No spaces. Only letters, numerals, hyphens, periods,
        underscores, +, and @. If you specify a name that's already in use, you'll get a 409 error.
        This name will be the user's login to the Console. You might want to pick a
        name that your company's own identity system (e.g., Active Directory, LDAP, etc.) already uses.
        If you delete a user and then create a new user with the same name, they'll be considered different
        users because they have different OCIDs.

        You must also specify a *description* for the user (although it can be an empty string).
        It does not have to be unique, and you can change it anytime with
        [UpdateUser](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/User/UpdateUser). You can use the field to provide the user's
        full name, a description, a nickname, or other information to generally identify the user.
        A new user has no permissions until you place the user in one or more groups (see
        [AddUserToGroup](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/UserGroupMembership/AddUserToGroup)). If the user needs to
        access the Console, you need to provide the user a password (see
        [CreateOrResetUIPassword](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/UIPassword/CreateOrResetUIPassword)).
        If the user needs to access the Oracle Cloud Infrastructure REST API, you need to upload a
        public API signing key for that user (see
        [Required Keys and OCIDs](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm) and also
        [UploadApiKey](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/ApiKey/UploadApiKey)).

        **Important:** Make sure to inform the new user which compartment(s) they have access to.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_user = oci.identity.User("testUser",
            compartment_id=var["tenancy_ocid"],
            description=var["user_description"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            email=var["user_email"],
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/user:User test_user "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the user.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description you assign to the user during creation. Does not have to be unique, and it's changeable.
        :param pulumi.Input[str] email: (Updatable) The email you assign to the user. Has to be unique across the tenancy.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name: The name you assign to the user during creation. This is the user's login for the Console. The name must be unique across all users in the tenancy and cannot be changed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the User resource in Oracle Cloud Infrastructure Identity service.

        Creates a new user in your tenancy. For conceptual information about users, your tenancy, and other
        IAM Service components, see [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        You must specify your tenancy's OCID as the compartment ID in the request object (remember that the
        tenancy is simply the root compartment). Notice that IAM resources (users, groups, compartments, and
        some policies) reside within the tenancy itself, unlike cloud resources such as compute instances,
        which typically reside within compartments inside the tenancy. For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You must also specify a *name* for the user, which must be unique across all users in your tenancy
        and cannot be changed. Allowed characters: No spaces. Only letters, numerals, hyphens, periods,
        underscores, +, and @. If you specify a name that's already in use, you'll get a 409 error.
        This name will be the user's login to the Console. You might want to pick a
        name that your company's own identity system (e.g., Active Directory, LDAP, etc.) already uses.
        If you delete a user and then create a new user with the same name, they'll be considered different
        users because they have different OCIDs.

        You must also specify a *description* for the user (although it can be an empty string).
        It does not have to be unique, and you can change it anytime with
        [UpdateUser](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/User/UpdateUser). You can use the field to provide the user's
        full name, a description, a nickname, or other information to generally identify the user.
        A new user has no permissions until you place the user in one or more groups (see
        [AddUserToGroup](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/UserGroupMembership/AddUserToGroup)). If the user needs to
        access the Console, you need to provide the user a password (see
        [CreateOrResetUIPassword](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/UIPassword/CreateOrResetUIPassword)).
        If the user needs to access the Oracle Cloud Infrastructure REST API, you need to upload a
        public API signing key for that user (see
        [Required Keys and OCIDs](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm) and also
        [UploadApiKey](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/ApiKey/UploadApiKey)).

        **Important:** Make sure to inform the new user which compartment(s) they have access to.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_user = oci.identity.User("testUser",
            compartment_id=var["tenancy_ocid"],
            description=var["user_description"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            email=var["user_email"],
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/user:User test_user "id"
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            UserArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["email"] = email
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            __props__.__dict__["capabilities"] = None
            __props__.__dict__["db_user_name"] = None
            __props__.__dict__["email_verified"] = None
            __props__.__dict__["external_identifier"] = None
            __props__.__dict__["identity_provider_id"] = None
            __props__.__dict__["inactive_state"] = None
            __props__.__dict__["last_successful_login_time"] = None
            __props__.__dict__["previous_successful_login_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(User, __self__).__init__(
            'oci:Identity/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserCapabilityArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            db_user_name: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            email_verified: Optional[pulumi.Input[bool]] = None,
            external_identifier: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            identity_provider_id: Optional[pulumi.Input[str]] = None,
            inactive_state: Optional[pulumi.Input[str]] = None,
            last_successful_login_time: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            previous_successful_login_time: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UserCapabilityArgs']]]] capabilities: Properties indicating how the user is allowed to authenticate.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the user.
        :param pulumi.Input[str] db_user_name: DB username of the DB credential. Has to be unique across the tenancy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description you assign to the user during creation. Does not have to be unique, and it's changeable.
        :param pulumi.Input[str] email: (Updatable) The email you assign to the user. Has to be unique across the tenancy.
        :param pulumi.Input[bool] email_verified: Whether the email address has been validated.
        :param pulumi.Input[str] external_identifier: Identifier of the user in the identity provider
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] identity_provider_id: The OCID of the `IdentityProvider` this user belongs to.
        :param pulumi.Input[str] inactive_state: Returned only if the user's `lifecycleState` is INACTIVE. A 16-bit value showing the reason why the user is inactive:
               * bit 0: SUSPENDED (reserved for future use)
               * bit 1: DISABLED (reserved for future use)
               * bit 2: BLOCKED (the user has exceeded the maximum number of failed login attempts for the Console)
        :param pulumi.Input[str] last_successful_login_time: The date and time of when the user most recently logged in the format defined by RFC3339 (ex. `2016-08-25T21:10:29.600Z`). If there is no login history, this field is null.
        :param pulumi.Input[str] name: The name you assign to the user during creation. This is the user's login for the Console. The name must be unique across all users in the tenancy and cannot be changed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] previous_successful_login_time: The date and time of when the user most recently logged in the format defined by RFC3339 (ex. `2016-08-25T21:10:29.600Z`). If there is no login history, this field is null.
        :param pulumi.Input[str] state: The user's current state.
        :param pulumi.Input[str] time_created: Date and time the user was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["db_user_name"] = db_user_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["email_verified"] = email_verified
        __props__.__dict__["external_identifier"] = external_identifier
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["identity_provider_id"] = identity_provider_id
        __props__.__dict__["inactive_state"] = inactive_state
        __props__.__dict__["last_successful_login_time"] = last_successful_login_time
        __props__.__dict__["name"] = name
        __props__.__dict__["previous_successful_login_time"] = previous_successful_login_time
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence['outputs.UserCapability']]:
        """
        Properties indicating how the user is allowed to authenticate.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the tenancy containing the user.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> pulumi.Output[str]:
        """
        DB username of the DB credential. Has to be unique across the tenancy.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description you assign to the user during creation. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        (Updatable) The email you assign to the user. Has to be unique across the tenancy.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="emailVerified")
    def email_verified(self) -> pulumi.Output[bool]:
        """
        Whether the email address has been validated.
        """
        return pulumi.get(self, "email_verified")

    @property
    @pulumi.getter(name="externalIdentifier")
    def external_identifier(self) -> pulumi.Output[str]:
        """
        Identifier of the user in the identity provider
        """
        return pulumi.get(self, "external_identifier")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="identityProviderId")
    def identity_provider_id(self) -> pulumi.Output[str]:
        """
        The OCID of the `IdentityProvider` this user belongs to.
        """
        return pulumi.get(self, "identity_provider_id")

    @property
    @pulumi.getter(name="inactiveState")
    def inactive_state(self) -> pulumi.Output[str]:
        """
        Returned only if the user's `lifecycleState` is INACTIVE. A 16-bit value showing the reason why the user is inactive:
        * bit 0: SUSPENDED (reserved for future use)
        * bit 1: DISABLED (reserved for future use)
        * bit 2: BLOCKED (the user has exceeded the maximum number of failed login attempts for the Console)
        """
        return pulumi.get(self, "inactive_state")

    @property
    @pulumi.getter(name="lastSuccessfulLoginTime")
    def last_successful_login_time(self) -> pulumi.Output[str]:
        """
        The date and time of when the user most recently logged in the format defined by RFC3339 (ex. `2016-08-25T21:10:29.600Z`). If there is no login history, this field is null.
        """
        return pulumi.get(self, "last_successful_login_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name you assign to the user during creation. This is the user's login for the Console. The name must be unique across all users in the tenancy and cannot be changed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="previousSuccessfulLoginTime")
    def previous_successful_login_time(self) -> pulumi.Output[str]:
        """
        The date and time of when the user most recently logged in the format defined by RFC3339 (ex. `2016-08-25T21:10:29.600Z`). If there is no login history, this field is null.
        """
        return pulumi.get(self, "previous_successful_login_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The user's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Date and time the user was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

