# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GeneratedKeyKeyShape',
    'KeyExternalKeyReference',
    'KeyExternalKeyReferenceDetail',
    'KeyKeyShape',
    'KeyReplicaDetail',
    'KeyRestoreFromFile',
    'KeyRestoreFromObjectStore',
    'KeyVersionExternalKeyReferenceDetail',
    'KeyVersionReplicaDetail',
    'VaultExternalKeyManagerMetadata',
    'VaultExternalKeyManagerMetadataOauthMetadata',
    'VaultExternalKeyManagerMetadataSummary',
    'VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary',
    'VaultReplicaDetail',
    'VaultRestoreFromFile',
    'VaultRestoreFromObjectStore',
    'GetEkmsPrivateEndpointsEkmsPrivateEndpointResult',
    'GetEkmsPrivateEndpointsFilterResult',
    'GetKeyExternalKeyReferenceResult',
    'GetKeyExternalKeyReferenceDetailResult',
    'GetKeyKeyShapeResult',
    'GetKeyReplicaDetailResult',
    'GetKeyRestoreFromFileResult',
    'GetKeyRestoreFromObjectStoreResult',
    'GetKeyVersionExternalKeyReferenceDetailResult',
    'GetKeyVersionReplicaDetailResult',
    'GetKeyVersionsFilterResult',
    'GetKeyVersionsKeyVersionResult',
    'GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult',
    'GetKeyVersionsKeyVersionReplicaDetailResult',
    'GetKeysFilterResult',
    'GetKeysKeyResult',
    'GetKeysKeyExternalKeyReferenceResult',
    'GetKeysKeyExternalKeyReferenceDetailResult',
    'GetKeysKeyKeyShapeResult',
    'GetKeysKeyReplicaDetailResult',
    'GetKeysKeyRestoreFromFileResult',
    'GetKeysKeyRestoreFromObjectStoreResult',
    'GetReplicationStatusReplicaDetailResult',
    'GetVaultExternalKeyManagerMetadataResult',
    'GetVaultExternalKeyManagerMetadataOauthMetadataResult',
    'GetVaultExternalKeyManagerMetadataSummaryResult',
    'GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult',
    'GetVaultReplicaDetailResult',
    'GetVaultReplicasFilterResult',
    'GetVaultReplicasVaultReplicaResult',
    'GetVaultRestoreFromFileResult',
    'GetVaultRestoreFromObjectStoreResult',
    'GetVaultsFilterResult',
    'GetVaultsVaultResult',
    'GetVaultsVaultExternalKeyManagerMetadataResult',
    'GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult',
    'GetVaultsVaultExternalKeyManagerMetadataSummaryResult',
    'GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult',
    'GetVaultsVaultReplicaDetailResult',
    'GetVaultsVaultRestoreFromFileResult',
    'GetVaultsVaultRestoreFromObjectStoreResult',
]

@pulumi.output_type
class GeneratedKeyKeyShape(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "curveId":
            suggest = "curve_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GeneratedKeyKeyShape. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GeneratedKeyKeyShape.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GeneratedKeyKeyShape.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 length: int,
                 curve_id: Optional[str] = None):
        """
        :param str algorithm: The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        :param int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param str curve_id: Supported curve IDs for ECDSA keys.
        """
        GeneratedKeyKeyShape._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            algorithm=algorithm,
            length=length,
            curve_id=curve_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             algorithm: str,
             length: int,
             curve_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'curveId' in kwargs:
            curve_id = kwargs['curveId']

        _setter("algorithm", algorithm)
        _setter("length", length)
        if curve_id is not None:
            _setter("curve_id", curve_id)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[str]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")


@pulumi.output_type
class KeyExternalKeyReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalKeyId":
            suggest = "external_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyExternalKeyReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyExternalKeyReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyExternalKeyReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_key_id: str):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        """
        KeyExternalKeyReference._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']

        _setter("external_key_id", external_key_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        """
        return pulumi.get(self, "external_key_id")


@pulumi.output_type
class KeyExternalKeyReferenceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalKeyId":
            suggest = "external_key_id"
        elif key == "externalKeyVersionId":
            suggest = "external_key_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyExternalKeyReferenceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyExternalKeyReferenceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyExternalKeyReferenceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_key_id: Optional[str] = None,
                 external_key_version_id: Optional[str] = None):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        :param str external_key_version_id: Key version ID associated with the external key.
        """
        KeyExternalKeyReferenceDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
            external_key_version_id=external_key_version_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: Optional[str] = None,
             external_key_version_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']
        if 'externalKeyVersionId' in kwargs:
            external_key_version_id = kwargs['externalKeyVersionId']

        if external_key_id is not None:
            _setter("external_key_id", external_key_id)
        if external_key_version_id is not None:
            _setter("external_key_version_id", external_key_version_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> Optional[str]:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM
        """
        return pulumi.get(self, "external_key_id")

    @property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> Optional[str]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class KeyKeyShape(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "curveId":
            suggest = "curve_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyKeyShape. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyKeyShape.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyKeyShape.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 length: int,
                 curve_id: Optional[str] = None):
        """
        :param str algorithm: The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        :param int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        :param str curve_id: Supported curve IDs for ECDSA keys.
        """
        KeyKeyShape._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            algorithm=algorithm,
            length=length,
            curve_id=curve_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             algorithm: str,
             length: int,
             curve_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'curveId' in kwargs:
            curve_id = kwargs['curveId']

        _setter("algorithm", algorithm)
        _setter("length", length)
        if curve_id is not None:
            _setter("curve_id", curve_id)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> Optional[str]:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")


@pulumi.output_type
class KeyReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[str] = None):
        """
        :param str replication_id: ReplicationId associated with a key operation
        """
        KeyReplicaDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        if replication_id is not None:
            _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[str]:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class KeyRestoreFromFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentLength":
            suggest = "content_length"
        elif key == "restoreKeyFromFileDetails":
            suggest = "restore_key_from_file_details"
        elif key == "contentMd5":
            suggest = "content_md5"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyRestoreFromFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyRestoreFromFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyRestoreFromFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_length: str,
                 restore_key_from_file_details: str,
                 content_md5: Optional[str] = None):
        """
        :param str content_length: (Updatable) content length of key's backup binary file
        :param str restore_key_from_file_details: Key backup file content.
        :param str content_md5: (Updatable) content md5 hashed value of key's backup file
        """
        KeyRestoreFromFile._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content_length=content_length,
            restore_key_from_file_details=restore_key_from_file_details,
            content_md5=content_md5,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content_length: str,
             restore_key_from_file_details: str,
             content_md5: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'contentLength' in kwargs:
            content_length = kwargs['contentLength']
        if 'restoreKeyFromFileDetails' in kwargs:
            restore_key_from_file_details = kwargs['restoreKeyFromFileDetails']
        if 'contentMd5' in kwargs:
            content_md5 = kwargs['contentMd5']

        _setter("content_length", content_length)
        _setter("restore_key_from_file_details", restore_key_from_file_details)
        if content_md5 is not None:
            _setter("content_md5", content_md5)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        (Updatable) content length of key's backup binary file
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> str:
        """
        Key backup file content.
        """
        return pulumi.get(self, "restore_key_from_file_details")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[str]:
        """
        (Updatable) content md5 hashed value of key's backup file
        """
        return pulumi.get(self, "content_md5")


@pulumi.output_type
class KeyRestoreFromObjectStore(dict):
    def __init__(__self__, *,
                 destination: str,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param str bucket: (Updatable) Name of the bucket where key was backed up
        :param str namespace: (Updatable) Namespace of the bucket where key was backed up
        :param str object: (Updatable) Object containing the backup
        :param str uri: (Updatable) Pre-authenticated-request-uri of the backup
        """
        KeyRestoreFromObjectStore._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            destination=destination,
            bucket=bucket,
            namespace=namespace,
            object=object,
            uri=uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             destination: str,
             bucket: Optional[str] = None,
             namespace: Optional[str] = None,
             object: Optional[str] = None,
             uri: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("destination", destination)
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)
        if uri is not None:
            _setter("uri", uri)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        (Updatable) Name of the bucket where key was backed up
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace of the bucket where key was backed up
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class KeyVersionExternalKeyReferenceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalKeyId":
            suggest = "external_key_id"
        elif key == "externalKeyVersionId":
            suggest = "external_key_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVersionExternalKeyReferenceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVersionExternalKeyReferenceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVersionExternalKeyReferenceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_key_id: Optional[str] = None,
                 external_key_version_id: Optional[str] = None):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param str external_key_version_id: Key version ID associated with the external key.
        """
        KeyVersionExternalKeyReferenceDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
            external_key_version_id=external_key_version_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: Optional[str] = None,
             external_key_version_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']
        if 'externalKeyVersionId' in kwargs:
            external_key_version_id = kwargs['externalKeyVersionId']

        if external_key_id is not None:
            _setter("external_key_id", external_key_id)
        if external_key_version_id is not None:
            _setter("external_key_version_id", external_key_version_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> Optional[str]:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> Optional[str]:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class KeyVersionReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVersionReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVersionReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVersionReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[str] = None):
        """
        :param str replication_id: ReplicationId associated with a key version operation
        """
        KeyVersionReplicaDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        if replication_id is not None:
            _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[str]:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class VaultExternalKeyManagerMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalVaultEndpointUrl":
            suggest = "external_vault_endpoint_url"
        elif key == "oauthMetadata":
            suggest = "oauth_metadata"
        elif key == "privateEndpointId":
            suggest = "private_endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultExternalKeyManagerMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultExternalKeyManagerMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultExternalKeyManagerMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_vault_endpoint_url: str,
                 oauth_metadata: 'outputs.VaultExternalKeyManagerMetadataOauthMetadata',
                 private_endpoint_id: str):
        """
        :param str external_vault_endpoint_url: URI of the vault on external key manager.
        :param 'VaultExternalKeyManagerMetadataOauthMetadataArgs' oauth_metadata: Authorization details required to get access token from IDP for accessing protected resources.
        :param str private_endpoint_id: OCID of private endpoint created by customer.
        """
        VaultExternalKeyManagerMetadata._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_vault_endpoint_url=external_vault_endpoint_url,
            oauth_metadata=oauth_metadata,
            private_endpoint_id=private_endpoint_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_vault_endpoint_url: str,
             oauth_metadata: 'outputs.VaultExternalKeyManagerMetadataOauthMetadata',
             private_endpoint_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalVaultEndpointUrl' in kwargs:
            external_vault_endpoint_url = kwargs['externalVaultEndpointUrl']
        if 'oauthMetadata' in kwargs:
            oauth_metadata = kwargs['oauthMetadata']
        if 'privateEndpointId' in kwargs:
            private_endpoint_id = kwargs['privateEndpointId']

        _setter("external_vault_endpoint_url", external_vault_endpoint_url)
        _setter("oauth_metadata", oauth_metadata)
        _setter("private_endpoint_id", private_endpoint_id)

    @property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> str:
        """
        URI of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @property
    @pulumi.getter(name="oauthMetadata")
    def oauth_metadata(self) -> 'outputs.VaultExternalKeyManagerMetadataOauthMetadata':
        """
        Authorization details required to get access token from IDP for accessing protected resources.
        """
        return pulumi.get(self, "oauth_metadata")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        OCID of private endpoint created by customer.
        """
        return pulumi.get(self, "private_endpoint_id")


@pulumi.output_type
class VaultExternalKeyManagerMetadataOauthMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAppId":
            suggest = "client_app_id"
        elif key == "clientAppSecret":
            suggest = "client_app_secret"
        elif key == "idcsAccountNameUrl":
            suggest = "idcs_account_name_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultExternalKeyManagerMetadataOauthMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultExternalKeyManagerMetadataOauthMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultExternalKeyManagerMetadataOauthMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_app_id: str,
                 client_app_secret: str,
                 idcs_account_name_url: str):
        """
        :param str client_app_id: ID of the client app created in IDP.
        :param str client_app_secret: Secret of the client app created in IDP.
        :param str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        VaultExternalKeyManagerMetadataOauthMetadata._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            client_app_id=client_app_id,
            client_app_secret=client_app_secret,
            idcs_account_name_url=idcs_account_name_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             client_app_id: str,
             client_app_secret: str,
             idcs_account_name_url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientAppId' in kwargs:
            client_app_id = kwargs['clientAppId']
        if 'clientAppSecret' in kwargs:
            client_app_secret = kwargs['clientAppSecret']
        if 'idcsAccountNameUrl' in kwargs:
            idcs_account_name_url = kwargs['idcsAccountNameUrl']

        _setter("client_app_id", client_app_id)
        _setter("client_app_secret", client_app_secret)
        _setter("idcs_account_name_url", idcs_account_name_url)

    @property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @property
    @pulumi.getter(name="clientAppSecret")
    def client_app_secret(self) -> str:
        """
        Secret of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_secret")

    @property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class VaultExternalKeyManagerMetadataSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalVaultEndpointUrl":
            suggest = "external_vault_endpoint_url"
        elif key == "oauthMetadataSummaries":
            suggest = "oauth_metadata_summaries"
        elif key == "privateEndpointId":
            suggest = "private_endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultExternalKeyManagerMetadataSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultExternalKeyManagerMetadataSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultExternalKeyManagerMetadataSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_vault_endpoint_url: Optional[str] = None,
                 oauth_metadata_summaries: Optional[Sequence['outputs.VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary']] = None,
                 private_endpoint_id: Optional[str] = None,
                 vendor: Optional[str] = None):
        """
        :param str external_vault_endpoint_url: URI of the vault on external key manager.
        :param Sequence['VaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs'] oauth_metadata_summaries: Summary about authorization to be returned to the customer as a response.
        :param str private_endpoint_id: OCID of private endpoint created by customer.
        :param str vendor: Vendor of the external key manager.
        """
        VaultExternalKeyManagerMetadataSummary._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_vault_endpoint_url=external_vault_endpoint_url,
            oauth_metadata_summaries=oauth_metadata_summaries,
            private_endpoint_id=private_endpoint_id,
            vendor=vendor,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_vault_endpoint_url: Optional[str] = None,
             oauth_metadata_summaries: Optional[Sequence['outputs.VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary']] = None,
             private_endpoint_id: Optional[str] = None,
             vendor: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalVaultEndpointUrl' in kwargs:
            external_vault_endpoint_url = kwargs['externalVaultEndpointUrl']
        if 'oauthMetadataSummaries' in kwargs:
            oauth_metadata_summaries = kwargs['oauthMetadataSummaries']
        if 'privateEndpointId' in kwargs:
            private_endpoint_id = kwargs['privateEndpointId']

        if external_vault_endpoint_url is not None:
            _setter("external_vault_endpoint_url", external_vault_endpoint_url)
        if oauth_metadata_summaries is not None:
            _setter("oauth_metadata_summaries", oauth_metadata_summaries)
        if private_endpoint_id is not None:
            _setter("private_endpoint_id", private_endpoint_id)
        if vendor is not None:
            _setter("vendor", vendor)

    @property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> Optional[str]:
        """
        URI of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @property
    @pulumi.getter(name="oauthMetadataSummaries")
    def oauth_metadata_summaries(self) -> Optional[Sequence['outputs.VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary']]:
        """
        Summary about authorization to be returned to the customer as a response.
        """
        return pulumi.get(self, "oauth_metadata_summaries")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[str]:
        """
        OCID of private endpoint created by customer.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter
    def vendor(self) -> Optional[str]:
        """
        Vendor of the external key manager.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAppId":
            suggest = "client_app_id"
        elif key == "idcsAccountNameUrl":
            suggest = "idcs_account_name_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_app_id: Optional[str] = None,
                 idcs_account_name_url: Optional[str] = None):
        """
        :param str client_app_id: ID of the client app created in IDP.
        :param str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        VaultExternalKeyManagerMetadataSummaryOauthMetadataSummary._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            client_app_id=client_app_id,
            idcs_account_name_url=idcs_account_name_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             client_app_id: Optional[str] = None,
             idcs_account_name_url: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientAppId' in kwargs:
            client_app_id = kwargs['clientAppId']
        if 'idcsAccountNameUrl' in kwargs:
            idcs_account_name_url = kwargs['idcsAccountNameUrl']

        if client_app_id is not None:
            _setter("client_app_id", client_app_id)
        if idcs_account_name_url is not None:
            _setter("idcs_account_name_url", idcs_account_name_url)

    @property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> Optional[str]:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> Optional[str]:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class VaultReplicaDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationId":
            suggest = "replication_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultReplicaDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultReplicaDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultReplicaDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_id: Optional[str] = None):
        """
        :param str replication_id: ReplicationId associated with a vault operation
        """
        VaultReplicaDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        if replication_id is not None:
            _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[str]:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class VaultRestoreFromFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentLength":
            suggest = "content_length"
        elif key == "restoreVaultFromFileDetails":
            suggest = "restore_vault_from_file_details"
        elif key == "contentMd5":
            suggest = "content_md5"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultRestoreFromFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultRestoreFromFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultRestoreFromFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_length: str,
                 restore_vault_from_file_details: str,
                 content_md5: Optional[str] = None):
        """
        :param str content_length: content length of vault's backup binary file
        :param str restore_vault_from_file_details: Vault backup file content
        :param str content_md5: (Updatable) content md5 hashed value of vault's backup file
        """
        VaultRestoreFromFile._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content_length=content_length,
            restore_vault_from_file_details=restore_vault_from_file_details,
            content_md5=content_md5,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content_length: str,
             restore_vault_from_file_details: str,
             content_md5: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'contentLength' in kwargs:
            content_length = kwargs['contentLength']
        if 'restoreVaultFromFileDetails' in kwargs:
            restore_vault_from_file_details = kwargs['restoreVaultFromFileDetails']
        if 'contentMd5' in kwargs:
            content_md5 = kwargs['contentMd5']

        _setter("content_length", content_length)
        _setter("restore_vault_from_file_details", restore_vault_from_file_details)
        if content_md5 is not None:
            _setter("content_md5", content_md5)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        content length of vault's backup binary file
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> str:
        """
        Vault backup file content
        """
        return pulumi.get(self, "restore_vault_from_file_details")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[str]:
        """
        (Updatable) content md5 hashed value of vault's backup file
        """
        return pulumi.get(self, "content_md5")


@pulumi.output_type
class VaultRestoreFromObjectStore(dict):
    def __init__(__self__, *,
                 destination: str,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str destination: (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param str bucket: (Updatable) Name of the bucket where vault was backed up
        :param str namespace: (Updatable) Namespace of the bucket where vault was backed up
        :param str object: (Updatable) Object containing the backup
        :param str uri: (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        VaultRestoreFromObjectStore._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            destination=destination,
            bucket=bucket,
            namespace=namespace,
            object=object,
            uri=uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             destination: str,
             bucket: Optional[str] = None,
             namespace: Optional[str] = None,
             object: Optional[str] = None,
             uri: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("destination", destination)
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)
        if uri is not None:
            _setter("uri", uri)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        (Updatable) Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        (Updatable) Name of the bucket where vault was backed up
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace of the bucket where vault was backed up
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        (Updatable) Object containing the backup
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        (Updatable) Pre-authenticated-request-uri of the backup* `restore_trigger` - (Optional) (Updatable) An optional property when flipped triggers restore from restore option provided in config file.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetEkmsPrivateEndpointsEkmsPrivateEndpointResult(dict):
    def __init__(__self__, *,
                 ca_bundle: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 external_key_manager_ip: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 port: int,
                 private_endpoint_ip: str,
                 state: str,
                 subnet_id: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str ca_bundle: CABundle to validate TLS certificate of the external key manager system in PEM format
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: Mutable name of the EKMS private endpoint
        :param str external_key_manager_ip: Private IP of the external key manager system to connect to from the EKMS private endpoint
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier that is immutable
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        :param int port: The port of the external key manager system
        :param str private_endpoint_ip: The IP address in the customer's VCN for the EKMS private endpoint. This is taken from subnet
        :param str state: The current state of the EKMS private endpoint resource.
        :param str subnet_id: Subnet Identifier
        :param str time_created: The time the EKMS private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param str time_updated: The time the EKMS private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        GetEkmsPrivateEndpointsEkmsPrivateEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ca_bundle=ca_bundle,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            external_key_manager_ip=external_key_manager_ip,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            port=port,
            private_endpoint_ip=private_endpoint_ip,
            state=state,
            subnet_id=subnet_id,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ca_bundle: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             external_key_manager_ip: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             port: int,
             private_endpoint_ip: str,
             state: str,
             subnet_id: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'caBundle' in kwargs:
            ca_bundle = kwargs['caBundle']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'externalKeyManagerIp' in kwargs:
            external_key_manager_ip = kwargs['externalKeyManagerIp']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'privateEndpointIp' in kwargs:
            private_endpoint_ip = kwargs['privateEndpointIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("ca_bundle", ca_bundle)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("external_key_manager_ip", external_key_manager_ip)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("port", port)
        _setter("private_endpoint_ip", private_endpoint_ip)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> str:
        """
        CABundle to validate TLS certificate of the external key manager system in PEM format
        """
        return pulumi.get(self, "ca_bundle")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Mutable name of the EKMS private endpoint
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalKeyManagerIp")
    def external_key_manager_ip(self) -> str:
        """
        Private IP of the external key manager system to connect to from the EKMS private endpoint
        """
        return pulumi.get(self, "external_key_manager_ip")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port of the external key manager system
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> str:
        """
        The IP address in the customer's VCN for the EKMS private endpoint. This is taken from subnet
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the EKMS private endpoint resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Subnet Identifier
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the EKMS private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the EKMS private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEkmsPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetEkmsPrivateEndpointsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKeyExternalKeyReferenceResult(dict):
    def __init__(__self__, *,
                 external_key_id: str):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        GetKeyExternalKeyReferenceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']

        _setter("external_key_id", external_key_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")


@pulumi.output_type
class GetKeyExternalKeyReferenceDetailResult(dict):
    def __init__(__self__, *,
                 external_key_id: str,
                 external_key_version_id: str):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param str external_key_version_id: Key version ID associated with the external key.
        """
        GetKeyExternalKeyReferenceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
            external_key_version_id=external_key_version_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: str,
             external_key_version_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']
        if 'externalKeyVersionId' in kwargs:
            external_key_version_id = kwargs['externalKeyVersionId']

        _setter("external_key_id", external_key_id)
        _setter("external_key_version_id", external_key_version_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class GetKeyKeyShapeResult(dict):
    def __init__(__self__, *,
                 algorithm: str,
                 curve_id: str,
                 length: int):
        """
        :param str algorithm: The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        :param str curve_id: Supported curve IDs for ECDSA keys.
        :param int length: The length of the key in bytes, expressed as an integer. Supported values include the following:
               * AES: 16, 24, or 32
               * RSA: 256, 384, or 512
               * ECDSA: 32, 48, or 66
        """
        GetKeyKeyShapeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            algorithm=algorithm,
            curve_id=curve_id,
            length=length,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             algorithm: str,
             curve_id: str,
             length: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'curveId' in kwargs:
            curve_id = kwargs['curveId']

        _setter("algorithm", algorithm)
        _setter("curve_id", curve_id)
        _setter("length", length)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt. Only AES algorithm is supported for `External` keys.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> str:
        """
        Supported curve IDs for ECDSA keys.
        """
        return pulumi.get(self, "curve_id")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include the following:
        * AES: 16, 24, or 32
        * RSA: 256, 384, or 512
        * ECDSA: 32, 48, or 66
        """
        return pulumi.get(self, "length")


@pulumi.output_type
class GetKeyReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a key operation
        """
        GetKeyReplicaDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeyRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: str,
                 content_md5: str,
                 restore_key_from_file_details: str):
        """
        :param str content_length: content length of key's backup binary file
        :param str content_md5: content md5 hashed value of key's backup file
        :param str restore_key_from_file_details: Key backup file content
        """
        GetKeyRestoreFromFileResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content_length=content_length,
            content_md5=content_md5,
            restore_key_from_file_details=restore_key_from_file_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content_length: str,
             content_md5: str,
             restore_key_from_file_details: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'contentLength' in kwargs:
            content_length = kwargs['contentLength']
        if 'contentMd5' in kwargs:
            content_md5 = kwargs['contentMd5']
        if 'restoreKeyFromFileDetails' in kwargs:
            restore_key_from_file_details = kwargs['restoreKeyFromFileDetails']

        _setter("content_length", content_length)
        _setter("content_md5", content_md5)
        _setter("restore_key_from_file_details", restore_key_from_file_details)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        content length of key's backup binary file
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        """
        content md5 hashed value of key's backup file
        """
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> str:
        """
        Key backup file content
        """
        return pulumi.get(self, "restore_key_from_file_details")


@pulumi.output_type
class GetKeyRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 destination: str,
                 namespace: str,
                 object: str,
                 uri: str):
        """
        :param str bucket: Name of the bucket where key was backed up
        :param str destination: Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param str namespace: Namespace of the bucket where key was backed up
        :param str object: Object containing the backup
        :param str uri: Pre-authenticated-request-uri of the backup
        """
        GetKeyRestoreFromObjectStoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            destination=destination,
            namespace=namespace,
            object=object,
            uri=uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             destination: str,
             namespace: str,
             object: str,
             uri: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("bucket", bucket)
        _setter("destination", destination)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("uri", uri)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket where key was backed up
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace of the bucket where key was backed up
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object containing the backup
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetKeyVersionExternalKeyReferenceDetailResult(dict):
    def __init__(__self__, *,
                 external_key_id: str,
                 external_key_version_id: str):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param str external_key_version_id: Key version ID associated with the external key.
        """
        GetKeyVersionExternalKeyReferenceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
            external_key_version_id=external_key_version_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: str,
             external_key_version_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']
        if 'externalKeyVersionId' in kwargs:
            external_key_version_id = kwargs['externalKeyVersionId']

        _setter("external_key_id", external_key_id)
        _setter("external_key_version_id", external_key_version_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class GetKeyVersionReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a key version operation
        """
        GetKeyVersionReplicaDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeyVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetKeyVersionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKeyVersionsKeyVersionResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 external_key_reference_details: Sequence['outputs.GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult'],
                 external_key_version_id: str,
                 id: str,
                 is_primary: bool,
                 key_id: str,
                 key_version_id: str,
                 management_endpoint: str,
                 public_key: str,
                 replica_details: Sequence['outputs.GetKeyVersionsKeyVersionReplicaDetailResult'],
                 restored_from_key_id: str,
                 restored_from_key_version_id: str,
                 state: str,
                 time_created: str,
                 time_of_deletion: str,
                 vault_id: str):
        """
        :param str compartment_id: The OCID of the compartment that contains this key version.
        :param Sequence['GetKeyVersionsKeyVersionExternalKeyReferenceDetailArgs'] external_key_reference_details: Key reference data to be returned to the customer as a response.
        :param str external_key_version_id: Key version ID associated with the external key.
        :param str id: The OCID of the key version.
        :param bool is_primary: A Boolean value that indicates whether the KeyVersion belongs to primary Vault or replica Vault.
        :param str key_id: The OCID of the key.
        :param str key_version_id: The OCID of the key version.
        :param str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param str public_key: The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        :param Sequence['GetKeyVersionsKeyVersionReplicaDetailArgs'] replica_details: KeyVersion replica details
        :param str restored_from_key_version_id: The OCID of the key version from which this key version was restored.
        :param str state: The key version's current lifecycle state.  Example: `ENABLED`
        :param str time_created: The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        :param str time_of_deletion: An optional property to indicate when to delete the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str vault_id: The OCID of the vault that contains this key version.
        """
        GetKeyVersionsKeyVersionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            external_key_reference_details=external_key_reference_details,
            external_key_version_id=external_key_version_id,
            id=id,
            is_primary=is_primary,
            key_id=key_id,
            key_version_id=key_version_id,
            management_endpoint=management_endpoint,
            public_key=public_key,
            replica_details=replica_details,
            restored_from_key_id=restored_from_key_id,
            restored_from_key_version_id=restored_from_key_version_id,
            state=state,
            time_created=time_created,
            time_of_deletion=time_of_deletion,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             external_key_reference_details: Sequence['outputs.GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult'],
             external_key_version_id: str,
             id: str,
             is_primary: bool,
             key_id: str,
             key_version_id: str,
             management_endpoint: str,
             public_key: str,
             replica_details: Sequence['outputs.GetKeyVersionsKeyVersionReplicaDetailResult'],
             restored_from_key_id: str,
             restored_from_key_version_id: str,
             state: str,
             time_created: str,
             time_of_deletion: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'externalKeyReferenceDetails' in kwargs:
            external_key_reference_details = kwargs['externalKeyReferenceDetails']
        if 'externalKeyVersionId' in kwargs:
            external_key_version_id = kwargs['externalKeyVersionId']
        if 'isPrimary' in kwargs:
            is_primary = kwargs['isPrimary']
        if 'keyId' in kwargs:
            key_id = kwargs['keyId']
        if 'keyVersionId' in kwargs:
            key_version_id = kwargs['keyVersionId']
        if 'managementEndpoint' in kwargs:
            management_endpoint = kwargs['managementEndpoint']
        if 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if 'replicaDetails' in kwargs:
            replica_details = kwargs['replicaDetails']
        if 'restoredFromKeyId' in kwargs:
            restored_from_key_id = kwargs['restoredFromKeyId']
        if 'restoredFromKeyVersionId' in kwargs:
            restored_from_key_version_id = kwargs['restoredFromKeyVersionId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeOfDeletion' in kwargs:
            time_of_deletion = kwargs['timeOfDeletion']
        if 'vaultId' in kwargs:
            vault_id = kwargs['vaultId']

        _setter("compartment_id", compartment_id)
        _setter("external_key_reference_details", external_key_reference_details)
        _setter("external_key_version_id", external_key_version_id)
        _setter("id", id)
        _setter("is_primary", is_primary)
        _setter("key_id", key_id)
        _setter("key_version_id", key_version_id)
        _setter("management_endpoint", management_endpoint)
        _setter("public_key", public_key)
        _setter("replica_details", replica_details)
        _setter("restored_from_key_id", restored_from_key_id)
        _setter("restored_from_key_version_id", restored_from_key_version_id)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_of_deletion", time_of_deletion)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains this key version.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="externalKeyReferenceDetails")
    def external_key_reference_details(self) -> Sequence['outputs.GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult']:
        """
        Key reference data to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_reference_details")

    @property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the key version.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        A Boolean value that indicates whether the KeyVersion belongs to primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> str:
        """
        The OCID of the key version.
        """
        return pulumi.get(self, "key_version_id")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetKeyVersionsKeyVersionReplicaDetailResult']:
        """
        KeyVersion replica details
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> str:
        return pulumi.get(self, "restored_from_key_id")

    @property
    @pulumi.getter(name="restoredFromKeyVersionId")
    def restored_from_key_version_id(self) -> str:
        """
        The OCID of the key version from which this key version was restored.
        """
        return pulumi.get(self, "restored_from_key_version_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The key version's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property to indicate when to delete the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The OCID of the vault that contains this key version.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult(dict):
    def __init__(__self__, *,
                 external_key_id: str,
                 external_key_version_id: str):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param str external_key_version_id: Key version ID associated with the external key.
        """
        GetKeyVersionsKeyVersionExternalKeyReferenceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
            external_key_version_id=external_key_version_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: str,
             external_key_version_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']
        if 'externalKeyVersionId' in kwargs:
            external_key_version_id = kwargs['externalKeyVersionId']

        _setter("external_key_id", external_key_id)
        _setter("external_key_version_id", external_key_version_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class GetKeyVersionsKeyVersionReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a key version operation
        """
        GetKeyVersionsKeyVersionReplicaDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a key version operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeysFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetKeysFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKeysKeyResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 current_key_version: str,
                 defined_tags: Mapping[str, Any],
                 desired_state: str,
                 display_name: str,
                 external_key_reference_details: Sequence['outputs.GetKeysKeyExternalKeyReferenceDetailResult'],
                 external_key_references: Sequence['outputs.GetKeysKeyExternalKeyReferenceResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_primary: bool,
                 key_shapes: Sequence['outputs.GetKeysKeyKeyShapeResult'],
                 management_endpoint: str,
                 protection_mode: str,
                 replica_details: Sequence['outputs.GetKeysKeyReplicaDetailResult'],
                 restore_from_files: Sequence['outputs.GetKeysKeyRestoreFromFileResult'],
                 restore_from_object_stores: Sequence['outputs.GetKeysKeyRestoreFromObjectStoreResult'],
                 restore_trigger: bool,
                 restored_from_key_id: str,
                 state: str,
                 time_created: str,
                 time_of_deletion: str,
                 vault_id: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param str current_key_version: The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param Sequence['GetKeysKeyExternalKeyReferenceDetailArgs'] external_key_reference_details: Key reference data to be returned to the customer as a response.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the key.
        :param bool is_primary: A Boolean value that indicates whether the Key belongs to primary Vault or replica vault.
        :param Sequence['GetKeysKeyKeyShapeArgs'] key_shapes: The cryptographic properties of a key.
        :param str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        :param str protection_mode: A key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        :param Sequence['GetKeysKeyReplicaDetailArgs'] replica_details: Key replica details
        :param str state: The key's current lifecycle state.  Example: `ENABLED`
        :param str time_created: The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param str time_of_deletion: An optional property indicating when to delete the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str vault_id: The OCID of the vault that contains this key.
        """
        GetKeysKeyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            current_key_version=current_key_version,
            defined_tags=defined_tags,
            desired_state=desired_state,
            display_name=display_name,
            external_key_reference_details=external_key_reference_details,
            external_key_references=external_key_references,
            freeform_tags=freeform_tags,
            id=id,
            is_primary=is_primary,
            key_shapes=key_shapes,
            management_endpoint=management_endpoint,
            protection_mode=protection_mode,
            replica_details=replica_details,
            restore_from_files=restore_from_files,
            restore_from_object_stores=restore_from_object_stores,
            restore_trigger=restore_trigger,
            restored_from_key_id=restored_from_key_id,
            state=state,
            time_created=time_created,
            time_of_deletion=time_of_deletion,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             current_key_version: str,
             defined_tags: Mapping[str, Any],
             desired_state: str,
             display_name: str,
             external_key_reference_details: Sequence['outputs.GetKeysKeyExternalKeyReferenceDetailResult'],
             external_key_references: Sequence['outputs.GetKeysKeyExternalKeyReferenceResult'],
             freeform_tags: Mapping[str, Any],
             id: str,
             is_primary: bool,
             key_shapes: Sequence['outputs.GetKeysKeyKeyShapeResult'],
             management_endpoint: str,
             protection_mode: str,
             replica_details: Sequence['outputs.GetKeysKeyReplicaDetailResult'],
             restore_from_files: Sequence['outputs.GetKeysKeyRestoreFromFileResult'],
             restore_from_object_stores: Sequence['outputs.GetKeysKeyRestoreFromObjectStoreResult'],
             restore_trigger: bool,
             restored_from_key_id: str,
             state: str,
             time_created: str,
             time_of_deletion: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'currentKeyVersion' in kwargs:
            current_key_version = kwargs['currentKeyVersion']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'desiredState' in kwargs:
            desired_state = kwargs['desiredState']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'externalKeyReferenceDetails' in kwargs:
            external_key_reference_details = kwargs['externalKeyReferenceDetails']
        if 'externalKeyReferences' in kwargs:
            external_key_references = kwargs['externalKeyReferences']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isPrimary' in kwargs:
            is_primary = kwargs['isPrimary']
        if 'keyShapes' in kwargs:
            key_shapes = kwargs['keyShapes']
        if 'managementEndpoint' in kwargs:
            management_endpoint = kwargs['managementEndpoint']
        if 'protectionMode' in kwargs:
            protection_mode = kwargs['protectionMode']
        if 'replicaDetails' in kwargs:
            replica_details = kwargs['replicaDetails']
        if 'restoreFromFiles' in kwargs:
            restore_from_files = kwargs['restoreFromFiles']
        if 'restoreFromObjectStores' in kwargs:
            restore_from_object_stores = kwargs['restoreFromObjectStores']
        if 'restoreTrigger' in kwargs:
            restore_trigger = kwargs['restoreTrigger']
        if 'restoredFromKeyId' in kwargs:
            restored_from_key_id = kwargs['restoredFromKeyId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeOfDeletion' in kwargs:
            time_of_deletion = kwargs['timeOfDeletion']
        if 'vaultId' in kwargs:
            vault_id = kwargs['vaultId']

        _setter("compartment_id", compartment_id)
        _setter("current_key_version", current_key_version)
        _setter("defined_tags", defined_tags)
        _setter("desired_state", desired_state)
        _setter("display_name", display_name)
        _setter("external_key_reference_details", external_key_reference_details)
        _setter("external_key_references", external_key_references)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_primary", is_primary)
        _setter("key_shapes", key_shapes)
        _setter("management_endpoint", management_endpoint)
        _setter("protection_mode", protection_mode)
        _setter("replica_details", replica_details)
        _setter("restore_from_files", restore_from_files)
        _setter("restore_from_object_stores", restore_from_object_stores)
        _setter("restore_trigger", restore_trigger)
        _setter("restored_from_key_id", restored_from_key_id)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_of_deletion", time_of_deletion)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currentKeyVersion")
    def current_key_version(self) -> str:
        """
        The OCID of the key version used in cryptographic operations. During key rotation, the service might be in a transitional state where this or a newer key version are used intermittently. The `currentKeyVersion` property is updated when the service is guaranteed to use the new key version for all subsequent encryption operations.
        """
        return pulumi.get(self, "current_key_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> str:
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the key. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalKeyReferenceDetails")
    def external_key_reference_details(self) -> Sequence['outputs.GetKeysKeyExternalKeyReferenceDetailResult']:
        """
        Key reference data to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_reference_details")

    @property
    @pulumi.getter(name="externalKeyReferences")
    def external_key_references(self) -> Sequence['outputs.GetKeysKeyExternalKeyReferenceResult']:
        return pulumi.get(self, "external_key_references")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        A Boolean value that indicates whether the Key belongs to primary Vault or replica vault.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="keyShapes")
    def key_shapes(self) -> Sequence['outputs.GetKeysKeyKeyShapeResult']:
        """
        The cryptographic properties of a key.
        """
        return pulumi.get(self, "key_shapes")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        """
        The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> str:
        """
        A key's protection mode indicates how the key persists and where cryptographic operations that use the key are performed. A protection mode of `HSM` means that the key persists on a hardware security module (HSM) and all cryptographic operations are performed inside the HSM. A protection mode of `SOFTWARE` means that the key persists on the server, protected by the vault's RSA wrapping key which persists on the HSM. All cryptographic operations that use a key with a protection mode of `SOFTWARE` are performed on the server. A protection mode of `EXTERNAL` mean that the key persists on the customer's external key manager which is hosted externally outside of oracle. Oracle only hold a reference to that key. All cryptographic operations that use a key with a protection mode of `EXTERNAL` are performed by external key manager.
        """
        return pulumi.get(self, "protection_mode")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetKeysKeyReplicaDetailResult']:
        """
        Key replica details
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="restoreFromFiles")
    def restore_from_files(self) -> Sequence['outputs.GetKeysKeyRestoreFromFileResult']:
        return pulumi.get(self, "restore_from_files")

    @property
    @pulumi.getter(name="restoreFromObjectStores")
    def restore_from_object_stores(self) -> Sequence['outputs.GetKeysKeyRestoreFromObjectStoreResult']:
        return pulumi.get(self, "restore_from_object_stores")

    @property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> bool:
        return pulumi.get(self, "restore_trigger")

    @property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> str:
        return pulumi.get(self, "restored_from_key_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The key's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the key was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property indicating when to delete the key, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The OCID of the vault that contains this key.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetKeysKeyExternalKeyReferenceResult(dict):
    def __init__(__self__, *,
                 external_key_id: str):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        GetKeysKeyExternalKeyReferenceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']

        _setter("external_key_id", external_key_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")


@pulumi.output_type
class GetKeysKeyExternalKeyReferenceDetailResult(dict):
    def __init__(__self__, *,
                 external_key_id: str,
                 external_key_version_id: str):
        """
        :param str external_key_id: ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        :param str external_key_version_id: Key version ID associated with the external key.
        """
        GetKeysKeyExternalKeyReferenceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_key_id=external_key_id,
            external_key_version_id=external_key_version_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_key_id: str,
             external_key_version_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalKeyId' in kwargs:
            external_key_id = kwargs['externalKeyId']
        if 'externalKeyVersionId' in kwargs:
            external_key_version_id = kwargs['externalKeyVersionId']

        _setter("external_key_id", external_key_id)
        _setter("external_key_version_id", external_key_version_id)

    @property
    @pulumi.getter(name="externalKeyId")
    def external_key_id(self) -> str:
        """
        ExternalKeyId refers to the globally unique key Id associated with the key created in external vault in CTM.
        """
        return pulumi.get(self, "external_key_id")

    @property
    @pulumi.getter(name="externalKeyVersionId")
    def external_key_version_id(self) -> str:
        """
        Key version ID associated with the external key.
        """
        return pulumi.get(self, "external_key_version_id")


@pulumi.output_type
class GetKeysKeyKeyShapeResult(dict):
    def __init__(__self__, *,
                 algorithm: str,
                 curve_id: str,
                 length: int):
        """
        :param str algorithm: The algorithm used by a key's key versions to encrypt or decrypt data. Currently, support includes AES, RSA, and ECDSA algorithms.
        :param str curve_id: The curve ID of the keys. (This pertains only to ECDSA keys.)
        :param int length: The length of the key in bytes, expressed as an integer. Supported values include 16, 24, or 32.
        """
        GetKeysKeyKeyShapeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            algorithm=algorithm,
            curve_id=curve_id,
            length=length,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             algorithm: str,
             curve_id: str,
             length: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'curveId' in kwargs:
            curve_id = kwargs['curveId']

        _setter("algorithm", algorithm)
        _setter("curve_id", curve_id)
        _setter("length", length)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used by a key's key versions to encrypt or decrypt data. Currently, support includes AES, RSA, and ECDSA algorithms.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="curveId")
    def curve_id(self) -> str:
        """
        The curve ID of the keys. (This pertains only to ECDSA keys.)
        """
        return pulumi.get(self, "curve_id")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        The length of the key in bytes, expressed as an integer. Supported values include 16, 24, or 32.
        """
        return pulumi.get(self, "length")


@pulumi.output_type
class GetKeysKeyReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a key operation
        """
        GetKeysKeyReplicaDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a key operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetKeysKeyRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: str,
                 content_md5: str,
                 restore_key_from_file_details: str):
        GetKeysKeyRestoreFromFileResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content_length=content_length,
            content_md5=content_md5,
            restore_key_from_file_details=restore_key_from_file_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content_length: str,
             content_md5: str,
             restore_key_from_file_details: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'contentLength' in kwargs:
            content_length = kwargs['contentLength']
        if 'contentMd5' in kwargs:
            content_md5 = kwargs['contentMd5']
        if 'restoreKeyFromFileDetails' in kwargs:
            restore_key_from_file_details = kwargs['restoreKeyFromFileDetails']

        _setter("content_length", content_length)
        _setter("content_md5", content_md5)
        _setter("restore_key_from_file_details", restore_key_from_file_details)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="restoreKeyFromFileDetails")
    def restore_key_from_file_details(self) -> str:
        return pulumi.get(self, "restore_key_from_file_details")


@pulumi.output_type
class GetKeysKeyRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 destination: str,
                 namespace: str,
                 object: str,
                 uri: str):
        GetKeysKeyRestoreFromObjectStoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            destination=destination,
            namespace=namespace,
            object=object,
            uri=uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             destination: str,
             namespace: str,
             object: str,
             uri: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("bucket", bucket)
        _setter("destination", destination)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("uri", uri)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetReplicationStatusReplicaDetailResult(dict):
    def __init__(__self__, *,
                 region: str,
                 status: str):
        """
        :param str region: The replica region
        :param str status: Replication status associated with a replicationId
        """
        GetReplicationStatusReplicaDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            region=region,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             region: str,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("region", region)
        _setter("status", status)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The replica region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Replication status associated with a replicationId
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVaultExternalKeyManagerMetadataResult(dict):
    def __init__(__self__, *,
                 external_vault_endpoint_url: str,
                 oauth_metadatas: Sequence['outputs.GetVaultExternalKeyManagerMetadataOauthMetadataResult'],
                 private_endpoint_id: str):
        """
        :param str external_vault_endpoint_url: URL of the vault on external key manager.
        :param str private_endpoint_id: OCID of the private endpoint.
        """
        GetVaultExternalKeyManagerMetadataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_vault_endpoint_url=external_vault_endpoint_url,
            oauth_metadatas=oauth_metadatas,
            private_endpoint_id=private_endpoint_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_vault_endpoint_url: str,
             oauth_metadatas: Sequence['outputs.GetVaultExternalKeyManagerMetadataOauthMetadataResult'],
             private_endpoint_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalVaultEndpointUrl' in kwargs:
            external_vault_endpoint_url = kwargs['externalVaultEndpointUrl']
        if 'oauthMetadatas' in kwargs:
            oauth_metadatas = kwargs['oauthMetadatas']
        if 'privateEndpointId' in kwargs:
            private_endpoint_id = kwargs['privateEndpointId']

        _setter("external_vault_endpoint_url", external_vault_endpoint_url)
        _setter("oauth_metadatas", oauth_metadatas)
        _setter("private_endpoint_id", private_endpoint_id)

    @property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> str:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @property
    @pulumi.getter(name="oauthMetadatas")
    def oauth_metadatas(self) -> Sequence['outputs.GetVaultExternalKeyManagerMetadataOauthMetadataResult']:
        return pulumi.get(self, "oauth_metadatas")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")


@pulumi.output_type
class GetVaultExternalKeyManagerMetadataOauthMetadataResult(dict):
    def __init__(__self__, *,
                 client_app_id: str,
                 client_app_secret: str,
                 idcs_account_name_url: str):
        """
        :param str client_app_id: ID of the client app created in IDP.
        :param str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        GetVaultExternalKeyManagerMetadataOauthMetadataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            client_app_id=client_app_id,
            client_app_secret=client_app_secret,
            idcs_account_name_url=idcs_account_name_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             client_app_id: str,
             client_app_secret: str,
             idcs_account_name_url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientAppId' in kwargs:
            client_app_id = kwargs['clientAppId']
        if 'clientAppSecret' in kwargs:
            client_app_secret = kwargs['clientAppSecret']
        if 'idcsAccountNameUrl' in kwargs:
            idcs_account_name_url = kwargs['idcsAccountNameUrl']

        _setter("client_app_id", client_app_id)
        _setter("client_app_secret", client_app_secret)
        _setter("idcs_account_name_url", idcs_account_name_url)

    @property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @property
    @pulumi.getter(name="clientAppSecret")
    def client_app_secret(self) -> str:
        return pulumi.get(self, "client_app_secret")

    @property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class GetVaultExternalKeyManagerMetadataSummaryResult(dict):
    def __init__(__self__, *,
                 external_vault_endpoint_url: str,
                 oauth_metadata_summaries: Sequence['outputs.GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult'],
                 private_endpoint_id: str,
                 vendor: str):
        """
        :param str external_vault_endpoint_url: URL of the vault on external key manager.
        :param Sequence['GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs'] oauth_metadata_summaries: Summary about authorization to be returned to the customer as a response.
        :param str private_endpoint_id: OCID of the private endpoint.
        :param str vendor: Vendor of the external key manager.
        """
        GetVaultExternalKeyManagerMetadataSummaryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_vault_endpoint_url=external_vault_endpoint_url,
            oauth_metadata_summaries=oauth_metadata_summaries,
            private_endpoint_id=private_endpoint_id,
            vendor=vendor,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_vault_endpoint_url: str,
             oauth_metadata_summaries: Sequence['outputs.GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult'],
             private_endpoint_id: str,
             vendor: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalVaultEndpointUrl' in kwargs:
            external_vault_endpoint_url = kwargs['externalVaultEndpointUrl']
        if 'oauthMetadataSummaries' in kwargs:
            oauth_metadata_summaries = kwargs['oauthMetadataSummaries']
        if 'privateEndpointId' in kwargs:
            private_endpoint_id = kwargs['privateEndpointId']

        _setter("external_vault_endpoint_url", external_vault_endpoint_url)
        _setter("oauth_metadata_summaries", oauth_metadata_summaries)
        _setter("private_endpoint_id", private_endpoint_id)
        _setter("vendor", vendor)

    @property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> str:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @property
    @pulumi.getter(name="oauthMetadataSummaries")
    def oauth_metadata_summaries(self) -> Sequence['outputs.GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult']:
        """
        Summary about authorization to be returned to the customer as a response.
        """
        return pulumi.get(self, "oauth_metadata_summaries")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        Vendor of the external key manager.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult(dict):
    def __init__(__self__, *,
                 client_app_id: str,
                 idcs_account_name_url: str):
        """
        :param str client_app_id: ID of the client app created in IDP.
        :param str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        GetVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            client_app_id=client_app_id,
            idcs_account_name_url=idcs_account_name_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             client_app_id: str,
             idcs_account_name_url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientAppId' in kwargs:
            client_app_id = kwargs['clientAppId']
        if 'idcsAccountNameUrl' in kwargs:
            idcs_account_name_url = kwargs['idcsAccountNameUrl']

        _setter("client_app_id", client_app_id)
        _setter("idcs_account_name_url", idcs_account_name_url)

    @property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class GetVaultReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a vault operation
        """
        GetVaultReplicaDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetVaultReplicasFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetVaultReplicasFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVaultReplicasVaultReplicaResult(dict):
    def __init__(__self__, *,
                 crypto_endpoint: str,
                 management_endpoint: str,
                 region: str,
                 status: str):
        """
        :param str crypto_endpoint: The vault replica's crypto endpoint
        :param str management_endpoint: The vault replica's management endpoint
        :param str region: Region to which vault is replicated to
        :param str status: Status of the Vault
        """
        GetVaultReplicasVaultReplicaResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            crypto_endpoint=crypto_endpoint,
            management_endpoint=management_endpoint,
            region=region,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             crypto_endpoint: str,
             management_endpoint: str,
             region: str,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cryptoEndpoint' in kwargs:
            crypto_endpoint = kwargs['cryptoEndpoint']
        if 'managementEndpoint' in kwargs:
            management_endpoint = kwargs['managementEndpoint']

        _setter("crypto_endpoint", crypto_endpoint)
        _setter("management_endpoint", management_endpoint)
        _setter("region", region)
        _setter("status", status)

    @property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> str:
        """
        The vault replica's crypto endpoint
        """
        return pulumi.get(self, "crypto_endpoint")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        """
        The vault replica's management endpoint
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region to which vault is replicated to
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the Vault
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVaultRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: str,
                 content_md5: str,
                 restore_vault_from_file_details: str):
        """
        :param str content_length: content length of vault's backup binary file
        :param str content_md5: content md5 hashed value of vault's backup file
        :param str restore_vault_from_file_details: Vault backup file content
        """
        GetVaultRestoreFromFileResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content_length=content_length,
            content_md5=content_md5,
            restore_vault_from_file_details=restore_vault_from_file_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content_length: str,
             content_md5: str,
             restore_vault_from_file_details: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'contentLength' in kwargs:
            content_length = kwargs['contentLength']
        if 'contentMd5' in kwargs:
            content_md5 = kwargs['contentMd5']
        if 'restoreVaultFromFileDetails' in kwargs:
            restore_vault_from_file_details = kwargs['restoreVaultFromFileDetails']

        _setter("content_length", content_length)
        _setter("content_md5", content_md5)
        _setter("restore_vault_from_file_details", restore_vault_from_file_details)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        """
        content length of vault's backup binary file
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        """
        content md5 hashed value of vault's backup file
        """
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> str:
        """
        Vault backup file content
        """
        return pulumi.get(self, "restore_vault_from_file_details")


@pulumi.output_type
class GetVaultRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 destination: str,
                 namespace: str,
                 object: str,
                 uri: str):
        """
        :param str bucket: Name of the bucket where vault was backed up
        :param str destination: Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        :param str namespace: Namespace of the bucket where vault was backed up
        :param str object: Object containing the backup
        :param str uri: Pre-authenticated-request-uri of the backup
        """
        GetVaultRestoreFromObjectStoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            destination=destination,
            namespace=namespace,
            object=object,
            uri=uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             destination: str,
             namespace: str,
             object: str,
             uri: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("bucket", bucket)
        _setter("destination", destination)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("uri", uri)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket where vault was backed up
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Type of backup to restore from. Values of "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI" are supported
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace of the bucket where vault was backed up
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object containing the backup
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Pre-authenticated-request-uri of the backup
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetVaultsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetVaultsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVaultsVaultResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 crypto_endpoint: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 external_key_manager_metadata_summaries: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryResult'],
                 external_key_manager_metadatas: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_primary: bool,
                 management_endpoint: str,
                 replica_details: Sequence['outputs.GetVaultsVaultReplicaDetailResult'],
                 restore_from_files: Sequence['outputs.GetVaultsVaultRestoreFromFileResult'],
                 restore_from_object_stores: Sequence['outputs.GetVaultsVaultRestoreFromObjectStoreResult'],
                 restore_trigger: bool,
                 restored_from_vault_id: str,
                 state: str,
                 time_created: str,
                 time_of_deletion: str,
                 vault_type: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param str crypto_endpoint: The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        :param Sequence['GetVaultsVaultExternalKeyManagerMetadataSummaryArgs'] external_key_manager_metadata_summaries: Summary about metadata of external key manager to be returned to the customer as a response.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the vault.
        :param bool is_primary: A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        :param str management_endpoint: The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        :param Sequence['GetVaultsVaultReplicaDetailArgs'] replica_details: Vault replica details
        :param str restored_from_vault_id: The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        :param str state: The vault's current lifecycle state.  Example: `DELETED`
        :param str time_created: The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        :param str time_of_deletion: An optional property to indicate when to delete the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param str vault_type: The type of vault. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        GetVaultsVaultResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            crypto_endpoint=crypto_endpoint,
            defined_tags=defined_tags,
            display_name=display_name,
            external_key_manager_metadata_summaries=external_key_manager_metadata_summaries,
            external_key_manager_metadatas=external_key_manager_metadatas,
            freeform_tags=freeform_tags,
            id=id,
            is_primary=is_primary,
            management_endpoint=management_endpoint,
            replica_details=replica_details,
            restore_from_files=restore_from_files,
            restore_from_object_stores=restore_from_object_stores,
            restore_trigger=restore_trigger,
            restored_from_vault_id=restored_from_vault_id,
            state=state,
            time_created=time_created,
            time_of_deletion=time_of_deletion,
            vault_type=vault_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             crypto_endpoint: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             external_key_manager_metadata_summaries: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryResult'],
             external_key_manager_metadatas: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataResult'],
             freeform_tags: Mapping[str, Any],
             id: str,
             is_primary: bool,
             management_endpoint: str,
             replica_details: Sequence['outputs.GetVaultsVaultReplicaDetailResult'],
             restore_from_files: Sequence['outputs.GetVaultsVaultRestoreFromFileResult'],
             restore_from_object_stores: Sequence['outputs.GetVaultsVaultRestoreFromObjectStoreResult'],
             restore_trigger: bool,
             restored_from_vault_id: str,
             state: str,
             time_created: str,
             time_of_deletion: str,
             vault_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'cryptoEndpoint' in kwargs:
            crypto_endpoint = kwargs['cryptoEndpoint']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'externalKeyManagerMetadataSummaries' in kwargs:
            external_key_manager_metadata_summaries = kwargs['externalKeyManagerMetadataSummaries']
        if 'externalKeyManagerMetadatas' in kwargs:
            external_key_manager_metadatas = kwargs['externalKeyManagerMetadatas']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isPrimary' in kwargs:
            is_primary = kwargs['isPrimary']
        if 'managementEndpoint' in kwargs:
            management_endpoint = kwargs['managementEndpoint']
        if 'replicaDetails' in kwargs:
            replica_details = kwargs['replicaDetails']
        if 'restoreFromFiles' in kwargs:
            restore_from_files = kwargs['restoreFromFiles']
        if 'restoreFromObjectStores' in kwargs:
            restore_from_object_stores = kwargs['restoreFromObjectStores']
        if 'restoreTrigger' in kwargs:
            restore_trigger = kwargs['restoreTrigger']
        if 'restoredFromVaultId' in kwargs:
            restored_from_vault_id = kwargs['restoredFromVaultId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeOfDeletion' in kwargs:
            time_of_deletion = kwargs['timeOfDeletion']
        if 'vaultType' in kwargs:
            vault_type = kwargs['vaultType']

        _setter("compartment_id", compartment_id)
        _setter("crypto_endpoint", crypto_endpoint)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("external_key_manager_metadata_summaries", external_key_manager_metadata_summaries)
        _setter("external_key_manager_metadatas", external_key_manager_metadatas)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_primary", is_primary)
        _setter("management_endpoint", management_endpoint)
        _setter("replica_details", replica_details)
        _setter("restore_from_files", restore_from_files)
        _setter("restore_from_object_stores", restore_from_object_stores)
        _setter("restore_trigger", restore_trigger)
        _setter("restored_from_vault_id", restored_from_vault_id)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_of_deletion", time_of_deletion)
        _setter("vault_type", vault_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> str:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        """
        return pulumi.get(self, "crypto_endpoint")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalKeyManagerMetadataSummaries")
    def external_key_manager_metadata_summaries(self) -> Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryResult']:
        """
        Summary about metadata of external key manager to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_manager_metadata_summaries")

    @property
    @pulumi.getter(name="externalKeyManagerMetadatas")
    def external_key_manager_metadatas(self) -> Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataResult']:
        return pulumi.get(self, "external_key_manager_metadatas")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the vault.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        """
        The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetVaultsVaultReplicaDetailResult']:
        """
        Vault replica details
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="restoreFromFiles")
    def restore_from_files(self) -> Sequence['outputs.GetVaultsVaultRestoreFromFileResult']:
        return pulumi.get(self, "restore_from_files")

    @property
    @pulumi.getter(name="restoreFromObjectStores")
    def restore_from_object_stores(self) -> Sequence['outputs.GetVaultsVaultRestoreFromObjectStoreResult']:
        return pulumi.get(self, "restore_from_object_stores")

    @property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> bool:
        return pulumi.get(self, "restore_trigger")

    @property
    @pulumi.getter(name="restoredFromVaultId")
    def restored_from_vault_id(self) -> str:
        """
        The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        """
        return pulumi.get(self, "restored_from_vault_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The vault's current lifecycle state.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property to indicate when to delete the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> str:
        """
        The type of vault. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        return pulumi.get(self, "vault_type")


@pulumi.output_type
class GetVaultsVaultExternalKeyManagerMetadataResult(dict):
    def __init__(__self__, *,
                 external_vault_endpoint_url: str,
                 oauth_metadatas: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult'],
                 private_endpoint_id: str):
        """
        :param str external_vault_endpoint_url: URL of the vault on external key manager.
        :param str private_endpoint_id: OCID of the private endpoint.
        """
        GetVaultsVaultExternalKeyManagerMetadataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_vault_endpoint_url=external_vault_endpoint_url,
            oauth_metadatas=oauth_metadatas,
            private_endpoint_id=private_endpoint_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_vault_endpoint_url: str,
             oauth_metadatas: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult'],
             private_endpoint_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalVaultEndpointUrl' in kwargs:
            external_vault_endpoint_url = kwargs['externalVaultEndpointUrl']
        if 'oauthMetadatas' in kwargs:
            oauth_metadatas = kwargs['oauthMetadatas']
        if 'privateEndpointId' in kwargs:
            private_endpoint_id = kwargs['privateEndpointId']

        _setter("external_vault_endpoint_url", external_vault_endpoint_url)
        _setter("oauth_metadatas", oauth_metadatas)
        _setter("private_endpoint_id", private_endpoint_id)

    @property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> str:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @property
    @pulumi.getter(name="oauthMetadatas")
    def oauth_metadatas(self) -> Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult']:
        return pulumi.get(self, "oauth_metadatas")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")


@pulumi.output_type
class GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult(dict):
    def __init__(__self__, *,
                 client_app_id: str,
                 client_app_secret: str,
                 idcs_account_name_url: str):
        """
        :param str client_app_id: ID of the client app created in IDP.
        :param str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        GetVaultsVaultExternalKeyManagerMetadataOauthMetadataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            client_app_id=client_app_id,
            client_app_secret=client_app_secret,
            idcs_account_name_url=idcs_account_name_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             client_app_id: str,
             client_app_secret: str,
             idcs_account_name_url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientAppId' in kwargs:
            client_app_id = kwargs['clientAppId']
        if 'clientAppSecret' in kwargs:
            client_app_secret = kwargs['clientAppSecret']
        if 'idcsAccountNameUrl' in kwargs:
            idcs_account_name_url = kwargs['idcsAccountNameUrl']

        _setter("client_app_id", client_app_id)
        _setter("client_app_secret", client_app_secret)
        _setter("idcs_account_name_url", idcs_account_name_url)

    @property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @property
    @pulumi.getter(name="clientAppSecret")
    def client_app_secret(self) -> str:
        return pulumi.get(self, "client_app_secret")

    @property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class GetVaultsVaultExternalKeyManagerMetadataSummaryResult(dict):
    def __init__(__self__, *,
                 external_vault_endpoint_url: str,
                 oauth_metadata_summaries: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult'],
                 private_endpoint_id: str,
                 vendor: str):
        """
        :param str external_vault_endpoint_url: URL of the vault on external key manager.
        :param Sequence['GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryArgs'] oauth_metadata_summaries: Summary about authorization to be returned to the customer as a response.
        :param str private_endpoint_id: OCID of the private endpoint.
        :param str vendor: Vendor of the external key manager.
        """
        GetVaultsVaultExternalKeyManagerMetadataSummaryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            external_vault_endpoint_url=external_vault_endpoint_url,
            oauth_metadata_summaries=oauth_metadata_summaries,
            private_endpoint_id=private_endpoint_id,
            vendor=vendor,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             external_vault_endpoint_url: str,
             oauth_metadata_summaries: Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult'],
             private_endpoint_id: str,
             vendor: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'externalVaultEndpointUrl' in kwargs:
            external_vault_endpoint_url = kwargs['externalVaultEndpointUrl']
        if 'oauthMetadataSummaries' in kwargs:
            oauth_metadata_summaries = kwargs['oauthMetadataSummaries']
        if 'privateEndpointId' in kwargs:
            private_endpoint_id = kwargs['privateEndpointId']

        _setter("external_vault_endpoint_url", external_vault_endpoint_url)
        _setter("oauth_metadata_summaries", oauth_metadata_summaries)
        _setter("private_endpoint_id", private_endpoint_id)
        _setter("vendor", vendor)

    @property
    @pulumi.getter(name="externalVaultEndpointUrl")
    def external_vault_endpoint_url(self) -> str:
        """
        URL of the vault on external key manager.
        """
        return pulumi.get(self, "external_vault_endpoint_url")

    @property
    @pulumi.getter(name="oauthMetadataSummaries")
    def oauth_metadata_summaries(self) -> Sequence['outputs.GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult']:
        """
        Summary about authorization to be returned to the customer as a response.
        """
        return pulumi.get(self, "oauth_metadata_summaries")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        OCID of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        Vendor of the external key manager.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult(dict):
    def __init__(__self__, *,
                 client_app_id: str,
                 idcs_account_name_url: str):
        """
        :param str client_app_id: ID of the client app created in IDP.
        :param str idcs_account_name_url: Base URL of the IDCS account where confidential client app is created.
        """
        GetVaultsVaultExternalKeyManagerMetadataSummaryOauthMetadataSummaryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            client_app_id=client_app_id,
            idcs_account_name_url=idcs_account_name_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             client_app_id: str,
             idcs_account_name_url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clientAppId' in kwargs:
            client_app_id = kwargs['clientAppId']
        if 'idcsAccountNameUrl' in kwargs:
            idcs_account_name_url = kwargs['idcsAccountNameUrl']

        _setter("client_app_id", client_app_id)
        _setter("idcs_account_name_url", idcs_account_name_url)

    @property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> str:
        """
        ID of the client app created in IDP.
        """
        return pulumi.get(self, "client_app_id")

    @property
    @pulumi.getter(name="idcsAccountNameUrl")
    def idcs_account_name_url(self) -> str:
        """
        Base URL of the IDCS account where confidential client app is created.
        """
        return pulumi.get(self, "idcs_account_name_url")


@pulumi.output_type
class GetVaultsVaultReplicaDetailResult(dict):
    def __init__(__self__, *,
                 replication_id: str):
        """
        :param str replication_id: ReplicationId associated with a vault operation
        """
        GetVaultsVaultReplicaDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            replication_id=replication_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             replication_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'replicationId' in kwargs:
            replication_id = kwargs['replicationId']

        _setter("replication_id", replication_id)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> str:
        """
        ReplicationId associated with a vault operation
        """
        return pulumi.get(self, "replication_id")


@pulumi.output_type
class GetVaultsVaultRestoreFromFileResult(dict):
    def __init__(__self__, *,
                 content_length: str,
                 content_md5: str,
                 restore_vault_from_file_details: str):
        GetVaultsVaultRestoreFromFileResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content_length=content_length,
            content_md5=content_md5,
            restore_vault_from_file_details=restore_vault_from_file_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content_length: str,
             content_md5: str,
             restore_vault_from_file_details: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'contentLength' in kwargs:
            content_length = kwargs['contentLength']
        if 'contentMd5' in kwargs:
            content_md5 = kwargs['contentMd5']
        if 'restoreVaultFromFileDetails' in kwargs:
            restore_vault_from_file_details = kwargs['restoreVaultFromFileDetails']

        _setter("content_length", content_length)
        _setter("content_md5", content_md5)
        _setter("restore_vault_from_file_details", restore_vault_from_file_details)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> str:
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> str:
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="restoreVaultFromFileDetails")
    def restore_vault_from_file_details(self) -> str:
        return pulumi.get(self, "restore_vault_from_file_details")


@pulumi.output_type
class GetVaultsVaultRestoreFromObjectStoreResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 destination: str,
                 namespace: str,
                 object: str,
                 uri: str):
        GetVaultsVaultRestoreFromObjectStoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            destination=destination,
            namespace=namespace,
            object=object,
            uri=uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             destination: str,
             namespace: str,
             object: str,
             uri: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("bucket", bucket)
        _setter("destination", destination)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("uri", uri)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")


